/// <reference types="node" />
import { OAuth2Client, JWT, Compute, UserRefreshClient, BaseExternalAccountClient, GaxiosPromise, GoogleConfigurable, MethodOptions, StreamMethodOptions, GlobalOptions, GoogleAuth, BodyResponseCallback, APIRequestContext } from 'googleapis-common';
import { Readable } from 'stream';
export declare namespace contentwarehouse_v1 {
    export interface Options extends GlobalOptions {
        version: 'v1';
    }
    interface StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient | BaseExternalAccountClient | GoogleAuth;
        /**
         * V1 error format.
         */
        '$.xgafv'?: string;
        /**
         * OAuth access token.
         */
        access_token?: string;
        /**
         * Data format for response.
         */
        alt?: string;
        /**
         * JSONP
         */
        callback?: string;
        /**
         * Selector specifying which fields to include in a partial response.
         */
        fields?: string;
        /**
         * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
         */
        key?: string;
        /**
         * OAuth 2.0 token for the current user.
         */
        oauth_token?: string;
        /**
         * Returns response with indentations and line breaks.
         */
        prettyPrint?: boolean;
        /**
         * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
         */
        quotaUser?: string;
        /**
         * Legacy upload protocol for media (e.g. "media", "multipart").
         */
        uploadType?: string;
        /**
         * Upload protocol for media (e.g. "raw", "multipart").
         */
        upload_protocol?: string;
    }
    /**
     * Document AI Warehouse API
     *
     *
     *
     * @example
     * ```js
     * const {google} = require('googleapis');
     * const contentwarehouse = google.contentwarehouse('v1');
     * ```
     */
    export class Contentwarehouse {
        context: APIRequestContext;
        projects: Resource$Projects;
        constructor(options: GlobalOptions, google?: GoogleConfigurable);
    }
    export interface Schema$AbuseiamAbuseType {
        id?: string | null;
        /**
         * Optional client specific subtype of abuse that is too specific to belong in the above enumeration. For example, some client may want to differentiate nudity from graphic sex, but both are PORNOGRAPHY.
         */
        subtype?: string | null;
    }
    export interface Schema$AbuseiamAgeRestriction {
        /**
         * This restriction applies if the user is between [min_age_years, age_years) years old.
         */
        ageYears?: number | null;
        minAgeYears?: number | null;
    }
    export interface Schema$AbuseiamAndRestriction {
        /**
         * This restriction applies if all of the children apply.
         */
        child?: Schema$AbuseiamUserRestriction[];
    }
    /**
     * A client is be a Google product, or subproduct that provides content for AbuseIAm to classify.
     */
    export interface Schema$AbuseiamClient {
        id?: string | null;
        /**
         * The name of the subservice within a client. This subservice can be used to affect the flow of decision script, or selection of backend classifiers. For example, StreetView may want to specify a panel is insufficiently blurred (maybe there is a lisense plate or public sex, etc), which requires manual review then the subservice might be "blurring".
         */
        subservice?: string | null;
    }
    /**
     * Extra information regarding evaluations received through cluster review.
     */
    export interface Schema$AbuseiamClusterEvaluationContext {
        /**
         * The family of the cluster where the case received the evaluation.
         */
        clusterFamily?: string | null;
        /**
         * The AbuseIAm rowkey of the cluster where the case received an evaluation.
         */
        clusterRowkey?: string | null;
        /**
         * The gaia id of a mail box that ops can send inquiries to for appeals. Used only by user clusters to fill a required gatekeeper param. See gaia_disableserver.DisableSpec.escalate_to field.
         */
        gaiaIdToEscalate?: string | null;
    }
    export interface Schema$AbuseiamConstantRestriction {
        /**
         * A constant of type TRUE always applies, and of type FALSE never applies.
         */
        type?: string | null;
    }
    /**
     * Pair of Verdicts used for ProjectR age/geo gating. See http://go/projectr for more information.
     */
    export interface Schema$AbuseiamContentRestriction {
        /**
         * Takedowns specified by admins via AbuseIAm
         */
        adminVerdict?: Schema$AbuseiamVerdict[];
        /**
         * User-specified takedowns
         */
        userVerdict?: Schema$AbuseiamVerdict[];
    }
    /**
     * Backends return Evaluations to AbuseIAm. One of the things Evaluations are used for is to explain Verdicts.
     */
    export interface Schema$AbuseiamEvaluation {
        abuseType?: Schema$AbuseiamAbuseType;
        /**
         * Who creates this Evaluation. This field is required.
         */
        backend?: string | null;
        /**
         * Extra information regarding the cluster review context where the case received the evaluation.
         */
        clusterEvaluationContext?: Schema$AbuseiamClusterEvaluationContext;
        /**
         * Backends can choose to put some debug info in addition to abuse_type, score, and status.
         */
        comment?: string | null;
        /**
         * A set of repeated features to allow adapters to return semi structured data. Please, prefer using feature instead of the old misc_data field since it supports richer and more structured data to be passed back.
         */
        feature?: Schema$AbuseiamFeature[];
        /**
         * Information about the manual review, for manual review evaluations. Do NOT expect this field to be set if `backend != MANUAL_REVIEW`.
         */
        manualReviewInfo?: Schema$AbuseiamManualReviewEvaluationInfo;
        /**
         * This field is used to store miscellaneous information that Backend might provide. If you find youself here considering to use this field, please prefer using the repeated feature field below instead. It supports a richer structure for passing complex data back from the backend.
         */
        miscData?: Schema$AbuseiamNameValuePair[];
        /**
         * When the evaluation was processed by the decision script.
         */
        processedMicros?: string | null;
        /**
         * Time in milliseconds when the Backend processed this Evaluation.
         */
        processTimeMillisecs?: string | null;
        /**
         * The list of regions where the evaluation applies.
         */
        region?: Schema$AbuseiamRegion[];
        score?: number | null;
        status?: string | null;
        target?: Schema$AbuseiamTarget;
        /**
         * When the Evaluation was generated.
         */
        timestampMicros?: string | null;
        /**
         * A boolean expression tree used to define the restrictions where the verdict applies. Please use java/com/google/ccc/abuse/abuseiam/client/TakedownManager.java to evaluate this proto.
         */
        userRestriction?: Schema$AbuseiamUserRestriction;
        /**
         * Version of Backend. For rules, this string is the only way to differentiate between them.
         */
        version?: string | null;
        /**
         * Information about the video review, for video review evaluations. Do NOT expect this field to be set if `backend != VIDEO_REVIEW`.
         */
        videoReviewData?: Schema$AbuseiamVideoReviewData;
    }
    export interface Schema$AbuseiamFeature {
        /**
         * Exactly one of the following should be filled in.
         */
        booleanValue?: boolean | null;
        doubleValue?: number | null;
        /**
         * Useful for applications that need to know how many times a specific feature occurs
         */
        featureCount?: string | null;
        /**
         * Useful for timestamps, or for numerical features where it is helpful for decision scripts to have exact values.
         */
        int64Value?: string | null;
        /**
         * integer value field is deprecated and shall only be used for passing the following features hardcoded in spamiam::SpamIAmMessage: spamiam::OrkutSenderId spamiam::OrkutPostnumReports spamiam::BloggerNumComments spamiam::BloggerNumCommentsByOthers Another hard-coded spamiam feature is spamiam::BlogName, which can be specified via string value.
         */
        integerValue?: number | null;
        name?: string | null;
        stringValue?: string[] | null;
        /**
         * This field should only be used to store a sequence of timestamps associated with the feature.
         */
        timestampSequence?: string[] | null;
    }
    /**
     * A node representing a table of regions and restrictions that apply to those regions. This table understands region inclusion and knows to apply the most specific rule, for example, a rule for France would override a rule for the EU for a user in France.
     */
    export interface Schema$AbuseiamGeoRestriction {
        locale?: Schema$AbuseiamGeoRestrictionLocale[];
    }
    export interface Schema$AbuseiamGeoRestrictionLocale {
        /**
         * The location where the restriction applies. Defaults to the "The world". See go/iii.
         */
        location?: string | null;
        /**
         * The UserRestriction that applies to this location. If not specified evaluates to true.
         */
        restriction?: Schema$AbuseiamUserRestriction;
    }
    /**
     * Information about various hashes that can be computed on a message ex: simhash, attachment hash, etc
     */
    export interface Schema$AbuseiamHash {
        /**
         * 64 bit hash in the hex form.
         */
        hash?: string | null;
        type?: string | null;
    }
    export interface Schema$AbuseiamManualReviewerInfo {
        credential?: string[] | null;
        username?: string | null;
    }
    /**
     * Relevant information for manual review evaluations.
     */
    export interface Schema$AbuseiamManualReviewEvaluationInfo {
        /**
         * Reviewer performing the manual review.
         */
        reviewer?: Schema$AbuseiamManualReviewerInfo;
        /**
         * Tool used to perform the manual review.
         */
        tool?: Schema$AbuseiamManualReviewTool;
    }
    export interface Schema$AbuseiamManualReviewTool {
        experimentId?: string | null;
        name?: string | null;
    }
    export interface Schema$AbuseiamNameValuePair {
        name?: string | null;
        nonUtf8Value?: string | null;
        value?: string | null;
    }
    export interface Schema$AbuseiamNotRestriction {
        /**
         * This restriction applies if the child does not apply. Only one is allowed. "repeated" is used to avoid breaking Sawzall (See b/6758277).
         */
        child?: Schema$AbuseiamUserRestriction[];
    }
    export interface Schema$AbuseiamOrRestriction {
        /**
         * This restriction applies if any of the children apply.
         */
        child?: Schema$AbuseiamUserRestriction[];
    }
    export interface Schema$AbuseiamRegion {
        /**
         * This is a CLDR Region Code: http://wiki/Main/IIIHowTo#using_region It is used to denote the region affected by a verdict.
         */
        region?: string | null;
    }
    /**
     * A SpecialRestriction is a standardized UserRestriction which lives in a table maintained via CDD.
     */
    export interface Schema$AbuseiamSpecialRestriction {
        type?: string | null;
    }
    export interface Schema$AbuseiamTarget {
        id?: string | null;
        type?: string | null;
    }
    /**
     * A structure used to configure a notification to a user.
     */
    export interface Schema$AbuseiamUserNotification {
        channel?: string | null;
    }
    /**
     * Describes restrictions on where the verdict applies. Please use {@code TakedownManager\} to evaluate this proto.
     */
    export interface Schema$AbuseiamUserRestriction {
        ageRestriction?: Schema$AbuseiamAgeRestriction;
        /**
         * Operators
         */
        andRestriction?: Schema$AbuseiamAndRestriction;
        /**
         * Constant
         */
        constantRestriction?: Schema$AbuseiamConstantRestriction;
        /**
         * Leaf Nodes
         */
        geoRestriction?: Schema$AbuseiamGeoRestriction;
        notRestriction?: Schema$AbuseiamNotRestriction;
        orRestriction?: Schema$AbuseiamOrRestriction;
        specialRestriction?: Schema$AbuseiamSpecialRestriction;
    }
    /**
     * Verdict against a target. AbuseIAm generates a verdict based on evaluations. AbuseIAm can send such verdicts to clients for enforcement.
     */
    export interface Schema$AbuseiamVerdict {
        /**
         * Target client of the verdict. It can be used to differentiate verdicts from multiple clients when such verdicts are processed in one common place.
         */
        client?: Schema$AbuseiamClient;
        /**
         * Additional info regarding the verdict.
         */
        comment?: string | null;
        decision?: string | null;
        /**
         * Time duration (in minutes) of the verdict.
         */
        durationMins?: number | null;
        /**
         * Evaluations relevant to this verdict. Every Verdict should contain at least one Evaluation.
         */
        evaluation?: Schema$AbuseiamEvaluation[];
        /**
         * Details of all the hashes that can be computed on a message, such as simhash and attachment hash
         */
        hashes?: Schema$AbuseiamHash[];
        /**
         * Is this verdict issued by legal?
         */
        isLegalIssued?: boolean | null;
        /**
         * This field is used to pass relevant / necessary scores to our clients. For eg: ASBE propogates these scores to moonshine.
         */
        miscScores?: Schema$AbuseiamNameValuePair[];
        /**
         * A short description of the reason why the verdict decision is made.
         */
        reasonCode?: string | null;
        /**
         * The regions in which this verdict should be enforced. Absence of this field indicates that the verdict is applicable everywhere.
         */
        region?: Schema$AbuseiamRegion[];
        /**
         * Restrictions on where this verdict applies. If any restriction is met, the verdict is applied there. If no restrictions are present, the verdict is considered global.
         */
        restriction?: Schema$AbuseiamVerdictRestriction[];
        /**
         * Category of the strike if this is a strike verdict.
         */
        strikeCategory?: string | null;
        target?: Schema$AbuseiamTarget;
        /**
         * The timestamp of the target. E.g., the time when the target was updated.
         */
        targetTimestampMicros?: string | null;
        /**
         * When the verdict is generated
         */
        timestampMicros?: string | null;
        /**
         * Extra notification(s) to be delivered to target user or message owner about the verdict.
         */
        userNotification?: Schema$AbuseiamUserNotification[];
        /**
         * version of decision script
         */
        version?: string | null;
    }
    /**
     * Describes restrictions on where the verdict applies.
     */
    export interface Schema$AbuseiamVerdictRestriction {
        /**
         * For a restriction to apply, all contexts must be satisfied. For example, if context[0] is COUNTRY/'GERMANY' and context[1] is DESTINATION_STREAM/'gplus:SQUARE:knitting_discussion', then the verdict applies only when the 'knitting discussion' square is viewed from inside Germany. Please note that this is present for legacy reasons and users of this field would be migrated to use the user_restriction field defined below.
         */
        context?: Schema$AbuseiamVerdictRestrictionContext[];
        /**
         * A boolean expression tree used to define the restrictions where the verdict applies. Please use java/com/google/ccc/abuse/abuseiam/client/TakedownManager.java to evaluate this proto.
         */
        userRestriction?: Schema$AbuseiamUserRestriction;
    }
    /**
     * Describes a dimension of a context where a verdict applies.
     */
    export interface Schema$AbuseiamVerdictRestrictionContext {
        /**
         * String identifying the context.
         */
        id?: string | null;
        type?: string | null;
    }
    /**
     * Information about a video review.
     */
    export interface Schema$AbuseiamVideoReviewData {
        /**
         * Serialized repeated youtube_admin.adminmatch.csai.ReferenceFragment
         */
        referenceFragment?: string[] | null;
        /**
         * Information about the video reviewer.
         */
        reviewer?: Schema$AbuseiamVideoReviewer;
        /**
         * The Viper id of the video.
         */
        videoId?: string | null;
    }
    /**
     * Information about video reviewers.
     */
    export interface Schema$AbuseiamVideoReviewer {
        type?: string | null;
        /**
         * The username of the person doing the video review.
         */
        username?: string | null;
    }
    /**
     * The serialized form of a SORI id. NOTE that this proto is stored in V4/O4 index and that new fields should not be added without getting an agreement from the serving team as well.
     */
    export interface Schema$AdsShoppingReportingOffersSerializedSoriId {
        highId?: string | null;
        lowId1?: string | null;
        lowId2?: string | null;
    }
    export interface Schema$Anchors {
        anchor?: Schema$AnchorsAnchor[];
        /**
         * The total # of local homepage anchors dropped in AnchorAccumulator.
         */
        homepageAnchorsDropped?: string | null;
        /**
         * The index tier from which the anchors were extracted. Note that this is only valid in the anchor record written by linkextractor. The value can be one of the enum values defined in segindexer/types.h.
         */
        indexTier?: number | null;
        /**
         * The total # of local non-homepage anchors dropped in AnchorAccumulator.
         */
        localAnchorsDropped?: string | null;
        /**
         * The total # of non-local anchors dropped in AnchorAccumulator.
         */
        nonlocalAnchorsDropped?: string | null;
        redundantanchorinfo?: Schema$AnchorsRedundantAnchorInfo[];
        /**
         * The *_anchors_dropped fields below are not populated by Alexandria, which uses cdoc.anchor_stats instead. The total # of redundant anchors dropped in linkextractor.
         */
        redundantAnchorsDropped?: string | null;
        /**
         * The total # of supplemental anchors dropped in AnchorAccumulator. ## DEPRECATED.
         */
        supplementalAnchorsDropped?: string | null;
        /**
         * may be implicit
         */
        targetDocid?: string | null;
        /**
         * HOST_LEVEL site chunking.
         */
        targetSite?: string | null;
        /**
         * This is produced during link extraction but not written out in the linklogs in order to save space.
         */
        targetUrl?: string | null;
    }
    export interface Schema$AnchorsAnchor {
        bucket?: number | null;
        /**
         * CATfish tags attached to a link. These are similar to link tags, except the values are created on the fly within Cookbook. See: http://sites/cookbook/exporting/indexing
         */
        catfishTags?: number[] | null;
        /**
         * If the anchor contained images, these image urls are stored here in compressed form.
         */
        compressedImageUrls?: string[] | null;
        /**
         * The anchor's original target url, compressed. Available only in Alexandria docjoins when the anchor is forwarded.
         */
        compressedOriginalTargetUrl?: string | null;
        context?: number | null;
        /**
         * This is a hash of terms near the anchor. (This is a second-generation hash replacing the value stored in the 'context' field.)
         */
        context2?: number | null;
        /**
         * used for history - the first and last time we have seen this anchor. creation_date also used for Freshdocs Twitter indexing, a retweet is an anchor of the original tweet. This field records the time when a retweet is created.
         */
        creationDate?: number | null;
        deleted?: boolean | null;
        deletionDate?: number | null;
        /**
         * DEPRECATED
         */
        demotionreason?: number | null;
        /**
         * Encoded data containing information about newsiness of anchor. Populated only if anchor is classified as coming from a newsy, high quality site. Encoded data for anchor sources are being stored in googledata/quality/freshness/news_anchors/encoded_news_anchors_data.txt Scores are being computed with quality/freshness/news_anchors/ routines.
         */
        encodedNewsAnchorData?: number | null;
        /**
         * If true, the anchor is for experimental purposes and should not be used in serving.
         */
        experimental?: boolean | null;
        /**
         * true iff exp domain
         */
        expired?: boolean | null;
        /**
         * # days past Dec 31, 1994, 23:00:00 UTC (Unix time @788914800) that this link was first seen. Should never occupy more than 15 bits. NOTE: this is NOT the same as creation_date; firstseen_date is filled during link extraction
         */
        firstseenDate?: number | null;
        /**
         * true if we think 'firstseen_date' is an accurate estimate of when the link was actually added to the source page. false if it may have existed for some time before we saw it.
         */
        firstseenNearCreation?: boolean | null;
        fontsize?: number | null;
        /**
         * How the anchor is forwarded to the canonical, available only for forwarded anchors (i.e., the field is set). The forwarding types are defined in URLForwardingUtil (segindexer/segment-indexer-util.h). Always use URLForwardingUtil to access this field and use URLForwardingUtil::GetAnchorForwardingReason to get the explanation how the anchor is forwarded to the canonical. NOTE: Use with caution as it is only set for docjoins generated using the urlmap from repository/updater.
         */
        forwardingTypes?: number | null;
        /**
         * The URL fragment for this anchor (the foo in http://www.google.com#foo)
         */
        fragment?: string | null;
        /**
         * The full context. These are not written out in the linklogs.
         */
        fullLeftContext?: string[] | null;
        fullRightContext?: string[] | null;
        /**
         * The bit ~roughly~ indicates whether an anchor's source and target pages are on the same domain. Note: this plays no role in determining whether an anchor is onsite, ondomain, or offdomain in mustang (i.e., the bit above).
         */
        isLocal?: boolean | null;
        /**
         * Used for history and freshness tracking - the timestamp this anchor is updated in indexing.
         */
        lastUpdateTimestamp?: number | null;
        /**
         * Additional information related to the anchor, such as additional anchor text or scores.
         */
        linkAdditionalInfo?: Schema$Proto2BridgeMessageSet;
        /**
         * Contains info on link type, source page, etc.
         */
        linkTags?: number[] | null;
        /**
         * For ranking purposes, the quality of an anchor is measured by its "locality" and "bucket". See quality/anchors/definitions.h for more information.
         */
        locality?: number | null;
        /**
         * This is the offset for the first term in the anchor - it can be used as a unique ID for the anchor within the document and compared against all per-tag data. This is measured in bytes from the start of the document. We write this out to the linklogs to recover the original order of links after source/target forwarding. This is necessary for computing the global related data.
         */
        offset?: number | null;
        /**
         * The docid of the anchor's original target. This field is available if and only if the anchor is forwarded.
         */
        originalTargetDocid?: string | null;
        /**
         * Original text, including capitalization and punctuation. Runs of whitespace are collapsed into a single space.
         */
        origText?: string | null;
        /**
         * Weight to be stored in linkmaps for pageranker
         */
        pagerankWeight?: number | null;
        /**
         * The number of additional links from the same source page to the same target domain. Not populated if is_local is true.
         */
        parallelLinks?: number | null;
        /**
         * DEPRECATED. It used to be set if firstseen_date is not set. It's to indicate that the anchor is possibly old, but we don't have enough information to tell until the linkage map is updated. TODO(hxu) rename it to possibly_old_firstseen_date_DEPRECATED after clean up other dependencies.
         */
        possiblyOldFirstseenDate?: boolean | null;
        /**
         * TEMPORARY
         */
        setiPagerankWeight?: number | null;
        source?: Schema$AnchorsAnchorSource;
        /**
         *  is to record the quality of the anchor's source page and is correlated with but not identical to the index tier of the source page. In the docjoins built by the indexing pipeline (Alexandria), - Anchors marked TYPE_HIGH_QUALITY are from base documents. - Anchors marked TYPE_MEDIUM_QUALITY are from documents of medium quality (roughly but not exactly supplemental tier documents). - Anchors marked TYPE_LOW_QUALITY are from documents of low quality (roughly but not exactly blackhole documents). Note that the source_type can also be used as an importance indicator of an anchor (a lower source_type value indicates a more important anchor), so it is important to enforce that TYPE_HIGH_QUALITY < TYPE_MEDIUM_QUALITY < TYPE_LOW_QUALITY To add a new source type in future, please maintain the proper relationship among the types as well. TYPE_FRESHDOCS, only available in freshdocs indexing, is a special case and is considered the same type as TYPE_HIGH_QUALITY for the purpose of anchor importance in duplicate anchor removal.
         */
        sourceType?: number | null;
        /**
         * A given target URL may be found in different encodings in different documents. We store the URL encoding with each source anchor so that we can count them later to find the encoding most likely to be expected by the Web site. Around 0.7% of target URLs are expected to require a non-default value here. The default value 0 is referenced in C++ as webutil::kDefaultUrlEncoding. See also webutil/urlencoding.
         */
        targetUrlEncoding?: number | null;
        /**
         * Space-delimited anchor words. Text that needs segmentation (like CJK or Thai) is unsegmented, since we set FLAGS_segment_during_lexing to false in mr-linkextractor.cc .
         */
        text?: string | null;
        /**
         * This field is DEPRECATED and no longer filled. For source page crawl timestamp, use Source.crawl_timestamp. Next tag id should be 62.
         */
        timestamp?: string | null;
        /**
         * DEPRECATED: Now in link_tags
         */
        type?: number | null;
        /**
         * weights are 0-127
         */
        weight?: number | null;
    }
    /**
     * attributes of the source document for the link
     */
    export interface Schema$AnchorsAnchorSource {
        /**
         * Additional information related to the source, such as news hub info.
         */
        additionalInfo?: Schema$Proto2BridgeMessageSet;
        /**
         * anchor++ cluster id
         */
        cluster?: number | null;
        /**
         * compressed source url
         */
        compressedUrl?: string | null;
        /**
         * Source page crawl timestamp.
         */
        crawlTimestamp?: string | null;
        /**
         * The docid field used to be "required", but it is now "optional" because it is not present when anchors are stored in webtable. When anchors are stored as part of docjoin files in the segment indexer, however, docid should be considered required.
         */
        docid?: string | null;
        /**
         * necessary for anything?
         */
        doclength?: number | null;
        /**
         * Information about if the source page is a home page. It can be one of the enum values defined in PerDocData::HomePageInfo (NOT_HOMEPAGE, NOT_TRUSTED, PARTIALLY_TRUSTED, and FULLY_TRUSTED).
         */
        homePageInfo?: number | null;
        /**
         * uint16 scale
         */
        indyrank?: number | null;
        /**
         * DEPRECATED, use packed_ipaddress
         */
        ipaddr?: number | null;
        /**
         * default -\> English
         */
        language?: number | null;
        /**
         * 0 -\> no hash
         */
        linkhash?: string | null;
        /**
         * Countries to which the source page is local/most relevant; stored as III identifiers for country/region codes (see http://go/iii).
         */
        localCountryCodes?: number[] | null;
        /**
         * This NSR value has range [0,1000] and is the original value [0.0,1.0] multiplied by 1000 rounded to an integer.
         */
        nsr?: number | null;
        outdegree?: number | null;
        /**
         * approx num of pointed-to sites
         */
        outsites?: number | null;
        /**
         * string in IPAddress::ToPackedString() format.
         */
        packedIpaddress?: string | null;
        /**
         * uint16 scale
         */
        pagerank?: number | null;
        /**
         * unit16 scale
         */
        pagerankNs?: number | null;
        /**
         * Page tags are described by enum PageTag in PerDocData. Page tags are used in anchors to identify properties of the linking page. These are DEPRECATED: in the future, use link_tags instead. DEPRECATED
         */
        pageTags?: number[] | null;
        /**
         * DEPRECATED
         */
        seglanguage?: number | null;
        site?: string | null;
        /**
         * uint16 scale
         */
        spamrank?: number | null;
        /**
         * deprecated, to be removed after October 20. 0-127 scale
         */
        spamscore1?: number | null;
        /**
         * 0-127 scale
         */
        spamscore2?: number | null;
        /**
         * Webtable key of source
         */
        webtableKey?: string | null;
    }
    /**
     * NOTE: in docjoins, the following anchor sampling information is only ## available in the first record of a document (under the same docid). The total number of redundant anchors dropped per (domain, text) in linkextractor. If we receive a large number of anchors from a particular domain, then we'll throw out all but a sampling of them from that domain. The data is sorted by the (domain,text) pairs. This field is not populated by Alexandria, which uses cdoc.anchor_stats instead.
     */
    export interface Schema$AnchorsRedundantAnchorInfo {
        anchorsDropped?: string | null;
        domain?: string | null;
        text?: string | null;
    }
    /**
     * Represents a GSuite customer ID. Obfuscated with CustomerIdObfuscator.
     */
    export interface Schema$AppsDynamiteCustomerId {
        customerId?: string | null;
    }
    /**
     * Contains info about the entity that something is, or is owned by.
     */
    export interface Schema$AppsDynamiteSharedOrganizationInfo {
        consumerInfo?: Schema$AppsDynamiteSharedOrganizationInfoConsumerInfo;
        customerInfo?: Schema$AppsDynamiteSharedOrganizationInfoCustomerInfo;
    }
    /**
     * Intentionally empty. Used to disambiguate consumer and customer use cases in oneof below.
     */
    export interface Schema$AppsDynamiteSharedOrganizationInfoConsumerInfo {
    }
    export interface Schema$AppsDynamiteSharedOrganizationInfoCustomerInfo {
        customerId?: Schema$AppsDynamiteCustomerId;
    }
    /**
     * Contains info on membership count for member types: HUMAN_USER, APP_USER & ROSTER_MEMBER different states: INVITED, JOINED
     */
    export interface Schema$AppsDynamiteSharedSegmentedMembershipCount {
        /**
         * count of members with given type and state
         */
        membershipCount?: number | null;
        membershipState?: string | null;
        memberType?: string | null;
    }
    export interface Schema$AppsDynamiteSharedSegmentedMembershipCounts {
        value?: Schema$AppsDynamiteSharedSegmentedMembershipCount[];
    }
    /**
     * A DestinationStream is a /namespace/id[0]/id[1]/.../id[n] that represents a collection of Activities. Example destinations: -The Profile Stream on http://plus.google.com/+JohnDoe/posts -A Square Stream on http://plus.google.com/squares/123 -A "comment Stream" (Fountain) on http://www.youtube.com/watch?id=123 It's possible for a single Activity to show in each of these destinations - and it might behave/look slightly differently for each one. Destinations can have their own business logic associated with them at both write-time and read-time server-side (these are documented below). Each DestinationStream is indexed and can be retrieved using the GetDestinationStreamRequest. For the repeated ID space indexing happens at all levels, e.g. if you have: /square/123/abc /square/123/efd /square/456 You can fetch /square/123/abc directly or /square/123 (which includes all Activities in both /square/123/abc and /square/123/efd), or even /square which retrieves all Activities in the Square namespace (visible for that user). On the storage layer, we represent DestinationStream as Channel (http://cs/#google3/social/common/channel/channel.proto), since the storage does not have the concept of a Stream. Both terms are used interchangeably within the service layer, but client of Social Infrastructure should use the term DestinationStream. Next ID: 3
     */
    export interface Schema$AppsPeopleActivityBackendDestinationStream {
        /**
         * The hierarchy of IDs. Each individual ID is "flat" and the repeated list defines the hierarchy. Namespaces define the "validity" of this hierachy (depth, naming convention, etc) and the server will reject invalid IDs.
         */
        id?: string[] | null;
        namespace?: string | null;
    }
    /**
     * Stores the number of different kind of user engagement actions. Abuse Report is also consider an engagement. Currently we only have abuse report engagements but in future we might add other types of engagements as well.
     */
    export interface Schema$AppsPeopleActivityStreamqualityDistillerEngagements {
        /**
         * Corresponds on "This account might be compromised or hacked" reporting action.
         */
        reportCompromised?: string | null;
        /**
         * Corresponds on "Harassment or bullying" reporting action.
         */
        reportHarassment?: string | null;
        /**
         * Corresponds on "Hate speach or graphic violence" reporting action.
         */
        reportHate?: string | null;
        /**
         * Corresponds on "Pornography or sexually explicit material" reporting action.
         */
        reportPorn?: string | null;
        /**
         * Corresponds on "Unwanted commercial content or spam" reporting action.
         */
        reportSpam?: string | null;
        /**
         * Number of times this activity was served out of asbe/stanza.
         */
        serveCount?: string | null;
        /**
         * Timestamp in seconds for which time this record is valid.
         */
        timeSec?: string | null;
        /**
         * Corresponds on Distiller comment thumbs down action.
         */
        ytThumbsDown?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiAbout {
        contentType?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * Sanitized HTML value that is only populated when the SANITIZE_ABOUT_HTML extension is requested.
         */
        safeHtmlValue?: Schema$WebutilHtmlTypesSafeHtmlProto;
        value?: string | null;
    }
    /**
     * Extension data for use in AboutMe.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedData {
        nameDisplayOptions?: Schema$AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataNameDisplayOptions;
        photosCompareData?: Schema$AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataPhotosCompareData;
        profileEditability?: Schema$AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataProfileEditability;
        profileNameModificationHistory?: Schema$AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataProfileNameModificationHistory;
    }
    /**
     * See NameDisplayOptions in //depot/google3/focus/backend/proto/backend.proto. See also go/nickname-mess.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataNameDisplayOptions {
        nicknameOption?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataPhotosCompareData {
        diffData?: Schema$AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataPhotosCompareDataDiffData;
        highResUrl?: string | null;
        /**
         * True if photo diff is greater than 0.01 on any color band, or if the user has a low res photo but no high res photo. This field is primarily for use in About Me and for other uses it's recommended to use the DiffData values directly instead. The cutoff is based on a heuristic determined in go/comparing-profile-photos
         */
        inconsistentPhoto?: boolean | null;
        /**
         * Only present if the photo diff is greater than 0.01 on any color band.
         */
        lowResData?: string | null;
        lowResUrl?: string | null;
        monogramUrl?: string | null;
        /**
         * True if the low-res photo has a private ACL set.
         */
        privateLowResAcl?: boolean | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataPhotosCompareDataDiffData {
        blueDiff?: number | null;
        greenDiff?: number | null;
        redDiff?: number | null;
    }
    /**
     * See UserEditedLockedMask in //depot/google3/focus/backend/proto/backend.proto.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataProfileEditability {
        /**
         * Read-only set of zero or more field paths that are locked for update on this person, such as "person.name", "person.email", etc. The set of fields is only populated for the requester's profile. Fields in the set cannot be edited, added, or deleted from the profile. Attempting to update any of these fields will result in an exception.
         */
        lockedField?: string[] | null;
    }
    /**
     * See ABUSE_NAME_LAST_MODIFIED in //depot/google3/focus/backend/proto/backend.proto which maps to //depot/google3/focus/proto/profileattribute.proto
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataProfileNameModificationHistory {
        /**
         * The number of name changes remaining at RPC request time. This can be more than name_changes_remaining, if user hasn't changed name for some time and accrued quota since last change.
         */
        computedNameChangesRemaining?: number | null;
        /**
         * The number of nickname changes remaining at RPC request time. This can be more than nickname_changes_remaining, if user hasn't changed nickname for some time and accrued quota since last change.
         */
        computedNicknameChangesRemaining?: number | null;
        /**
         * The number of name changes remaining at the time the name was last modified.
         */
        nameChangesRemaining?: number | null;
        /**
         * The last time the profile name was modified in milliseconds UTC.
         */
        nameLastModified?: string | null;
        /**
         * The number of nickname changes remaining at the time the nickname was last modified.
         */
        nicknameChangesRemaining?: number | null;
        /**
         * The last time the profile nickname was modified in milliseconds UTC.
         */
        nicknameLastModified?: string | null;
        quotaEnforcementStatus?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiAccountEmail {
        email?: string | null;
    }
    /**
     * Additional information about a container. TO BE DELETED: replaced by DeviceContactInfo.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiAdditionalContainerInfo {
        /**
         * When the container is a DEVICE_CONTACT, this list provides account information from the raw contact which is the source of this field.
         */
        rawDeviceContactInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiRawDeviceContactInfo[];
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiAddress {
        country?: string | null;
        countryCode?: string | null;
        /**
         * FeatureId associated with the address. The format is the same as that used for ids in PLACE containers in SourceIdentity.
         */
        encodedPlaceId?: string | null;
        extendedAddress?: string | null;
        formatted?: string | null;
        /**
         * The `type` translated and formatted in the request locale. See go/people-api-howto/localization for details on how to usage.
         */
        formattedType?: string | null;
        locality?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        poBox?: string | null;
        pointSpec?: Schema$AppsPeopleOzExternalMergedpeopleapiPointSpec;
        postalCode?: string | null;
        region?: string | null;
        streetAddress?: string | null;
        /**
         * The type of the address. The type can be free form or one of these predefined values: * `home` * `work` * `other`
         */
        type?: string | null;
    }
    /**
     * Similar to social.graph.storage.Affinity, but pared down to what the clients of the People API are interested in.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiAffinity {
        /**
         * Contains extra ranking information returned by DAS.
         */
        affinityMetadata?: Schema$SocialGraphWireProtoPeopleapiAffinityMetadata;
        affinityType?: string | null;
        /**
         * The ID of the container
         */
        containerId?: string | null;
        /**
         * The type of container to which this affinity applies
         */
        containerType?: string | null;
        /**
         * Used to log events for this affinity value, for disco diagnostic-purposes. See go/disco-diagnostics.
         */
        loggingId?: string | null;
        /**
         * Affinity value. Frequently represented as an inverse ranking, sometimes with additional data encoded. If data_formats.affinity_formats.score_format is set to RAW_SCORE then the value will be the score returned by DAS.
         */
        value?: number | null;
    }
    /**
     * Please read go/people-api-howto:age on how to get age data. Message for the `Person.age_range_repeated` field. Replaces the existing `Person.age_range` field.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiAgeRangeType {
        /**
         * Please read go/people-api-howto:age on how to get age data. Age of the user. The field is set based on profile storage fields such as account birthday. If the source fields are not present, `age_in_years` will be left unset.
         */
        ageInYears?: number | null;
        /**
         * Deprecated. Use go/supervised-accounts#capabilities-for-child-accounts instead. Denotes whether the user is under the region based Age of Consent. The user's region is based on ClientUserInfo.GlobalTos.AgreedLocation The age is inferred from Birthday field or CertifiedBornBefore field. The region based AoC is specified at go/aoc.
         */
        ageOfConsentStatus?: string | null;
        /**
         * Deprecated. Please read go/people-api-howto:age on how to get age data. Age range is populated based on `account_birthday` and `certified_born_before`, which may not be set for dasher users.
         */
        ageRange?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
    }
    /**
     * Store all app unique info that are needed for app action fulfillment.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiAppUniqueInfo {
        /**
         * Store the app unique id endpoint. This will be passed over to app to fulfill the action. For example, app_unique_id for Whatsapp will be "11234567890@s.whatsapp.net"
         */
        appUniqueId?: string | null;
        /**
         * Where this contact info was retrieved from. Note: only added for Assistant usage, and will not be populated by PAPI. This is due to the coupling between Assistant Proto, and PAPI proto. (//depot/google3/quality/qrewrite/servlets/proto/focus_name.proto)
         */
        contactInfoSource?: string | null;
        /**
         * Store third party endpoint that is displayed to users. For example, display_app_unique_id for Whatsapp will be "Message +11234567890".
         */
        displayAppUniqueId?: string | null;
        /**
         * Store third party endpoint label. For example, "HOME", "WORK"
         */
        label?: string | null;
        /**
         * Store mimetype of this endpoint. We will use this as the differentiator for Assistant to know whether to use the RawContact for messaging, call or video call. For example, send message mimetype for whatsapp: "vnd.android.cursor.item/vnd.com.whatsapp.profile" voice call mimetype for whatsapp: "vnd.android.cursor.item/vnd.com.whatsapp.voip.call"
         */
        mimetype?: string | null;
    }
    /**
     * The best suggested name to use for the Person from the available source fields, which may include FileAs, Name, Org, Email, IM, Phone, ... Rough source container priority order is Contact, then Profile, then Place.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiBestDisplayName {
        /**
         * The container the suggested name was sourced from
         */
        containerType?: string | null;
        /**
         * The display name. This name is intended to be the best name to display for this Person. It may be built from a variety of fields, even if those fields are not explicitly requested in the request mask. Generally, the display name is formatted in 'first last' format. If the name appears to be a CJK name (as determined by a heuristic), the 'last first' format will be used. There may be other cases that the 'last first' format is used which are not documented here. See the code at: http://google3/java/com/google/focus/backend/client/DisplayNameFormatter.java?l=659&rcl=351360938
         */
        displayName?: string | null;
        /**
         * The display name, always in 'last first' format. This field does not depend on the format of `display_name` and will always be in 'last first' format.
         */
        displayNameLastFirst?: string | null;
    }
    /**
     * IMPORTANT NOTES: - Requesting person.birthday requires membership in the purpose limited data ACL group sgbe-ac-d-birthday-(read|mutate). Contact people-api-eng@ for assistance with initial setup. - The birthday field should not be used to calculate the requester's age! To determine the requester's age, use person.age_range_repeated. - For more details about age see go/peopleapi-howto/age Birthday value may not be present: - Consumer users generally required to have account birthday set (required at account creation), though some users created via legacy flows may not have birthday present. - Dasher users generally don't require birthday, but could optionally have it set by users. - Any other types of accounts (e.g. robot, service) do not have birthdays. - Account Birthday field may be present but without birthday value set for grace period birthday (provisional new birthday). For users that do have birthday data: - "Profile Birthday" (person.birthday.metadata.container is PROFILE) may not have a year set if user "hides" the year. - "Account Birthday" (see api-specific notes below) will only be returned for the requester's own profile. - People API (go/peopleapi): * Account birthday is only supported in GetPeople for PeopleAPI. * If account birthday is needed, use a request mask with: `include_field { paths: "person.birthday" \}` `include_container: ACCOUNT` - People API++ (go/peopleapi++): * Account birthday is supported for most apis in PeopleAPI++. * If account birthday is needed, use a request mask with: `include_field { paths: "person.account_birthday" \}` `include_container: PROFILE` (note: it will also need `include_container: DOMAIN_PROFILE` because they must be requested together: go/people-api-masks#profile-domain_profile) - See go/papi-vs-papi++#birthday for more details.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiBirthday {
        /**
         * Only supported for PROFILE/DOMAIN_PROFILE/ACCOUNT container.
         */
        ageDisableGracePeriod?: Schema$AppsPeopleOzExternalMergedpeopleapiBirthdayAgeDisableGracePeriod;
        /**
         * Whether the user has opted in to display their birthday via photo decorations. Only supported for PROFILE/DOMAIN_PROFILE container.
         */
        birthdayDecoration?: Schema$SocialGraphApiProtoBirthdayDecoration;
        /**
         * Only supported for PROFILE/DOMAIN_PROFILE/ACCOUNT container.
         */
        birthdayResolution?: string | null;
        /**
         * Birthdays are more accurately represented as a calendar day that does not depend on a timestamp representation at all. When given a timestamp, there are lots of opportunities to make mistakes, so a CalendarDay proto is replacing timestamps. Currently this is always returned by PeopleApi on reads that include birthday fields. New clients should write using calendar_day. Clients that were already writing via date_ms are allowlisted such that writes use that field. Old callers should migrate to writing BOTH date_ms and calendar_day values. If those are consistent, they may be removed from the 'legacy_timestamp_event_write_behavior_enabled' capability.
         */
        calendarDay?: Schema$GoogleTypeDate;
        /**
         * Birthdays are currently represented as timestamp values, although the interpretation of these timestamp values is a calendar date. Clients are recommended to read the calendar_day field, which is easier to work with than date_ms. New clients writing to PeopleApi must set calendar_day instead of date_ms. There are a few important details about how this value should be mapped to a calendar date that should be consistent among all clients. 1. Epoch - The epoch or calendar date equivalent to 0 ms is chosen to be 1970-01-01 UTC. 2. Timezone - All of the conversions to calendars should occur in the UTC timezone. We don't typically think of someones birthday changing when they travel, so clients should not use local times. 3. Calendar - The calendar used for the dates should be a Gregorian proleptic calendar. Proleptic means that the rules of the Gregorian calendar are retrofitted to before its adoption. It is easy to get this wrong, particularly with the java GregorianCalendar class, which by default is a mixed Gregorian/Julian calendar. Joda Time makes this easy, but if it's not an option, look into GregorianCalendar.setGregorianChange(). 4. Omitted years - Clients have chosen to represent birthdays or events without years as timestamps within the year zero. When the computed date has a year of 0, it means the client did not specify a year. Note that a year 0 does not exist in a chronology like the familiar Anno Domini (A.D. and B.C.); clients must agree on year numbering. 5. Year Numbering - The chronology used to map dates to the calendar should use Astronomical Year Numbering so that the year 0 is defined and dates before it have a negative year. If libraries only provide Anno Domini, then the year of 1 BC corresponds to year zero and an omitted user provided year. Other BC values are presumed rare, but clients should still not ignore the era and interpret the year as an A.D. value, especially if writing values back to PeopleApi.
         */
        dateMs?: string | null;
        /**
         * date_ms_as_number contains the same data as date_ms, but has a different type in generated javascript bindings. Non javascript clients can ignore it.
         */
        dateMsAsNumber?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * People Prompts settings for contact birthday data. Only supported for CONTACT container.
         */
        prompt?: Schema$SocialGraphApiProtoPrompt;
        /**
         * Actual value entered. Allows unstructured values.
         */
        value?: string | null;
    }
    /**
     * Whether this field is set or not determines whether an account is in the grace period. While in the grace period, the user is unable to change their birthday on their own, and will be age-disabled if they don't act in a limited amount of time. Applies only to ServiceData Birthday. Users enter the grace period if they choose a birthday below the Age of Consent (go/aoc). After the grace period ends, the account will be age disabled. See go/age-disable-grace-period-dd.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiBirthdayAgeDisableGracePeriod {
        /**
         * Provisional birthday <AoC the user provided, which made them enter the grace period. The main birthday fields were not altered yet while in the grace period.
         */
        calendarDay?: Schema$GoogleTypeDate;
        /**
         * Timestamp which signifies the end of the grace period for this account.
         */
        gracePeriodEnd?: string | null;
        /**
         * Timestamp which signifies the start of the grace period for this account.
         */
        gracePeriodStart?: string | null;
        gracePeriodType?: string | null;
        manualGracePeriodInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiBirthdayAgeDisableGracePeriodManualGracePeriodInfo;
    }
    /**
     * Information provided within MutateDataRequest when setting a user into AgeDisableGracePeriod manually. When the grace period expires, this info will be forwarded to Gaia when disabling the user. cs//symbol:InitiateAgeDisableGracePeriodArguments
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiBirthdayAgeDisableGracePeriodManualGracePeriodInfo {
        /**
         * The Gaia ID of an email that ops can send inquiries to for appeals.
         */
        escalateTo?: string | null;
        /**
         * The Gaia ID of a Googler who initiated this disable.
         */
        executedBy?: string | null;
        /**
         * When setting a user into age grace period manually, the requester can additionally supply a short human-readable reason of why the account is put into manual grace period. The description will be forwarded to Gaia when we disable the account when the grace period expires.
         */
        reason?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiBraggingRights {
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        value?: string | null;
    }
    /**
     * A url to the person's calendar. As of 03/2018 is not supported for user Profile.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiCalendar {
        /**
         * The `type` translated and formatted in the request locale. See go/people-api-howto/localization for details on how to usage.
         */
        formattedType?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * The type of the calendar URL. The type can be free form or one of these predefined values: * `home` * `freeBusy` * `work`
         */
        type?: string | null;
        url?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiCallerIdExtendedData {
        /**
         * Indicates which data source was used to populate the caller ID result
         */
        callerIdSource?: Schema$AppsPeopleOzExternalMergedpeopleapiCallerIdExtendedDataCallerIdSource;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiCallerIdExtendedDataCallerIdSource {
        sourceType?: string | null;
    }
    /**
     * Information related to domain administrator (or authority) certification of a users age.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiCertifiedBornBefore {
        /**
         * Indicates that the user was born at or before this time.
         */
        bornBefore?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiChannelData {
        /**
         * Unique ID that corresponds to a Youtube channel.
         */
        channelId?: string | null;
        /**
         * Number of comments for a given Youtube channel.
         */
        commentCount?: string | null;
        /**
         * Description of the channel.
         */
        description?: string | null;
        playlistCount?: string | null;
        /**
         * A FIFE URL pointing to the channel's profile image (go/avatar-fife-urls) with default fife url options. Also refer to go/people-api-concepts:photos for People API's FIFE best practices. The image could be up to a couple of days stale, though it is much fresher in practice. If a fresh image is required, contact the YouTubeAccountProfileService. The URL itself expires ~30 days after generation.
         */
        profilePictureUrl?: string | null;
        /**
         * URL of user's Youtube channel profile.
         */
        profileUrl?: string | null;
        /**
         * Number of subscribers for a given Youtube channel.
         */
        subscriberCount?: string | null;
        /**
         * Title of the YouTube channel
         */
        title?: string | null;
        /**
         * Whether or not the channel's profile has a title/avatar that is canonical in YouTube. Used to determine if the product profile card should be part of the core persona or have their own persona.
         */
        usesYoutubeNames?: boolean | null;
        /**
         * Number of videos uploaded in a given Youtube channel.
         */
        videoCount?: string | null;
    }
    /**
     * A circle membership that the person has. A circle membership is created by adding a person to a circle by person-id or by email.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiCircleMembership {
        /**
         * The circle that the person belongs to.
         */
        circleId?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
    }
    /**
     * Arbitrary client data that is populated based on the client
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiClientData {
        key?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        namespace?: string | null;
        value?: string | null;
    }
    /**
     * Email for Google product communication with the user. This is only allowed in ServiceData. It is purely synthesized and read-only, and contains at most one field. It proxies from RawCommunicationEmail and only includes the primary field if exists. Otherwise if RawCommunicationEmail does not have primary, this includes a field synthesized from valid Gaia primary account email. Otherwise if Gaia primary account email is invalid, this field is empty. See go/comm-email-use for more details.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiCommunicationEmail {
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        value?: string | null;
    }
    /**
     * Contact-level people-prompts settings and contact-level connection reminders. Part of go/people-prompts.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiConnectionReminder {
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * Contact-level "reminder to connect" prompts for this contact.
         */
        prompt?: Schema$SocialGraphApiProtoPrompt[];
    }
    /**
     * Contact creation timestamps and related metadata. See go/contact-edit-history. This message is a pure wrapper of the shared ContactCreactionContext message so that it can be a top-level person field. No other fields should be added to the message.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiContactCreateContextInfo {
        contactCreateContext?: Schema$SocialGraphApiProtoContactCreateContext;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
    }
    /**
     * Contact edit timestamps and related metadata. See go/contact-edit-history. This message is a pure wrapper of the shared ContactCreactionContext message so that it can be a top-level person field. No other fields should be added to the message.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiContactEditContextInfo {
        contactEditContext?: Schema$SocialGraphApiProtoContactEditContext;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
    }
    /**
     * A membership that the person has. The person can be a member of multiple circles and multiple contact-groups. A circle membership is created by adding a person to a circle by person-id or by email. A contact-group membership is created by adding a contact to a contact-group.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiContactGroupMembership {
        /**
         * The contact-group that the person belong to. The id can be either a hex-formatted id or a camel-cased SystemContactGroup predefined group name. The id will be predefined group name iff the system_contact_group_id has a value.
         */
        contactGroupId?: string | null;
        /**
         * Information related to delegated group that this contact belongs to.
         */
        delegatedGroupInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiDelegatedGroupInfo;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * This field will be populated when the membership is in a system-reserved contact-group.
         */
        systemContactGroupId?: string | null;
    }
    /**
     * Contact level People Prompt settings. This message is a pure wrapper of the shared ContactPromptSettings message so that it can be a top-level person field. No other fields should be added to the message.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiContactPromptSettingsInfo {
        contactPromptSettings?: Schema$SocialGraphApiProtoContactPromptSettings;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
    }
    /**
     * Contact state and related metadata. See go/fbs-contacts-trash. This message is a pure wrapper of the shared ContactState message so that it can be a top-level person field. No other fields should be added to the message.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiContactStateInfo {
        contactState?: Schema$SocialGraphApiProtoContactState;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
    }
    /**
     * CoverPhoto is the long banner photo (also called full bleed photo) at the top of G+ profile page.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiCoverPhoto {
        imageHeight?: number | null;
        imageId?: string | null;
        imageUrl?: string | null;
        imageWidth?: number | null;
        isAnimated?: boolean | null;
        isDefault?: boolean | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
    }
    /**
     * Contains customer data for profile owner proxied from D3.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiCustomerInfo {
        /**
         * DEPRECATED. Use obfuscated_customer_id instead. If result has a GSuite Customer ID, this field will continue to be populated with -1 to indicate the presence of a value for backwards compatibility with clients in the wild. See b/144596193.
         */
        customerId?: string | null;
        /**
         * Customer organization name for dasher user.
         */
        customerName?: string | null;
        /**
         * Obfuscated FlexOrgs customer ID for Dasher user. See cs/symbol:CustomerIdObfuscator.
         */
        obfuscatedCustomerId?: string | null;
    }
    /**
     * Custom fields associated with a person, from the custom schema defined on the domain. See go/custompeopleapi and go/customfocus. NOTE: these are only updatable via Cloud Directory (go/cd).
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiCustomSchemaField {
        fieldDisplayName?: string | null;
        fieldId?: string | null;
        fieldType?: string | null;
        /**
         * The `type` translated and formatted in the request locale. See go/people-api-howto/localization for details on how to usage.
         */
        formattedType?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        multiValued?: boolean | null;
        schemaDisplayName?: string | null;
        schemaId?: string | null;
        /**
         * The type of the custom schema field. The type can be free form or one of these predefined values: * `home` * `other` * `work`
         */
        type?: string | null;
        /**
         * String representation of the value, based on FieldType
         */
        value?: string | null;
    }
    /**
     * Container information for deduping. When two fields have the same value and only differ by field.metadata a service implementation can choose to avoid duplicating the fields and instead set field.metadata.other_deduped_containers This type can include information on the dedupe type (for example, strict value match vs. lenient value match)
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiDedupedContainerInfo {
        /**
         * See SourceIdentity.container_type
         */
        containerType?: string | null;
        /**
         * See SourceIdentity.id
         */
        id?: string | null;
    }
    /**
     * Information related to delegated group that this contact belongs to.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiDelegatedGroupInfo {
        /**
         * Required. The additional id specifically for a delegated group.
         */
        delegatedGroupId?: Schema$SocialGraphApiProtoDelegatedGroupId;
    }
    /**
     * Extra metadata for an aggregated or raw device contact.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiDeviceContactExtraMetadata {
        /**
         * Attributes for this device contact.
         */
        attributes?: string[] | null;
        /**
         * Usage info for this device contact.
         */
        usageInfo?: Schema$SocialGraphApiProtoUsageInfo[];
    }
    /**
     * Unique id for an aggregated device contact.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiDeviceContactId {
        /**
         * Aggregated device contact id on the source device.
         */
        contactId?: string | null;
        /**
         * Source device id (go/client-instance-id) of this device contact.
         */
        deviceId?: string | null;
    }
    /**
     * Device contact information.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiDeviceContactInfo {
        /**
         * Metadata for this device contact.
         */
        deviceContactMetadata?: Schema$AppsPeopleOzExternalMergedpeopleapiDeviceContactExtraMetadata;
        /**
         * Output only. True if any of the contact's phone, email or address fields can be used on devices other than the one it originated from. Note that there can be other fields, typically name, and metadata such as some of the raw_contact_infos that can be used on other devices. Assigned by the server.
         */
        hasCrossDeviceData?: boolean | null;
        /**
         * Id of the device contact.
         */
        id?: Schema$AppsPeopleOzExternalMergedpeopleapiDeviceContactId;
        /**
         * Last time a device contact was updated on device.
         */
        lastClientUpdateTime?: string | null;
        /**
         * An opaque value used by the device to look up this contact if its row id changed as a result of a sync or aggregation. See: https://developer.android.com/reference/android/provider/ContactsContract.ContactsColumns.html#LOOKUP_KEY
         */
        lookupKey?: string | null;
        /**
         * Info about the raw device contacts that make up this device contact.
         */
        rawContactInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiRawDeviceContactInfo[];
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiEdgeKeyInfo {
        /**
         * The container ID of the entity this field creates a join to. See `SourceIdentity.id`.
         */
        containerId?: string | null;
        /**
         * The type of container that this edge points to. See `SourceIdentity.container_type`.
         */
        containerType?: string | null;
        /**
         * Data that is added to the proto by peopleapi read extensions.
         */
        extendedData?: Schema$AppsPeopleOzExternalMergedpeopleapiEdgeKeyInfoExtensionData;
        /**
         * True indicates this edge links this source to a container represented by this person object. Note: Except for certain legacy clients, EdgeKeyInfo is only created for for edges to an entity in this person and this will always be true.
         */
        materialized?: boolean | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiEdgeKeyInfoExtensionData {
        /**
         * The GDataCompatibilityExtension will (temporarily) return mobile_owner_id for profile containers.
         */
        gdataCompatibilityExtensionId?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiEmail {
        certificate?: Schema$AppsPeopleOzExternalMergedpeopleapiEmailCertificate[];
        classification?: string | null;
        /**
         * To read or update, use the CONTACT_GROUP_PREFERENCE mask field.
         */
        contactGroupPreference?: Schema$AppsPeopleOzExternalMergedpeopleapiEmailContactGroupPreference[];
        displayName?: string | null;
        extendedData?: Schema$AppsPeopleOzExternalMergedpeopleapiEmailExtendedData;
        /**
         * The `type` translated and formatted in the request locale. See go/people-api-howto/localization for details on how to usage.
         */
        formattedType?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        signupEmailMetadata?: Schema$AppsPeopleOzExternalMergedpeopleapiEmailSignupEmailMetadata;
        /**
         * The type of the email address. The type can be free form or one of these predefined values: * `home` * `work` * `other`
         */
        type?: string | null;
        value?: string | null;
    }
    /**
     * Represents a S/MIME certificate config for use with Gmail. See //caribou/smime/proto/certificate_status.proto. There can be zero or more certificates associated with an email address, be it profile email or contact email.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiEmailCertificate {
        /**
         * The name of this certificate configuration. Examples could be "High security level" or "For domain emails only".
         */
        configurationName?: string | null;
        /**
         * It is conceivable that certificates could be ACLed. We also need to indicate which certificate is the default. The PersonFieldMetadata can accomplish both of these.
         */
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        status?: Schema$AppsPeopleOzExternalMergedpeopleapiEmailCertificateCertificateStatus;
    }
    /**
     * Minimal S/MIME certificate status i.e. two fields per email address.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiEmailCertificateCertificateStatus {
        /**
         * The certificate expiration timestamp in seconds.
         */
        notAfterSec?: string | null;
        /**
         * Current status of the email's certificate chain.
         */
        statusCode?: string | null;
    }
    /**
     * Preferred email addresses for contact groups.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiEmailContactGroupPreference {
        contactGroupId?: string | null;
        /**
         * If the Preference was implicitly set by PeopleApi/Contacts Service. A preference with this bit will not be saved to storage. See go/contact-group-email-preference-papi-problem for more info.
         */
        isSynthetic?: boolean | null;
        type?: string | null;
    }
    /**
     * Extension data for a person email.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiEmailExtendedData {
        /**
         * For use with the CUSTOMER_INFO_ADDITIONAL_DATA extension. This includes information on whether the given email is internal to or external to the requesting user's domain.
         */
        internalExternal?: Schema$PeoplestackFlexorgsProtoInternalExternal;
        /**
         * For ListPeoplebyKnownId to indicate an email is sythesized from a lookup email.
         */
        isPlaceholder?: boolean | null;
        /**
         * For use with the TLS extension. Whether the SMTP server that handles delivery for this email address supports TLS encryption.
         */
        smtpServerSupportsTls?: boolean | null;
        /**
         * For use with the Gmail Homograph Warning extension. Whether the email contains mixed character sets that could be used to decieve users. This field is populated by the GMAIL_SECURITY_DATA extension.
         */
        usesConfusingCharacters?: boolean | null;
    }
    /**
     * Additional metadata for a signup email. This will only be set if the email's classification is SIGNUP_EMAIL.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiEmailSignupEmailMetadata {
        /**
         * This is considered to be the primary signup email. At most 1 signup email will have this set.
         */
        primary?: boolean | null;
    }
    /**
     * Emergency info for Person. See go/emergency-trusted-contacts-papi.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiEmergencyInfo {
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * Opaque id from Pomeroy (go/pomeroy). Non-empty pomeroy_id means that this contact has the potential to become trusted contact or it's already trusted contact. Trust is eventually gaia<-\>gaia link, but when the trust link is initiated gaia might not be known. Until gaia is discovered, pomeroy_id is used to identify the contact uniquely. If trust_level is missing or set to TRUST_LEVEL_UNSPECIFIED pomeroy_id must be empty.
         */
        pomeroyId?: string | null;
        trustLevel?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiEvent {
        /**
         * Event are more accurately represented as a calendar day that does not depend on a timestamp representation at all. When given a timestamp, there are lots of opportunities to make mistakes, so a CalendarDay proto is replacing timestamps. PeopleApi will return these values on reads, and unless the client is a legacy caller in the legacy_timestamp_event_write_behavior_enabled capability allowlist, this value is what is used for Person writes.
         */
        calendarDay?: Schema$GoogleTypeDate;
        /**
         * The `type` translated and formatted in the request locale. See go/people-api-howto/localization for details on how to usage.
         */
        formattedType?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * People Prompts settings for contact event data.
         */
        prompt?: Schema$SocialGraphApiProtoPrompt;
        /**
         * Clients are recommended to read the calendar_day field instead of timestamp_millis. When writing events, new clients must set calendar_day instead of timestamp_millis. Events are currently represented as timestamp values, although the interpretation of these timestamp values is a calendar date. There are a few important details about how this value should be mapped to a calendar date that should be consistent among all clients. For detailed information, see Birthday.date_ms.
         */
        timestampMillis?: string | null;
        /**
         * The type of the event. The type can be free form or one of these predefined values: * `anniversary` * `other`
         */
        type?: string | null;
    }
    /**
     * External identifier associated with the person.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiExternalId {
        /**
         * The `type` translated and formatted in the request locale. See go/people-api-howto/localization for details on how to usage.
         */
        formattedType?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * The type of the external ID. The type can be free form or one of these predefined values: * `account` * `customer` * `loginId` * `network` * `organization`
         */
        type?: string | null;
        value?: string | null;
    }
    /**
     * The field ACL. Currently only populated on profile fields for the profile owner. A Person field ACL; see http://go/peopleapi-acl
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiFieldAcl {
        /**
         * A custom type of field ACL entry. The set of all ACL entries includes those listed in acl_entry as well as predefined_acl_entry.
         */
        aclEntry?: Schema$AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntry[];
        /**
         * Set of users that will be authorized to view the field by this field ACL. If the ACL is public, this will only contain ALL_USERS. This field is synthesized, read-only, and currently only used for profile photos. It's populated under "person.photo.metadata.field_acl" for the current photo ACL and "person.photo.metadata.acl_choices" for available photo ACL choices. Note: The set of authorized viewers for a given FieldAcl may depend on the user's account type and domain configuration. For example, a PRIVATE_READ FieldAcl could have any of the following authorized viewers: Consumer user: [IDENTITY_ACL_ESTABLISHED] Dasher user without domain contact sharing: [IDENTITY_ACL_ESTABLISHED] Unicorn user: [SAME_UNICORN_FAMILY] Hafez user: []
         */
        authorizedViewers?: string[] | null;
        /**
         * A common type of field ACL entry. A predefined ACL entry is a shortcut for a commonly occurring case of role and scope. For example, PUBLIC_READ is the same as an AclEntry with role = READER and scope.all_users = true. The set of all ACL entries includes those listed in acl_entry as well as predefined_acl_entry.
         */
        predefinedAclEntry?: string[] | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntry {
        role?: string | null;
        scope?: Schema$AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScope;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScope {
        /**
         * Indicates that the field is accessible to all users including unauthenticated users. For some fields this means "to everyone except blocked users".
         */
        allUsers?: boolean | null;
        /**
         * This is a "synthetic" field. In reality domains are treated as gaia- groups. This field will be 'true' when the field is ACLed to the gaia-group of the requester's domain.
         */
        domainUsers?: boolean | null;
        membership?: Schema$AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAcl;
        /**
         * Indicates that the field is accessible to a person.
         */
        person?: Schema$AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopePersonAcl;
    }
    /**
     * Used when the field is accessible to a membership that the person has.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAcl {
        circle?: Schema$AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAclCircleAcl;
        contactGroup?: Schema$AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAclContactGroupAcl;
    }
    /**
     * Used when a field is accessible to a circle.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAclCircleAcl {
        circleId?: string | null;
        circleSet?: string | null;
        /**
         * Equivalent to Circle.display_name for the circle_id. Included when FieldAclOption.FULL_ACL_WITH_DETAILS is requested. This field is read-only and ignored on update.
         */
        displayName?: string | null;
    }
    /**
     * Used when a field is accessible to a legacy contact group. Contact groups are discouraged and may be deprecated soon. ContactGroupAcls are read-only. If they are included as part of an ACL on an Update, an exception is thrown.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAclContactGroupAcl {
        /**
         * A contact group ID. This is either a user-defined contact group hex ID, or it is the string name of the enum constant in Group.PredefinedId in FBS backend.proto for predefined groups. Common values for the predefined name include, but are not limited to: all, myContacts, starred, chatBuddies, friends, family, coworkers, and blocked.
         */
        contactGroupId?: string | null;
        /**
         * The localized display name for the predefined group, if known; or, the display name for the user-defined contact group. Included when FieldAclOption.FULL_ACL_WITH_DETAILS is requested.
         */
        displayName?: string | null;
    }
    /**
     * Used when a field is accessible to a person. NOTE: ACLs to a circle or to a non-self person are no longer supported, so this can only be applied to the requester self.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopePersonAcl {
        /**
         * DEPRECATED. This is not different than reading from person.name for a self-read; ACLs to a circle or to a non-self person are no longer supported. Equivalent to Name.display_name for the person_id profile. Included when the profile Name is ACLed to the requester and FieldAclOption.FULL_ACL_WITH_DETAILS is requested. This field is read-only and ignored on update.
         */
        displayName?: string | null;
        personId?: string | null;
        /**
         * DEPRECATED. This is not different than reading from person.photo for a self-read; ACLs to a circle or to a non-self person are no longer supported. Equivalent to Photo.url for the person_id profile. Included when the profile Photo is ACLed to the requester and FieldAclOption.FULL_ACL_WITH_DETAILS is requested. This field is read-only and ignored on update.
         */
        photoUrl?: string | null;
    }
    /**
     * Emergency information for Person field, such as Phone or Email. See go/emergency-trusted-contacts-papi.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiFieldEmergencyInfo {
        emergencyLevel?: string | null;
    }
    /**
     * The FileAs field in Contacts is used to override the DisplayName of a Contact for that User.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiFileAs {
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        value?: string | null;
    }
    /**
     * Gender in PeopleApi has some odd semantics about writing and reading that are not obvious from the proto definition. First, the `type` string, when read, always maps to the constrained domain of "male", "female", and "other", aside from a pathological case that PeopleApi would like to fix. There are two typical patterns: 1. `type` is either "male" or "female" and `custom_type` and `address_me_as` are exactly as specified by an update to PeopleApi, although they are most often absent for "male" and "female" writes. 2. `type` is "other" and `custom_type` is set to a freeform string from the request. `address_me_as` is equal to whatever was provided at write time. When writing, the free-form string for `custom_type` can come from either `custom_type` if the field is present on the request, or if `custom_type` is absent, the string value of `type` will be copied into it. Any value in `type` will be coerced to "other" and the free-form value will be copied into `custom_type`, even if `type` is exactly "other". Prefer to explicitly set `custom_type` and set type to "other" instead of setting type to a free-form value. There are weird edge cases when the value is "unknown". Consider the behavior for `type` == "unknown" unspecified. Clients reading the gender should use the value from `formatted_type` if `type` is "male" or "female". If `type` is "other", `formatted_type` will be "Other" (or some translation) and clients should read `custom_type` for more specificity.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiGender {
        /**
         * Preferred pronoun choice. It's unclear whether this value is constrained to a finite domain by UIs. `address_me_as` may be populated regardless of whether `type` is "male", "female", or "other", although most writers only set it if `type` is "other".
         */
        addressMeAs?: string | null;
        /**
         * A free-form string indicating what the user entered as their gender. `custom_type` may exist even if the type is "male" or "female", although most writers do not set it unless `type` is "other".
         */
        customType?: string | null;
        /**
         * The `type` translated and formatted in the request locale. See go/people-api-howto/localization for details on how to usage.
         */
        formattedType?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * The gender. "male", "female", or "other". If "other", typically, additional fields will have additional information.
         */
        type?: string | null;
    }
    /**
     * Extension data for use in GPay Product Profile. go/gpay-product-profile-1-pager Contact: profiles-eng-fe@google.com
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiGPayExtendedData {
        /**
         * Failure type if there is an error when fetching product profile data.
         */
        failure?: Schema$AppsPeopleOzExternalMergedpeopleapiProductProfileFailure;
        /**
         * A number in international format including the country code that is made user readable by including formatting such as spaces. Example: "+41 44 668 1800" DEPRECATED: A user's phone number should be masked and not in an international format
         */
        internationalNumber?: string | null;
        /**
         * The masked string of a user's phone number The number will be obfucsated with * except the last 4 digits. Refer to: //java/com/google/nbu/paisa/common/PhoneNumberMasker.java
         */
        maskedNumber?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiGplusExtendedData {
        contentRestriction?: string | null;
        /**
         * Equivalent to having the DASHER_POLICY bit in the REGISTERED state.
         */
        isEnterpriseUser?: boolean | null;
    }
    /**
     * Extension data for use in Hangouts.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiHangoutsExtendedData {
        hadPastHangoutState?: string | null;
        /**
         * Populated for all contacts. Only set if had_past_hangout_state == HAD_PAST_HANGOUT. INVITATION_NEEDED is not a valid value because there already is a past hangout, which means either the invitation is still pending or it’s been accepted.
         */
        invitationStatus?: string | null;
        /**
         * True if this is a Hangouts bot.
         */
        isBot?: boolean | null;
        isDismissed?: boolean | null;
        isFavorite?: boolean | null;
        isPinned?: boolean | null;
        userType?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiIdentityInfo {
        /**
         * Original lookup token from the request that resulted in this person or one of its containers.
         */
        originalLookupToken?: string[] | null;
        /**
         * Any former IDs this person may have had, in the case that their ID may have changed. Populated only for sync requests. Examples of such changes include adding an edge to a contact that links to a profile. The ID will change from being contact-oriented to being profile-oriented. To be used to clear out old versions of a person.
         */
        previousPersonId?: string[] | null;
        /**
         * A list of sources contributing to the merged person, including profiles (with gaia-id), contacts and synthetic-contacts.
         */
        sourceIds?: Schema$AppsPeopleOzExternalMergedpeopleapiSourceIdentity[];
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiIm {
        /**
         * The `protocol` translated and formatted in the request locale. See go/people-api-howto/localization for details on how to usage.
         */
        formattedProtocol?: string | null;
        /**
         * The `type` translated and formatted in the request locale. See go/people-api-howto/localization for details on how to usage.
         */
        formattedType?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * The protocol of the IM. The protocol can be free form or one of these predefined values: * `aim` * `msn` * `yahoo` * `skype` * `qq` * `googleTalk` * `icq` * `jabber` * `netMeeting`
         */
        protocol?: string | null;
        /**
         * The type of the IM. The type can be free form or one of these predefined values: * `home` * `work` * `other`
         */
        type?: string | null;
        value?: string | null;
    }
    /**
     * How and where to send notifications to this person in other apps, and why the requester can do so. See go/reachability for more info. "How" and "where" identify the recipient in a P2P Bridge (glossary/p2p bridge), and "why" may be helpful in a UI to disambiguate which of several ways may be used to contact the recipient. How: Via a Google profile or a reachable-only phone number that the requester has access to. Specified in the target "type" and "value". Where: Apps in which the profile/phone number owner may receive notifications. Specified in the repeated "app". Why: Which fields in, e.g., a contact associated with this person make the notification target info visible to the requester. Specified in the repeated originating_field param. Example: Alice has a contact Bob, with: Email 0 = bob@gmail.com Phone 0 = +12223334444 Phone 1 = +15556667777 Email 0 and Phone 0 let Alice see Bob's public profile (obfuscated gaia ID = 123). Public profiles are visible by email by default, and Bob has explicitly made it visible via Phone 0. Bob says people can send notifications to his public profile in YouTube. Phone 2 is associated with another Google profile that Bob owns, but he doesn't want others to see it. He is okay with people sending notifications to him in Who's Down if they have this phone number, however. There will be separate InAppNotificationTargets: one for Bob's public Google profile, and one for the second phone number, which is in his private profile. IANT #1 - targeting Bob's public profile (visible via Email 0 and Phone 0): app = [YOUTUBE] type = OBFUSCATED_GAIA_ID value = 123 originating_field: [ { field_type = EMAIL, field_index = 0 \} // For Email 0 { field_type = PHONE, field_index = 0 \} // For Phone 0 ] IANT #2 - targeting Bob's private profile phone number Phone 1: app = [WHOS_DOWN] type = PHONE value = +15556667777 originating_field: [ { field_type = PHONE, field_index = 1 \} // For Phone 1 ]
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiInAppNotificationTarget {
        app?: string[] | null;
        clientData?: Schema$AppsPeopleOzExternalMergedpeopleapiInAppNotificationTargetClientData[];
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * There may be more than one field from which this IANT originates, as in the case of Bob's public profile.
         */
        originatingField?: Schema$AppsPeopleOzExternalMergedpeopleapiInAppNotificationTargetOriginatingField[];
        type?: string | null;
        /**
         * The value of the target, used for delivery. E.g., the obfuscated gaia ID for a visible profile.
         */
        value?: string | null;
    }
    /**
     * Client-specific data pertaining to app reachability. No PII data or user content should be stored in this blob.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiInAppNotificationTargetClientData {
        /**
         * The app to which this client data applies.
         */
        app?: string | null;
        byteValue?: string | null;
    }
    /**
     * Info for identifying the specific field in this person that lets the requester send them notifications. These are typically fields added to a contact (e.g., email). There will not always be in originating field, typically in the case that whatever permits the requester to see this target info is not something that can be used on its own for contacting this person.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiInAppNotificationTargetOriginatingField {
        /**
         * The index of the relevant field in the merged person
         */
        fieldIndex?: number | null;
        fieldType?: string | null;
        /**
         * The value of the origin field
         */
        value?: string | null;
    }
    /**
     * This is deprecated in PEOPLE_API/SHARPEN, and should only be used for PROFILES. Clients should use InAppNotificationTarget field instead. Which apps the person has indicated they are reachable at for the requester. See go/d13y and com.google.focus.proto.InAppReachability.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiInAppReachability {
        appType?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        reachabilityKey?: Schema$AppsPeopleOzExternalMergedpeopleapiInAppReachabilityReachabilityKey;
        status?: string | null;
    }
    /**
     * Information pertaining to how this reachable state was established.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiInAppReachabilityReachabilityKey {
        keyType?: string | null;
        /**
         * The value of the key by which the user said they may be reachable. E.g., the phone number.
         */
        keyValue?: string | null;
    }
    /**
     * Defines interactions that are allowed or disallowed with this person.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiInteractionSettings {
        allowed?: boolean | null;
        interaction?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiInterest {
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        value?: string | null;
    }
    /**
     * The value can either by a language code conforming to the IETF BCP 47 specification or a custom freeform value. By default the returned value is proxied from FBS Profile.Language. If `include_account_locale` is set on the `MergePersonSourceOptions` the language from go/uls is preferred and returned as primary along with a secondary language from FBS.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiLanguage {
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        value?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiLatLng {
        lat?: number | null;
        lng?: number | null;
    }
    /**
     * Fields used in legacy applications. Useful for joining legacy and new data streams. Most applications should not care about these fields.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiLegacyFields {
        /**
         * Mobile obfuscated gaia id. This is the same gaia id in metadata.owner_id, but obfuscated with the legacy mobile obfuscator.
         */
        mobileOwnerId?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiLimitedProfileSettingsField {
        limitedProfileSettings?: Schema$SocialGraphApiProtoLimitedProfileSettings;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiLocation {
        buildingId?: string | null;
        /**
         * The building_name field is only filled if the DESK_LOCATION_ADDITIONAL_DATA extension is active.
         */
        buildingName?: string | null;
        current?: boolean | null;
        /**
         * Most specific textual description of individual desk location.
         */
        deskCode?: string | null;
        floorName?: string | null;
        floorSection?: string | null;
        /**
         * Indicates the time this location was added or last edited.
         */
        lastUpdateTime?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * Value indicates the origin of this location information.
         */
        source?: string | null;
        /**
         * Describes the type of location. For e.g. Grew_up, Desk. Corresponds to FBS backend.proto Location.StandardTag
         */
        type?: string | null;
        value?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiManagementUpchain {
        /**
         * List of managers in the chain. If user has manager email "abc@google.com" and manager's manager has email "xyz@google.com" then the list will be: [0]: { email: "abc@google.com" \} [1]: { email: "xyz@google.com" \}
         */
        indirectManager?: Schema$AppsPeopleOzExternalMergedpeopleapiManagementUpchainIndirectManager[];
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        status?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiManagementUpchainIndirectManager {
        email?: string | null;
        personId?: string | null;
    }
    /**
     * Extension data for use in Maps Product Profile.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiMapsExtendedData {
        /**
         * Failure type if there is an error when fetching product profile data.
         */
        failure?: Schema$AppsPeopleOzExternalMergedpeopleapiProductProfileFailure;
        /**
         * Number of people the user is following.
         */
        followeeCount?: string | null;
        /**
         * Number of people who are following the user.
         */
        followerCount?: number | null;
        /**
         * Sum of creators contributions i.e. reviews, rating, questions, etc.
         */
        numContributions?: string | null;
        /**
         * The user's profile photo that might have a badge rendered at the corner if the user is eligible for a badge.
         */
        profilePhotoUrl?: string | null;
        /**
         * A user's bio, or tagline.
         */
        tagline?: string | null;
        /**
         * A topic that creator has expertise in. This will be in the format: emoji associated with the topic, display name of the topic, topic score
         */
        topicExpertise?: string[] | null;
        /**
         * A user's caption displayed under the user name on their profile page i.e. 'Local Guide Level 8'
         */
        userCaption?: string | null;
    }
    /**
     * Maps Profile Data. See go/product-profiles-backend-api.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiMapsProfile {
        fieldRestriction?: Schema$AppsPeopleOzExternalMergedpeopleapiMapsProfileFieldRestriction[];
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        tagline?: string | null;
        /**
         * A link to the profile owner's website to be displayed in profile.
         */
        websiteLink?: Schema$AppsPeopleOzExternalMergedpeopleapiMapsProfileUrlLink;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiMapsProfileFieldRestriction {
        /**
         * Opaque data associated with this restriction e.g. abuse status.
         */
        clientData?: string | null;
        type?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiMapsProfileUrlLink {
        /**
         * Anchor text to be displayed as clickable link. If not present, the URL should be displayed directly.
         */
        anchorText?: string | null;
        /**
         * The URL to be linked to.
         */
        url?: string | null;
    }
    /**
     * Represents the matching information for a field when there is a query.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiMatchInfo {
        /**
         * The list of matches ordered by most relevant matching for autocomplete coming first.
         */
        match?: Schema$AppsPeopleOzExternalMergedpeopleapiMatchInfoLookupTokenMatch[];
        /**
         * The query token we are matching against.
         */
        query?: string | null;
    }
    /**
     * All the substring that were matched for the given query against the current field. Represents a substring of another string.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiMatchInfoLookupTokenMatch {
        /**
         * Index right after the last character that matches the query. length = end-start, we have substring = [start, end).
         */
        endIndex?: number | null;
        /**
         * Index of the first unicode character that matches the query.
         */
        startIndex?: number | null;
    }
    /**
     * A membership that the person has. The person can be a member of multiple circles and multiple contact-groups. A circle membership is created by adding a person to a circle by person-id or by email. A contact-group membership is created by adding a contact to a contact-group.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiMembership {
        /**
         * A circle that the person belongs to.
         */
        circleId?: string | null;
        /**
         * A contact-group that the person belong to. The id can be either a hex-formatted id or a camel-cased SystemContactGroup predefined group name. The id will be predefined group name iff the system_contact_group_id has a value.
         */
        contactGroupId?: string | null;
        /**
         * The metadata field can be used to determine which container generated the membership. For example, when the membership has a contact_group_id, the metadata.container will be CONTACT and the container_id will be the contact Id.
         */
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * The membership has a contact_group_id, this field will be populated when the membership is in a system-reserved contact-group.
         */
        systemContactGroupId?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiMission {
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        value?: string | null;
    }
    /**
     * See go/people-api-howto:names for an overview of name usage in PeopleAPI. The `unstructured_name` field contains a free form name value. The `given_name`, `middle_name`, `family_name`, etc, fields contain the structured name. For CONTACT mutates, (i.e. when Name.metadata.container is CONTACT), it is recommended for clients to set either the `unstructured_name` or the set of structured name fields, not both. * When only the `unstructured_name` is set, it is parsed to produce a best-guess set of structured name values for the `given_name`, `family_name`, etc. * When only the structured name fields are set, the various values are combined to produce an `unstructured_name`. * When both are set, the `unstructured_name` is saved as-is and the structured name fields are saved as-is. This may be confusing as they might not "match". For PROFILE mutates, (i.e. when Name.metadata.container is PROFILE), it is _required_ for clients to use the structured name fields as the unstructured field value is ignored on write. The unstructured name fields are generated for convenience on read. For DEVICE_CONTACTS, see b/156020778.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiName {
        /**
         * Read-only. A name synthesized based on `unstructured_name` and the structured name fields. Example: "John Smith" If a language code is passed in the side channel using http://cs/symbol:framework.rpc.DeprecatedPropagatedLanguageCode.value or http://cs/symbol:google.rpc.context.OriginContext.accept_language and the name does not have `honorific_prefix`, `middle_name`, or `honorific_suffix` set, the language code will be used to format `display_name`. If `include_account_locale` is set on the `MergePersonSourceOptions` and a language code is not passed in the side channel. The language code from go/uls will be used as the language code for formatting `display_name`.
         */
        displayName?: string | null;
        /**
         * Read-only. A name synthesized based on `unstructured_name` and the structured name fields with the last name first. Example: "Smith, John"
         */
        displayNameLastFirst?: string | null;
        /**
         * Read-only. The source of the display name.
         */
        displayNameSource?: Schema$SocialGraphApiProtoDisplayNameSource;
        familyName?: string | null;
        /**
         * DEPRECATED(b/70571931). Use `unstructured_name` instead.
         */
        formattedName?: string | null;
        givenName?: string | null;
        honorificPrefix?: string | null;
        honorificSuffix?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        middleName?: string | null;
        /**
         * This field is stored in contact annotations and merged at read-time. It is available with CONTACT_ANNOTATION container type at read time.
         */
        pronunciations?: Schema$SocialGraphApiProtoPronunciations;
        /**
         * NOTE: this is currently NOT IMPLEMENTED due to changed priorities. Clients usually rely on "first name" instead, when a short name is needed. Read-only. A possibly shorter version of the user's name. - The purpose of this field is to address the needs of UIs where a full display name might be too large to fit. Instead of relying on `first_name`, which might not be present, `short_display_name` is preferred. - This is only available for PROFILE and DOMAIN_PROFILE container types. - About the actual content in this field: will be the first name when it's visible to the requester, or the same as `display_name`, otherwise. A sample scenario where the first name may not be visible is when the limited profile is returned. For more info, see: http://shortn/_9iV7TJ33la
         */
        shortDisplayName?: string | null;
        /**
         * The free form name value. For contact mutates it is recommended for clients to set either the `unstructured_name` or the set of structured name fields, not both.
         */
        unstructuredName?: string | null;
        yomiFamilyName?: string | null;
        yomiFullName?: string | null;
        yomiGivenName?: string | null;
        yomiHonorificPrefix?: string | null;
        yomiHonorificSuffix?: string | null;
        yomiMiddleName?: string | null;
    }
    /**
     * Pronunciation audio metadata info. See go/name-pronunciation-backend. The metadata itself tracks the state of a user's name pronunciation audio.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiNamePronunciationAudioMetadataInfo {
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * Actual metadata proto, shared with FBS backends.
         */
        namePronunciationAudioMetadata?: Schema$SocialGraphApiProtoNamePronunciationAudioMetadata;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiNickname {
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        type?: string | null;
        value?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiOccupation {
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        value?: string | null;
    }
    /**
     * The periods that this place is open during the week. The periods are in chronological order, starting with today in the place-local timezone. An empty (but not absent) value indicates a place that is never open, e.g. because it is closed temporarily for renovations.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiOpeningHours {
        /**
         * Is this place open right now? Always present unless we lack time-of-day or timezone data for these opening hours.
         */
        openNow?: boolean | null;
        periods?: Schema$AppsPeopleOzExternalMergedpeopleapiOpeningHoursPeriod[];
        /**
         * Localized strings describing the opening hours of this place, one string for each day of the week. Will be empty if the hours are unknown or could not be converted to localized text. Example: "Sun: 18:00-06:00"
         */
        weekdayTexts?: string[] | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiOpeningHoursEndpoint {
        /**
         * A day of the week, as an integer in the range 0-6. 0 is Sunday, 1 is Monday, etc.
         */
        day?: number | null;
        /**
         * A time in 24-hour "hhmm" format (i.e. range is 0000 to 2359).
         */
        time?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiOpeningHoursPeriod {
        close?: Schema$AppsPeopleOzExternalMergedpeopleapiOpeningHoursEndpoint;
        open?: Schema$AppsPeopleOzExternalMergedpeopleapiOpeningHoursEndpoint;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiOrganization {
        assignment?: Schema$AppsPeopleOzExternalMergedpeopleapiOrganizationAssignment[];
        certification?: string | null;
        costCenter?: string | null;
        current?: boolean | null;
        department?: string | null;
        description?: string | null;
        domain?: string | null;
        /**
         * Start and End Dates are better represented as calendar entities. The intention is to replace timestamps. Not set if no value exists. Clients can choose whether to use has* semantics or default value semantics. For writes, the default proto and an absent message are equivalent. Legacy callers in the legacy_timestamp_event_write_behavior_enabled capability allowlist should write to PeopleApi via end_ms and migrate to setting both so they can be removed from the whitelist.
         */
        endCalendarDay?: Schema$GoogleTypeDate;
        /**
         * Clients are encouraged to read the end_calendar_day instead. PeopleApi writes will still use end_ms for legacy callers that are in the legacy_timestamp_event_write_behavior_enabled capability allowlist. New writers must use the calendar_day fields.
         */
        endMs?: string | null;
        endMsAsNumber?: string | null;
        /**
         * The `string_type` translated and formatted in the request locale. See go/people-api-howto/localization for details on how to usage.
         */
        formattedStringType?: string | null;
        fteMilliPercent?: number | null;
        importance?: number | null;
        location?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        name?: string | null;
        project?: Schema$AppsPeopleOzExternalMergedpeopleapiOrganizationProject[];
        /**
         * Start and End Dates are better represented as calendar entities. The intention is to replace timestamps. Not set if no value exists. Clients can choose whether to use has* semantics or default value semantics. For writes, the default proto and an absent message are equivalent. Legacy callers in the legacy_timestamp_event_write_behavior_enabled capability allowlist should write to PeopleApi via start_ms and migrate to setting both so they can be removed from the allowlist.
         */
        startCalendarDay?: Schema$GoogleTypeDate;
        /**
         * Clients are encouraged to read the start_calendar_day instead. PeopleApi writes will still use start_ms for legacy callers that are in the legacy_timestamp_event_write_behavior_enabled capability allowlist. New writers must use the calendar_day fields.
         */
        startMs?: string | null;
        startMsAsNumber?: string | null;
        /**
         * The type of the organization. The type can be free form or one of these predefined values: * `work` * `school`
         */
        stringType?: string | null;
        symbol?: string | null;
        title?: string | null;
        type?: string | null;
        yomiName?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiOrganizationAssignment {
        name?: string | null;
        url?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiOrganizationProject {
        description?: string | null;
        name?: string | null;
        role?: string | null;
        /**
         * Mapped from StandardProjectTag / CustomProjectTag
         */
        type?: string | null;
        url?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiOtherKeyword {
        /**
         * The `type` translated and formatted in the request locale. See go/people-api-howto/localization for details on how to usage.
         */
        formattedType?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        source?: string | null;
        /**
         * The type of the event. The type depends on the `OtherKeyword.source`. `OUTLOOK` source fields must be one of: * `billing_information` * `directory_server` * `keyword` * `mileage` * `sensitivity` * `user` * `subject` All other fields are treated as a `CUSTOM` source field. The value can be free form or one of these predefined values: * `home` * `other` * `work`
         */
        type?: string | null;
        value?: string | null;
    }
    /**
     * Merged-person combines multiple sources of data like contacts and profiles. See go/people-api and go/understanding-merged-person NOTE: Why are all the fields repeated? See go/people-api-concepts#repeated
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiPerson {
        about?: Schema$AppsPeopleOzExternalMergedpeopleapiAbout[];
        address?: Schema$AppsPeopleOzExternalMergedpeopleapiAddress[];
        /**
         * Deprecated. If age is needed use `person.age_range_repeated` instead. Please see go/people-api-howto:age on how to correctly get age data.
         */
        ageRange?: string | null;
        /**
         * Data on the person's age range, adult status, and age of consent. NOTE: Please read go/people-api-howto:age on how to correctly get age data.
         */
        ageRangeRepeated?: Schema$AppsPeopleOzExternalMergedpeopleapiAgeRangeType[];
        birthday?: Schema$AppsPeopleOzExternalMergedpeopleapiBirthday[];
        /**
         * Used only by contacts, no data will be returned for profiles.
         */
        braggingRights?: Schema$AppsPeopleOzExternalMergedpeopleapiBraggingRights[];
        /**
         * b/145671020: Deprecated for Profiles, but not for Contacts.
         */
        calendar?: Schema$AppsPeopleOzExternalMergedpeopleapiCalendar[];
        certifiedBornBefore?: Schema$AppsPeopleOzExternalMergedpeopleapiCertifiedBornBefore[];
        /**
         * Circles that this person is a member of.
         */
        circleMembership?: Schema$AppsPeopleOzExternalMergedpeopleapiCircleMembership[];
        clientData?: Schema$AppsPeopleOzExternalMergedpeopleapiClientData[];
        communicationEmail?: Schema$AppsPeopleOzExternalMergedpeopleapiCommunicationEmail[];
        /**
         * Reminder to connect with a Contact (part of go/people-prompts). Also contains contact-level prompts settings. Each Contact can have a single `connection_reminder` (but can have multiple Prompts inside of it). Field is repeated per PeopleAPI data model go/people-api-concepts#repeated. Only supported for CONTACT container.
         */
        connectionReminder?: Schema$AppsPeopleOzExternalMergedpeopleapiConnectionReminder[];
        /**
         * ContactCreateContextInfo has a timestamp timestamp and additional metadata (e.g. the source of the creation) for when the contact was created. See also `ContactEditContextInfo`.
         */
        contactCreateContextInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiContactCreateContextInfo[];
        /**
         * ContactEditContextInfo is a timestamp and additional metadata (e.g. the source of the edit) for the last 'human initiated edit'. See also `ContactCreateContextInfo`.
         */
        contactEditContextInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiContactEditContextInfo[];
        /**
         * Contact groups that this person is a member of.
         */
        contactGroupMembership?: Schema$AppsPeopleOzExternalMergedpeopleapiContactGroupMembership[];
        contactPromptSettingsInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiContactPromptSettingsInfo[];
        /**
         * Contact state and related metadata. See go/fbs-contacts-trash. If this field was requested but is not set on the Person then the contact is in the DEFAULT contact state. This field is read-only, and should not be set on a mutate (e.g. UpdatePerson) call. Clients must call the explicit APIs (e.g. UntrashPerson) to change contact state.
         */
        contactStateInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiContactStateInfo[];
        /**
         * DEPRECATED. Now always returns a default cover photo. See go/sunset-cover-photo.
         */
        coverPhoto?: Schema$AppsPeopleOzExternalMergedpeopleapiCoverPhoto[];
        customSchemaField?: Schema$AppsPeopleOzExternalMergedpeopleapiCustomSchemaField[];
        email?: Schema$AppsPeopleOzExternalMergedpeopleapiEmail[];
        /**
         * Emergency information. See go/emergency-trusted-contacts-papi.
         */
        emergencyInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiEmergencyInfo[];
        /**
         * Event is currently in use by contacts.
         */
        event?: Schema$AppsPeopleOzExternalMergedpeopleapiEvent[];
        /**
         * Data added by extensions that are not specific to a particular field.
         */
        extendedData?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonExtendedData;
        externalId?: Schema$AppsPeopleOzExternalMergedpeopleapiExternalId[];
        fileAs?: Schema$AppsPeopleOzExternalMergedpeopleapiFileAs[];
        /**
         * A fingerprint that can be used to reliably determine if a resource has changed. Externally it is used as part of the etag.
         */
        fingerprint?: string | null;
        gender?: Schema$AppsPeopleOzExternalMergedpeopleapiGender[];
        im?: Schema$AppsPeopleOzExternalMergedpeopleapiIm[];
        /**
         * Ways to send in-app notifications to this person. See go/reachability. This field is read-only and ignored for mutates.
         */
        inAppNotificationTarget?: Schema$AppsPeopleOzExternalMergedpeopleapiInAppNotificationTarget[];
        /**
         * Used only by profile service, deprecated for PeopleAPI and Sharpen. If you aren't sure, contact people-api-users@ and profile-service-eng@.
         */
        inAppReachability?: Schema$AppsPeopleOzExternalMergedpeopleapiInAppReachability[];
        /**
         * DEPRECATED. This field isn't populated in people.list.
         */
        interactionSettings?: Schema$AppsPeopleOzExternalMergedpeopleapiInteractionSettings[];
        interest?: Schema$AppsPeopleOzExternalMergedpeopleapiInterest[];
        language?: Schema$AppsPeopleOzExternalMergedpeopleapiLanguage[];
        /**
         * DEPRECATED. This field was only for backwards compatibility with legacy GData callers, and should not be used by new clients. Legacy fields used for mobile clients.
         */
        legacyFields?: Schema$AppsPeopleOzExternalMergedpeopleapiLegacyFields;
        /**
         * Settings for the limited profile. See go/limited-profiles-api.
         */
        limitedProfileSettings?: Schema$AppsPeopleOzExternalMergedpeopleapiLimitedProfileSettingsField[];
        /**
         * Other person resources linked indirectly by an edge. The full person or just the IDs may be populated depending on request parameters. We consider linked people distinct people, but they share information. Example: A contact with two outgoing edges. The two edges are considered separate, but linked people.
         */
        linkedPerson?: Schema$AppsPeopleOzExternalMergedpeopleapiPerson[];
        location?: Schema$AppsPeopleOzExternalMergedpeopleapiLocation[];
        managementUpchain?: Schema$AppsPeopleOzExternalMergedpeopleapiManagementUpchain[];
        /**
         * MapsProfile, see go/product-profiles-backend-api
         */
        mapsProfile?: Schema$AppsPeopleOzExternalMergedpeopleapiMapsProfile[];
        /**
         * DEPRECATED. Please use `circle_membership` or `contact_group_membership` instead. Contact-groups and circles that this person is a member of.
         */
        membership?: Schema$AppsPeopleOzExternalMergedpeopleapiMembership[];
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonMetadata;
        mission?: Schema$AppsPeopleOzExternalMergedpeopleapiMission[];
        /**
         * See go/people-api-howto:names for details about names in PeopleAPI.
         */
        name?: Schema$AppsPeopleOzExternalMergedpeopleapiName[];
        /**
         * Metadata info for a user's name pronunciation audio. See go/name-pronunication-backend.
         */
        namePronunciationAudioMetadataInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiNamePronunciationAudioMetadataInfo[];
        nickname?: Schema$AppsPeopleOzExternalMergedpeopleapiNickname[];
        occupation?: Schema$AppsPeopleOzExternalMergedpeopleapiOccupation[];
        organization?: Schema$AppsPeopleOzExternalMergedpeopleapiOrganization[];
        /**
         * Legacy arbitrary key value fields
         */
        otherKeyword?: Schema$AppsPeopleOzExternalMergedpeopleapiOtherKeyword[];
        /**
         * DEPRECATED. This feature was stubbed, but never implemented. This field will not be populated with any results.
         */
        peopleInCommon?: Schema$AppsPeopleOzExternalMergedpeopleapiPerson[];
        /**
         * In order to request this field, the client must set desired PersonAttributeKey in the dedicated RequestMask field `person_attribute`. Unlike other person fields, this field cannot be requested in the `include_field` field mask.
         */
        personAttribute?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonAttribute[];
        /**
         * The ID of the person. This is determined by the backend, is unstable, and may not be the same as a user_id. Internally referred as 'personKey' to distinguish from the common PersonId pojo. See go/people-api-concepts#person-id
         */
        personId?: string | null;
        phone?: Schema$AppsPeopleOzExternalMergedpeopleapiPhone[];
        /**
         * See go/people-api-concepts/photos for usage details
         */
        photo?: Schema$AppsPeopleOzExternalMergedpeopleapiPhoto[];
        /**
         * Data specific to places. Data which also applies to contacts and profiles such as name, phone, photo, etc. are returned in the corresponding Person fields.
         */
        placeDetails?: Schema$AppsPeopleOzExternalMergedpeopleapiPlaceDetails[];
        /**
         * DEPRECATED. Info about plus pages in the person.
         */
        plusPageInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiPlusPageInfo[];
        posixAccount?: Schema$AppsPeopleOzExternalMergedpeopleapiPosixAccount[];
        /**
         * DEPRECATED. No data is returned for this field anymore. (go/people-api-concepts#repeated): Use person.profile_url_repeated instead. Access to this field is restricted to a set of legacy clients. This is a Google+-only field. See go/fbs-g+-deprecation. NOTE: `Person.profile_url` is only populated for profile-centric person.
         */
        profileUrl?: string | null;
        /**
         * DEPRECATED. No data is returned for this field anymore. This is a Google+-only field. See go/fbs-g+-deprecation.
         */
        profileUrlRepeated?: Schema$AppsPeopleOzExternalMergedpeopleapiProfileUrl[];
        /**
         * Pronouns are not supported for consumer profiles. See go/pronouns-in-people-system-prd for more details.
         */
        pronoun?: Schema$AppsPeopleOzExternalMergedpeopleapiPronoun[];
        /**
         * Information about the profiles that are a part of this Person. This is only applicable to PROFILE and DOMAIN_PROFILE containers.
         */
        readOnlyProfileInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfo[];
        /**
         * See go/relation-vs-relationship for relation vs relationship explanation.
         */
        relation?: Schema$AppsPeopleOzExternalMergedpeopleapiRelation[];
        /**
         * DEPRECATED. No data is returned for this field anymore.
         */
        relationshipInterest?: Schema$AppsPeopleOzExternalMergedpeopleapiRelationshipInterest[];
        /**
         * DEPRECATED. No data is returned for this field anymore.
         */
        relationshipStatus?: Schema$AppsPeopleOzExternalMergedpeopleapiRelationshipStatus[];
        rightOfPublicityState?: Schema$AppsPeopleOzExternalMergedpeopleapiRightOfPublicityState[];
        /**
         * Data specific to rosters (such as Google Groups and Chat Rooms). Data which also applies to contacts and profiles such as name, email, and photo, etc are returned in the corresponding Person fields.
         */
        rosterDetails?: Schema$AppsPeopleOzExternalMergedpeopleapiRosterDetails[];
        /**
         * Profile for Janata and Search. go/janata-profile-in-sgbe
         */
        searchProfile?: Schema$AppsPeopleOzExternalMergedpeopleapiSearchProfile[];
        /**
         * SipAddress is currently in use by contacts.
         */
        sipAddress?: Schema$AppsPeopleOzExternalMergedpeopleapiSipAddress[];
        skills?: Schema$AppsPeopleOzExternalMergedpeopleapiSkills[];
        /**
         * NOTE: this is used by go/starlight, but not actually used or returned in PeopleAPI. See b/27281119 for context. Please reach out to people-api-eng@ if you have questions.
         */
        socialConnection?: Schema$AppsPeopleOzExternalMergedpeopleapiSocialConnection[];
        sortKeys?: Schema$AppsPeopleOzExternalMergedpeopleapiSortKeys;
        sshPublicKey?: Schema$AppsPeopleOzExternalMergedpeopleapiSshPublicKey[];
        /**
         * Only supported for PLACE container results, no data will be returned for profiles.
         */
        tagline?: Schema$AppsPeopleOzExternalMergedpeopleapiTagline[];
        /**
         * DEPRECATED. *UNSUPPORTED*. This field is never populated.
         */
        teamsExtendedData?: Schema$AppsPeopleOzExternalMergedpeopleapiTeamsExtendedData;
        /**
         * UserDefined is currently in use by contacts.
         */
        userDefined?: Schema$AppsPeopleOzExternalMergedpeopleapiUserDefined[];
        /**
         * Add annotation_id and metadata (product_source) for visible to guests contacts go/visible-to-guests.
         */
        visibleToGuests?: Schema$AppsPeopleOzExternalMergedpeopleapiVisibleToGuests[];
        website?: Schema$AppsPeopleOzExternalMergedpeopleapiWebsite[];
    }
    /**
     * Client-specific binary blob stored with Person data. This differs from ClientData, which stores structured, key-value pairs.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiPersonAttribute {
        attributeKey?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        value?: string | null;
    }
    /**
     * Extension data for the whole person entity.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiPersonExtendedData {
        /**
         * For use by AboutMe and SmartProfile clients.
         */
        aboutMeExtendedData?: Schema$AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedData;
        /**
         * For use with Apps Waldo Availability Data extension
         */
        appsWaldoExtendedData?: Schema$SocialGraphWireProtoPeopleapiExtensionAppsWaldoExtendedData;
        /**
         * For use with caller ID extension
         */
        callerIdExtendedData?: Schema$AppsPeopleOzExternalMergedpeopleapiCallerIdExtendedData;
        /**
         * For use with Contacts extension.
         */
        contactsExtendedData?: Schema$AppsPeopleOzExternalMergedpeopleapiWebContactsExtendedData;
        /**
         * Hosted domain this person is a member of. The domain_name is also returned as part of the person's ReadOnlyProfileInfo, so requesting it via this extension is no longer necessary.
         */
        domainName?: string[] | null;
        /**
         * For use with Dynamite extension.
         */
        dynamiteExtendedData?: Schema$SocialGraphWireProtoPeopleapiExtensionDynamiteExtendedData;
        /**
         * For use with Google Pay extension.
         */
        gpayExtendedData?: Schema$AppsPeopleOzExternalMergedpeopleapiGPayExtendedData;
        /**
         * For use with Google+ extension.
         */
        gplusExtendedData?: Schema$AppsPeopleOzExternalMergedpeopleapiGplusExtendedData;
        /**
         * For use with Hangouts extension.
         */
        hangoutsExtendedData?: Schema$AppsPeopleOzExternalMergedpeopleapiHangoutsExtendedData;
        /**
         * For use with gmail extensions and lookup by email. If true, no person was actually found using the specified email address, but we want to return TLS info about the email address regardless.
         */
        isPlaceholder?: boolean | null;
        /**
         * For use with Maps extension.
         */
        mapsExtendedData?: Schema$AppsPeopleOzExternalMergedpeopleapiMapsExtendedData;
        /**
         * For use with Paisa extension
         */
        paisaExtendedData?: Schema$SocialGraphWireProtoPeopleapiExtensionPaisaExtendedData;
        /**
         * DEPRECATED: Use people_stack_person_extended_data instead. For use with PeopleStack extension.
         */
        peopleStackExtendedData?: Schema$SocialGraphWireProtoPeopleapiExtensionPeopleStackExtendedData;
        /**
         * For use with PeopleStack extension.
         */
        peopleStackPersonExtendedData?: Schema$SocialGraphWireProtoPeopleapiExtensionPeopleStackPersonExtendedData;
        /**
         * For use with Play Games Product Profile extension. See go/jam-games-profile. The play games profile will be returned only for profile-centric requests.
         */
        playGamesExtendedData?: Schema$AppsPeopleOzExternalMergedpeopleapiPlayGamesExtendedData;
        /**
         * For use with the TLS extension and lookup by email. If true, no person was actually found using the specified email address, but we want to return TLS info about the email address regardless. DEPRECATED: Use is_placeholder instead.
         */
        tlsIsPlaceholder?: boolean | null;
        /**
         * For use with Youtube extension.
         */
        youtubeExtendedData?: Schema$AppsPeopleOzExternalMergedpeopleapiYoutubeExtendedData;
    }
    /**
     * Metadata for a single Person field. See go/understanding-merged-person
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata {
        /**
         * When the container is PROFILE/DOMAIN_PROFILE and the profile owner is the requester, this read-only, synthesized field indicates which ACLs the user is allowed to set on the profile field. This is distinct from field_acl, which is the field's currently set ACL. field_acl will always be a valid ACL choice, except for the case of default synthesized profile fields like monogram profile photos. For those, field_acl does not represent a user-set field ACL, so it may or may not be a valid choice. In all cases, default_acl_choice will always be a valid choice. This is currently only populated on the photo field when the "person.photo.metadata.acl_choices" mask is set.
         */
        aclChoices?: Schema$AppsPeopleOzExternalMergedpeopleapiFieldAcl[];
        /**
         * Additional information about the container of this field.
         */
        additionalContainerInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiAdditionalContainerInfo;
        /**
         * For field-level affinity scores. The affinity between the requester and this particular field in the Person (e.g., frequency of calling a particular phone number).
         */
        affinity?: Schema$AppsPeopleOzExternalMergedpeopleapiAffinity[];
        /**
         * Each field can have different visibility settings Only returned when explicitly requested.
         */
        contactVisibility?: string[] | null;
        /**
         * DEPRECATED. Use container_type instead. Having the Container be an enum at the PFM message level causes circular dependency when other types try to refer to it. It breaks javascript build targets.
         */
        container?: string | null;
        /**
         * DEPRECATED. Use encoded_container_id instead. The numeric id of the data source. The id is only unique within a single container type. This is only set when the id of the container is numeric, e.g. contact id.
         */
        containerId?: string | null;
        /**
         * Indicates if this field is the primary field for the container and container_id.
         */
        containerPrimary?: boolean | null;
        /**
         * The source for the data in the field.
         */
        containerType?: string | null;
        /**
         * True if this field can be used on other devices than the one it originated from. Assigned by the server. Currently only used for device contacts.
         */
        crossDeviceAllowed?: boolean | null;
        /**
         * When the container is PROFILE/DOMAIN_PROFILE and the profile owner is the requester, this read-only, synthesized field contains the default ACL choice. This can be used to select a preferred choice from acl_choices. Generally, default_acl_choice should only be preferred for default synthesized profile fields like monogram profile photos. Otherwise, the existing field_acl should be preferred. This is currently only populated on the photo field when the "person.photo.metadata.acl_choices" mask is set.
         */
        defaultAclChoice?: Schema$AppsPeopleOzExternalMergedpeopleapiFieldAcl;
        /**
         * DEPRECATED. Use container_id. Not populated or used at all.
         */
        deprecatedContactContainerId?: string | null;
        /**
         * Field is an edge key for this person. Modifying it breaks the link between data sources. This is equivalent to edge_key_info having at least one entry with materialized = true.
         */
        edgeKey?: boolean | null;
        /**
         * Edges that this field creates. This includes all edges and not necessarily just the edge relevant to the joined entities.
         */
        edgeKeyInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiEdgeKeyInfo[];
        /**
         * The encoded id of the data source. The id is only unique within a single container type. This field correlates to person.metadata.identity_info.source_id.id. This field may not be populated in some special cases, where the id is not visible to the querying user. e.g. ListAutocompletions with full phone number query. For value format, see google3/social/graph/api/proto/main_merged_person.proto?q=symbol:SourceIdentity.id
         */
        encodedContainerId?: string | null;
        /**
         * When the container is PROFILE and the profile owner is the requester, this field indicates how the profile field is accessible.
         */
        fieldAcl?: Schema$AppsPeopleOzExternalMergedpeopleapiFieldAcl;
        /**
         * Indicates the time that the field was added or last edited. Currently this is populated for: (1) person.birthday with ContainerType PROFILE, DOMAIN_PROFILE or ACCOUNT. (2) person.name, person.address, person.relation, person.email and person.phone with ContainerType CONTACT_ANNOTATION;
         */
        lastUpdateTime?: string | null;
        /**
         * The matching informations if there was a query against this field.
         */
        matchingInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiMatchInfo[];
        /**
         * When deduping fields by value, list of containers of the fields that where deduped.
         */
        otherDedupedContainers?: Schema$AppsPeopleOzExternalMergedpeopleapiDedupedContainerInfo[];
        /**
         * If true, indicates this field is the Person's primary field eg. Contact, and (Profile) Person could have different Name fields, and the Name represented by the Person is primary. For selecting a primary field from RepeatedFields within a Person, use container_primary.
         */
        primary?: boolean | null;
        /**
         * The product(s) that generated the data in this field. Empty is equivalent to DEFAULT. ST_USER_METADATA
         */
        productMetadata?: Schema$AppsPeopleOzExternalMergedpeopleapiProductMetadata[];
        /**
         * Indicates whether this is a verified field. It is synthesized from verification and is read-only. If there is at least one verification with status PASSED, the field is considered verified. Currently this is applicable to address, email, name, and phone for PROFILE and DOMAIN_PROFILE. Use .metadata.verified in the request mask.
         */
        verified?: boolean | null;
        /**
         * Currently, only people.get may set this value
         */
        visibility?: string | null;
        /**
         * Whether the field is writeable to the requester.
         */
        writeable?: boolean | null;
    }
    /**
     * A person list with total number specified.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiPersonListWithTotalNumber {
        people?: Schema$AppsPeopleOzExternalMergedpeopleapiPerson[];
        /**
         * The total number of people, which is aways no less than the size of the above list.
         */
        totalNumber?: number | null;
    }
    /**
     * Metadata for the entire Person resource.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiPersonMetadata {
        /**
         * Affinities associated with the person, with respect to the requester.
         */
        affinity?: Schema$AppsPeopleOzExternalMergedpeopleapiAffinity[];
        /**
         * Populated when the data for the MergedPerson comes from a 3rd party provider or data source. Clients must display these attributions to the user if they are present. NOTE: This field is only relevant when requesting the following containers: - PLACE (data read from Maps)
         */
        attribution?: string[] | null;
        /**
         * The best name to use for this person for user-facing display. See go/people-api-howto:names for details about how this field is computed. In many cases this will simply be Person.name[0]. However, Person.name returns only explicit Name fields, but other fields maybe usable as a name (for example: nicknames, file_as, ...). `best_display_name` will be calculated from all fields in storage which are usable as a name, even fields which are not explicitly requested in the MergedPerson result. See go/javagoog/apps/tacotown/socialgraph/entity/PersonNameFormatter.java
         */
        bestDisplayName?: Schema$AppsPeopleOzExternalMergedpeopleapiBestDisplayName;
        /**
         * DEPRECATED. Indicates whether the profile owner has blocked this person. Please use `person.read_only_profile_info.block_type` instead.
         */
        blockType?: string[] | null;
        /**
         * DEPRECATED. The circles the person belongs to.
         */
        circleId?: string[] | null;
        /**
         * DEPRECATED. Please use `person.contact_group_memberships` instead. The contact groups the person belongs to.
         */
        contactGroupId?: string[] | null;
        /**
         * The IDs of all contacts contributing to this person.
         */
        contactId?: string[] | null;
        /**
         * DEPRECATED. Customized masking of the response similar to the legacy People2RequestMask People2Params request message. NOTE: This param is inherently client-specific, limited to specific legacy clients, and not open to new usage. NOTE: Effects may be applied to a subset of people in the response.
         */
        customResponseMaskingType?: string | null;
        /**
         * For sync requests (i.e., changed since the provided sync_token), indicates the resource is a tombstone for a Person resource that has been entirely deleted.
         */
        deleted?: boolean | null;
        /**
         * DEPRECATED. Please use `person.read_only_profile_info.block_type` instead.
         */
        deprecatedBlocked?: boolean | null;
        /**
         * DEPRECATED. This field is no longer populated or read.
         */
        deprecatedMembershipCircleId?: string[] | null;
        /**
         * DEPRECATED. This field is no longer populated or read.
         */
        deprecatedMembershipContactGroupId?: string[] | null;
        /**
         * Info about the aggregated device contacts. When the person contains RAW_DEVICE_CONTACT containers, each DeviceContactInfo represents a single aggregate device contact made up of one or more raw device contacts.
         */
        deviceContactInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiDeviceContactInfo[];
        /**
         * Detailed metadata about the lookup IDs and data sources included in a MergedPerson result.
         */
        identityInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiIdentityInfo;
        /**
         * DEPRECATED. Indicates whether this person is blocking the profile owner. Please use `person.read_only_profile_info.incoming_block_type` instead.
         */
        incomingBlockType?: string[] | null;
        /**
         * DEPRECATED. Indicates whether this person is in the same domain as the viewer. For proxying trust between two users based on organization membership, see: - go/flex-orgs-platform - go/flex-orgs-compliance-handbook (especially http://shortn/_ChwfAY36Ys)
         */
        inViewerDomain?: boolean | null;
        /**
         * DEPRECATED. The last update timestamps for the constituent components of this person are available in `identity_info.source_ids`. The time of the most recent change to this person, in !!!NANOS!!! (due to a bug). May be a change to any of the underlying parts of the person (profile, contact, etc.). Not guaranteed to be the timestamp of the most recent change, due to limitations in the backend. This field is not fully deprecated for backend container-specific storage services like ProfileService which lack identity_info. The use is still discouraged in such systems and they should prefer to use the `last_update_time` field of this message instead.
         */
        lastUpdateTimeMicros?: string | null;
        /**
         * The person model that is used to construct this person.
         */
        model?: string | null;
        /**
         * DEPRECATED.
         */
        objectType?: string | null;
        /**
         * DEPRECATED. Please use `person.read_only_profile_info.owner_id` instead.
         */
        ownerId?: string | null;
        /**
         * DEPRECATED. See `person.read_only_profile_info.owner_user_type` instead.
         */
        ownerUserType?: string[] | null;
        /**
         * DEPRECATED. Please use `Person.plus_page_info` instead.
         */
        plusPageType?: string | null;
        /**
         * DEPRECATED. This field is no longer populated or read.
         */
        previousPersonId?: string[] | null;
        /**
         * DEPRECATED. Stats/counters pertaining to followers and incoming edges. Please use `person.read_only_profile_info.profile_owner_stats` instead.
         */
        profileOwnerStats?: Schema$AppsPeopleOzExternalMergedpeopleapiProfileOwnerStats;
        /**
         * Contact people-directory-dev-team@ if you want to use this field.
         */
        scoringInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonMetadataScoringInfo;
        /**
         * DEPRECATED. This field is no longer populated or read.
         */
        userVisibleStats?: Schema$AppsPeopleOzExternalMergedpeopleapiUserVisibleStats;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiPersonMetadataScoringInfo {
        /**
         * Only populated on a SearchDirectoryPeople call, when results are scored. Contact people-directory-dev-team@ if you want to use this field.
         */
        rawMatchQualityScore?: number | null;
        /**
         * Only populated on a SearchDirectoryPeople call that sends a request with StFieldSpecExpressions. - Used for linking indexed terms with query terms for go/better-name-matching - Name should be alphanumeric or underscores - Value should be an st expression following the syntax at go/stsyntax Contact people-directory-dev-team@ if you want to use this field.
         */
        stExpressionResults?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonMetadataScoringInfoStExpressionResult[];
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiPersonMetadataScoringInfoStExpressionResult {
        name?: string | null;
        value?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiPhone {
        /**
         * Canonicalized form that follows ITU-T E.164 international public telecommunication numbering plan.
         */
        canonicalizedForm?: string | null;
        /**
         * Emergency information. See go/emergency-trusted-contacts-papi.
         */
        emergencyInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiFieldEmergencyInfo;
        /**
         * Read-only. Field requested by specifying `HANGOUTS_PHONE_DATA` in `extension_set.extension_names`.
         */
        extendedData?: Schema$AppsPeopleOzExternalMergedpeopleapiPhoneExtendedData;
        /**
         * The `type` translated and formatted in the request locale. See go/people-api-howto/localization for details on how to usage.
         */
        formattedType?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * The type of the phone number. The type can be free form or one of these predefined values: * `home` * `work` * `mobile` * `homeFax` * `workFax` * `otherFax` * `pager` * `workMobile` * `workPager` * `main` * `googleVoice` * `other`
         */
        type?: string | null;
        uri?: string | null;
        value?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiPhoneExtendedData {
        /**
         * For use with Hangouts extension.
         */
        structuredPhone?: Schema$AppsPeopleOzExternalMergedpeopleapiStructuredPhone;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiPhoto {
        /**
         * Read-only. Use UpdatePersonPhoto to change photo decorations. If this photo is decorated, this field contains information about its decorations. For now, this will contain at most one entry.
         */
        decoration?: Schema$SocialGraphApiProtoDecorationOverlay[];
        /**
         * URL of an emoji avatar as an image. See go/emoji-cdn. PeopleAPI will return the SVG format so that it can be scaled client side and so that the images will not be animated. All clients that use this field must also have fall-back handling for using the `Photo.url` field if this is empty. When we have FIFE-compatible emoji-image URLs we will drop this field and return the Photo.url instead. Clients that have their own go/emoji-rendering integration may prefer to render the emoji-avatar from `Photo.glyph` field using their rendering system so that the emoji version/style match the rest of the application. For further background, see go/chatroom-avatar-as-roster-metadata. This field will only be populated if all of: - The PersonFieldMetadata `container_type` for the Photo is NAMED_CHAT_ROOM - The chat room has an emoji type avatar image set
         */
        emojiAvatarUrl?: string | null;
        /**
         * Unicode emoji representation of the chat room emoji avatar. This can be used by clients that use go/emoji-rendering directly so that they can present this with the same version/style as the rest of their application. This value may also be useful to clients as alt-text for the image. This field will only be populated if all of: - The PersonFieldMetadata `container_type` for the Photo is NAMED_CHAT_ROOM - The chat room has an emoji type avatar image set
         */
        glyph?: string | null;
        /**
         * A set of HTML data provider attributions that must be shown with the result. Supported for PLACES photos only. See: go/understanding-places-api-attribution-requirements
         */
        htmlAttribution?: string[] | null;
        /**
         * True when the photo is synthetic or generated (i.e. a monogram or default photo), false when the person has a custom photo.
         */
        isDefault?: boolean | null;
        /**
         * Indicates if the photo is a monogram avatar. Combined with is_default, the type of photo can be determined by: is_default=true, is_monogram=true: Default monogram avatar. is_default=true, is_monogram=false: Default silhouette avatar. is_default=false: Custom photo. is_monogram is irrelevant in this case.
         */
        isMonogram?: boolean | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * When is_monogram=true, this is the background color of the monogram photo as a hex RGB formatted string "RRGGBB".
         */
        monogramBackground?: string | null;
        /**
         * Read-only. A reference to the original, undecorated profile photo in storage. This field is not stored. It is populated by a live read to /SocialGraphImageService.GetActiveProfilePhoto. This field is only returned when "person.photo.original_photo" is specified in the request mask.
         */
        originalPhoto?: Schema$SocialGraphApiProtoImageReference;
        /**
         * For writes only. Indicates photo content for person photo-field update. Currently only used for profile-photo updates (not contact photos yet).
         */
        photoId?: Schema$AppsPeopleOzExternalMergedpeopleapiPhotoPhotoStorageId;
        /**
         * Most clients don't need to worry about this field and should just use the `url` to fetch the photo. See go/phototoken-migration-plan for some more context about this field. If you think you want to use this please talk with people-api-eng@ first.
         */
        photoToken?: string | null;
        /**
         * See go/people-api-concepts/photos for info on the different representations of URLs.
         */
        url?: string | null;
        /**
         * A URL for a UI to view the photo in its original context. For example, for a place photo, this is the url of a Google Maps page displaying the photo. Supported for place photos only.
         */
        viewerUrl?: string | null;
    }
    /**
     * Info necessary for looking up a photo in storage.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiPhotoPhotoStorageId {
        /**
         * For writes only, pass the media key that represents the image in photos backend. Note, this is not populated on reads.
         */
        mediaKey?: string | null;
    }
    /**
     * Metadata specific to places.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiPlaceDetails {
        /**
         * A URL hosted by Google providing more information about this place This is the URL returned by Places API in the Place.Url.google field
         */
        googleUrl?: string | null;
        latLng?: Schema$AppsPeopleOzExternalMergedpeopleapiLatLng;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        openingHours?: Schema$AppsPeopleOzExternalMergedpeopleapiOpeningHours;
        /**
         * The name of the primary type. Examples of primary type are: "art_school", "clothing_wholesaler", etc. All primary types can be found at http://shortn/_veqh6UwWdc
         */
        primaryTypeName?: string | null;
    }
    /**
     * Extension data for use in Play Games Product Profile. See go/jam-games-profile.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiPlayGamesExtendedData {
        /**
         * User's top achievements that are sorted for example by rarity.
         */
        achievements?: Schema$AppsPeopleOzExternalMergedpeopleapiPlayGamesExtendedDataAchievement[];
        /**
         * The avatar image to display for the user.
         */
        avatarImageUrl?: string | null;
        /**
         * Failure type if there is an error when fetching product profile data.
         */
        failure?: Schema$AppsPeopleOzExternalMergedpeopleapiProductProfileFailure;
        /**
         * The gamer tag set by the user. Not set if the user hasn't set a gamer tag yet.
         */
        gamerTag?: string | null;
        /**
         * User's level.
         */
        playerLevel?: number | null;
        /**
         * Specifies the visibility of the player's profile.
         */
        profileVisibility?: string | null;
        /**
         * Total number of friends.
         */
        totalFriendsCount?: string | null;
        /**
         * How many achievements this player has unlocked.
         */
        totalUnlockedAchievements?: string | null;
    }
    /**
     * Details of an achievement that the user has unlocked.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiPlayGamesExtendedDataAchievement {
        /**
         * The name of the achievement.
         */
        achievementName?: string | null;
        /**
         * The achievement icon url shown to the user if it is unlocked.
         */
        achievementUnlockedIconUrl?: string | null;
        /**
         * Rarity of unlocking this achievement (3% of players unlocked would be 3)
         */
        rarityPercentage?: number | null;
    }
    /**
     * Information about a plus page and the entity it represents.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiPlusPageInfo {
        /**
         * Int64 ID of packaging-service entry; if set, the plus page is associated with a third-party application.
         */
        applicationId?: string | null;
        entityType?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
    }
    /**
     * Map marker location for an address.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiPointSpec {
        bounds?: Schema$GeostoreRectProto;
        point?: Schema$GeostorePointProto;
        pointSource?: string | null;
    }
    /**
     * Custom field that represents POSIX account information. Description of the field family: go/fbs-posix. If account has non-empty Username or Uid we will enforce global uniqueness of (AccountNamespace, CustomerKey, SystemId, Uid) and (AccountNamespace, CustomerKey, SystemId, Username) tuples to ensure there are no duplicates.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiPosixAccount {
        /**
         * The user visible value is used to distinguish identical posix account fields with different customer key values.
         */
        accountId?: string | null;
        /**
         * Value indicates the uniqueness namespace that applies to the POSIX information. The value is included in all POSIX account uniqueness indices. The indexing prevents two accounts within the same customer from having the same username. Namespacing allows Windows and Linux users to share the same username.
         */
        accountNamespace?: string | null;
        /**
         * Value indicates whether the POSIX information is associated with a non-human entity and the validation logic to apply during PosixAccount mutation.
         */
        accountType?: string | null;
        /**
         * The customer associated with the POSIX identity. If the user is already associated with a G Suite Customer, this field has the same value as http://google3/ccc/hosted/policies/settings/dthree_customer_info.proto
         */
        customerKey?: string | null;
        /**
         * The value is automatically set to a SHA-256 fingerprint of the POSIX account. A fingerprint should uniquely identify a POSIX account entry.
         */
        fingerprint?: string | null;
        /**
         * The GECOS (user information) entry for this account.
         */
        gecos?: string | null;
        /**
         * The default group ID.
         */
        gid?: string | null;
        /**
         * The path to the home directory for this account.
         */
        homeDirectory?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * Value indicates whether to use Linux or Windows specific validation logic during PosixAccount mutation.
         */
        operatingSystemType?: string | null;
        /**
         * The path to the login shell for this account.
         */
        shell?: string | null;
        /**
         * System identifier for which account Username or Uid apply to. If not specified on mutate by a caller it will default to empty value if either Username or Uid are being set. SystemId does require to have a value (even an empty one) because it is included into null-filtered Spanner index used to enforce uniqueness on Username and Uid fields.
         */
        systemId?: string | null;
        /**
         * The user ID.
         */
        uid?: string | null;
        /**
         * The username of the account.
         */
        username?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiProductMetadata {
        productSource?: string | null;
    }
    /**
     * Product profiles failure type: the status of the rpc to fetch the product profile.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiProductProfileFailure {
        failureType?: string | null;
    }
    /**
     * Stats pertaining to incoming edges and views, visible to the requester (with acls applied). Related to, but not equal to, com.google.focus.proto.Storage.UserVisibleStats.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiProfileOwnerStats {
        /**
         * Replacement for deprecated follower_count. Comes from the EdgeSummary.
         */
        incomingAnyCircleCount?: string | null;
        /**
         * Deprecated. This field is no longer populated by the server.
         */
        viewCount?: string | null;
    }
    /**
     * This is a Google+-only field (and thus does not exist for consumer users). See go/fbs-g+-deprecation.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiProfileUrl {
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        url?: string | null;
    }
    /**
     * Message to represent a user's set of preferred pronouns, see go/pronouns-backend.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiPronoun {
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        pronounData?: Schema$SocialGraphApiProtoPronounData;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiRawDeviceContactAnalyticalInfo {
        /**
         * The data set within the account that this raw contact belongs to.
         */
        dataSet?: string | null;
        /**
         * The CP2 dirty field which indicates the sync state of the raw contact: https://developer.android.com/reference/android/provider/ContactsContract.SyncColumns#DIRTY True if the row is changed but not synced
         */
        dirty?: boolean | null;
        /**
         * Whether the source ID exists for non-Google contacts. Won't set for Google contacts.
         */
        sourceIdExist?: boolean | null;
        /**
         * The Sync Info of a raw contact.
         */
        syncInfo?: Schema$SocialGraphApiProtoSyncInfo;
    }
    /**
     * Raw device contact information.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiRawDeviceContactInfo {
        /**
         * Account name of raw contact, e.g. "google@gmail.com".
         */
        accountName?: string | null;
        /**
         * Account type of raw contact, e.g. "com.google" or "com.linkedin.android".
         */
        accountType?: string | null;
        /**
         * The detailed app-specific endpoint data available for the given RawDeviceContactInfo instance. This proto should be used to obtain the list of actions and mimetypes supported by the third-party app. Design: go/3p-contact-upload
         */
        appContactData?: Schema$SocialGraphApiAppContactData[];
        /**
         * The app-specific endpoint data needed for app action fulfillment. Usage of this field should be avoided on the server-side, and should use the more detailed |full_app_info| field.
         */
        appInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiAppUniqueInfo;
        /**
         * If true, this raw contact can be used on other devices than the one it originated from. Assigned by the server.
         */
        crossDeviceAllowed?: boolean | null;
        /**
         * Extra metadata for this raw contact.
         */
        deviceContactMetadata?: Schema$AppsPeopleOzExternalMergedpeopleapiDeviceContactExtraMetadata;
        /**
         * The focus contact id for Google contacts.
         */
        googleContactId?: string | null;
        /**
         * The base64 serialized social.graph.peopleapi.proto.internal.RawDeviceContactId. This id should be used to correlate to field.metadata.encoded_container_id when the field.metadata.container_type is RAW_DEVICE_CONTACT The id also correlates to person.metadata.identity_info.source_id.id. For value format, see google3/social/graph/api/proto/main_merged_person.proto?q=symbol:SourceIdentity.id
         */
        id?: string | null;
        /**
         * The type of photo from the device (if any).
         */
        photoType?: string | null;
        /**
         * The id of the raw contact on the device.
         */
        rawContactId?: string | null;
        /**
         * Only to be used by Romanesco team specifically for analytics.
         */
        rawDeviceContactAnalyticalInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiRawDeviceContactAnalyticalInfo;
    }
    /**
     * Metadata information about a profile. This message replaces legacy profile-specific singleton fields from the PersonMetadata proto (singleton top level Person fields are not compatible with non-profile-centric person results, which may include multiple profile containers).
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfo {
        /**
         * The account email linked to the profile, if any exists and is visible to the requester.
         */
        accountEmail?: Schema$AppsPeopleOzExternalMergedpeopleapiAccountEmail;
        /**
         * Indicates whether the profile owner has blocked this person.
         */
        blockType?: string[] | null;
        /**
         * CustomerInfo for dasher user. The reader has to explicitly request this in the field_mask as 'read_only_profile_info.customer_info'
         */
        customerInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiCustomerInfo;
        /**
         * DEPRECATED. Use the `ReadOnlyProfileInfo.customer_info` field instead (b/138120418). Only populated if in_viewer_domain is true.
         */
        domainInfo?: Schema$AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfoDomainInfo;
        /**
         * Indicates whether this person is blocking the profile owner.
         */
        incomingBlockType?: string[] | null;
        /**
         * DEPRECATED. Proxying trust between users in a domain should use go/flex-orgs-platform. For more info see: http://doc/18i0-C7vWcz2UuXYBsmulnriVCK3_EuMPpRlPa2OmMHw#heading=h.dobotdwx25kg Indicates whether the profile owner is in the same domain as the viewer.
         */
        inViewerDomain?: boolean | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * DEPRECATED.
         */
        objectType?: string | null;
        /**
         * The Focus-obfuscated Gaia ID of the profile owner (go/obfuscated-ids).
         */
        ownerId?: string | null;
        ownerUserType?: string[] | null;
        /**
         * DEPRECATED. Please use `person.plus_page_info` instead.
         */
        plusPageType?: string | null;
        /**
         * Stats/counters pertaining to followers and incoming edges.
         */
        profileOwnerStats?: Schema$AppsPeopleOzExternalMergedpeopleapiProfileOwnerStats;
        /**
         * Returned only when explicitly requested in the request mask as read_only_profile_info.unjoined_email_certificates. Equivalent to fetching the Emails & the Email Certificates with the acls ignored.
         */
        unjoinedEmailCertificates?: Schema$AppsPeopleOzExternalMergedpeopleapiEmail[];
    }
    /**
     * DEPRECATED.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfoDomainInfo {
        /**
         * DEPRECATED. Organization badge for the domain this person is a member of. The badge is the primary hosted domain.
         */
        domainBadge?: string[] | null;
        /**
         * DEPRECATED. Hosted domain this person is a member of. Formerly only available via PersonExtendedData.
         */
        domainName?: string[] | null;
    }
    /**
     * Relation stores the related person between the contact or profile and a third person. See go/relation-vs-relationship for relation vs relationship explanation. This field currently includes RelationshipToMe data in fields value and canonical_value for ContainerType CONTACT_ANNOTATION. This will be moved to RelationshipToMe in b/221081499.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiRelation {
        /**
         * Canonicalized `value` of the relation from this person to the user. This is currently used for data from contact annotations. Possible canonical values are based from http://google3/googledata/quality/aliases/relationship_en.config.
         */
        canonicalValue?: string | null;
        /**
         * The `type` translated and formatted in the request locale. See go/people-api-howto/localization for details on how to usage.
         */
        formattedType?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * The person whose email matches the Relation.value field, if it is a valid email address. This field is read-only and ignored on update.
         */
        relationDetails?: Schema$AppsPeopleOzExternalMergedpeopleapiRelationRelationDetails;
        /**
         * The relation type. The type can be free form or one of these predefined values: * `spouse` * `child` * `mother` * `father` * `parent` * `brother` * `sister` * `friend` * `relative` * `domesticPartner` * `manager` * `assistant` * `referredBy` * `partner`
         */
        type?: string | null;
        /**
         * The person this relation applies to. Custom value provided by the user.
         */
        value?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiRelationRelationDetails {
        /**
         * Equivalent to Name.display_name for the person_id profile.
         */
        displayName?: string | null;
        /**
         * Equivalent to Organization.title for the primary organization of the person_id profile.
         */
        jobTitle?: string | null;
        personId?: string | null;
        /**
         * Equivalent to Photo.url for the person_id profile.
         */
        photoUrl?: string | null;
    }
    /**
     * Deprecated in b/122464133. No data returned for this field.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiRelationshipInterest {
        /**
         * The `type` translated and formatted in the request locale. See go/people-api-howto/localization for details on how to usage.
         */
        formattedType?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * These fields may give away the sexual orientation of the user.
         */
        type?: string | null;
    }
    /**
     * Deprecated in b/122464133. No data returned for this field.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiRelationshipStatus {
        /**
         * The `type` translated and formatted in the request locale. See go/people-api-howto/localization for details on how to usage.
         */
        formattedType?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        type?: string | null;
    }
    /**
     * User preference for shared endorsements. See go/se-devguide and go/sharedendorsements for details, including guidance on which contexts are which.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiRightOfPublicityState {
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        state?: string | null;
    }
    /**
     * Information specific to rosters like Google Groups and Chatrooms.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiRosterDetails {
        /**
         * Abridged / sample subset of member details of the roster. NOTE: This field is only returned if the request's field mask includes "person.roster_details.abridged_roster_memberships". http://cs/symbol:google.apps.cloudidentity.groups.internal.GroupSummary.abridged_memberships
         */
        abridgedRosterMemberships?: Schema$AppsPeopleOzExternalMergedpeopleapiRosterMember[];
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * Indicates the number of members and sub-rosters of the roster. Corresponds to http://cs/symbol:google.apps.cloudidentity.groups.internal.Group.direct_member_count_per_type
         */
        rosterMemberCount?: Schema$AppsPeopleOzExternalMergedpeopleapiRosterMemberCount;
    }
    /**
     * Represents details of a member of a roster. Used in RosterDetails. Corresponds to http://cs/symbol:google.apps.cloudidentity.groups.internal.Membership
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiRosterMember {
        /**
         * Type of the member.
         */
        memberType?: string | null;
        /**
         * Focus-Obfuscated Gaia Id of the member.
         */
        personId?: string | null;
    }
    /**
     * Represents the summary of member counts of a roster. Used in RosterDetails. Corresponds to http://cs/symbol:google.apps.cloudidentity.groups.internal.Group.DirectMemberCountPerType
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiRosterMemberCount {
        /**
         * Indicates the number of direct sub-rosters of the roster. This comes from http://cs/symbol:google.apps.cloudidentity.groups.internal.Group.DirectMemberCountPerType.group_count
         */
        directGroupCount?: string | null;
        /**
         * Indicates the number of direct, non-roster members of the roster. This comes from http://cs/symbol:google.apps.cloudidentity.groups.internal.Group.DirectMemberCountPerType.user_count
         */
        directUserCount?: string | null;
    }
    /**
     * Profile for Janata and Search. go/janata-profile-in-sgbe
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiSearchProfile {
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        searchProfileData?: Schema$SocialGraphApiProtoSearchProfileData;
    }
    /**
     * As of 03/2018 is not supported for user Profile.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiSipAddress {
        /**
         * The `type` translated and formatted in the request locale. See go/people-api-howto/localization for details on how to usage.
         */
        formattedType?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * The type of the SIP address. The type can be free form or or one of these predefined values: * `home` * `work` * `mobile` * `other`
         */
        type?: string | null;
        value?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiSkills {
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        value?: string | null;
    }
    /**
     * The social connection of this person to the viewer. NOTE: this is used by go/starlight, but not actually used or returned in PeopleAPI. See b/27281119 for context.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiSocialConnection {
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        type?: string[] | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiSortKeys {
        affinity?: Schema$AppsPeopleOzExternalMergedpeopleapiAffinity[];
        /**
         * Deprecated. This field is only populated with 0.000 for legacy reasons. Clients should not use this field.
         */
        interactionRank?: string | null;
        lastName?: string | null;
        lastNameRaw?: string | null;
        name?: string | null;
        /**
         * Raw name strings that were used to generate the name and last_name sort keys fields above. Contacts+ need them to generate section headers for list view (b/30642866).
         */
        nameRaw?: string | null;
    }
    /**
     * Id of a single source from the merged person.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiSourceIdentity {
        /**
         * The type of source. To be deprecated infavor of container_type
         */
        container?: string | null;
        /**
         * The type of the source.
         */
        containerType?: string | null;
        /**
         * In sync responses, indicates whether the identity source has been deleted. Not applicable to GOOGLE_GROUP.
         */
        deleted?: boolean | null;
        /**
         * The encoded id of the data source. This field correlates to PersonFieldMetadata.encoded_container_id. The possible values of this `id` field are as follows based on the value of the `container_type` field: CONTACT: Hex-encoded contact id. PROFILE: DOMAIN_PROFILE: GOOGLE_GROUP: NAMED_CHAT_ROOM: Focus-obfuscated Gaia ID. DOMAIN_CONTACT: Synthetic-contact id representing the domain shared contact. PLACE: Encoded PlaceId (go/javagoog/maps/api/places/util/PlaceIdEncoder.java) RAW_DEVICE_CONTACT: Pair of device_id and raw_contact_id, encoded as base64 serialized social.graph.peopleapi.proto.internal.RawDeviceContactId proto. CONTACT_ANNOTATION: Pair of annotation_id and event_timestamp, encoded as base64 serialized social.graph.peopleapi.proto.internal.ContactAnnotationId proto. -- DEPRECATED container types -- If the container is CIRCLE, then the id is going to be the synthetic- contact id representing the email-only circle member or gaia circle member for which the requester does not have a contact for.
         */
        id?: string | null;
        /**
         * Last update timestamp of this source. NOTE: Only populated for CONTACT container type in Java PeopleAPI. Populated for CONTACT, PROFILE, DOMAIN_PROFILE in Sharpen implementation. NOTE: Not populated for GOOGLE_GROUP.
         */
        lastUpdated?: string | null;
        /**
         * **DEPRECATED** Please use `last_updated` field instead. Last update timestamp of this source in microseconds. NOTE: Only populated for CONTACT container type.
         */
        lastUpdatedMicros?: string | null;
        /**
         * NOTE: Not populated for GOOGLE_GROUP.
         */
        sourceEtag?: string | null;
    }
    /**
     * Custom field that represents SSH public keys associated with the user. We can treat the field as a map from a string fingerprint to the SSH public key information.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiSshPublicKey {
        expirationTime?: string | null;
        /**
         * The value is automatically set to a SHA-256 fingerprint of an SSH public key. A fingerprint should uniquely identify an SSH public key.
         */
        fingerprint?: string | null;
        key?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
    }
    /**
     * This message mirrors the ContactPhoneNumber message in ccc/grand_central/common/types.proto. For various reasons, we cannot take on a direct dependency. See other proto file for most recent documentation.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiStructuredPhone {
        /**
         * The phone formatted type. See docs from mirrored proto: http://google3/ccc/grand_central/common/types.proto?l=128&rcl=241000760
         */
        formattedType?: string | null;
        phoneNumber?: Schema$AppsPeopleOzExternalMergedpeopleapiStructuredPhonePhoneNumber;
        shortCode?: Schema$AppsPeopleOzExternalMergedpeopleapiStructuredPhoneShortCode;
        /**
         * The type of phone. See docs from mirrored proto: http://google3/ccc/grand_central/common/types.proto?l=125&rcl=241000760
         */
        type?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiStructuredPhonePhoneNumber {
        e164?: string | null;
        i18nData?: Schema$AppsPeopleOzExternalMergedpeopleapiStructuredPhonePhoneNumberI18nData;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiStructuredPhonePhoneNumberI18nData {
        countryCode?: number | null;
        internationalNumber?: string | null;
        isValid?: boolean | null;
        nationalNumber?: string | null;
        regionCode?: string | null;
        validationResult?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiStructuredPhoneShortCode {
        /**
         * The phone code. See docs from mirrored proto: http://google3/ccc/grand_central/common/types.proto?l=70&rcl=241000760
         */
        code?: string | null;
        countryCode?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiTagline {
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        value?: string | null;
    }
    /**
     * *UNSUPPORTED*. This message is never populated and is no longer used.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiTeamsExtendedData {
        admins?: Schema$AppsPeopleOzExternalMergedpeopleapiPerson[];
        adminTo?: Schema$AppsPeopleOzExternalMergedpeopleapiPerson[];
        dottedLineManagers?: Schema$AppsPeopleOzExternalMergedpeopleapiPerson[];
        dottedLineReports?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonListWithTotalNumber;
        failures?: string[] | null;
        managementChain?: Schema$AppsPeopleOzExternalMergedpeopleapiPerson[];
        reports?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonListWithTotalNumber;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiUserDefined {
        key?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        value?: string | null;
    }
    /**
     * DEPRECATED in favor of ProfileStats. Stats pertaining to incoming edges and views, visible to the requester (with acls applied). Related to, but not equal to, com.google.focus.proto.Storage.UserVisibleStats.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiUserVisibleStats {
        /**
         * Replacement for deprecated follower_count. Comes from the EdgeSummary.
         */
        incomingAnyCircleCount?: string | null;
        viewCount?: string | null;
    }
    /**
     * Store metadata information like annotation-id and product source for visible to guests contacts go/visible-to-guests.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiVisibleToGuests {
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiWebContactsExtendedData {
        /**
         * Used by Contacts client-side to indicate whether a person is not completed.
         */
        isIncomplete?: boolean | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiWebsite {
        /**
         * The `type` translated and formatted in the request locale. See go/people-api-howto/localization for details on how to usage.
         */
        formattedType?: string | null;
        metadata?: Schema$AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata;
        /**
         * Currently in Oz: "Links": Links with no rel. "Other profiles": Links with rel=ME. "Contributor to": Links with rel=CONTRIBUTOR_TO or PAST_CONTRIBUTOR_TO.
         */
        rel?: Schema$AppsPeopleOzExternalMergedpeopleapiWebsiteRelationshipInfo[];
        /**
         * The type of the website. The type can be free form or one of these predefined values: * `home` * `work` * `blog` * `profile` * `homePage` * `ftp` * `reservations` * `appInstallPage`: website for a Currents application. * `other`
         */
        type?: string | null;
        value?: string | null;
    }
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiWebsiteRelationshipInfo {
        type?: string | null;
    }
    /**
     * Extension data for use in Youtube Product Profile.
     */
    export interface Schema$AppsPeopleOzExternalMergedpeopleapiYoutubeExtendedData {
        /**
         * Information about a channel created by the user. A user can create multiple Youtube channels.
         */
        channelData?: Schema$AppsPeopleOzExternalMergedpeopleapiChannelData[];
        /**
         * Failure type if there is an error when fetching product profile data.
         */
        failure?: Schema$AppsPeopleOzExternalMergedpeopleapiProductProfileFailure;
    }
    /**
     * The features supported by the ActionV2 protocol. Note that after we move on to ConversationProto for all surfaces we can remove this message.
     */
    export interface Schema$AssistantApiActionV2SupportedFeatures {
        /**
         * This flag is used to work around a bug in AGSA 6.8 that got away. The bug prevents users from accessing their shopping list if the URL of the shopping list is not a keep.google.com URL. This will happen when switch the backend that stores the shopping list from Keep to a backend maintained by the Google Shopping Express team.
         */
        expressUrlInSettingsResponseSupported?: boolean | null;
        /**
         * Whether client supports reconnect client input in action v2 payload. This capability is needed to determine if client supports parsing client input payload from actionv2 proto for workflow purposes. See go/personal-workflow. OWNER:nyzstar,vvvemuri.
         */
        reconnectClientInputSupported?: boolean | null;
        /**
         * Whether or not the surface supports a simple UnsupportedAction instead of a ModalState punt card for rendering. For ActionV2 punt cards, the ModalState extension on the ResourceSet is the canonical way of building punt cards. However, while most all devices support the ActionV2 protocol, not all devices handle the ModalState rendering as part of the ActionV2. For these devices, we want to build a modified ActionV2 for punt cards which omits this ModalState. At present, this is only Android Wear and should not be used for other devices if they support ModalState or Conversation protocol.
         */
        simpleActionV2PuntSupported?: boolean | null;
        /**
         * A list of all the action types supported by the client. These should be the string representation of majel.ActionTypes within "quality/majel/api/proto/action_v2.proto".
         */
        supportedActionType?: string[] | null;
        /**
         * Checks if screenshots can be taken on the client. This field is set on the client from AGSA 7.2 onwards.
         */
        takeScreenshotSupported?: boolean | null;
        /**
         * If IMMERSIVE_ACTIONS UiType is supported by the client.
         */
        voiceDelightImmersiveUiSupported?: boolean | null;
        /**
         * If Voice Delight Stickers are supported by the client. In order to support Voice Delight stickers, the client should know how to extract sticker_url from VoiceDelightSystemInteractionSegment.
         */
        voiceDelightStickersSupported?: boolean | null;
        /**
         * If Voice Delight Suggestion Chips are supported by the client. In order to support Voice Delight Suggestion Chips, the client should know how to extract suggestions form VoiceDelightSystemInteraction.ResourceSet.
         */
        voiceDelightSuggestionsSupported?: boolean | null;
    }
    /**
     * Capabilities related to Android intent support. These capabilities can apply to any device on the Android platform. Provides the list of Android package names that support a given Android intent.
     */
    export interface Schema$AssistantApiAndroidIntentCapabilities {
        androidIntentCapability?: Schema$AssistantApiAndroidIntentCapabilitiesAndroidIntentCapability[];
    }
    export interface Schema$AssistantApiAndroidIntentCapabilitiesAndroidIntentCapability {
        /**
         * The Action name of the Android Intent in standard notation (https://developer.android.com/reference/android/content/Intent#getAction()).
         */
        intentActionName?: string | null;
        /**
         * The Android provider packages that support the intent, e.g. "com.google.android.deskclock".
         */
        packageNames?: string[] | null;
    }
    /**
     * Used to describe app capabilities of the device installed apps reported to the server.
     */
    export interface Schema$AssistantApiAppCapabilities {
        /**
         * Indicates whether the provider is compatible for media fulfillment on this surface. For example, Amazon Music isn't compatible with the driving mode.
         */
        allowlistedForMediaFulfillment?: boolean | null;
        /**
         * Currently unused. Will be used in the future when integrating with incremental app capabilities.
         */
        appIntegrationsSettings?: Schema$AssistantApiAppIntegrationsSettings;
        /**
         * This system app is disabled in settings.
         */
        disabledSystemApp?: boolean | null;
        /**
         * The installed app of the provider.
         */
        provider?: Schema$AssistantApiCoreTypesProvider;
        /**
         * This provider has integrated its cloud backend with Google, and Google can route the user queries to the provider's cloud.
         */
        routableToProviderCloud?: boolean | null;
        /**
         * This provider has an app that supports on-device search through the provider's own inventory.
         */
        searchableOnDevice?: boolean | null;
        /**
         * This provider has integrated its content with Google, and Google has enabled to serve its content as a server-side solution.
         */
        searchableOnServer?: boolean | null;
        /**
         * Indicates whether the provider supports playback of 3P(externally hosted) podcasts.
         */
        supports3pPodcastPlayback?: boolean | null;
        /**
         * This provider has an app that supports starting new media playback when there is no screen (e.g. by integrating with the Bisto SDK).
         */
        supportsScreenlessInitiation?: boolean | null;
        /**
         * This provider is an app which should be used for query annotations. This is useful for apps which may not be already indexed by Google or are client specific.
         */
        whitelistedForAnnotation?: boolean | null;
    }
    /**
     * Used to describe the incremental change of app capabilities of the device installed apps reported to the server.
     */
    export interface Schema$AssistantApiAppCapabilitiesDelta {
        /**
         * Currently unused. Will be used in the future when integrating with incremental app capabilities.
         */
        appIntegrationsSettings?: Schema$AssistantApiAppIntegrationsSettings;
        /**
         * The installed app of the provider.
         */
        providerDelta?: Schema$AssistantApiCoreTypesProviderDelta;
    }
    export interface Schema$AssistantApiAppControlSupport {
        enabled?: string | null;
        /**
         * If true, disable send message AppControl/SD flow. This is needed to suppress the feature for specific device. If we decide to turn down this feature for all devices, then this field will become obsolete and should be removed. See context in b/275727627.
         */
        sendMessageSuppressed?: boolean | null;
    }
    /**
     * Contains the app privacy bits used for App Integrations implicit request. (go/app-privacy-settings-for-implicit-requests)
     */
    export interface Schema$AssistantApiAppIntegrationsSettings {
        /**
         * Whether to enable Assistant to handle request with predicted apps.
         */
        handleRequestsWithPredictedApps?: string | null;
    }
    export interface Schema$AssistantApiAssistantContinuedPresenceSupport {
        /**
         * Indicates in what cases assistant continued presence can be shown as a plate. This field is white-listed as being PII-free. Please do not add PII here.
         */
        plateSupport?: string | null;
    }
    /**
     * These capabilities represent the audio input features associated with the device. This includes what kind of audio input the device can handle, and what the privacy circumstances of that input are.
     */
    export interface Schema$AssistantApiAudioInput {
        environment?: string | null;
        quality?: string | null;
    }
    /**
     * These capabilities represent the audio output features associated with the device. This includes what kind of audio output the device can handle, and what the privacy circumstances of that output are.
     */
    export interface Schema$AssistantApiAudioOutput {
        alwaysOnSpeaker?: string | null;
        environment?: string | null;
        mediaTtsMixable?: string | null;
        quality?: string | null;
        volumeProperties?: Schema$AssistantApiVolumeProperties;
    }
    /**
     * Bluetooth capabilities related to usage of a feature.
     */
    export interface Schema$AssistantApiBluetoothCapabilities {
        /**
         * If this surface needs to bluetooth pair a phone before using a feature.
         */
        isBluetoothConnectedProfileRequired?: boolean | null;
    }
    /**
     * CallCapabilities supported by a surface. See go/call-capabilities. Next ID: 7
     */
    export interface Schema$AssistantApiCallCapabilities {
        /**
         * The supported call formats on the surface.
         */
        callFormats?: string[] | null;
        /**
         * The supported call mediums on the surface.
         */
        callMediums?: string[] | null;
        /**
         * The call options this surface can provide. For example, SPEAKERPHONE is available on Android OPA while iOPA doesn't support it yet.
         */
        callOptions?: string[] | null;
        /**
         * If true, APP_ID queries initiated by this device should fall back to execution on the tethered device if it's available and if the primary device cannot perform the action (e.g. due to the app not being installed).
         */
        fallbackToTetheredDeviceAppCapabilities?: boolean | null;
        /**
         * Should only be checked if nonempty.
         */
        supportedRecipientTypes?: string[] | null;
        supportsDuoEmailEndpoint?: boolean | null;
    }
    /**
     * These capabilities represent the camera features associated with the device.
     */
    export interface Schema$AssistantApiCameraCapabilities {
        /**
         * Whether the device supports Face Match.
         */
        faceMatchCapable?: boolean | null;
        /**
         * Whether the device has a camera.
         */
        hasCamera?: boolean | null;
    }
    /**
     * These capabilities present the capability of the device running camera receiver apps.
     */
    export interface Schema$AssistantApiCameraReceiverCapabilities {
        /**
         * Whether the device has limited camera stream capability. If true, check supported_camera_receivers for detailed supported cameras.
         */
        hasLimitedCameraStreamCapability?: boolean | null;
        /**
         * The camera receiver cast apps the device supports. Only used if has_limited_camera_stream_capability is true.
         */
        supportedCameraReceivers?: Schema$AssistantApiCoreTypesCastAppInfo[];
    }
    /**
     * Capabilities that are associated with Assistants on auto surfaces. This is different from other capabilities such as CarSettingsCapabilities, CloudCarCapabilities since they are specific to settings and 3P cloud information. All the auto/car Assistant specific capabilities should live here.
     */
    export interface Schema$AssistantApiCarAssistantCapabilities {
        /**
         * Indicates whether the current Assistant should provide a multi Assistant specific punt when there are multiple Auto specific Google Assistants (Android Auto Projected (AAP) and Android Auto Embedded (AAE)) in the same GAS enabled car. This will be used by both AAP and AAE. Design doc: go/doubledash++
         */
        shouldPuntMultiAssistantMode?: boolean | null;
    }
    /**
     * Capabilities that are associated with Assistant Settings on auto surfaces.
     */
    export interface Schema$AssistantApiCarSettingsCapabilities {
        /**
         * If true, it indicates that the auto surface client should receive a warmer welcome TTS for signed-out users. For signed-in user, we will rely on server side metadata. go/aaae:preview-lang
         */
        playWarmerWelcome?: boolean | null;
        /**
         * If true, it indicates that the client can be used to add cars after account linking with the OEM.
         */
        supportsAddingCars?: boolean | null;
    }
    export interface Schema$AssistantApiCastAssistantSettingLinkingResult {
        /**
         * Cast linking status for ATV surfaces. This is derived from error messages returned from Cast Orchestration Server and will be used for data profiling only(go/katniss-settings-dashboard).
         */
        castLinkingStatus?: string | null;
        /**
         * The error msg returned from COS, truncated in case it's too large.
         */
        truncatedErrorMsg?: string | null;
    }
    /**
     * These capabilities represent capabilities that have to do with casting that pertain to this device. Next ID: 9
     */
    export interface Schema$AssistantApiCastCapabilities {
        /**
         * Whether the device has limited camera stream capability and if yes, which receivers are supported.
         */
        cameraReceiverCapabilities?: Schema$AssistantApiCameraReceiverCapabilities;
        /**
         * The supported protocols for camera streaming. The value is used as string in go/smarthome-internal-api#camera-stream, so using a string for this field instead of an enum. Supported protocols: (align the definition in go/smarthome-camerastream-trait) - "hls": HTTP Live Streaming - "dash": Dynamic Adaptive Streaming over HTTP - "smooth_stream": Smooth Streaming - "progressive_mp4": Progressive MP4 (will likely only be used for Clips) - "webrtc": WebRTC (currently, only H.264 is supported) - "nexustalk": Internal-only protocol used for Nest
         */
        cameraStreamSupportedProtocols?: string[] | null;
        /**
         * True if we can cast things to this device.
         */
        canReceiveCast?: boolean | null;
        /**
         * Optional for primarily cast devices (e.g., Chirp, Chromecast). For devices that are NOT primarily cast devices, but having a cast receiver as secondary functionality, this field SHOULD store the cast-device-id to be used to send remote casting commands to the device. Example: Android TV, which supports both Android-native actions as well as remote casting using its built-in cast receiver. Android TV device id contains a DUSI id, which is not a cast-device-id. When executing a cast command on the Android TV, this field is used to route the cast command (through CloudCastService) to the cast receiver on the device.
         */
        deviceId?: Schema$AssistantApiCoreTypesDeviceId;
        /**
         * Whether this device supports dynamic groups or not. It implies if a Stream Control operation (transfer, expansion, and contraction) could be applied on this device since Stream Control is implemented as part of dynamic groups (ie, adding/removing devices from playback)
         */
        dynamicGroupsSupported?: boolean | null;
        groupType?: string | null;
        /**
         * Whether UI overlay applications are supported on this device. It's used by Chromecast only.
         */
        overlayApplicationsSupported?: boolean | null;
        /**
         * Whether the device supports playing games through Yeti. This is set by the cast device when the device is updated: Chromecast updates -\> Chromecast registers its capabilities with CCS -\> CCS passes the capabilities to the AssistantSettingsService -\> AssistantSettingsService stores the device's capabilities. go/yeti-gaming-supported-cast-capability
         */
        yetiGamingSupported?: boolean | null;
    }
    /**
     * The properties of the client op device.MODIFY_SETTING. This proto is stored in the SupportedClientOp proto.
     */
    export interface Schema$AssistantApiClientOpPropertiesDeviceModifySettingClientOpProperty {
        /**
         * Additional specific setting capabilities. This boolean is used to indicate whether we want to skip the Android and GSA version check in CheckSettingSchemaAndMaybeGetUris() from assistant/vertical/device/fulfillment/utils/setting_utils.h. Consider setting this field to true if your device is neither Android or GSA (especially when the UserAgent string of your device's TaskRequest will not contain a valid/up-to-date Android/GSA version).
         */
        skipAndroidAndGsaVersionCheck?: boolean | null;
        /**
         * Uses DeviceSetting enum which corresponds to setting_id. This indicates which specific settings are supported by client. An empty list implies all settings are supported.
         */
        supportedSettings?: string[] | null;
        /**
         * Additional specific setting capabilities. This boolean is used to indicate if do not disturb with duration is supported through device.MODIFY_SETTING clientop on a client or not.
         */
        supportsDoNotDisturbWithDuration?: boolean | null;
        /**
         * Additional specific setting capabilities. This boolean is used to indicate if new unmute logic is enabled on a client or not.
         */
        supportsMuteUnmute?: boolean | null;
    }
    /**
     * The properties of the provider.OPEN ClientOp. This proto is stored in the SupportedClientOp proto with the key provider.OPEN.
     */
    export interface Schema$AssistantApiClientOpPropertiesProviderOpenClientOpProperty {
        /**
         * Whether conversation is kept alive after opening the app. See go/keep-opa-conversation-alive for details.
         */
        keepsConversationAliveAfterOpeningApp?: boolean | null;
    }
    /**
     * Used to describe clock capabilities of the device (for example, capabilities related to maximum number of supported alarms and timers that can be created on the device). Fields may be populated by clients or be backfilled by SAL (in case of Timon, for example).
     */
    export interface Schema$AssistantApiClockCapabilities {
        /**
         * Maximum number of alarms that can be created on the client.
         */
        maxSupportedAlarms?: number | null;
        /**
         * Maximum extended timer duration supported by the client. The extended timer duration is the total start-to-finish duration after an AddTimeToTimer operation. E.g. if a user sets a timer for 30 minutes, and later adds 10 minutes, the extended duration is 40 minutes.
         */
        maxSupportedExtendedTimerDuration?: Schema$AssistantApiDuration;
        /**
         * Maximum duration of timers that can be created on the client.
         */
        maxSupportedTimerDuration?: Schema$AssistantApiDuration;
        /**
         * Maximum number of timers that can be created on the client.
         */
        maxSupportedTimers?: number | null;
        /**
         * The preferred provider to use for stopwatch related functionality.
         */
        preferredStopwatchProvider?: Schema$AssistantApiCoreTypesProvider;
        /**
         * Whether the client restricts alarms to ring within the next 24 hours.
         */
        restrictAlarmsToNext24h?: boolean | null;
    }
    /**
     * UI capabilities for the surfaces rendering Comms features. See go/rohan-comms-fluid-actions-customization.
     */
    export interface Schema$AssistantApiCommunicationUiCapabilities {
        fluidActionsUiType?: string | null;
    }
    export interface Schema$AssistantApiContactLookupCapabilities {
        /**
         * If true, contact.LOOKUP should be routed to the tethered device (if present) if the tethered device supports contact.LOOKUP and the primary device does not.
         */
        fallbackToTetheredDevice?: boolean | null;
    }
    /**
     * The android app information of the provider. Like, Spotify. Next ID: 17 LINT.IfChange
     */
    export interface Schema$AssistantApiCoreTypesAndroidAppInfo {
        accountType?: string | null;
        activityInfo?: Schema$AssistantApiCoreTypesAndroidAppInfoActivityInfo;
        /**
         * Intent associated with the app. We include intents here as different versions of the same app may support different intents. In those cases, the package_name is not enough to identify the app and we should use the combination of package_name and android_intent. This field might contain sensitive data, if represents ClientOp with encapsulated PII such as user query.
         */
        androidIntent?: string | null;
        /**
         * Store the app unique id endpoint. This will be passed over to app to fulfill the action.
         */
        appUniqueId?: string | null;
        /**
         * The android app version. Deprecated because https://developer.android.com/reference/android/content/pm/PackageInfo.html#getLongVersionCode
         */
        appVersion?: number | null;
        /**
         * data_mimetype and account_type are the what AGSA uses to filter which contacts support this Android app in ContactProvider.
         */
        dataMimetype?: string | null;
        /**
         * If true, client should broadcast the intent instead of open the intent.
         */
        isBroadcastIntent?: boolean | null;
        /**
         * App is the default app for it's core functionality. For example, it will be true for Android messages if it is the default app to send and receive SMS on the phone.
         */
        isDefault?: boolean | null;
        /**
         * The localized app name.
         */
        localizedAppName?: string | null;
        /**
         * The long android app version.
         */
        longVersionCode?: string | null;
        /**
         * Store mimetype of this endpoint. We will use this as the differentiator for Assistant to know whether to use the RawContact for messaging, call or video call. For example, send message mimetype for whatsapp: "vnd.android.cursor.item/vnd.com.whatsapp.profile" voice call mimetype for whatsapp: "vnd.android.cursor.item/vnd.com.whatsapp.voip.call"
         */
        mimetype?: string | null;
        /**
         * The android app package of the provider, like "com.spotify.music".
         */
        packageName?: string | null;
        /**
         * The OemProviderType is specific for OEM system Android apps. For example, in Auto Embedded, the OEM will have a system Radio/Media app. The system app’s capabilities/core functionalities are captured here. For physical media sources, the OEM may decide to implement one media app (thus, one package name) that handles multiple physical media sources. For these cases, each physical media source will be sent as different providers even though the package name is the same.
         */
        providerType?: string | null;
        /**
         * Id of the app's Android shortcut to be launched by Assistant. The client is expected to use the Android LauncherApps API to execute this shortcut which in turn will open the app. For example, Whatsapp may create an Android shortcut for a frequently messaged contact with an id "contact_123". This field will contain that id and the client can execute it to open up the chat with that particular contact. If this field is set, the package_name field must also be set since both will be used by the LauncherApps API for execution. If this field is set, the intent related fields will be ignored and not used as a fallback. Design: go/shortcut-id-in-provider-open-clientop This field should only be set for devices with Android API level \>= 25 (since that is the version from which the LauncherApps startShortcut API is available)
         */
        shortcutId?: string | null;
        /**
         * The fully qualified target class name of the provider, like "com.example.myapp.GetOrderService".
         */
        targetClass?: string | null;
        /**
         * The android app version name, like "4.1.091.05.40d", "11.2.7.21.alpha". Android Docs: https://developer.android.com/reference/android/content/pm/PackageInfo#versionName
         */
        versionName?: string | null;
    }
    /**
     * General information about activities in the app.
     */
    export interface Schema$AssistantApiCoreTypesAndroidAppInfoActivityInfo {
        /**
         * Activities that are currently active and tagged as ACTION_MAIN and CATEGORY_LAUNCHER. Includes the activity corresponding to android_intent if it falls under CATEGORY_LAUNCHER.
         */
        activeLaunchableActivities?: Schema$AssistantApiCoreTypesAndroidAppInfoActivityInfoActivity[];
    }
    /**
     * Information about an individual activity.
     */
    export interface Schema$AssistantApiCoreTypesAndroidAppInfoActivityInfoActivity {
        /**
         * The localized user visible activity name.
         */
        localizedActivityName?: string | null;
        /**
         * Short class name for activity, following https://developer.android.com/reference/android/content/ComponentName#getShortClassName()
         */
        shortClassName?: string | null;
    }
    /**
     * The change of AndroidAppInfo, e.g. app installation or deletion for incremental delta app info upload.
     */
    export interface Schema$AssistantApiCoreTypesAndroidAppInfoDelta {
        /**
         * The android app information of the provider. Like, Spotify.
         */
        androidAppInfo?: Schema$AssistantApiCoreTypesAndroidAppInfo;
        /**
         * The client-side timestamp in millis when the app is last updated, installed or deleted.
         */
        lastUpdateTimestamp?: string | null;
        /**
         * App is installed or deleted.
         */
        updateType?: string | null;
    }
    /**
     * This proto contains the information of a calendar event, including title, start time, end time, etc. LINT.IfChange(CalendarEvent) NEXT_ID: 26
     */
    export interface Schema$AssistantApiCoreTypesCalendarEvent {
        /**
         * Attendees invited to the event, usually includes also the organizer.
         */
        attendees?: Schema$AssistantApiCoreTypesCalendarEventAttendee[];
        /**
         * The background color of the event, in RGB format.
         */
        backgroundColor?: number | null;
        /**
         * Optional calendar containing the event.
         */
        calendarId?: string | null;
        /**
         * The person who created this event.
         */
        creator?: Schema$AssistantApiCoreTypesCalendarEventAttendee;
        /**
         * Optional description of the event (plain text).
         */
        description?: string | null;
        /**
         * The end time of the event. Start and end time must either both be date or both be datetime. End is exclusive, ie. the first day / first second when the event is over.
         */
        end?: Schema$AssistantApiDateTime;
        /**
         * Optional event id provided by assistant server. Needs to be unique, at least on a per-user and calendar level, ideally globally unique. If none is given, the server will assign an id.
         */
        eventId?: string | null;
        /**
         * The flair name, calculated according to the event title (go/as-cal-flair). With the flair name, background images can be got from gstatic (go/scs): https://ssl.gstatic.com/tmly/f8944938hffheth4ew890ht4i8/flairs/
         */
        flairName?: string | null;
        /**
         * The foreground color of the event, in RGB format.
         */
        foregroundColor?: number | null;
        /**
         * Whether the guests can invite other guests.
         */
        guestsCanInviteOthers?: boolean | null;
        /**
         * Whether the guests can modify the event.
         */
        guestsCanModify?: boolean | null;
        /**
         * Whether the guests of the event can be seen. If false, the user is reported as the only attendee to the event, even though there may be more attendees.
         */
        guestsCanSeeGuests?: boolean | null;
        /**
         * Optional id of the Habit (Calendar Goal) this event is linked to
         */
        habitId?: string | null;
        /**
         * Optional status for this habit event instance.
         */
        habitStatus?: string | null;
        /**
         * Absolute link to this event in the Calendar web UI.
         */
        htmlLink?: string | null;
        /**
         * Optional location of the event (plain text).
         */
        location?: string | null;
        meetingContacts?: Schema$AssistantApiCoreTypesCalendarEventMeetingContact[];
        /**
         * The organizer of this event.
         */
        organizer?: Schema$AssistantApiCoreTypesCalendarEventAttendee;
        /**
         * Whether not all attendees are included in the attendee list. This is set when the attendees list has been truncated (e.g., when the number of attendees is beyond the maxAttendees limitation).
         */
        otherAttendeesExcluded?: boolean | null;
        /**
         * The user's response (the owner of this copy of the event) to this event.
         */
        participationResponse?: string | null;
        /**
         * If this is an instance of a recurring event, recurring_event_id identifies the recurring series as a whole.
         */
        recurringEventId?: string | null;
        /**
         * Meeting rooms associated to this event.
         */
        rooms?: Schema$AssistantApiCoreTypesCalendarEventRoom[];
        /**
         * The start time of the event. This event is an all-day event if start has no time_of_day.
         */
        start?: Schema$AssistantApiDateTime;
        /**
         * The title of the event.
         */
        summary?: string | null;
        /**
         * Optional visibility of the event.
         */
        visibility?: string | null;
    }
    /**
     * Next id: 8
     */
    export interface Schema$AssistantApiCoreTypesCalendarEventAttendee {
        /**
         * Display name, present only if available.
         */
        displayName?: string | null;
        /**
         * Email address of the attendee (calendar), for regular events. For +Events, this field is not populated, instead "id" is used.
         */
        email?: string | null;
        /**
         * Given (first) name, present only if available. This is used for generating meeting titles as given name is preferred over display (full) name (ie: "Jeff : Sundar" is better than "Jeff Dean : Sundar Pichai").
         */
        givenName?: string | null;
        /**
         * Profile ID of the principal, for +Events. For regular events, this field is not populated, instead "email" is used.
         */
        id?: string | null;
        /**
         * Is this the organizer?
         */
        organizer?: boolean | null;
        /**
         * Attendees response status.
         */
        responseStatus?: string | null;
        /**
         * Is this the owner of this copy of the event?
         */
        self?: boolean | null;
    }
    /**
     * Next id: 10
     */
    export interface Schema$AssistantApiCoreTypesCalendarEventMeetingContact {
        /**
         * ID that corresponds to in ConferenceData.conference_id in calendar.common.ConferenceData proto. For Meet, this is the identifier used to join a meeting via URL.
         */
        conferenceId?: string | null;
        dialInNumberClasses?: string[] | null;
        /**
         * Default meeting phone number, for example: "tel:+1-475-777-1840"
         */
        phoneNumberUri?: string | null;
        /**
         * A PIN that the participant will need to input after dialing in the conference.
         */
        pinNumber?: string | null;
        /**
         * Provider info for the meeting.
         */
        provider?: Schema$AssistantApiCoreTypesProvider;
        /**
         * The region code for the default meeting phone number
         */
        regionCode?: string | null;
        source?: string | null;
        /**
         * The universal meeting PIN number for phone numbers in all available countries
         */
        universalPinNumber?: string | null;
        /**
         * URL that can be used to join the meeting.
         */
        url?: string | null;
    }
    /**
     * A room that is available for a potential meeting or has been booked for a scheduled meeting. Next id: 4
     */
    export interface Schema$AssistantApiCoreTypesCalendarEventRoom {
        /**
         * Room email that identifies the room and is used to book it.
         */
        email?: string | null;
        /**
         * Additional room details. Read-only, populated on request.
         */
        locationDetails?: Schema$AssistantApiCoreTypesCalendarEventRoomRoomLocationDetails;
        /**
         * Room name (ex: "MTV-PR55-5-A-Shadow 5K0 (13) GVC (No external guests)").
         */
        name?: string | null;
    }
    /**
     * Room location details. Read-only, populated on request. Next id: 8
     */
    export interface Schema$AssistantApiCoreTypesCalendarEventRoomRoomLocationDetails {
        /**
         * Building where the room is (ex: "PR55").
         */
        building?: string | null;
        /**
         * City where the room is (ex: "MTV").
         */
        city?: string | null;
        /**
         * Floor where the room is (ex: "5").
         */
        floor?: string | null;
        /**
         * The latitude in degrees.
         */
        latitude?: number | null;
        /**
         * The longitude in degrees.
         */
        longitude?: number | null;
        /**
         * Section in the floor (ex: "A").
         */
        section?: string | null;
        /**
         * Room name (ex: "Shadow 5K0").
         */
        simpleName?: string | null;
    }
    /**
     * This empty type allows us to publish sensitive calendar events to go/attentional-entities, while maintaining BUILD visibility protection for their contents. The BUILD-visibility-protected extension to this message is defined at http://google3/assistant/verticals/calendar/proto/multi_account_calendar_event.proto
     */
    export interface Schema$AssistantApiCoreTypesCalendarEventWrapper {
    }
    /**
     * The cast app information of the provider.
     */
    export interface Schema$AssistantApiCoreTypesCastAppInfo {
        /**
         * The cast app id. |cast_app_id| is the ID of the cast app used on the current device and |content_app_id| is the ID of the app that provides the actual content. For example, in a group playback, on a follower device, the |cast_app_id| is the follower cast app ID and the |content_app_id| is the leader cast app ID.
         */
        castAppId?: string | null;
        /**
         * The id of the cast app that provides the content in a group. The field will always be filled. In the case of a group playback and the current device is a follower, the |cast_app_id| has the ID of the follower app, and |content_app_id| has ID of the actual content app. In all other cases, |content_app_id| and |cast_app_id| will be the same.
         */
        contentAppId?: string | null;
    }
    /**
     * The ChromeOS app information of the provider. Next ID: 3
     */
    export interface Schema$AssistantApiCoreTypesChromeOsAppInfo {
        /**
         * The localized app name.
         */
        localizedAppName?: string | null;
        /**
         * Unique package name that identifies a ChromeOS app of the provider.
         */
        packageName?: string | null;
    }
    /**
     * The third party provider information.
     */
    export interface Schema$AssistantApiCoreTypesCloudProviderInfo {
        agentStyle?: Schema$AssistantApiCoreTypesCloudProviderInfoAgentStyle;
        /**
         * URL to a directory page about the third party agent in Assistant HQ. This is a universal (https) URL that may be handled natively by clients to show HQ or launch to the HQ directory web page.
         */
        directoryUrl?: string | null;
        /**
         * The logo url for the third party provider.
         */
        logoUrl?: string | null;
        /**
         * The user visible name of the cloud provider, which may be used for example in the chat header during a conversation with the third party.
         */
        name?: string | null;
    }
    /**
     * The style customizations for the 3p agent.
     */
    export interface Schema$AssistantApiCoreTypesCloudProviderInfoAgentStyle {
        /**
         * The background color of the agent. Used if no background image is specified for the given display orientation, or if the provided background image does not fit.
         */
        backgroundColor?: Schema$AssistantApiCoreTypesGovernedColor;
        headerTheme?: string | null;
        /**
         * URL for the background image of the agent on landscape display.
         */
        landscapeBackgroundImageUrl?: string | null;
        /**
         * URL for the image containing the 3p logo. This can include logomark and logotype, or logotype only. If present, this can be used in place of the square logo contained in the top level logo_url field in CloudProviderInfo. See go/cards-logo-customization for details on applying this logo.
         */
        logoUrl?: string | null;
        /**
         * The color of the mask to apply to the background. See go/aog-cards-background-mask for details on applying this mask.
         */
        maskColor?: Schema$AssistantApiCoreTypesGovernedColor;
        /**
         * URL for the background image of the agent on portrait display.
         */
        portraitBackgroundImageUrl?: string | null;
        /**
         * The primary color of the agent. Used by the client to style the header and suggestion chips.
         */
        primaryColor?: Schema$AssistantApiCoreTypesGovernedColor;
    }
    /**
     * The identification information for third party devices that integrates with the assistant. All of these fields will be populated by the third party when the query is sent from the third party device. Next Id: 5
     */
    export interface Schema$AssistantApiCoreTypesDeviceConfig {
        /**
         * Pantheon Project ID that uniquely identifies the consumer project ID. Required
         */
        agentId?: string | null;
        /**
         * Unique identifier for the device. Example: DBCDW098234. Required
         */
        deviceId?: string | null;
    }
    /**
     * LINT.IfChange(DeviceId) Specifies identifier of a device AKA surface. Note there may be multiple device ids for the same physical device E.g. Allo app and Assistant app on Nexus. Note: DeviceId usage is complicated. Please do not depend on it for surface specific logic. Please use google3/assistant/api/capabilities.proto instead. IMPORTANT: When checking for equality between two `DeviceId`s, you should always use an `isSameDevice{As\}` function to check for equality, as deep equality between `DeviceId`'s is not guaranteed. * C++: http://google3/assistant/assistant_server/util/device_id_util.cc;l=23;rcl=421295740 * Dart: http://google3/assistant/context/util/lib/device_id.dart;l=26;rcl=442126145 * Java: http://google3/java/com/google/assistant/assistantserver/utils/DeviceIdHelper.java;l=9;rcl=390378522 See http://go/deviceid-equality for more details. Next ID: 14
     */
    export interface Schema$AssistantApiCoreTypesDeviceId {
        /**
         * The client_instance_id on devices with GSA. See 'client_instance_field' in go/androidids.
         */
        agsaClientInstanceId?: string | null;
        /**
         * Allo Id. Corresponds to the GBotRequest.Sender.sender. NOTE(dychen): This may change to standard android/ios physical device ids in order to enable shared data (e.g. installed app on physical device shared between Allo and Opa apps on Nexus).
         */
        alloDeviceId?: string | null;
        /**
         * A unique device ID for Assistant devices as proposed by go/ocelot-team to solve the device id fragmentation problem. The value of this id is the HomeGraph id of the device. See go/ocelot-track-0-registry-design. New surfaces should use the canonical_device_id instead of using other ids, and the registration should utilize the DeviceDataLayer (go/ddl-v0). Please contact the assistant-state-management@ team for guidance. Note: We didn't reuse |home_graph_device_id| because in Assistant code base |home_graph_device_id| is common to associate it with 3P devices. See go/project-yellowstone for more context.
         */
        canonicalDeviceId?: string | null;
        /**
         * If set, indicates that the device is a cast device, and contains the UUID of the cast device. Corresponds to the device_id field of the CastDevice proto.
         */
        castDeviceId?: string | null;
        /**
         * DUSI (go/dusi) is used as the identifier here. This identifier is unique to the user and device. This will help identify which device or application the user's request originated from. This is not to be confused with the client_instance_id that android devices provide. This is currently used by surfaces that use the assistant-legacy-nexus and assistant-legacy-clockwork pipelines. DUSI is created and set in S3. This field is only filled for GAIA requests.
         */
        clientInstanceId?: string | null;
        /**
         * A device ID produced by a connected dock, which is registered in HomeGraph.
         */
        connectedDockId?: string | null;
        /**
         * The unique DeviceConfig to the specific third party device. It is also used by Android Auto Embedded first party device. See go/opa-ids.
         */
        deviceConfig?: Schema$AssistantApiCoreTypesDeviceConfig;
        /**
         * DEPRECATED. assistant.api.core_types.governed.SurfaceIdentity.surface_type field should be used instead. The device's surface type. This is the string version of surface_type. The server should use the SurfaceType value derived from this string. If the device_type isn't supported within the SurfaceType enum, it will be set as UNKNOWN. Developers should use the enum in ServerParams instead of this string. WARNING: Clients are not actually setting this field. This field will be removed once references to it within the code base have been removed.
         */
        deviceType?: string | null;
        /**
         * The unique device ID for HomeGraph devices. This is the HomeGraph ID, created when the device is registered into HomeGraph. It is immutable for the same device unless it is completely deleted and recreated. See go/home-graph for details.
         */
        homeGraphDeviceId?: string | null;
        /**
         * The unique ID for libassistant based devices. See go/libassistant-id for details.
         */
        libassistantDeviceId?: string | null;
        /**
         * If set, indicates that the device is participating the multi-hotword arbitration and the id is an UUID to distinguish it from other devices. It should also be consistent between requests from a single device within a session (or short duration).
         */
        multiHotwordArbitrationDeviceId?: string | null;
        /**
         * The unique device ID for the Assistant App on iOS. See go/opa-ios-design for details.
         */
        opaIosDeviceId?: string | null;
        /**
         * The unique ID of a Quartz device. See go/quartz-design-doc for more details. Quartz ID is a hash of (android_id + gaia).
         */
        quartzDeviceId?: string | null;
    }
    /**
     * LINT.IfChange
     */
    export interface Schema$AssistantApiCoreTypesDeviceUserIdentity {
        /**
         * The identifier of the device.
         */
        deviceId?: Schema$AssistantApiCoreTypesDeviceId;
        /**
         * The identifier of the user.
         */
        gaiaId?: string | null;
    }
    /**
     * LINT.IfChange Represents a color in the RGBA color space. This message mirrors google.type.Color. IMPORTANT: The definition of Color proto is being moved to //assistant/api/core_types/color_type.proto. All existing references will be updated to point to the new location. If you are adding a reference, use the new one instead.
     */
    export interface Schema$AssistantApiCoreTypesGovernedColor {
        /**
         * The fraction of this color that should be applied to the pixel. That is, the final pixel color is defined by the equation: pixel color = alpha * (this color) + (1.0 - alpha) * (background color) This means that a value of 1.0 corresponds to a solid color, whereas a value of 0.0 corresponds to a completely transparent color. If omitted, this color object is to be rendered as a solid color (as if the alpha value had been explicitly given with a value of 1.0).
         */
        alpha?: number | null;
        /**
         * The amount of blue in the color as a value in the interval [0, 1].
         */
        blue?: number | null;
        /**
         * The amount of green in the color as a value in the interval [0, 1].
         */
        green?: number | null;
        /**
         * The amount of red in the color as a value in the interval [0, 1].
         */
        red?: number | null;
    }
    /**
     * The identification information for third party devices that integrates with the assistant. All of these fields will be populated by the third party when the query is sent from the third party device. IMPORTANT: The definition of DeviceConfig proto is being moved to //assistant/api/core_types/device_type.proto. All existing references will be updated to point to the new location. If you are adding a reference, use the new one instead. Next Id: 5
     */
    export interface Schema$AssistantApiCoreTypesGovernedDeviceConfig {
        /**
         * Pantheon Project ID that uniquely identifies the consumer project ID. Required
         */
        agentId?: string | null;
        /**
         * Unique identifier for the device. Example: DBCDW098234. Required
         */
        deviceId?: string | null;
    }
    /**
     * LINT.IfChange Specifies identifier of a device AKA surface. Note there may be multiple device ids for the same physical device E.g. Allo app and Assistant app on Nexus. Note: DeviceId usage is complicated. Please do not depend on it for surface specific logic. Please use google3/assistant/api/capabilities.proto instead. IMPORTANT: When checking for equality between two `DeviceId`s, you should always use an `isSameDevice{As\}` function to check for equality, as deep equality between `DeviceId`'s is not guaranteed. * C++: http://google3/assistant/assistant_server/util/device_id_util.cc;l=23;rcl=421295740 * Dart: http://google3/assistant/context/util/lib/device_id.dart;l=26;rcl=442126145 * Java: http://google3/java/com/google/assistant/assistantserver/utils/DeviceIdHelper.java;l=9;rcl=390378522 See http://go/deviceid-equality for more details. IMPORTANT: The definition of DeviceId proto is being moved to //assistant/api/core_types/device_type.proto. All existing references will be updated to point to the new location. If you are adding a reference, use the new one instead. Next ID: 14
     */
    export interface Schema$AssistantApiCoreTypesGovernedDeviceId {
        /**
         * The client_instance_id on devices with GSA. See 'client_instance_field' in go/androidids.
         */
        agsaClientInstanceId?: string | null;
        /**
         * Allo Id. Corresponds to the GBotRequest.Sender.sender. NOTE(dychen): This may change to standard android/ios physical device ids in order to enable shared data (e.g. installed app on physical device shared between Allo and Opa apps on Nexus).
         */
        alloDeviceId?: string | null;
        /**
         * A unique device ID for Assistant devices as proposed by go/ocelot-team to solve the device id fragmentation problem. The value of this id is the HomeGraph id of the device. See go/ocelot-track-0-registry-design. New surfaces should use the canonical_device_id instead of using other ids, and the registration should utilize the DeviceDataLayer (go/ddl-v0). Please contact the assistant-state-management@ team for guidance. Note: We didn't reuse |home_graph_device_id| because in Assistant code base |home_graph_device_id| is common to associate it with 3P devices. See go/project-yellowstone for more context.
         */
        canonicalDeviceId?: string | null;
        /**
         * If set, indicates that the device is a cast device, and contains the UUID of the cast device. Corresponds to the device_id field of the CastDevice proto.
         */
        castDeviceId?: string | null;
        /**
         * DUSI (go/dusi) is used as the identifier here. This identifier is unique to the user and device. This will help identify which device or application the user's request originated from. This is not to be confused with the client_instance_id that android devices provide. This is currently used by surfaces that use the assistant-legacy-nexus and assistant-legacy-clockwork pipelines. DUSI is created and set in S3. This field is only filled for GAIA requests.
         */
        clientInstanceId?: string | null;
        /**
         * A device ID produced by a connected dock, which is registered in HomeGraph.
         */
        connectedDockId?: string | null;
        /**
         * The unique DeviceConfig to the specific third party device. It is also used by Android Auto Embedded first party device. See go/opa-ids.
         */
        deviceConfig?: Schema$AssistantApiCoreTypesGovernedDeviceConfig;
        /**
         * DEPRECATED. assistant.api.core_types.governed.SurfaceIdentity.surface_type field should be used instead. The device's surface type. This is the string version of surface_type. The server should use the SurfaceType value derived from this string. If the device_type isn't supported within the SurfaceType enum, it will be set as UNKNOWN. Developers should use the enum in ServerParams instead of this string. WARNING: Clients are not actually setting this field. This field will be removed once references to it within the code base have been removed.
         */
        deviceType?: string | null;
        /**
         * The unique device ID for HomeGraph devices. This is the HomeGraph ID, created when the device is registered into HomeGraph. It is immutable for the same device unless it is completely deleted and recreated. See go/home-graph for details.
         */
        homeGraphDeviceId?: string | null;
        /**
         * The unique ID for libassistant based devices. See go/libassistant-id for details.
         */
        libassistantDeviceId?: string | null;
        /**
         * If set, indicates that the device is participating the multi-hotword arbitration and the id is an UUID to distinguish it from other devices. It should also be consistent between requests from a single device within a session (or short duration).
         */
        multiHotwordArbitrationDeviceId?: string | null;
        /**
         * The unique device ID for the Assistant App on iOS. See go/opa-ios-design for details.
         */
        opaIosDeviceId?: string | null;
        /**
         * The unique ID of a Quartz device. See go/quartz-design-doc for more details. Quartz ID is a hash of (android_id + gaia).
         */
        quartzDeviceId?: string | null;
    }
    /**
     * LINT.IfChange Task metadata information describing the ringtone. IMPORTANT: The definition of RingtoneTaskMetadata proto is being moved to //assistant/api/core_types/ringtone_task_metadata.proto. All existing references will be updated to point to the new location. If you are adding a reference, use the new one instead. Next id: 11
     */
    export interface Schema$AssistantApiCoreTypesGovernedRingtoneTaskMetadata {
        /**
         * The category related with the ringtone. It's used to generate ringtone related with the category if the entity_mid is not be populated. E.g. for instrument, the ringtone may be piano sound.
         */
        category?: string | null;
        characterAlarmMetadata?: Schema$AssistantApiCoreTypesGovernedRingtoneTaskMetadataCharacterAlarmMetadata;
        characterTag?: string | null;
        /**
         * The freebase mid of the entity related to the ringtone. It will be used to generate the ringtone for the alarm or timer (with support for i18n). For instance, for the "cat" mid, the related ringtone will be a cat sound in some language, and for the "Beyonce" mid, the ringtone will be, e.g., a playlist of Beyonce's best hits.
         */
        entityMid?: string | null;
        funtimeMetadata?: Schema$AssistantApiCoreTypesGovernedRingtoneTaskMetadataFuntimeMetadata;
        genMlAlarmMetadata?: Schema$AssistantApiCoreTypesGovernedRingtoneTaskMetadataGenMlAlarmMetadata;
        /**
         * Gentle wake information for this alarm.
         */
        gentleWakeInfo?: Schema$AssistantApiCoreTypesGovernedRingtoneTaskMetadataGentleWakeInfo;
        onDeviceAlarmMetadata?: Schema$AssistantApiCoreTypesGovernedRingtoneTaskMetadataOnDeviceAlarmMetadata;
        /**
         * Will be deprecated. Use OnDeviceAlarmMetadata.
         */
        onDeviceAlarmSound?: string | null;
        routineAlarmMetadata?: Schema$AssistantApiCoreTypesGovernedRingtoneTaskMetadataRoutineAlarmMetadata;
    }
    export interface Schema$AssistantApiCoreTypesGovernedRingtoneTaskMetadataCharacterAlarmMetadata {
        /**
         * For character alarm, the media resources are provided through AOG apps. During alarm trigger phase, aog apps with the specified agent_ids are used to get the media resources. Multiple "AoG agents" can satisfy a character_tag. So the user will select the agents they want at alarm creation time. The chosen agents will be recorded so that the resources only from those agents will be used at trigger time. The number of selected agent_ids will not exceed 3. See go/character-alarm-aog.
         */
        agentIds?: string[] | null;
        /**
         * The Character Alarm tag. Tags are needed to identify the theme of the alarm. For example, if the tag is 'astronaut', astronaut based audio is played during alarm ring. Note : We have made it repeated so that the user can choose multiple character alarm themes at one go. At present, the user is allowed to choose only one theme during alarm creation.
         */
        characterTags?: string[] | null;
        /**
         * Icons urls corresponding to a character. Note : We have made it repeated so that we can show different images when the alarm rings. At present, we only support only one image.
         */
        iconUrls?: string[] | null;
    }
    /**
     * Used to make timers and alarms more delightful. See go/funtime-engdesign for more details.
     */
    export interface Schema$AssistantApiCoreTypesGovernedRingtoneTaskMetadataFuntimeMetadata {
        /**
         * For FunTime alarms and timers, the media resources are provided through AOG apps during their ringtone. Multiple AoG agents can satisfy a label. So a random agent will be chosen from those that are supplied. See go/funtime-engdesign.
         */
        agentIds?: string[] | null;
        /**
         * These bytes may represent the blob of the Rive animation that we pass to the Opal App. We will deprecate this field if we figure out a solution to load the animation from the web.
         */
        animationBlob?: string | null;
        /**
         * Url for Rive animation that is brought up on ring. Rive is a lightweight animation library that is compatible with Flutter on Opal. See https://rive.app/.
         */
        animationUrl?: string | null;
        /**
         * The url used to load the image that is at the center of the timer during timer countdown visuals.
         */
        timerHeroUrl?: string | null;
        /**
         * This is used to call S3 to realize the TTS. Is in the form of bytes because of a circular dependency issue in libassistant protos. It is a serialized proto of type speech.s3.TtsServiceRequest.
         */
        ttsServiceRequestBytes?: string | null;
    }
    /**
     * Metadata for machine learning generated audio samples. This will be similar to character alarms, Category will be set MEDIA but this metadata field will be used to identify the ringtone type on surface. (go/magenta-alarm-ringtones).
     */
    export interface Schema$AssistantApiCoreTypesGovernedRingtoneTaskMetadataGenMlAlarmMetadata {
        isEnabled?: boolean | null;
        /**
         * Label for the generated ringtone.
         */
        ringtoneLabel?: string | null;
    }
    /**
     * Gentle wake actions like slowly brightening the room/device screen leading up to the alarm firing (go/cube-gentle-wake-up).
     */
    export interface Schema$AssistantApiCoreTypesGovernedRingtoneTaskMetadataGentleWakeInfo {
        /**
         * Specifies how long the effect lasts. Allowed for effect to last after the alarm has started ringing. If unset or negative or 0, effect is assumed to last until alarm trigger time.
         */
        effectDurationMs?: string | null;
        /**
         * Indicates if gentle wake action is to be performed before this alarm fires. This is enabled only if the device supports sunrise alarm capability. http://cs/symbol:assistant.api.SunriseFeaturesSupport
         */
        isEnabled?: boolean | null;
        /**
         * Specifies how long before the alarm fire time, the wakeup effect will start. ALWAYS POSITIVE.
         */
        startTimedeltaMs?: string | null;
    }
    /**
     * This describes the alarm sound resource enum and the alarm sound label for the on device alarm sound. On-device ringtones are product specific, hence Opal/UI layer will be responsible for populating this metadata at creation/edit. The enum map will be used to convert to an internal resource id used by libassistant for accessing the asset which are not exposed to UI.
     */
    export interface Schema$AssistantApiCoreTypesGovernedRingtoneTaskMetadataOnDeviceAlarmMetadata {
        /**
         * Opal/UI layer will set this bit based on the user selection.
         */
        onDeviceAlarmSound?: string | null;
        /**
         * A string label to identify the alarm sound name. Opal/UI layer will set this as per product definition. This will be used to display the name of the selected ringtone.
         */
        onDeviceAlarmSoundLabel?: string | null;
        /**
         * This is used to call S3 to realize the TTS. Is in the form of bytes because of a circular dependency issue in libassistant protos. It is a serialized proto of type speech.s3.TtsServiceRequest. This request will contain an ssml with the url to the ringtone files hosted on gstatic.
         */
        ttsServiceRequestBytes?: string | null;
    }
    export interface Schema$AssistantApiCoreTypesGovernedRingtoneTaskMetadataRoutineAlarmMetadata {
        /**
         * The unique id for each routine. When the alrm is dismissed, it will trigger the routine of the routine alarm's creator if feasible.
         */
        routineId?: string | null;
    }
    /**
     * The set of information that helps the server identify the surface. This replaces the User-Agent string within the Assistant Server. Note: The SurfaceIdentity proto should only be used to derive the capabilities of a surface. It should not be accessed outside of the CapabilityBuilder or CapabilityChecker. IMPORTANT: The partial migration to the SurfaceIdentity and SurfaceVersion protos defined here is being rolled back (b/303012824). All existing references will be updated to point back to //assistant/api/core_types/surface_identity.proto. If you are adding a reference, use the SurfaceIdentity and SurfaceVersion protos defined there. NEXT ID: 6 LINT.IfChange
     */
    export interface Schema$AssistantApiCoreTypesGovernedSurfaceIdentity {
        /**
         * The identifier of the device.
         */
        deviceId?: Schema$AssistantApiCoreTypesDeviceId;
        /**
         * DEPRECATED: The legacy device's surface type enum. NOTE: Prefer using the ontological `surface_type` field above. If you need to access the legacy surface type, please file a bug and add it in your code to migrate to ontological surface type.
         */
        legacySurfaceType?: string | null;
        /**
         * The device's surface type. The types are defined at google3/assistant/api/core_types/surfaces.gcl.
         */
        surfaceType?: string | null;
        /**
         * The version of the surface/client. This is different from the Conversation protocol version.
         */
        surfaceVersion?: Schema$AssistantApiCoreTypesGovernedSurfaceVersion;
    }
    /**
     * The version of the surface/client. New surfaces are encouraged to only use the “major” field to keep track of version number. The “minor” field may be used for surfaces that rely on both the “major” and “minor” fields to define their version.
     */
    export interface Schema$AssistantApiCoreTypesGovernedSurfaceVersion {
        major?: number | null;
        minor?: number | null;
    }
    /**
     * The Home app information of the provider. Next ID: 3
     */
    export interface Schema$AssistantApiCoreTypesHomeAppInfo {
        /**
         * The localized app name.
         */
        localizedAppName?: string | null;
        /**
         * Unique package name that identifies a Home app of the provider.
         */
        packageName?: string | null;
    }
    /**
     * An image represents the data about an image or a photo. LINT.IfChange NextId: 13
     */
    export interface Schema$AssistantApiCoreTypesImage {
        /**
         * A text description of the image to be used for accessibility, e.g. screen readers.
         */
        accessibilityText?: string | null;
        /**
         * App identifier. This field is specific to mobile surfaces and stands for app package name for Android surface, and app bundle identifier for iOS. In case identifier is specified but invalid, some default icon will be used, e.g. PackageManager.getDefaultActivityIcon() for Android. If you want to show image for AGSA versions which don't support this field, you can specify source_url as backup.
         */
        appIconIdentifier?: string | null;
        /**
         * This is the image that is displayed as the badge on the main image.
         */
        badgeImage?: Schema$AssistantApiCoreTypesImage;
        /**
         * Content of the image in bytes.
         */
        content?: string | null;
        height?: number | null;
        /**
         * Indicate the data source where the image is fetched.
         */
        imageSource?: string | null;
        /**
         * Content of image in form of JSON representation.
         */
        jsonContent?: string | null;
        /**
         * Text used to generate a letter drawable (a letter icon with color). It will be the default icon if the source_url is empty or cannot be rendered.
         */
        letterDrawableText?: string | null;
        /**
         * Url of the image provider, which is the website containing the image. For example, https://www.agentx.com.
         */
        providerUrl?: string | null;
        /**
         * The source url of the image. For example, https://www.agentx.com/logo.png
         */
        sourceUrl?: string | null;
        /**
         * Type of the source url.
         */
        sourceUrlType?: string | null;
        /**
         * The width and height of the image in pixels.
         */
        width?: number | null;
    }
    /**
     * Info for targeting a feature provided directly by the Assistant surface itself. i.e Could be pointing to AGSA audio player for AUDIO_PLAYER on AGSA.
     */
    export interface Schema$AssistantApiCoreTypesInternalProviderInfo {
        /**
         * Specifying which type of internal provider.
         */
        type?: string | null;
    }
    /**
     * The iOS app information of the provider. Next ID: 4
     */
    export interface Schema$AssistantApiCoreTypesIosAppInfo {
        /**
         * Bundle identifier that identifies an iOS app of the provider.
         */
        bundleIdentifier?: string | null;
        /**
         * The localized app name.
         */
        localizedAppName?: string | null;
        /**
         * A URL to open the provider's app.
         */
        openAppUrl?: string | null;
    }
    /**
     * The KaiOS app information of the provider. Next ID: 4
     */
    export interface Schema$AssistantApiCoreTypesKaiOsAppInfo {
        /**
         * The localized app name.
         */
        localizedAppName?: string | null;
        /**
         * A URL to open the provider's app.
         */
        openAppUrl?: string | null;
        /**
         * Unique package name that identifies a KaiOS app of the provider.
         */
        packageName?: string | null;
    }
    /**
     * Geographic coordinate information for location.
     */
    export interface Schema$AssistantApiCoreTypesLocationCoordinates {
        /**
         * The accuracy of the coordinates in meters.
         */
        accuracyMeters?: number | null;
        /**
         * Latitude degrees.
         */
        latDegrees?: number | null;
        /**
         * Longitude degrees.
         */
        lngDegrees?: number | null;
    }
    /**
     * LINT.IfChange(ungoverned_message_notification) This proto captures the contents of a messaging app notification that is typically part of a conversation thread. Next Id: 21
     */
    export interface Schema$AssistantApiCoreTypesMessageNotification {
        /**
         * App name of the message notification, e.g. Hangouts.
         */
        appName?: string | null;
        /**
         * The key used to group this notification into a cluster.
         */
        bundleId?: string | null;
        /**
         * Uri for the attachment (image, audio, video etc.).
         */
        dataUri?: string | null;
        /**
         * The group key of a proactive notification. Details in assistant.api.client_op.NotificationArgs.grouping_key.
         */
        groupingKey?: string | null;
        /**
         * Name of the group associated with the message notification. This field is set iff this is a group message.
         */
        groupName?: string | null;
        /**
         * Index of the message notification.
         */
        index?: number | null;
        /**
         * Boolean indicating if the mark_as_read action is available for this message.
         */
        markAsReadActionAvailable?: boolean | null;
        /**
         * Length of the message/notification content in characters. Note: We can't send the full content because of privacy restriction, preventing sending client content to our backends. Concatenated message_length of all notification_entries.
         */
        messageLength?: number | null;
        messageRecipientType?: string | null;
        /**
         * Word count of the message
         */
        messageWordCount?: number | null;
        /**
         * Mime type of the data_uri. e.g. 'audio/wav', 'video/mp4', 'image/png'.
         */
        mimeType?: string | null;
        notificationEntries?: Schema$AssistantApiCoreTypesMessageNotificationNotificationEntry[];
        /**
         * On-device cache key for notification icon.
         */
        notificationIconKey?: string | null;
        /**
         * String key of the notification. It is the key from original StatusBarNotification received from Android OS. It is used to identify the original notification to send a reply.
         */
        notificationKey?: string | null;
        /**
         * The opaque_token of a proactive notification. Details in assistant.api.client_op.NotificationArgs.opaque_token.
         */
        opaqueToken?: string | null;
        /**
         * App pkg of the message notification, e.g. "com.google.android.talk".
         */
        packageName?: string | null;
        /**
         * Timestamp of the last notification's post time.
         */
        postTime?: string | null;
        /**
         * Boolean indicating if the reply action is available for this message.
         */
        replyActionAvailable?: boolean | null;
        sender?: Schema$AssistantApiCoreTypesMessageNotificationPerson;
        /**
         * Sender's name of the message notification, e.g. Elsa. Last sender name in case of a group conversation.
         */
        senderName?: string | null;
    }
    /**
     * Structure of each notification in the MessageNotification Bundle. Attribute sender_name could be different in case of group messages. Next Id: 8
     */
    export interface Schema$AssistantApiCoreTypesMessageNotificationNotificationEntry {
        /**
         * Count of characters in the message body in the notification.
         */
        charCount?: number | null;
        /**
         * Uri for the attachment (image, audio, video etc.).
         */
        dataUri?: string | null;
        /**
         * Note that this is not present in production traffic. Content of the message body in the notification.
         */
        messageBody?: string | null;
        /**
         * Mime type of the data_uri. e.g. 'audio/wav', 'video/mp4', 'image/png'.
         */
        mimeType?: string | null;
        /**
         * Timestamp of the notification's post time.
         */
        postTime?: string | null;
        /**
         * Sender of the message notification.
         */
        sender?: Schema$AssistantApiCoreTypesMessageNotificationPerson;
        /**
         * Count of words in the message body in the notification.
         */
        wordCount?: number | null;
    }
    /**
     * Mirrors part of https://developer.android.com/reference/android/app/Person Next Id: 4
     */
    export interface Schema$AssistantApiCoreTypesMessageNotificationPerson {
        isImportant?: boolean | null;
        key?: string | null;
        name?: string | null;
    }
    /**
     * Provider. Like, Spotify or iHeartRadio. Next ID: 13
     */
    export interface Schema$AssistantApiCoreTypesProvider {
        /**
         * The android app information of the provider.
         */
        androidAppInfo?: Schema$AssistantApiCoreTypesAndroidAppInfo;
        /**
         * The cast app information of the provider.
         */
        castAppInfo?: Schema$AssistantApiCoreTypesCastAppInfo;
        /**
         * The ChromeOS app information of the provider.
         */
        chromeosAppInfo?: Schema$AssistantApiCoreTypesChromeOsAppInfo;
        /**
         * The third party provider information.
         */
        cloudProviderInfo?: Schema$AssistantApiCoreTypesCloudProviderInfo;
        /**
         * A URL to fallback to if app can not be opened.
         */
        fallbackUrl?: string | null;
        homeAppInfo?: Schema$AssistantApiCoreTypesHomeAppInfo;
        /**
         * Public URL pointing to an icon image for the provider. e.g. https://lh3.googleusercontent.com/UrY7BAZ-XfXGpfkeWg0zCCeo-7ras4DCoRalC_WXXWTK9q5b0Iw7B0YQMsVxZaNB7DM
         */
        iconImageUrl?: string | null;
        /**
         * The internal assistant provider information.
         */
        internalProviderInfo?: Schema$AssistantApiCoreTypesInternalProviderInfo;
        /**
         * The iOS app information of the provider.
         */
        iosAppInfo?: Schema$AssistantApiCoreTypesIosAppInfo;
        /**
         * The KaiOS app information of the provider.
         */
        kaiosAppInfo?: Schema$AssistantApiCoreTypesKaiOsAppInfo;
        /**
         * The sip information of the provider.
         */
        sipProviderInfo?: Schema$AssistantApiCoreTypesSipProviderInfo;
        /**
         * The web provider information.
         */
        webProviderInfo?: Schema$AssistantApiCoreTypesWebProviderInfo;
    }
    /**
     * ProviderDelta. The incremental change, e.g. installation or deletion for Spotify or iHeartRadio. Currently it is for Android only. A few considerations for edge cases: - If the app being deleted is not found from Footprints, it is ignored. - For Footprint upload through Geller, the gPRC response is available for client to retry in the next upload if the upload fails. - For Assistant Request, there is no upload status similar to the current AppCapabilities. Next ID: 4
     */
    export interface Schema$AssistantApiCoreTypesProviderDelta {
        /**
         * The android app information of the provider.
         */
        androidAppInfoDelta?: Schema$AssistantApiCoreTypesAndroidAppInfoDelta;
        /**
         * A URL to fallback to if app can not be opened.
         */
        fallbackUrl?: string | null;
        /**
         * Public URL pointing to an icon image for the provider. e.g. https://lh3.googleusercontent.com/UrY7BAZ-XfXGpfkeWg0zCCeo-7ras4DCoRalC_WXXWTK9q5b0Iw7B0YQMsVxZaNB7DM
         */
        iconImageUrl?: string | null;
    }
    /**
     * Session Initiation Protocol (SIP) information for providers that use SIP to initiate multimedia communication sessions, like Google Voice and Fi. https://en.wikipedia.org/wiki/Session_Initiation_Protocol
     */
    export interface Schema$AssistantApiCoreTypesSipProviderInfo {
        /**
         * The providers id (MID) which is the primary identifier for a call provider within the Assistant. A MID, or machine identifier, is a unique identifier issued by Knowledge Graph for all entities contained in it's graph.
         */
        providerId?: string | null;
        /**
         * Calling realm to be use for each call. i.e. For anonymous, this would be set to anonymous.chirp.google.com
         */
        realm?: string | null;
        /**
         * If true, client should use the Birdsong TaCL API for this call. Uses the VoiceCallManager API by default. For more details: go/birdsong-migration-google-home
         */
        useBirdsongTacl?: boolean | null;
    }
    /**
     * The set of information that helps the server identify the surface. This replaces the User-Agent string within the Assistant Server. Note: The SurfaceIdentity proto should only be used to derive the capabilities of a surface. It should not be accessed outside of the CapabilityBuilder or CapabilityChecker. NEXT ID: 6 LINT.IfChange
     */
    export interface Schema$AssistantApiCoreTypesSurfaceIdentity {
        /**
         * The identifier of the device.
         */
        deviceId?: Schema$AssistantApiCoreTypesDeviceId;
        /**
         * DEPRECATED: The legacy device's surface type enum. NOTE: Prefer using the ontological `surface_type` field above. If you need to access the legacy surface type, please file a bug and add it in your code to migrate to ontological surface type.
         */
        legacySurfaceType?: string | null;
        /**
         * The device's surface type. The types are defined at google3/assistant/api/core_types/surfaces.gcl. For more details, refer to go/ontologicalize-surface-type.
         */
        surfaceType?: string | null;
        /**
         * DEPRECATED. The legacy device's surface type string. NOTE: Prefer using the ontological `surface_type` field. The device's surface type. This is the string version of the assistant.api.core_types.SurfaceType enum. The server should not use this field, rather it should use the SurfaceType value derived from this string.
         */
        surfaceTypeString?: string | null;
        /**
         * The version of the surface/client. This is different from the Conversation protocol version.
         */
        surfaceVersion?: Schema$AssistantApiCoreTypesSurfaceVersion;
    }
    /**
     * Specifies the types of device surfaces. LINT.IfChange When adding new surface types make sure that My Activity (https://myactivity.google.com/product/assistant) will correctly render by adding your enum to http://cs/symbol:GetAssistSurfaceName%20f:%5C.cc$ If your type doesn't fit in to any of the existing surfaces messages, add a new message in http://google3/personalization/footprints/boq/uservisible/events/intl/smh_frontend_messages.h.
     */
    export interface Schema$AssistantApiCoreTypesSurfaceType {
        type?: string | null;
    }
    /**
     * The version of the surface/client. New surfaces are encouraged to only use the “major” field to keep track of version number. The “minor” field may be used for surfaces that rely on both the “major” and “minor” fields to define their version.
     */
    export interface Schema$AssistantApiCoreTypesSurfaceVersion {
        major?: number | null;
        minor?: number | null;
    }
    /**
     * The web information of the provider. Next ID: 5
     */
    export interface Schema$AssistantApiCoreTypesWebProviderInfo {
        /**
         * Serialized storage (context) persisted and retrieved for the app and home.
         */
        homeStorage?: string | null;
        /**
         * The localized app name.
         */
        localizedAppName?: string | null;
        /**
         * A URL to open the provider's app.
         */
        openAppUrl?: string | null;
        /**
         * Info about 3P Custom NLU used in this web provider. TODO(b/321644453) remove when QRewrite is able to call SERoot.
         */
        thirdPartyCustomNluInfo?: Schema$AssistantApiCoreTypesWebProviderInfoThirdPartyCustomNluInfo;
    }
    export interface Schema$AssistantApiCoreTypesWebProviderInfoThirdPartyCustomNluInfo {
        /**
         * The locale of this agent version, represented by BCP-47 language strings, such as "en", "en-US", "fr", "fr-CA", "sr-Latn", "zh-Hans-CN", etc.
         */
        locale?: string | null;
        /**
         * Unique internal identifier of 3P Custom NLU agent. UUID.
         */
        nluAgentId?: string | null;
        /**
         * Identifies the 3P Custom NLU agent version.
         */
        nluAgentVersion?: string | null;
    }
    export interface Schema$AssistantApiCrossDeviceExecutionCapability {
        /**
         * Whether the device has torus/usonia capabililities enabled or not.
         */
        localConnectivityEnabled?: boolean | null;
        /**
         * Whether the device supports cast media originated from a remote device to be executed through local execution and can upload results asynchronously. Needs to be checked before sending remote media initiation through local channel since it needs an async result upload path.
         */
        remoteCastMediaEnabled?: boolean | null;
    }
    export interface Schema$AssistantApiDataValidateCapabilities {
        /**
         * If true, data.VALIDATE should be routed to the tethered device (if present) if the tethered device supports data.VALIDATE and the primary device does not.
         */
        fallbackToTetheredDevice?: boolean | null;
    }
    /**
     * A Gregorian calendar date.
     */
    export interface Schema$AssistantApiDate {
        /**
         * The day, in 1...31.
         */
        day?: number | null;
        /**
         * The month, in 1...12.
         */
        month?: number | null;
        /**
         * The year, e.g. 2016.
         */
        year?: number | null;
    }
    /**
     * A date-time specification, combining a date and civil time (relative to a given timezone).
     */
    export interface Schema$AssistantApiDateTime {
        /**
         * A Gregorian calendar date.
         */
        date?: Schema$AssistantApiDate;
        /**
         * A civil time relative to a timezone.
         */
        timeOfDay?: Schema$AssistantApiTimeOfDay;
        /**
         * A time zone in IANA format.
         */
        timeZone?: Schema$AssistantApiTimeZone;
    }
    /**
     * A representation of a range of time with start and end datetime specified.
     */
    export interface Schema$AssistantApiDateTimeRange {
        /**
         * End date of the range.
         */
        endDate?: Schema$AssistantApiDateTime;
        /**
         * Start date of the range.
         */
        startDate?: Schema$AssistantApiDateTime;
    }
    /**
     * This message describes roughly what a surface is capable of doing and metadata around those capabilities. These capabilities are determined based on: - device hardware - software - status (e.g. volume level, battery percentage) These capabilities refer to the surface and not the physical device. The list of supported surfaces can be found in the assistant.api.core_types.SurfaceType enum. A surface's capabilities can differ from the device's. An example would be ANDROID_ALLO running on Pixel. Allo does not support AudioInput while the Pixel does. In this case, audio_input will be set to false for Assistant Allo requests while it might be set to true for OPA_NEXUS requests. Next ID: 37
     */
    export interface Schema$AssistantApiDeviceCapabilities {
        /**
         * Capabilites related to Android intent support.
         */
        androidIntentCapabilities?: Schema$AssistantApiAndroidIntentCapabilities;
        /**
         * Capabilities if surface supports Google Assistant.
         */
        assistantCapability?: string | null;
        /**
         * These capabilities are scoped to the ability to gather audio. It includes information like the type of audio that can be gathered (e.g. public, private).
         */
        audioInput?: Schema$AssistantApiAudioInput;
        /**
         * These capabilities are scoped to the ability to play audio. It includes information like the type of audio that can be played (e.g. public, private).
         */
        audioOutput?: Schema$AssistantApiAudioOutput;
        /**
         * Bluetooth capabilities related to usage of a feature.
         */
        bluetoothCapabilities?: Schema$AssistantApiBluetoothCapabilities;
        /**
         * The call capabilities of this device. go/call-capabilities
         */
        callCapabilities?: Schema$AssistantApiCallCapabilities;
        /**
         * These capabilities are scoped to the camera abilities of this device.
         */
        camera?: Schema$AssistantApiCameraCapabilities;
        /**
         * UX restrictions for Auto.
         */
        carUxRestrictions?: string[] | null;
        /**
         * These capabilities are scoped to the cast abilities of this device.
         */
        cast?: Schema$AssistantApiCastCapabilities;
        communicationUiCapabilities?: Schema$AssistantApiCommunicationUiCapabilities;
        contactLookupCapabilities?: Schema$AssistantApiContactLookupCapabilities;
        dataValidateCapabilities?: Schema$AssistantApiDataValidateCapabilities;
        /**
         * This is the same device id that is specified in the conversation protocol and should be unique to each device/user/model combination. For example, if a request is coming from a watch through AGSA the watch and AGSA should have different device_ids. Note: this field should only be used to determine which device the capabilities belong to and not to access the id of the device. Instead DeviceProperties should be used and accessed through ParamsAccessor.
         */
        deviceId?: Schema$AssistantApiCoreTypesDeviceId;
        /**
         * Capabilities related to Android tablet UX experience.
         */
        deviceUxMode?: string | null;
        /**
         * Indicates that the device has connection to cellular network that allows it to make voice calls. This is distinct from device just being capable of voice telephony, because the device can be capable yet miss the suitable SIM card (for example, it could miss SIM card altogether, or have data-only SIM card).
         */
        hasVoiceTelephony?: boolean | null;
        /**
         * Indicates if the client supports Javascript Whatsnext (go/jwn). Also contains the Jwn libraries present on the client along with their versions.
         */
        jwnCapabilities?: Schema$AssistantApiJwnCapabilities;
        /**
         * Capabilities related to Lens Perception, i.e. image understanding. See go/lens-perception-sdk.
         */
        lensPerceptionCapabilities?: Schema$AssistantApiLensPerceptionCapabilities;
        /**
         * These capabilities are scoped to the location abilities of this device.
         */
        location?: Schema$AssistantApiLocationCapabilities;
        /**
         * Data which is produced for logging and debugging. Servers MUST NOT use this for any other purposes, such as branching on it.
         */
        loggingOnlyData?: Schema$AssistantApiLoggingOnlyData;
        messageCapabilities?: Schema$AssistantApiMessageCapabilities;
        /**
         * These capabilities are scoped to abilities of the device to move around.
         */
        movement?: Schema$AssistantApiMovementCapabilities;
        /**
         * DEPRECATED: Use SystemNotificationRestrictions instead. Specifies whether the surface is able to display notifications. This field is superficially similar to ProactiveNotificationOutput, but unlike that field which tracks a per-user preference on the OPA side, this field captures whether the surface is capable of displaying notifications.
         */
        notificationCapabilities?: string | null;
        /**
         * Settings, that reflect whether a specific notification type is allowed for current device, e.g. if the user opted out from notification category or category group. This settings are server-side stored and evaluated unlike SystemNotificationRestrictions field.
         */
        notificationOutputRestrictions?: Schema$AssistantApiNotificationOutputRestrictions;
        /**
         * These are user configured restrictions indicating what the device is allowed to output from the privacy point of view.
         */
        outputRestrictions?: Schema$AssistantApiOutputRestrictions;
        /**
         * Capability to support Pop on lockscreen.
         */
        popOnLockscreenCapability?: string | null;
        /**
         * Indicates if the client has safety related restriction.
         */
        safetyRestrictions?: string | null;
        /**
         * These capabilities are scoped to the ability to see and interact with the Assistant through a screen. If the device has no screen it should send an empty ScreenCapabilities. Sending no ScreenCapabilities will cause this to be overridden with the surface default.
         */
        screen?: Schema$AssistantApiScreenCapabilities;
        /**
         * Capabilities related to SODA (Speech On-Device API).
         */
        sodaCapabilities?: Schema$AssistantApiSodaCapabilities;
        /**
         * These capabilities are scoped to the software available on the device as well as the set of supported Assistant features.
         */
        software?: Schema$AssistantApiSoftwareCapabilities;
        /**
         * DEPRECATED Capabilities related to speech detection on devices.
         */
        speechCapabilities?: Schema$AssistantApiSpeechCapabilities;
        /**
         * Locales supported by assistant settings for speaking and display. This is independent from device language that is defined in device setting. New locales are added based on rollout, whitelist and app version releases because older versions does not have model support. Currently supported locale list differs by surface type.
         */
        supportedLocale?: string[] | null;
        /**
         * The set of information that helps the server identify the surface.
         */
        surfaceIdentity?: Schema$AssistantApiCoreTypesSurfaceIdentity;
        /**
         * DEPRECATED. surface_identity field below already contains this information. The device's surface type. This is the string version of the assistant.api.core_types.SurfaceType enum. The server should not use this field, rather it should use the SurfaceType value derived from this string.
         */
        surfaceTypeString?: string | null;
        /**
         * Restrictions related to system-level notifications. This field is superficially similar to ProactiveNotificationOutput, but unlike that field which tracks a per-user preference on the OPA side, this field captures system level notifications restrictions. This field is not stored and is merged to capabilities from conversation params. It exists mostly for logging purposes of android channel state and global app-level notification opt out.
         */
        systemNotificationRestrictions?: Schema$AssistantApiSystemNotificationRestrictions;
        /**
         * Capabilities related to third party integration.
         */
        thirdPartyCapabilities?: Schema$AssistantApiThirdPartyCapabilities;
    }
    /**
     * A Duration represents a signed, fixed-length span of time represented as a count of seconds and fractions of seconds at nanosecond resolution. It is independent of any calendar and concepts like "day" or "month". It is related to Timestamp in that the difference between two Timestamp values is a Duration and it can be added or subtracted from a Timestamp. Range is approximately +-10,000 years.
     */
    export interface Schema$AssistantApiDuration {
        /**
         * Signed fractions of a second at nanosecond resolution of the span of time. Durations less than one second are represented with a 0 `seconds` field and a positive or negative `nanos` field. For durations of one second or more, a non-zero value for the `nanos` field must be of the same sign as the `seconds` field. Must be from -999,999,999 to +999,999,999 inclusive.
         */
        nanos?: number | null;
        /**
         * Signed seconds of the span of time. Must be from -315,576,000,000 to +315,576,000,000 inclusive.
         */
        seconds?: string | null;
    }
    export interface Schema$AssistantApiFeatureSpecificActionSupport {
        /**
         * Whether client supports clarification suggestion chip to be displayed see |assistant.suggestions.ClarificationData|
         */
        clarificationDataSupported?: boolean | null;
    }
    export interface Schema$AssistantApiFitnessFeatureSupport {
        /**
         * A list of fitness activity types supported by this client.
         */
        supportedActivities?: string[] | null;
    }
    export interface Schema$AssistantApiFluidActionsSupport {
        /**
         * Specifies the params proto that Fluid Actions uses to sync state with server.
         */
        stateSyncMethod?: string | null;
    }
    /**
     * Capabilities of Google assistant conversation service(GACS) devices. These capabilites including supported GACS actions and response size limitations.
     */
    export interface Schema$AssistantApiGacsCapabilities {
        /**
         * DeviceId of the accessory device (eg. watch) Commonly the go/dusi (eg. client_instance_id) is provided.
         */
        deviceId?: Schema$AssistantApiCoreTypesDeviceId;
        /**
         * Configuration sent by device.
         */
        responseConfig?: Schema$GoogleAssistantAccessoryV1ResponseConfig;
        /**
         * DEPRECATED: Format of TTS audio requested by the device.
         */
        ttsEncoding?: string | null;
    }
    /**
     * Capabilities related to GCM.
     */
    export interface Schema$AssistantApiGcmCapabilities {
        /**
         * GCM registration id for the device. Used to pass messages to the device.
         */
        gcmRegistrationId?: string | null;
        /**
         * Assistant supports GCM on the device. ClientOps can be sent to it over GCM and will be executed.
         */
        supportsAssistantGcm?: boolean | null;
        /**
         * If it is set to true, then it indicates to server that device is capable of receiving a GCM payload with serialized client input. The client input will be sent back to Assistant Server over conversation protocol.
         */
        supportsClientInputOverGcm?: boolean | null;
    }
    /**
     * The gesture capabilities related to Selina. Next ID: 4
     */
    export interface Schema$AssistantApiGestureCapabilities {
        /**
         * Whether Gesture is supported. When false, override the value for tap and omniswipe.
         */
        gestureSensing?: boolean | null;
        /**
         * Whether omniswipe is supported
         */
        omniswipeGestureCapable?: boolean | null;
        /**
         * Whether tap is supported
         */
        tapGestureCapable?: boolean | null;
    }
    /**
     * Access settings for guests.
     */
    export interface Schema$AssistantApiGuestAccessOutput {
        guestAccessOnYoutube?: string | null;
    }
    export interface Schema$AssistantApiImmersiveCanvasSupport {
        /**
         * Whether the client supports confirmation messages in Immersive Canvas actions.
         */
        confirmationMessageSupported?: boolean | null;
        /**
         * Whether the client support canvas pause signal. If true, the Assistant Server will send a signal when canvas transitioning to pause mode.
         */
        pauseSignalSupported?: boolean | null;
    }
    /**
     * These capabilities are used to determine the jwn libraries and their versions that are present on the client.
     */
    export interface Schema$AssistantApiJwnCapabilities {
        /**
         * The name and version of the jwn libraries currently stored on the client. These are the same that the server communicated when the library was first sent down.
         */
        librariesVersionMap?: {
            [key: string]: string;
        } | null;
        /**
         * Compression algorithms supported on the client. Server can choose one of these to compress WhatsNext Javascript programs and libraries.
         */
        supportedCompressionMode?: string[] | null;
        /**
         * Whether the client supports running jwn code.
         */
        supportsJwn?: boolean | null;
    }
    /**
     * Capabilities related to Lens Perception, i.e. image understanding. See go/loa-lens-device-capabilities. Next ID: 6
     */
    export interface Schema$AssistantApiLensPerceptionCapabilities {
        /**
         * Whether the device supports Lens Perception.
         */
        hasLensPerception?: boolean | null;
        /**
         * Indicates whether Lens supports Lens Direct Intent (go/lensdirectintent).
         */
        isLensDirectIntentAvailable?: boolean | null;
        /**
         * Indicates whether Lens supports Live view-finder experience.
         */
        isLensLiveViewfinderAvailable?: boolean | null;
        /**
         * Indicates whether Lens supports Post-capture experience with an image payload.
         */
        isLensPostCaptureAvailable?: boolean | null;
        /**
         * Contains the capabilities that Lens can support.
         */
        lensCapabilities?: Schema$AssistantApiLensPerceptionCapabilitiesLensCapabilities;
    }
    /**
     * The set of capabilities that Lens can support. This is the Assistant proto representation of Lens capabilities defined at j/c/g/android/apps/gsa/search/shared/service/proto/lens_service_event.proto Next ID: 7
     */
    export interface Schema$AssistantApiLensPerceptionCapabilitiesLensCapabilities {
        /**
         * The presence of this message means that Dining is supported.
         */
        dining?: Schema$AssistantApiLensPerceptionCapabilitiesLensCapabilitiesDining;
        /**
         * The presence of this message means that Education is supported.
         */
        education?: Schema$AssistantApiLensPerceptionCapabilitiesLensCapabilitiesEducation;
        /**
         * The presence of this message means that Outdoor is supported.
         */
        outdoor?: Schema$AssistantApiLensPerceptionCapabilitiesLensCapabilitiesOutdoor;
        /**
         * The presence of this message means that Shopping is supported.
         */
        shopping?: Schema$AssistantApiLensPerceptionCapabilitiesLensCapabilitiesShopping;
        /**
         * The presence of this message means that intenting directly into the text filter is supported.
         */
        text?: Schema$AssistantApiLensPerceptionCapabilitiesLensCapabilitiesText;
        /**
         * The presence of this message means that Translation is supported.
         */
        translate?: Schema$AssistantApiLensPerceptionCapabilitiesLensCapabilitiesTranslate;
    }
    /**
     * Dining recognition capability. For example popular dishes on a given restaurant menu image.
     */
    export interface Schema$AssistantApiLensPerceptionCapabilitiesLensCapabilitiesDining {
    }
    /**
     * Education recognition capability.
     */
    export interface Schema$AssistantApiLensPerceptionCapabilitiesLensCapabilitiesEducation {
    }
    /**
     * Outdoor place recognition capability. For example recognizing storefronts.
     */
    export interface Schema$AssistantApiLensPerceptionCapabilitiesLensCapabilitiesOutdoor {
    }
    /**
     * Shopping recognition capability.
     */
    export interface Schema$AssistantApiLensPerceptionCapabilitiesLensCapabilitiesShopping {
    }
    /**
     * Text recognition capability.
     */
    export interface Schema$AssistantApiLensPerceptionCapabilitiesLensCapabilitiesText {
        /**
         * Indicates whether text-to-speech is supported.
         */
        isTextToSpeechSupported?: boolean | null;
    }
    /**
     * Translation capability.
     */
    export interface Schema$AssistantApiLensPerceptionCapabilitiesLensCapabilitiesTranslate {
        /**
         * The list of language IETF BCP 47 tags that are supported. See the full details in the comment on the equivalent field in: http://google3/java/com/google/android/apps/gsa/search/shared/service/proto/lens_service_event.proto;l=55;rcl=355512559
         */
        supportedLanguageTags?: string[] | null;
    }
    export interface Schema$AssistantApiLiveTvChannelCapabilities {
        /**
         * A list of channel providers each of which provides a list of its channels.
         */
        channelsByProvider?: Schema$AssistantApiLiveTvChannelCapabilitiesChannelsByProvider[];
    }
    export interface Schema$AssistantApiLiveTvChannelCapabilitiesChannelsByProvider {
        /**
         * A list of channels provided by this input. Keep the performance impact in mind when the number/size of the channels is large. When there are too many channels, consider stripping out some data.
         */
        channels?: Schema$AssistantApiLiveTvChannelCapabilitiesLiveTvChannel[];
        /**
         * An identifier to identify the input source. For example for TIF based channels, this will be the TIF input ID to differentiate different tuner apps. See https://source.android.com/devices/tv
         */
        inputId?: string | null;
        /**
         * Type of provider who provides this channel input.
         */
        providerType?: string | null;
    }
    export interface Schema$AssistantApiLiveTvChannelCapabilitiesLiveTvChannel {
        /**
         * Unique channel identifier.
         */
        channelId?: string | null;
        /**
         * A list of channel names and synonyms.
         */
        channelName?: string[] | null;
        /**
         * Channel number displayed to user. Optional.
         */
        channelNumber?: string | null;
        /**
         * A deep link into the Live player app that tunes to this channel.
         */
        deeplink?: string | null;
        /**
         * KG mid of the channel if it exists in KG.
         */
        mid?: string | null;
        /**
         * Network KG mid of the channel if it exists in KG
         */
        networkMid?: string | null;
    }
    export interface Schema$AssistantApiLiveTvProvider {
        /**
         * Contains detailed provider information such as android app package name.
         */
        providerInfo?: Schema$AssistantApiCoreTypesProvider;
        /**
         * A provider enum string for OTT providers. The available key can be found in go/ump-provider-enum For Tuner provider, the provider key would be an ID the tuner app uploaded from TIF. See https://source.android.com/devices/tv
         */
        providerKey?: string | null;
        providerType?: string | null;
    }
    export interface Schema$AssistantApiLocationCapabilities {
        gpsAvailable?: boolean | null;
    }
    /**
     * Data which is produced for logging and debugging. Servers MUST NOT use this for any other purposes, such as branching on it. Next ID: 16
     */
    export interface Schema$AssistantApiLoggingOnlyData {
        /**
         * A user-readable string describing the ACP version (go/acp-version) of the client app used by the user to originate the conversation.
         */
        acpVersion?: string | null;
        /**
         * Random identifier assigned to Android mobile devices. Older logs may have previously stored other kinds of android IDs in this field, but all current logs should use the GServices Id. See go/androidids.
         */
        androidId?: string | null;
        /**
         * A user-readable string describing the version of the client app used by the user to originate the conversation.
         */
        appVersion?: string | null;
        /**
         * An enum specifying when was this ATV AssistantSettings entry initially created.
         */
        assistantSettingsSource?: string | null;
        /**
         * The type of board used by manufacturer for this device
         */
        boardName?: string | null;
        /**
         * The revision of board used
         */
        boardRevision?: string | null;
        /**
         * This field records the linking status between Assistant setting entry and Cast setting entry. Currently only ATV surface populates this field for profiling purpose.
         */
        castAssistantSettingLinkingResult?: Schema$AssistantApiCastAssistantSettingLinkingResult;
        /**
         * A user-readable string describing the device's hardware platform.
         */
        deviceModel?: string | null;
        /**
         * Any relevant info concerning the build options of the embedder (that is the software which runs as the 'driver' of an Assistant library, such as libassistant. the embedder is typically built by a third party)
         */
        embedderBuildInfo?: string | null;
        /**
         * A string recording the app version that is initially used to created this settings entry.
         */
        initialAppVersion?: string | null;
        /**
         * Boolean field to indicate whether a certain user is the primary user of a device or not. This is useful for distinguishing the user0 from other users given user0 might have certain privileges (Eg: Hubmode on Tangor)
         */
        isPrimaryUser?: boolean | null;
        /**
         * default display name of device over mdns. This is specified at the factory, not specified by the user.
         */
        mdnsDisplayName?: string | null;
        /**
         * A user-readable string describing the device's software platform.
         */
        platformBuild?: string | null;
        /**
         * A string describing device's release channel. For cast devices, the string will look like "qa-beta-channel", "eng-no-update", etc.
         */
        virtualReleaseChannel?: string | null;
    }
    export interface Schema$AssistantApiMediaControlSupport {
        /**
         * Whether to prevent confirmations (text, tts) for media control actions while media is playing so that the media session is not interrupted.
         */
        skipConfirmationsWhilePlaying?: boolean | null;
    }
    export interface Schema$AssistantApiMessageCapabilities {
        /**
         * If true, APP_ID queries initiated by this device should fall back to execution on the tethered device if it's available and if the primary device cannot perform the action (e.g. due to the app not being installed).
         */
        fallbackToTetheredDeviceAppCapabilities?: boolean | null;
        /**
         * For chat_message.SEND targeting, when either the primary or secondary (tethered) device is capable of handling the chat_message.SEND action, prefer targeting it to the primary device.
         */
        preferTargetingPrimaryDevice?: boolean | null;
        /**
         * Should only be checked if nonempty.
         */
        supportedRecipientTypes?: string[] | null;
    }
    export interface Schema$AssistantApiMovementCapabilities {
        /**
         * Indicates how much the device moves around. E.g., TV has a low mobility level, while Auto has a very high level.
         */
        mobility?: string | null;
    }
    export interface Schema$AssistantApiNotificationOutputRestrictions {
        optOutState?: Schema$AssistantApiNotificationOutputRestrictionsOptOutState;
    }
    /**
     * Per category/category group notification opt out settings.
     */
    export interface Schema$AssistantApiNotificationOutputRestrictionsOptOutState {
        categoryGroupState?: Schema$AssistantApiNotificationOutputRestrictionsOptOutStateCategoryGroupState[];
        categoryState?: Schema$AssistantApiNotificationOutputRestrictionsOptOutStateCategoryState[];
    }
    export interface Schema$AssistantApiNotificationOutputRestrictionsOptOutStateCategoryGroupState {
        categoryGroup?: string | null;
        state?: string | null;
    }
    export interface Schema$AssistantApiNotificationOutputRestrictionsOptOutStateCategoryState {
        category?: string | null;
        state?: string | null;
    }
    /**
     * Encapsulates the action capabilities of the OEM device. This data is merged from Device Model lookup, per-device registration, and per-request context. This data is sent to NLU layer for query understanding.
     */
    export interface Schema$AssistantApiOemCapabilities {
        /**
         * The OEM Cloud execution capability of this device, containing routing details for cloud fulfillment.
         */
        cloudCapability?: Schema$AssistantDevicesPlatformProtoCloudCapability;
        /**
         * If fulfillment is done via 3P cloud and 3P supports device capabilities, this field will be set.
         */
        cloudDeviceCapabilities?: {
            [key: string]: any;
        } | null;
        /**
         * Device Model Id from DeviceModelPackage.
         */
        deviceModelId?: string | null;
        /**
         * Device Model Revision Id from DeviceModelPackage.
         */
        deviceModelRevisionId?: string | null;
        /**
         * Opaque supported action data related to a specific domain of devices, for example for car. go/car-talk-registration-model
         */
        deviceSpecificData?: string | null;
        /**
         * Internal-only config containing metadata about the Device Model, for example to control the ranking behavior.
         */
        internalCapability?: Schema$AssistantDevicesPlatformProtoInternalCapability;
        /**
         * 3P Action Metadata, populated from the Device Model lookup and the client request parameters. For example, an Assistant SDK request would have the billed project id of the Assistant request added here in order to enable any Device Actions developed using the same Google Cloud project. This data is sent to Service Engine to mask triggering for Device Actions.
         */
        thirdPartyActionConfig?: Schema$AssistantApiThirdPartyActionConfig;
    }
    /**
     * Definitions of on-device assistant capabilities.
     */
    export interface Schema$AssistantApiOnDeviceAssistantCapabilities {
        /**
         * Capabilities related to local network arbitration (go/local-network-arbitration). Indicates if the device is capable of being a host device in the LAN whiling doing local network arbitration.
         */
        isLocalNetworkArbitrationSupported?: boolean | null;
        /**
         * Capabilities related to on-device arbitration(go/arbitration-on-device).
         */
        isOnDeviceArbitrationSupported?: boolean | null;
        /**
         * Indicates if on-device assistant is enabled on this device. Example usecases: NGA (go/nga) or Marble (go/marble).
         */
        isOnDeviceAssistantSupported?: boolean | null;
        /**
         * This may be used by NGA. E.g. if understanding happens on device, we can have more aggressive logic when fulfilling some features on the server side, like teleport.
         */
        isOnDeviceUnderstandingSupported?: boolean | null;
    }
    /**
     * Definitions of on-device Smart Home capabilities. Next ID: 2
     */
    export interface Schema$AssistantApiOnDeviceSmartHomeCapabilities {
        /**
         * Master bit for on-device Smart Home features.
         */
        isOnDeviceSmartHomeSupported?: boolean | null;
    }
    /**
     * The on-device storage capabilities found on the device.
     */
    export interface Schema$AssistantApiOnDeviceStorageCapabilities {
        /**
         * Determines if an on-device storage is supported.
         */
        isSupported?: boolean | null;
    }
    /**
     * These are user configurable permissions representing what the device is allowed to output. Next ID: 11
     */
    export interface Schema$AssistantApiOutputRestrictions {
        /**
         * The type of Google Photo content which the device can output.
         */
        googlePhotoContent?: string | null;
        /**
         * Access settings for guests.
         */
        guestAccessOutput?: Schema$AssistantApiGuestAccessOutput;
        /**
         * The level of personal data which the device can output. See go/personal-readout for detail.
         */
        personalData?: string | null;
        /**
         * This controls if the server can proactively send notification to users, and it does not affect scenarios that users ask for information. The notification may include TTS and lights. It could be only lights for chirp.
         */
        proactiveNotificationOutput?: string | null;
        /**
         * Restrictions on displaying and interacting with content on proactive surfaces (e.g. Dragonglass home screen). Note: NEVER access this field of OutputRestrictions directly, use the code in assistant/assistant_server/settings/device/device_settings_util.h instead.
         */
        proactiveOutput?: Schema$AssistantApiProactiveOutput;
        /**
         * Whether YouTube autoplay is allowed for queries from the user to this device. See go/assistant-youtube-settings for details.
         */
        youtubeAutoplayRestriction?: string | null;
        /**
         * The type of YouTube content which the device can output.
         */
        youtubeContent?: string | null;
        /**
         * The type of YouTube TV content which the device can output.
         */
        youtubeTvContent?: string | null;
    }
    /**
     * Next ID: 7
     */
    export interface Schema$AssistantApiProactiveOutput {
        /**
         * Allows displaying all personal data on proactive surfaces with no face match capability.
         */
        allowAllPersonalData?: boolean | null;
        /**
         * For ANDROID_TV devices, the location that this setting was last changed from. Note: this structure allows to extend to more per-vertical bits in the future.
         */
        androidTvAssistantSettingsSource?: string | null;
        /**
         * Allows displaying Health and Fitness content on proactive surfaces. This is a sub bit of the device-wide PR bit - the device-wide PR bit must be enabled AND this vertical sub bit must be enabled for H&F content to be shown. This bit will be available on all surfaces that have the proactive-bit enabled. If the proactive-bit is not enabled, then we do not show health and fitness content at all (or even allow access to this setting).
         */
        healthAndFitnessProactive?: string | null;
        /**
         * Allows displaying photos content on Dragonglass proactive surfaces. This is a sub bit of the device-wide PR bit - the device-wide PR bit must be enabled AND this vertical sub bit must be enabled for photos content to be shown on Dragonglass surfaces. This bit will be available on all Dragonglass surfaces that have the proactive-bit enabled. If the proactive-bit is not enabled or it's not a Dragonglass surface, then we do not show proactive photos content at all, nor allow access to this setting. See go/opa-photos-sg-settings for more details.
         */
        photosProactive?: string | null;
        /**
         * Settings for displaying personal data on proactive surfaces with face match capability.
         */
        userMatchProactive?: string | null;
    }
    /**
     * Also known as "Extensions Without Extensions" or "The Poor Man's Any", this simple proto is used to transmit arbitrary protocol buffers over the wire. Unlike extensions: - It does not require the proto type to be compiled into the binary. (Useful so that the proto declaration can be inside the conversation package) - It is compatible with all versions of proto, including proto3 and the wack-tastic version used on ChromecastOS. Server libraries for dealing with it live in google3/assistant/protocol/protobuf_lib.h.
     */
    export interface Schema$AssistantApiProtobuf {
        /**
         * The serialized protocol buffer.
         */
        protobufData?: string | null;
        /**
         * The type of the protocol buffer to use. This must be a resolvable name (Namespace.ProtoName) and refer to a proto which is either compiled in to both client and server (e.g. a base proto type) or to one which is part of the conversation package.
         */
        protobufType?: string | null;
    }
    /**
     * Date-based recurrences specify repeating events. Conceptually, a recurrence is a (possibly unbounded) sequence of dates on which an event falls, described by a list of constraints. A date is in a recurrence if and only if it satisfies all of the constraints. Note that devices may support some constraints, but not all.
     */
    export interface Schema$AssistantApiRecurrence {
        /**
         * The first day of the recurrence. If begin is not set, then the reminder will start infinitely in the past.
         */
        begin?: Schema$AssistantApiDate;
        /**
         * A list of blacklisted dates to skip the alarm on.
         */
        blacklistedRanges?: Schema$AssistantApiDateTimeRange[];
        /**
         * Specifies the date in a month. For example, if day_of_month is 15, then it represent the 15th day of the specified month.
         */
        dayOfMonth?: number[] | null;
        /**
         * Specifies a weekly or daily recurrence. Constraint: The date falls on one of these days of the week, in 0...6 (Sunday...Saturday).
         */
        dayOfWeek?: number[] | null;
        /**
         * The last day of the recurrence.
         */
        end?: Schema$AssistantApiDate;
        /**
         * Multiplier on the frequency of the recurrence. Use this to specify patterns that recur every X days, months, years, etc. Example: [remind me to call mom every 2nd week]. Default is 1 (every day, every month, every year).
         */
        every?: number | null;
        /**
         * Specifies the month in a year. Constrain: the month falls on one of these months, in 1, 2, ... 12 (January...December).
         */
        monthOfYear?: number[] | null;
        /**
         * The number of occurrences after which the recurrence should end.
         */
        numOccurrences?: number | null;
        /**
         * Specifies the index of week in a month. For example, the second Tuesday every month, in this case, week_of_month should be 2.
         */
        weekOfMonth?: number[] | null;
    }
    /**
     * These capabilities represent the tactile features associated with the device. This includes, for example, whether the device has a screen, how big the screen is, and privacy of the screen. Next ID: 11
     */
    export interface Schema$AssistantApiScreenCapabilities {
        /**
         * The scale factor used to convert Scalable Pixel (SP) units to Density-independent Pixel (DP) units (DP = SP * scale factor). Fonts are measured in units of SP, and on some platforms such as Android the SP to DP scale factor can be affected by the font size a user selects in accessibility settings.
         */
        fontScaleFactor?: number | null;
        /**
         * The types of input that this screen supports. Note that this can be empty in which case the screen's input type is unknown.
         */
        inputType?: string[] | null;
        /**
         * Mask defined for this device, if any.
         */
        mask?: Schema$AssistantApiScreenCapabilitiesMask;
        /**
         * The targeted schema version for ProtoLayout requests.
         */
        protoLayoutTargetedSchema?: Schema$AssistantApiScreenCapabilitiesProtoLayoutVersion;
        /**
         * If this field is absent, the resolution of the screen is unknown.
         */
        resolution?: Schema$AssistantApiScreenCapabilitiesResolution;
        /**
         * If screen is turned off.
         */
        screenOff?: boolean | null;
        /**
         * The ability of the client to correctly report screen state.
         */
        screenStateDetection?: string | null;
        /**
         * The primary supported rendering format for display on the device's screen. This may be used to determine what format of card to be returned when rendering cards.
         */
        supportedRenderingFormat?: string | null;
        /**
         * The screen states that the client supports. The current screen state is specified in DeviceProperties.screen.
         */
        supportedScreenStates?: string[] | null;
        /**
         * Whether the device enabled vision help features in accessibility settings. The settings is config in Assistant App and on-device settings, and stored in footprints. When enabled, font, color and TTS will be adjusted.
         */
        visionHelpEnabled?: boolean | null;
    }
    /**
     * A mask applied to the screen's pixel space to determine regions not visible on the physical device.
     */
    export interface Schema$AssistantApiScreenCapabilitiesMask {
        type?: string | null;
    }
    /**
     * Version info for ProtoLayout requests.
     */
    export interface Schema$AssistantApiScreenCapabilitiesProtoLayoutVersion {
        major?: number | null;
        minor?: number | null;
    }
    /**
     * A Resolution proto indicates the size of the application window. All fields are required.
     */
    export interface Schema$AssistantApiScreenCapabilitiesResolution {
        /**
         * Dots (pixels) per inch of the screen.
         */
        dpi?: number | null;
        heightPx?: number | null;
        /**
         * m_size is the smallest square box size to display a capital letter M so that the user can still easily understand it.
         */
        mSize?: number | null;
        /**
         * neng_size is the smallest square box size to display a letter 螚 (Neng, U+879A) so that the user can easily understand it. (Neng is a visually dense Chinese letter, and so may require a larger box than an M.)
         */
        nengSize?: number | null;
        /**
         * The dimensions of the application window, in pixels.
         */
        widthPx?: number | null;
    }
    /**
     * The Soli capabilities on Elaine, including gestures and sleep sensing. go/dingo-dc-software Next ID: 4
     */
    export interface Schema$AssistantApiSelinaCapabilites {
        /**
         * A list of gestures that selina supports
         */
        gestureCapabilities?: Schema$AssistantApiGestureCapabilities;
        /**
         * Whether the client supports selina.
         */
        selinaSupported?: boolean | null;
        /**
         * Whether the client can monitor sleep. This allows us to show sleep CUJ related information: go/TwilightDesign
         */
        sleepSensingSupported?: boolean | null;
    }
    export interface Schema$AssistantApiSettingsAmbientSettings {
        /**
         * Whether any user sets personal photos on this device. See go/ambient-setting-in-assistant-design.
         */
        anyUserHasSetPersonalPhotos?: boolean | null;
        /**
         * Whether or not the user's current selection for their ambient photo frame includes the auto-generated "Recent Highlights" album. This is used to determine which users to display the go/opa-photos-memories-tile. See go/opa-photo-memories-imax-optin for more discussion on why this bit was created.
         */
        recentHighlightsEnabled?: boolean | null;
        /**
         * Whether to enable the personal photo data in the ambient settings: https://screenshot.googleplex.com/Wd4OFkQfOyF See go/opa-photos-ambient-location-date-dd#heading=h.5x4iaouuiett for explanation.
         */
        showPersonalPhotoData?: boolean | null;
        /**
         * Whether current user sets personal photos on this device. See go/ambient-setting-in-assistant-design.
         */
        showPersonalPhotos?: boolean | null;
    }
    /**
     * These capabilities are associated with Assistant Settings on devices.
     */
    export interface Schema$AssistantApiSettingsAppCapabilities {
        /**
         * Capabilities that are associated with Assistant Settings on auto surfaces.
         */
        carSettingsCapabilities?: Schema$AssistantApiCarSettingsCapabilities;
        /**
         * Whether the client supports reissuing query after setting up in Music Settings.
         */
        reissueQueryAfterMusicSetup?: boolean | null;
        /**
         * Whether the client supports updating payments setting.
         */
        supportsPaymentsSettingsUpdate?: boolean | null;
    }
    /**
     * Settings pertaining to auto framing. See go/auto-framing-presentation.
     */
    export interface Schema$AssistantApiSettingsAutoFramingSettings {
        isAutoFramingEnabled?: boolean | null;
    }
    /**
     * Carrier related call settings on the device.
     */
    export interface Schema$AssistantApiSettingsCarrierCallDeviceSettings {
        /**
         * Whether this device is allowed to receive incoming PSTN calls.
         */
        allowIncomingCalls?: boolean | null;
    }
    /**
     * Specification of which communication features can be used.
     */
    export interface Schema$AssistantApiSettingsCommunicationsFilter {
        state?: string | null;
    }
    /**
     * Specification of times when most features on a device are disabled for certain users. During these periods, the device will respond to most interactions with something like "sorry, I'm sleeping right now". Design: go/home-ft-settings-storage PRD: go/home-family-tools-prd
     */
    export interface Schema$AssistantApiSettingsDeviceDowntimeSettings {
        schedules?: Schema$AssistantApiSettingsLabeledDowntimeSchedule[];
        /**
         * The set of users of this device that will have these downtime settings applied. Must have at least one element.
         */
        targets?: string[] | null;
    }
    /**
     * Defines a set of restrictions on particular device features for a certain set of users. Design: go/home-ft-settings-storage PRD: go/home-family-tools-prd
     */
    export interface Schema$AssistantApiSettingsDeviceFeatureFilters {
        /**
         * Enables/disables all the filters at the same time. For new devices or non-Cast devices this is always false.
         */
        enabled?: boolean | null;
        /**
         * The filters (feature restrictions) to apply when `enabled` is true.
         */
        featureFilters?: Schema$AssistantApiSettingsFeatureFilters;
        /**
         * The set of users of this device that will have these settings applied. Must have at least one element.
         */
        targets?: string[] | null;
    }
    export interface Schema$AssistantApiSettingsDeviceLogsOptIn {
        /**
         * Indicates whether the crash logs can be uploaded and the device logs can be enabled
         */
        optInEnabled?: boolean | null;
    }
    /**
     * Next ID: 73
     */
    export interface Schema$AssistantApiSettingsDeviceSettings {
        /**
         * LINT.ThenChange(//depot/google3/assistant/ui/assistant_device_settings_ui.proto)
         */
        ackStatus?: string | null;
        /**
         * A human-readable address string for the location; generally a one-line address such as "34 Masonic Ave, San Francisco CA 94117, United States". Set this field to empty string for deletion, in which case the rest of the location related fields below will be cleared as well.
         */
        address?: string | null;
        /**
         * The alias names of the device, e.g. my living room tv, tv, living room and etc., which user will usually use to refer to the device in addition to human_friendly_name. It can help speech biasing and query understanding. This field is set by the user and already localized.
         */
        aliasName?: string[] | null;
        /**
         * Whether this device is allowed to receive incoming calls.
         */
        allowIncomingCalls?: boolean | null;
        /**
         * Ambient settings contains the configuration of Photo Frame on DG device. This field relies on IMAX service to do the update, sync happenes after user updates IMAX device settings or a device registers in CloudCastDevice. So it's more like a cached version instead of definitive source-of-truth. More details at go/ambient-setting-in-assistant-design.
         */
        ambientSettings?: Schema$AssistantApiSettingsAmbientSettings;
        /**
         * The additional device ids. Currently used only for ATV. go/project-yellowstone Note: This field is for internal (Within settings) use only.
         */
        ancillaryDeviceId?: Schema$AssistantApiSettingsInternalAncillaryDeviceId;
        /**
         * Auto framing settings associated with a device. See go/auto-framing-presentation.
         */
        autoFramingSettings?: Schema$AssistantApiSettingsAutoFramingSettings;
        /**
         * Indicates whether the user has enabled Blue Steel. See go/blue-steel for more info on this project.
         */
        blueSteelEnabled?: boolean | null;
        /**
         * Describes roughly what a device is capable of doing and metadata around those capabilities. Note: this includes device limitations as well as user configurable settings.
         */
        capabilities?: Schema$AssistantApiDeviceCapabilities;
        /**
         * city and postal_code are sent to third party AoG Apps as location when permission is granted for precise or coarse location. https://developers.google.com/actions/reference/rest/Shared.Types/Permission city and postal_code have the same description as in Proto Postal Address: https://cs.corp.google.com/piper///depot/google3/location/country/postaladdress.proto city corresponds to locality_name, postal_code corresponds to postal_code_number. These two fields are set in assistant_settings_service by AddressConverter. https://cs.corp.google.com/piper///depot/google3/location/addressformatter/public/addressconverter.h See go/aog-i18n-address-parse for more information
         */
        city?: string | null;
        /**
         * Status of colocation. go/co-location-work-v2 Note: this is a cache at the Assistant level. The source of truth is inside CastAuthenticationServer, which is only used for Home devices.
         */
        colocationStatus?: string | null;
        /**
         * The timestamp that the device is linked with the user in milliseconds.
         */
        creationTimestampMs?: string | null;
        /**
         * Availability of this device for Assistant Cross-surface handoffs. (go/assistant-cross-surface)
         */
        crossSurfaceAvailability?: Schema$AssistantApiSettingsDeviceSettingsCrossSurfaceAvailability;
        /**
         * The identification of the default device which user want to output audio. See go/default-media-output-design for more info.
         */
        defaultAudioDeviceId?: Schema$AssistantApiCoreTypesDeviceId;
        /**
         * The identification of the default device which user want to output video. Note that, we don't fallback to this for audio playback when default_audio_device_id is not set. See go/default-media-output-design for more info.
         */
        defaultVideoDeviceId?: Schema$AssistantApiCoreTypesDeviceId;
        /**
         * The brand of the device, populated from DeviceOemParams. Examples: "google", "samsung".
         */
        deviceBrand?: string | null;
        /**
         * The identification of the device.
         */
        deviceId?: Schema$AssistantApiCoreTypesDeviceId;
        /**
         * The model ID of the device. This should be globally unique across manufactures/OEMs. Examples: "nest_cam_iq_2017", "comcast_voice_box_2017".
         */
        deviceModelId?: string | null;
        /**
         * The Device Platform Service lookup revision. (go/device-model-revision) For 1p devices, and most 3p devices with no custom feature, this should be always 0, which means no lookup needed. For 3p devices with custom assistant feature, this is provided directly by OEM as incremental (e.g. 1, 2, 3, ...)
         */
        deviceModelRevision?: number | null;
        /**
         * Only valid for ATV. Stores the android DUSI for the corresponding user. More details: go/auto-logout-on-unlink.
         */
        dusi?: string | null;
        /**
         * List of errors that happened during the face enrollment process if it failed. See go/face-match-enrollment-error for more info.
         */
        faceEnrollmentErrors?: string[] | null;
        /**
         * Indicates whether the user's face has been successfully enrolled on this device. See go/face-match-server-design for more info.
         */
        faceEnrollmentStatus?: string | null;
        /**
         * Indicates whether the user has enabled Face Match for this device. See go/face-match-server-design for more info on this project.
         */
        faceMatchEnabled?: boolean | null;
        /**
         * Stores GCM info associated with a device. See go/quartz-design-doc for more info.
         */
        gcmSettings?: Schema$AssistantApiSettingsGcmSettings;
        /**
         * Holds the data that should be written to HomeGraph. Note: this field is not persisted in Assistant Settings storage. It is simply used for transporting data when client calls UpdateSettings.
         */
        homeGraphData?: Schema$AssistantApiSettingsHomeGraphData;
        /**
         * The home graph ID that can be used to lookup the corresponding entry in HomeGraph. go/home-graph. Note: when this field is empty, it doesn't necessarily mean that the device is not in home graph. It just means that Assistant doesn't know about the mapping.
         */
        homeGraphId?: string | null;
        /**
         * Indicates whether the device is currently in Hospitality mode. go/hospitality-mode-design. This is moved to a per user setting in assistant settings. ref. go/hospitality-settings-v2
         */
        hospitalityModeStatus?: Schema$AssistantApiSettingsHospitalityMode;
        /**
         * The level of hotword sensitivity. go/hotword-sensitivity-prd
         */
        hotwordSensitivity?: string | null;
        /**
         * HotwordThresholdAdjustmentFactor contains threshold_adjustment_factor, and it's validity. TAF is a measure of adjustment applied to the hotword threshold as a result of go/autotune. Currently, this is updated from query_settings_frame, but if we move to updating it from the client, this could also contain TAFs as a result of Hotword Sensitivity, in addition to Autotune.
         */
        hotwordThresholdAdjustmentFactor?: Schema$AssistantApiSettingsHotwordThresholdAdjustmentFactor;
        /**
         * The human-friendly name of the cast device, e.g., my living room tv. This field is set by the user and already localized.
         */
        humanFriendlyName?: string | null;
        /**
         * Internal version of the DeviceSettings for measurement of the DeviceSettings mutation race conditions. See go/consistent-assistant-settings-update.
         */
        internalVersion?: Schema$AssistantApiSettingsInternalVersion;
        /**
         * Indicates whether the device is also managed through HA cloud sync. go/ha-dev-guide
         */
        isCloudSyncDevice?: boolean | null;
        /**
         * When true, the user has explicitly allowed audio and visual data collection on this device
         */
        isDeviceActivationCacheEnabled?: boolean | null;
        /**
         * Specifies if kids-mode is enabled for the device. See go/aff-parentalsupervision-dd.
         */
        kidsMode?: Schema$AssistantApiSettingsKidsMode;
        /**
         * Device's latest registration timestamp provided by Cast side. This field is not necessarily up to date. The update frequency is defined in last_registration_update_frequency_in_days field of AssistantConfig in java/com/google/chrome/dongle/common/proto/home_assistant_config.proto. go/cast-last-registration-time
         */
        lastCastRegistrationTimestamp?: string | null;
        /**
         * Coarsened hourly timestamp of when the device was last used.
         */
        lastUsedCoarseTimestamp?: string | null;
        /**
         * Stores pairing between different devices. See go/quartz-design-doc for more info.
         */
        linkedDeviceId?: Schema$AssistantApiCoreTypesDeviceId[];
        /**
         * Please do NOT use this field without prior approval from PWG. Users who have signed in onto this device, go/linked-users-in-pkg.
         */
        linkedUsers?: Schema$AssistantApiSettingsLinkedUser[];
        /**
         * The locale for the device: language + region, i.e., en-US, ja-JP.
         */
        locale?: string | null;
        /**
         * Coordinate information of the device location.
         */
        locationCoordinates?: Schema$AssistantApiCoreTypesLocationCoordinates;
        /**
         * The feature proto of the location of the device. Note: client does not need to populate this. It will be auto-populated based on "address" field on server side. Currently, only "bound" and "type" are persisted, since the entire FeatureProto is too big.
         */
        locationFeature?: Schema$GeostoreFeatureProto;
        /**
         * See go/marketplace-disclosure for more info.
         */
        marketplaceDisclosure?: Schema$AssistantApiSettingsMarketplaceDisclosure;
        masqueradeMode?: Schema$AssistantApiSettingsMasqueradeMode;
        /**
         * Information about how to send the user a notification. This won't be populated for fb-conv users (allo group chat users).
         */
        notificationProfile?: Schema$AssistantApiSettingsNotificationProfile;
        /**
         * OAuth client id for the device. This field is available for Assistant SDK devices. It is written when the device is registered to the user (AssistantSettingsUiService.LinkAssistantDeviceUi). When user revokes grant on the Assistant device, Assistant Devices Platform Service will receive Pubsub notification with OAuth client id for the revoked device, and we will compare that with this stored id to identity device to remove.
         */
        oauthClientId?: string | null;
        /**
         * Device specific app related settings.
         */
        onDeviceAppSettings?: Schema$AssistantApiSettingsOnDeviceAppSettings;
        /**
         * Specifies if device logs and crashes can be captured during SendFeedback
         */
        optInStatus?: Schema$AssistantApiSettingsDeviceLogsOptIn;
        /**
         * DEPRECATED: Use DeviceCapabilities.OutputRestrictions.personal_data instead. Whether the user has enabled payments for this device.
         */
        paymentsEnabled?: boolean | null;
        /**
         * Metadata about how personalization settings were configured.
         */
        personalizationMetadata?: Schema$AssistantApiSettingsPersonalizationMetadata;
        /**
         * Specify whether polite mode is enabled for this device. See go/pretty-please-dd.
         */
        politeMode?: Schema$AssistantApiSettingsPoliteMode;
        postalCode?: string | null;
        /**
         * Trusted device preferences Assistant reauth. go/assistant-reauth-verify-skip.
         */
        reauthTrustedDeviceSettings?: Schema$AssistantApiSettingsReauthTrustedDeviceSettings;
        /**
         * A human-readable shortened address. This is usually the street address. Note: client does not need to populate this. It will be auto-populated based on "address" field on server side. Developers can use this field to avoid reading out the full address everytime.
         */
        shortenedAddress?: string | null;
        /**
         * Indicates whether the user has enabled speaker-id for this device. See go/google-assistant-multi-user for more info on this project.
         */
        speakerIdEnabled?: boolean | null;
        /**
         * Settings related to TTS output.
         */
        speechOutputSettings?: Schema$AssistantApiSettingsSpeechOutputSettings;
        /**
         * Speech/hotword detection related settings.
         */
        speechSettings?: Schema$AssistantApiSettingsSpeechSettings;
        /**
         * Restrictions on how and when certain users can use a device. See go/home-ft-prd.
         */
        supervisionSettings?: Schema$AssistantApiSettingsDeviceSupervisionSettings;
        /**
         * The type of assistant surface. Only use this field when device type is ASSISTANT.
         */
        surfaceType?: Schema$AssistantApiCoreTypesSurfaceType;
        /**
         * Presence indicates a tethered wearable. go/wearable-device-ids.
         */
        tetheredInfo?: Schema$AssistantApiSettingsTetheredInfo;
        /**
         * Device time zone. It's mainly used for a one-time notification for new users when they just bought and activated their devices. They may not have used Search or Assistant before, so their timezone info may not available elsewhere when we want to send a notification. This should be used as a fallback only when other timezone sources such as assistant_settings:user_attribute#inferred_user_timezone are not available. Also, when both |time_zone| and |location| are set, the |location| should be preferred to derive the most up to date timezone. This info directly comes from the device through early device setting recording mechanism. See more details at go/early-device-setting-recording.
         */
        timeZone?: Schema$AssistantApiTimeZone;
        /**
         * Local network ID of the device (truncated to obfuscate devices and households globally). This is a temporary signal to determine proximity of Assistant devices in a house (HGS place).
         */
        truncatedLocalNetworkId?: string | null;
        /**
         * The type of the device. Note: this should only be used for grouping devices for UI presentation purpose. Use |capabilities| to decide what the device can do.
         */
        type?: string | null;
        /**
         * Indicates whether to play verbose tts for Elementary on chirp. See: go/opa-cast-a11y-impl-design fore more info on this project. Note: this should probably be in SpeechOutputSetting below.
         */
        verboseTtsForChromecastEnabled?: boolean | null;
        /**
         * Coarsened hourly timestamp of when the user was last verified by VoiceMatch on this device. This is used for enforcing VoiceMatch model TTL. go/voicematch-pdd-ttl
         */
        vmLastUsedCoarseTimestamp?: string | null;
        /**
         * Indicates whether the user's voice has been successfully enrolled on this device.
         */
        voiceEnrollmentStatus?: string | null;
        /**
         * A boolean indicates whether voice input (mic-button, hotword, etc) is enabled.
         */
        voiceInputEnabled?: boolean | null;
    }
    export interface Schema$AssistantApiSettingsDeviceSettingsCrossSurfaceAvailability {
        /**
         * Last known locale of the client.
         */
        lastKnownClientLocale?: string | null;
        /**
         * This is the timestamp when the AssistantRequestParams (in ASSISTANT_SNAPSHOT corpus) were last written for this device.
         */
        lastParamsWriteTimestamp?: string | null;
    }
    export interface Schema$AssistantApiSettingsDeviceSupervisionSettings {
        /**
         * Specification of times that a device shouldn't respond to certain users. See go/home-ft-prd.
         */
        downtimeSettings?: Schema$AssistantApiSettingsDeviceDowntimeSettings;
        /**
         * Restrictions on features that certain users can access on a device. See go/home-ft-prd.
         */
        featureFilters?: Schema$AssistantApiSettingsDeviceFeatureFilters;
    }
    /**
     * Specifies a period of up to 24 hours when downtime should be enabled, starting at certain time on a certain day of the week, and ending at a later time on either that day or the following day.
     */
    export interface Schema$AssistantApiSettingsDowntimePeriod {
        /**
         * True if downtime should be enabled during this period.
         */
        enabled?: boolean | null;
        /**
         * Time of day that this downtime period should end. Required. If end_time \> start_time, end_time is relative to start_day. Otherwise, end_time is relative to the day after start_day. For example, start_day: MONDAY, start_time: 9 p.m., end_time: 6 a.m. means that the downtime period starts at 9 p.m. on Monday and ends at 6 a.m. on Tuesday.
         */
        endTime?: Schema$GoogleTypeTimeOfDay;
        /**
         * The day of the week when this downtime period starts. Required.
         */
        startDay?: string | null;
        /**
         * Time of day that this downtime period should start. Required.
         */
        startTime?: Schema$GoogleTypeTimeOfDay;
    }
    /**
     * Specification of when downtime is enabled on different days of the week. Contains up to 7 DowntimePeriod messages, up to one per day of the week.
     */
    export interface Schema$AssistantApiSettingsDowntimeSchedule {
        /**
         * True if this downtime schedule should be enabled.
         */
        enabled?: boolean | null;
        /**
         * Downtime entries for the days of the week, in no particular order. There can be at most one period defined for each day of the week. Days of the week with no explicit period defined are treated as disabled, so the device is available all day (modulo an end time that may spill over from the previous day).
         */
        periods?: Schema$AssistantApiSettingsDowntimePeriod[];
    }
    /**
     * Duo related call settings on the device. Next ID: 5
     */
    export interface Schema$AssistantApiSettingsDuoCallDeviceSettings {
        /**
         * True if Duo Knock Kncok feature is enabled on the device.
         */
        allowKnockKnock?: boolean | null;
        /**
         * Boolean indicating if user has explicitly marked this device to be linked or not. This bit is used in case where unexpected errors occur and we have to check for account/device status and mark the device linked after verification.
         */
        shouldBeLinked?: boolean | null;
        /**
         * The call state of the device (i.e. whether a Duo call account has been setup on the device).
         */
        state?: string | null;
        /**
         * Client device settings: settings which are populated by client to give to duocore. TalkBack is an accessibility service that helps blind and vision-impaired users interact with their devices. Indicates whether talkback is enabled for the device. Note: this is per device settings currently filled by client for all users.
         */
        talkbackEnabled?: boolean | null;
    }
    /**
     * Specification of which assistant features are allowed for a particular device or user account.
     */
    export interface Schema$AssistantApiSettingsFeatureFilters {
        communicationsFilter?: Schema$AssistantApiSettingsCommunicationsFilter;
        musicFilter?: Schema$AssistantApiSettingsMusicFilter;
        newsFilter?: Schema$AssistantApiSettingsNewsFilter;
        podcastFilter?: Schema$AssistantApiSettingsPodcastFilter;
        searchFilter?: Schema$AssistantApiSettingsSearchFilter;
        thirdPartyAppsFilter?: Schema$AssistantApiSettingsThirdPartyAppsFilter;
        videoFilter?: Schema$AssistantApiSettingsVideoFilter;
        webviewFilter?: Schema$AssistantApiSettingsWebviewFilter;
    }
    export interface Schema$AssistantApiSettingsGcmSettings {
        gcmId?: string | null;
        gcmPackage?: string | null;
    }
    /**
     * Next ID: 8
     */
    export interface Schema$AssistantApiSettingsHomeGraphData {
        /**
         * Agent ID, aka project ID. Used as the AgentDeviceId.agent_id of device when calling Home Graph Service.
         */
        agentId?: string | null;
        /**
         * See go/ha-dev-guide and HomeGraphItem.attribute in //assistant/verticals/homeautomation/proto/home_graph.proto
         */
        attributes?: {
            [key: string]: any;
        } | null;
        /**
         * Device ID, used as AgentDeviceId.device_id of device when calling Home Graph Service.
         */
        deviceId?: string | null;
        /**
         * HGS device type. See java/com/google/home/graph/service/config/protoconf.pi for the exhaustive list of type strings.
         */
        deviceType?: string | null;
        /**
         * Whether device data should be written to Home Graph via Assistant device_settings. Assistant SDK and Google Home write their devices into Home Graph through AssistantSettingsService, while Home Automation Partner devices (e.g. SmartThings, Philips Hue, Nest, TP-Link, etc.) don't need to be written to Home Graph through AssistantSettingsService. This field decides whether AssistantSettingsService writes devices to Home Graph or not.
         */
        shouldWriteToHomeGraph?: boolean | null;
        /**
         * Supported traits of the device. See java/com/google/home/graph/service/config/protoconf.pi for the exhaustive list of trait-strings.
         */
        supportedTraits?: string[] | null;
        /**
         * Whether the device supports direct response. See HomeGraphItem.supports_direct_response in //assistant/verticals/homeautomation/proto/home_graph.proto
         */
        supportsDirectResponse?: boolean | null;
    }
    export interface Schema$AssistantApiSettingsHospitalityCardSettings {
        /**
         * Config for Hospitality UI modules.
         */
        cardConfig?: Schema$AssistantApiSettingsHospitalityCardSettingsCardConfig[];
        /**
         * Toggle media tap gesture tutorial card.
         */
        showMediaTapGestureTutorial?: boolean | null;
        /**
         * Toggle photo swipe gesture tutorial card.
         */
        showPhotoSwipeGestureTutorial?: boolean | null;
        /**
         * Config for YouTube video cards.
         */
        youtubeCardConfig?: Schema$AssistantApiSettingsHospitalityCardSettingsYouTubeCardConfig[];
    }
    /**
     * Configuration for hospitality card.
     */
    export interface Schema$AssistantApiSettingsHospitalityCardSettingsCardConfig {
        /**
         * Whether the UI module requires user action. If true, the UI module can peek on to the top of Ambient. See SmartDisplayModuleState::ACTIVE_ACTION_REQUIRED.
         */
        activeActionRequired?: boolean | null;
        /**
         * Whether the UI module is dismissable.
         */
        dismissable?: boolean | null;
        /**
         * The time that the module is effective and visible to the user. If not set, the module is effective immediately.
         */
        effectiveTime?: Schema$AssistantApiTimestamp;
        /**
         * The time that the module is expired and invisible to the user. If not set, the module never expires.
         */
        expiryTime?: Schema$AssistantApiTimestamp;
        /**
         * The image URL for the UI module.
         */
        imageUrl?: string | null;
        /**
         * Module ID.
         */
        moduleId?: string | null;
        /**
         * Payload query to the partner AoG action when user responds to UI Module, e.g. “Tell the hotel how my stay is going”.
         */
        payloadQuery?: string | null;
        /**
         * Title of the message to be shown to user at the top of the UI Module.
         */
        title?: string | null;
    }
    /**
     * Configuration for YouTube video card (Stargazer tile).
     */
    export interface Schema$AssistantApiSettingsHospitalityCardSettingsYouTubeCardConfig {
        /**
         * URL of image to go on card. The URL must be a public link accessible from ZeroState.
         */
        imageUrl?: string | null;
        /**
         * ID of YouTube playlist to play on card tap. A playlist is used instead of a single video id to avoid autoplaying related videos. The playlist and the videos it contains must be public or unlisted to be accessible from ZeroState.
         */
        playlistId?: string | null;
        /**
         * Text on card (i.e., video title).
         */
        text?: string | null;
    }
    /**
     * Hospitality mode config for the current device. go/hospitality-mode-design. Next ID: 17
     */
    export interface Schema$AssistantApiSettingsHospitalityMode {
        /**
         * List of AOG app context ids that are linked to this device. These apps will have access to the structure information for the device.
         */
        aogContextId?: string[] | null;
        /**
         * Invocation phrase for hotel's AoG action. Used for ZS promotion card and "talk to my hotel" rewrites. Setting this to an empty value will mark it unset.
         */
        aogInvocationPhrase?: string | null;
        branding?: Schema$AssistantApiSettingsHospitalityModeBranding;
        cardSettings?: Schema$AssistantApiSettingsHospitalityCardSettings;
        /**
         * The time when we received a request to reset the device.
         */
        deviceClearRequest?: Schema$AssistantApiTimestamp;
        /**
         * Should the dialog have a shorter ttl. See go/ipp-consumer-prd#heading=h.ibu9b1ysdl4t and go/interpreter-device-clear#bookmark=id.hw8ey1bzjadn for context.
         */
        dialogTtlOverrideMicros?: string | null;
        /**
         * Identifier for the enterprise which owns the device. Setting this to an empty value will mark it unset.
         */
        enterpriseId?: string | null;
        /**
         * Indicates whether this device is in the hospitality mode.
         */
        hospitalityModeEnabled?: boolean | null;
        /**
         * Last time the device was cleared and placed in hospitality mode. Will be set when the switch is toggled on and reset when a guest checks out. On the device this triggers removing alarms, timers, etc.
         */
        lastDeviceClear?: Schema$AssistantApiTimestamp;
        /**
         * Indicates when hospitality settings were last updated.
         */
        lastModifiedTimestamp?: Schema$AssistantApiTimestamp;
        /**
         * Last time the welcome message was played for the guest. If last_welcomed < welcome_request, the message should be replayed and this time set.
         */
        lastWelcomed?: Schema$AssistantApiTimestamp;
        /**
         * Indicates whether or not the device must be reset manually (by voice or touch), as opposed to being automatically reset. go/hospitality-manual-reset
         */
        manualResetRequired?: boolean | null;
        /**
         * In order promoted languages for interpreter devices. This represents languages by BCP-47 language strings, such as "en", "en-US", "fr", "fr-CA", "sr-Latn", "zh-Hans-CN", "zh-Hant-HK",etc.
         */
        promotedLanguages?: string[] | null;
        type?: string | null;
        /**
         * Whether we allow users to initiate clearing the device verbally. We generally allow this for private devices and not for public ones.
         */
        verbalResetSupported?: boolean | null;
        /**
         * The time when we received a request to welcome the user.
         */
        welcomeRequest?: Schema$AssistantApiTimestamp;
    }
    /**
     * TODO(b/169423976) Consider moving Branding out of user level settings into enterprise level settings. Partner branding fields used to customize the ui. Next ID: 7
     */
    export interface Schema$AssistantApiSettingsHospitalityModeBranding {
        /**
         * Brand display in the UI
         */
        displayName?: string | null;
        /**
         * Brand display in the UI for languages that the enterprise has a localized name that is different from its global branding name. For example, Hilton is 'ヒルトン' in Japanese and '希爾頓' in Chinese. The keys are hospitality supported display locales, e.g. en, ja-JP, etc, defined in experiment parameter Hospitality__hospitality_display_supported_locales.
         */
        displayNameForLanguage?: {
            [key: string]: string;
        } | null;
        largeLogoUrl?: string | null;
        smallLogoUrl?: string | null;
    }
    /**
     * HotwordThresholdAdjustmentFactor contains threshold_adjustment_factor, and it's validity. value should only be considered when is_valid = true.
     */
    export interface Schema$AssistantApiSettingsHotwordThresholdAdjustmentFactor {
        /**
         * Currently, is_valid is set to false whenever the TAF is not an Autotune aware value. This includes hotword sensitivity users, or devices not eligible for autotune.
         */
        isValid?: boolean | null;
        value?: number | null;
    }
    /**
     * Represents supporting device ids.
     */
    export interface Schema$AssistantApiSettingsInternalAncillaryDeviceId {
        /**
         * Contains device ids known to devices. eg. For ATV, it contains client_instance_id and cast_id.
         */
        deviceId?: Schema$AssistantApiCoreTypesDeviceId;
    }
    /**
     * Represents a version of a specifit setting, e.g. DeviceSettings.
     */
    export interface Schema$AssistantApiSettingsInternalVersion {
        /**
         * Contains the timestamp when this version was generated.
         */
        generationTime?: string | null;
        /**
         * Integer value of the version, it is a monotonically increasing number and starts at 0. On every update it is incremented by 1.
         */
        id?: string | null;
    }
    /**
     * Kids mode config for the current device. go/aff-parentalsupervision-dd
     */
    export interface Schema$AssistantApiSettingsKidsMode {
        kidsModeEnabled?: boolean | null;
        /**
         * Identifier of the account currently specified to be used with kids mode.
         */
        obfuscatedGaiaId?: string | null;
    }
    export interface Schema$AssistantApiSettingsLabeledDowntimeSchedule {
        /**
         * User-provided name for this schedule.
         */
        displayName?: string | null;
        schedule?: Schema$AssistantApiSettingsDowntimeSchedule;
    }
    /**
     * Represents the profile of the user who has signed in onto this device. Next id: 5
     */
    export interface Schema$AssistantApiSettingsLinkedUser {
        /**
         * Time of linking of the device with the user provided by Cast.
         */
        castLinkingTime?: string | null;
        /**
         * Primary email address of the user.
         */
        email?: string | null;
        gaiaId?: string | null;
        /**
         * Supports features which depend on profile name, when no matching contact is found.
         */
        names?: Schema$AppsPeopleOzExternalMergedpeopleapiName[];
    }
    export interface Schema$AssistantApiSettingsMarketplaceDisclosure {
        /**
         * True if the user has confirmed the marketplace disclosure.
         */
        confirmed?: boolean | null;
        /**
         * The time user confirmed the marketplace disclosure.
         */
        timestampMs?: string | null;
    }
    /**
     * Guest mode for the current device. go/assistant-guest-mode-summary
     */
    export interface Schema$AssistantApiSettingsMasqueradeMode {
        lastEnterGuestModeTimestamp?: Schema$AssistantApiTimestamp;
        lastExitGuestModeTimestamp?: Schema$AssistantApiTimestamp;
        masqueradeModeEnabled?: boolean | null;
    }
    /**
     * Specification of which music features can be used.
     */
    export interface Schema$AssistantApiSettingsMusicFilter {
        /**
         * Providers available at the time user updated settings.
         */
        availableProviders?: string[] | null;
        /**
         * Represents the state for the music provider filter.
         */
        providerFilterState?: string | null;
        state?: string | null;
        /**
         * Contains the list of whitelisted music providers.
         */
        whitelistedProviders?: string[] | null;
    }
    /**
     * Specification of which news features can be used.
     */
    export interface Schema$AssistantApiSettingsNewsFilter {
        state?: string | null;
    }
    export interface Schema$AssistantApiSettingsNotificationProfile {
        /**
         * Each device can have only one type of notification profile.
         */
        alloNotificationProfile?: Schema$AssistantApiSettingsNotificationProfileAlloNotificationProfile;
    }
    export interface Schema$AssistantApiSettingsNotificationProfileAlloNotificationProfile {
        /**
         * The send token of the conversation with the user.
         */
        botSendToken?: Schema$ChatBotPlatformBotSendToken;
        /**
         * The fireball id of this user.
         */
        id?: Schema$ChatBotPlatformFireballId;
    }
    export interface Schema$AssistantApiSettingsOnDeviceAppSettings {
        /**
         * On device carrier call related settings.
         */
        carrierCallDeviceSettings?: Schema$AssistantApiSettingsCarrierCallDeviceSettings;
        /**
         * On device duo call related settings.
         */
        duoCallDeviceSettings?: Schema$AssistantApiSettingsDuoCallDeviceSettings;
    }
    export interface Schema$AssistantApiSettingsPersonalizationMetadata {
        faceMatch?: string | null;
        personalResults?: string | null;
        voiceMatch?: string | null;
    }
    /**
     * Specification of which podcast features can be used.
     */
    export interface Schema$AssistantApiSettingsPodcastFilter {
        state?: string | null;
    }
    /**
     * Polite mode config for the current device. go/polite-mode-dd
     */
    export interface Schema$AssistantApiSettingsPoliteMode {
        politeModeEnabled?: boolean | null;
    }
    /**
     * Settings related to Assistant reauth. go/assistant-reauth-verify-skip Next id: 2
     */
    export interface Schema$AssistantApiSettingsReauthTrustedDeviceSettings {
        /**
         * Mapping from integrator client id to device's trust settings. Id from assistant/agent_platform/transactions/reauth/reauth_client.proto.
         */
        trustSettingsForClient?: {
            [key: string]: Schema$AssistantApiSettingsReauthTrustedDeviceSettingsTrustSettings;
        } | null;
    }
    /**
     * Next id: 6
     */
    export interface Schema$AssistantApiSettingsReauthTrustedDeviceSettingsTrustSettings {
        /**
         * If true, don't ask user to trust this device again.
         */
        neverAskAgain?: boolean | null;
        /**
         * DEPRECATED: Use never_ask_again instead. Expiration timestamp of "never ask again" status. If this field is set and is later than current timestamp, we should NOT ask the user whether they'd like to trust this device.
         */
        neverAskExpirationTimestamp?: string | null;
        /**
         * Expiration timestamp of "trusted" status. If this field is set and is later than current timestamp, we can consider this device to be trusted.
         */
        trustDeviceExpirationTimestamp?: string | null;
    }
    /**
     * Specification of which search features can be used.
     */
    export interface Schema$AssistantApiSettingsSearchFilter {
        state?: string | null;
    }
    /**
     * Settings related to TTS output.
     */
    export interface Schema$AssistantApiSettingsSpeechOutputSettings {
        speechOutput?: string | null;
    }
    /**
     * Settings related to speech detection. See go/hotword-settings-on-cloud for more info. Next ID: 16
     */
    export interface Schema$AssistantApiSettingsSpeechSettings {
        /**
         * Indicates whether Continued Conversation is enabled for this device.
         */
        continuedConversationEnabled?: boolean | null;
        /**
         * Stores the device model type e.g Pixel.
         */
        deviceModelType?: string | null;
        /**
         * Whether the device has DSP chip to enable always on hotword detection.
         */
        dspAvailable?: boolean | null;
        /**
         * Whether hotword has been enabled by the user during navigation.
         */
        hotwordInNavigationEnabled?: string | null;
        /**
         * Stores hotword setting status for the locales which don't support voice match.
         */
        hotwordSetting?: string | null;
        /**
         * Whether pin/pattern lockscreen has been enabled by the user.
         */
        lockscreenEnabled?: boolean | null;
        /**
         * Stores if Assistant is available for the user's device/locale, where Enabled means it is available and disabled means it is not.
         */
        opaEligibilityState?: string | null;
        /**
         * Stores if Assistant is available for the user's device/locale. Deprecated as bools do not give accurate true/false ratios due to old clients reporting the default value.
         */
        opaEligible?: boolean | null;
        /**
         * Stores the Android SDK version. This comes from android.os.Build.VERSION.SDK_INT.
         */
        sdkVersion?: number | null;
        /**
         * Whether speaker ID model is present for the user.
         */
        speakerIdModelPresent?: boolean | null;
        /**
         * Indicates whether the user has enabled speaker-id (fromAnyScreen/alwaysOn) for this device. Deprecated - use voice_match_setting instead
         */
        speakerIdRecognitionEnabled?: boolean | null;
        /**
         * Indicates whether the user has enabled trusted voice for this device.
         */
        trustedVoiceEnabled?: boolean | null;
        /**
         * A bool indicating whether device supports unlocking device with hotword.
         */
        unlockWithHotwordAvailable?: boolean | null;
        /**
         * Stores if user was migrated from undecided to declined as apart of Mariko project. Used for potential growth targeting.
         */
        userMigratedToDeclined?: boolean | null;
        /**
         * Stores the hotword/voice match setting status for the locales which support voice match.
         */
        voiceMatchSetting?: string | null;
    }
    export interface Schema$AssistantApiSettingsTetheredInfo {
        /**
         * The host this wearable is tethered to (e.g. phone). When host is AGSA then this is agsa_client_instance_id. When host is IOPA then this is opa_ios_device_id.
         */
        primaryHostDeviceId?: string | null;
    }
    /**
     * Specification of which third party apps can be used.
     */
    export interface Schema$AssistantApiSettingsThirdPartyAppsFilter {
        state?: string | null;
    }
    /**
     * Specification of which video features can be used.
     */
    export interface Schema$AssistantApiSettingsVideoFilter {
        /**
         * State that indicates whether autoplay is enabled for youtube videos.
         */
        autoplayToggleState?: string | null;
        /**
         * Providers available at the time user updated settings.
         */
        availableProviders?: string[] | null;
        /**
         * Represents the state for the video provider filter.
         */
        providerFilterState?: string | null;
        state?: string | null;
        /**
         * Contains the list of whitelisted video providers.
         */
        whitelistedProviders?: string[] | null;
    }
    /**
     * Specification of which webview features can be used.
     */
    export interface Schema$AssistantApiSettingsWebviewFilter {
        /**
         * Indicates if user has consented Jasper warning message.
         */
        jasperWebviewConsent?: boolean | null;
        state?: string | null;
    }
    /**
     * The method of sign in which the client supports.
     */
    export interface Schema$AssistantApiSignInMethod {
        method?: string | null;
        /**
         * Make Google sign-in mandatory for using Google Assistant on the device.
         */
        signInRequired?: boolean | null;
    }
    /**
     * Capabilities related to SODA (Speech On-Device API). Next ID: 5
     */
    export interface Schema$AssistantApiSodaCapabilities {
        /**
         * Whether the device supports different levels of hotword sensitivity. go/hotword-sensitivity-prd
         */
        supportsHotwordSensitivity?: boolean | null;
        /**
         * Whether Simple Stop (go/simple-stop) is enabled on the device. Simple stop allows users to stop firing alarms and timers by just saying "stop" without first saying the hotword.
         */
        supportsSimpleStop?: boolean | null;
        /**
         * Whether the device supports speaker-id (speaker identification based on hotword and/or spoken query - go/speaker-id). Note: there are existing devices that support speaker-id but does not have this capability set. Not having this field populated doesn't necessarily mean the device doesn't support speaker-id.
         */
        supportsSpeakerId?: boolean | null;
        /**
         * Whether the device supports WarmWords (go/warm-words-framework).
         */
        supportsWarmWords?: boolean | null;
    }
    /**
     * These capabilities represent what software features the client supports. This should be determined based on the client's various software versions (OS, GSA version, etc). Next ID: 27
     */
    export interface Schema$AssistantApiSoftwareCapabilities {
        /**
         * IMPORTANT: Only one of AppCapabilities and AppCapabilitiesDelta should be in the SoftwareCapabilities. In the edge case if the client sends up both AppCapabilities and AppCapabilitiesDelta, AppCapabilitiesDelta is ignored. Complete list of app capabilities.
         */
        appCapabilities?: Schema$AssistantApiAppCapabilities[];
        /**
         * Incremental update for app capabilities.
         */
        appCapabilitiesDelta?: Schema$AssistantApiAppCapabilitiesDelta[];
        /**
         * App integrations settings for each packge name.
         */
        appIntegrationsSettings?: {
            [key: string]: Schema$AssistantApiAppIntegrationsSettings;
        } | null;
        /**
         * Capabilities related to Assistant on Auto surfaces.
         */
        carAssistantCapabilities?: Schema$AssistantApiCarAssistantCapabilities;
        /**
         * Capabilities related to clock functionality, like alarms, timers, etc.
         */
        clockCapabilities?: Schema$AssistantApiClockCapabilities;
        /**
         * A top-level version of Conversation protocol where the versions are explicitly defined at go/conversation-versions.
         */
        conversationVersion?: Schema$AssistantApiSupportedConversationVersion;
        /**
         * For torus x-device execution support
         */
        crossDeviceExecutionCapabilities?: Schema$AssistantApiCrossDeviceExecutionCapability;
        gacsCapabilities?: Schema$AssistantApiGacsCapabilities;
        gcmCapabilities?: Schema$AssistantApiGcmCapabilities;
        /**
         * Capabilities related to live TV channels.
         */
        liveTvChannelCapabilities?: Schema$AssistantApiLiveTvChannelCapabilities;
        /**
         * List of actions OEM supports. This includes built-in actions and custom actions.
         */
        oemCapabilities?: Schema$AssistantApiOemCapabilities;
        /**
         * on-device Assistant capabilities
         */
        onDeviceAssistantCapabilities?: Schema$AssistantApiOnDeviceAssistantCapabilities;
        /**
         * Capability bits for on-device Smart Home. go/framework-for-local-semex
         */
        onDeviceSmartHomeCapabilities?: Schema$AssistantApiOnDeviceSmartHomeCapabilities;
        /**
         * Reflects the storage capabilities on the device.
         */
        onDeviceStorageCapabilities?: Schema$AssistantApiOnDeviceStorageCapabilities;
        /**
         * The operating system of the device.
         */
        operatingSystem?: string | null;
        /**
         * An ordered list containing the live tv providers available in the client. The order of the providers reflects the ranking in the client and will be respected by server as well.
         */
        orderedLiveTvProviders?: Schema$AssistantApiLiveTvProvider[];
        /**
         * The Soli capabilities on Elaine. go/dingo-dc-software
         */
        selinaCapabilities?: Schema$AssistantApiSelinaCapabilites;
        settingsAppCapabilities?: Schema$AssistantApiSettingsAppCapabilities;
        supportedClientOp?: Schema$AssistantApiSupportedClientOp[];
        supportedFeatures?: Schema$AssistantApiSupportedFeatures;
        supportedMsgVersion?: Schema$AssistantApiSupportedProtocolVersion;
        supportedProviderTypes?: Schema$AssistantApiSupportedProviderTypes;
        surfaceProperties?: Schema$AssistantApiSurfaceProperties;
    }
    /**
     * DEPRECATED These capabilities are associated with speech detection on devices.
     */
    export interface Schema$AssistantApiSpeechCapabilities {
        /**
         * A bool indicating whether device supports dsp based hotword detection.
         */
        dspAvailable?: boolean | null;
        /**
         * A bool indicating whether device supports unlocking device with hotword.
         */
        unlockWithHotwordAvailable?: boolean | null;
    }
    /**
     * Next ID: 18
     */
    export interface Schema$AssistantApiSuggestionsSupport {
        /**
         * Whether client supports user impersonation on suggestion chip click. go/suggestion-click-impersonation
         */
        clickImpersonationSupported?: boolean | null;
        /**
         * Whether client supports suggestions debug data to be displayed.
         */
        debugDataSupported?: boolean | null;
        /**
         * Whether DRL history chip is supported. Related bug: http://b/241837879, http://b/171854732 Design doc: http://go/panthera-history-chip-dd DRL history chip was originally rolled out to Panthera in http://google3/googledata/experiments/mobile/agsa/studies/agsa_nga/opa_panthera_one_input_ui_launch.gcl?l=55&rcl=384682900. We plan to roll it out to NGA and TNG. drl_history_chip_supported bit specifies whether the client support (and should have) DRL history chip.
         */
        drlHistoryChipSupported?: boolean | null;
        /**
         * Whether client supports escape hatches aka post execution suggestions go/nga-escape-hatch-prd
         */
        escapeHatchSupported?: string | null;
        /**
         * Whether the client can rewrite suggestion query text into executed text, if the latter is present. If this feature is disabled, the rewrite happens in Assistant Server.
         */
        executedTextSupported?: boolean | null;
        /**
         * Whether the client supports passing back `execution_context` from |assistant.api.client_op.SuggestionProcessingParams| when the suggestion is clicked or spoken.
         */
        executionContextSupported?: boolean | null;
        /**
         * Whether the client supports features in |SuggestionFeatureSpecificAction|.
         */
        featureSpecificActionSupport?: Schema$AssistantApiFeatureSpecificActionSupport;
        /**
         * Whether the client supports handling App Actions' notification when the suggestion is clicked. This will allow the server to populate the `app_actions_notification_data` extension field from |SuggestionFeatureSpecificAction| proto message.
         */
        featureSpecificAppActionsNotificationSupported?: boolean | null;
        /**
         * Whether the multi-step try saying suggestion feature is supported. dd: go/tng-multi-step-simplified
         */
        multiStepTrySayingSupported?: boolean | null;
        /**
         * Whether the rule_id field in the execution_context is supported. This is a temporary workaround to be able to identify clicks on Person entity suggestions on Sabrina and is expected to be eventually deprecated. TODO(b/185517153) : Deprecate (but do not delete) once click tracking is correctly sent up from the Katniss client.
         */
        ruleIdInExecutionContextSupported?: boolean | null;
        /**
         * Whether the client can show executed_text after the click on the suggestion chip. Must be set to false on TNG. TNG disregards |SuggestionProcessingParams.show_executed_text| field and always treats it as if |show_executed_text=true|.
         */
        showExecutedTextSupported?: boolean | null;
        /**
         * Whether the client can show chip as (text | translation). go/lang-partner-doc
         */
        showTranslationSupported?: boolean | null;
        /**
         * A list of suggestions display targets supported by this client. If unset only DEFAULT SuggestionDisplayTarget is supported.
         */
        supportedDisplayTargets?: Schema$AssistantApiSuggestionsSupportDisplayTargetSupport[];
        /**
         * Whether client supports widget suggestion chip to be displayed.
         */
        widgetDataSupported?: boolean | null;
    }
    export interface Schema$AssistantApiSuggestionsSupportDisplayTargetSupport {
        /**
         * Whether the client can rewrite suggestion query text into executed text, if the latter is present for the display target.
         */
        executedTextSupported?: boolean | null;
        /**
         * Whether PresentationParams.header_text is supported for the display target.
         */
        headerTextSupported?: boolean | null;
        /**
         * Whether Suggestion.repress_impression is supported. If not repressed suggestions are not returned.
         */
        repressImpressionSupported?: boolean | null;
        /**
         * Display target that is supported.
         */
        target?: string | null;
    }
    export interface Schema$AssistantApiSunriseFeaturesSupport {
        /**
         * If true, the device can slowly brighten the screen and simulate sunrise experience. Alarms with sunrise field enabled can be set on this device.
         */
        sunriseSimulationSupported?: boolean | null;
    }
    /**
     * These are the set of ClientOps that are supported by the device.
     */
    export interface Schema$AssistantApiSupportedClientOp {
        /**
         * This should be the same as the name of the SemanticClientOp that is supported.
         */
        clientOpName?: string | null;
        /**
         * The properties associated with the ClientOp. This proto should be associated with the client_op_name.
         */
        clientOpProperties?: Schema$AssistantApiProtobuf;
        supportedExecution?: Schema$AssistantApiSupportedClientOpSupportedExecution;
        /**
         * A version of 0 is the equivalent to not having support for that client_op type. Note that a client_op is also unsupported if it is not included at all in the list of supported client_ops.
         */
        version?: number | null;
    }
    /**
     * Additional properties that client can support for executing the client op. They are surface-specific execution properties and are unrelated to the execution model.
     */
    export interface Schema$AssistantApiSupportedClientOpSupportedExecution {
        /**
         * ClientOp execution supports special rendering behavior while the user is in the middle of expressing their query. This behavior includes: 1) New partial output always over-writes prior partial output. 2) Canceling the interaction removes partial fulfilment from any user visible interaction history. If this is true, whether to apply the special rendering behavior will be determined by PartialFulfillmentRenderingParams. More details can be found at go/ma-natcon-pf-api.
         */
        supportsPartialFulfillment?: boolean | null;
        /**
         * Client can support synchronous execution of the client op. For tts.OUTPUT client op it means that client would honor |synchronous_playback_args| argument. Please see more at go/synchronous-sounds-design.
         */
        supportsSynchronousExecution?: boolean | null;
    }
    /**
     * The overall Conversation Protocol version. As we make fundamental changes to Conversation protocol that are non-backwards compatible, we will increment the protocol version. By default, all clients will support version 0. All versions are documented at go/conversation-versions.
     */
    export interface Schema$AssistantApiSupportedConversationVersion {
        /**
         * Whether conversation protocol is supported explicitly. If true, SingleDeviceCapabilityChecker::SupportsConversationProtocol will always return true.
         */
        supportsConversationProtocol?: boolean | null;
        /**
         * The supported version number.
         */
        version?: number | null;
    }
    /**
     * These are the set of features that are supported by the device. It's a part of the SoftwareCapabilities of the device. Next ID: 68
     */
    export interface Schema$AssistantApiSupportedFeatures {
        /**
         * Whether the client supports the alternative message notification sources on AAE, in which case notification-related operations can access it.
         */
        aaeNotificationSourceSupported?: boolean | null;
        /**
         * In what way is assistant continued presence supported. (go/opa-acp-prd)
         */
        acpSupport?: Schema$AssistantApiAssistantContinuedPresenceSupport;
        actionV2SupportedFeatures?: Schema$AssistantApiActionV2SupportedFeatures;
        /**
         * Whether the client supports AlarmTimerManager API (go/alarm-timer-manager-api).
         */
        alarmTimerManagerApiSupported?: boolean | null;
        /**
         * The client information for app control support. More details in: go/acaia.
         */
        appControlSupport?: Schema$AssistantApiAppControlSupport;
        /**
         * Whether the client supports the assistant explore section. This field will be active only when the Explore section is available to the user. This means that the user is (a) signed-in, (b) a IOPA / AGSA user, and (c) in a locale where explore is available.
         */
        assistantExploreSupported?: boolean | null;
        /**
         * Whether Assistant for Kids (a.k.a. Designed for Family) features are supported.
         */
        assistantForKidsSupported?: boolean | null;
        /**
         * Whether communications flows for the client can bypass the DI/DC check. The client will enforce some other equivalent permission as necessary concerning access to device contacts and apps.
         */
        bypassDiDcCheckForComms?: boolean | null;
        /**
         * Whether or not Assistant should enforce the dismissal of communication notifications associated with messages.
         */
        bypassMsgNotificationDismissal?: boolean | null;
        /**
         * Whether the client supports 1m providers (go/1m-partner-expansion).
         */
        client1mProvidersSupported?: boolean | null;
        /**
         * Whether the client can batch client op results before sending them to the server.
         */
        clientOpResultBatchingSupported?: boolean | null;
        /**
         * Whether the client supports confirmation flow before announcement of multiple messages. If set to true the user will be prompted once and confirmation will be taken before all the messages are announced.
         */
        confirmationBeforeReadingMultipleMessagesSupported?: boolean | null;
        /**
         * Whether the client can render conversational care responses. go/conversational-care
         */
        conversationalCareSupported?: boolean | null;
        /**
         * Whether the client supports cross-device broadcast (i.e. on Torus).
         */
        crossDeviceBroadcastSupported?: boolean | null;
        /**
         * The version of cross device broadcast (ie; broadcast on torus) which the client supports.
         */
        crossDeviceBroadcastVersion?: string | null;
        /**
         * Whether the client supports csat visual overlay. (go/sd-od-csat)
         */
        csatVisualOverlaySupported?: boolean | null;
        /**
         * The features set which duo client on the device supports. This should be serialized from proto {@code duo_client_api.DuoClientApiFeatures\}.
         */
        duoClientApiFeatures?: string | null;
        /**
         * Whether the client supports Duo group calling.
         */
        duoGroupCallingSupported?: boolean | null;
        /**
         * Information about what support this device has for fitness.
         */
        fitnessFeatureSupport?: Schema$AssistantApiFitnessFeatureSupport;
        /**
         * Fluid Actions features supported by the client. If this field is not set in the incoming request, it could mean that the client does not support Fluid Actions. Alternatively, it could mean that the client supports Fluid Actions, but syncs state with server using the old protocol, namely ConversationStateParams. When b/140733618 is resolved, Surface Adaptation Layer will add this field for old clients that support Fluid Actions framework.
         */
        fluidActionsSupport?: Schema$AssistantApiFluidActionsSupport;
        /**
         * Whether the surface client op performer supports Funtime alarms and timers. go/funtime-engdesign
         */
        funtimeSupported?: boolean | null;
        /**
         * Whether account linking via Google Deep Integrations (GDI) is supported. go/opa-gdi-design
         */
        gdiSupported?: boolean | null;
        /**
         * Whether the client supports the Gearhead message notification source, in which case notification-related operations can access it.
         */
        gearheadNotificationSourceSupported?: boolean | null;
        /**
         * Whether the client has a physical radio installed.
         */
        hasPhysicalRadio?: boolean | null;
        /**
         * Whether the client supports confirmation messages in Immersive Canvas actions. Deprecated: use the filed in immersive_canvas_support.
         */
        immersiveCanvasConfirmationMessageSupported?: boolean | null;
        immersiveCanvasSupport?: Schema$AssistantApiImmersiveCanvasSupport;
        /**
         * Whether the client supports account linking in-dialog (askForSignIn). This is used before this feature is moved to conversation protocol. To support this, the client needs to: - Integrate with Google Deep Integrations. - Have logic to send the result of account linking back to AS.
         */
        inDialogAccountLinkingSupported?: boolean | null;
        /**
         * Whether paired-phone contact upload is needed for communications queries to work (e.g. on AAE).
         */
        isPairedPhoneContactUploadNeededForComms?: boolean | null;
        /**
         * Whether a Bluetooth-paired phone is a core component of communications flows on the client.
         */
        isPairedPhoneNeededForComms?: boolean | null;
        /**
         * Whether the client supports confirmation flow when a permission is missing. If set to true, the user will be prompted and on confirmation the original flow will continue.
         */
        justInTimeSupported?: boolean | null;
        /**
         * Which way of launching the keyboard the client supports.
         */
        launchKeyboardSupported?: string | null;
        /**
         * Whether the client has Google Lens (Assistant Eyes).
         */
        lensSupported?: boolean | null;
        /**
         * Whether the surface supports LiveCards. In cases where the user intent flow cannot be completed within the Assistant, LiveCards are used to take the user to an external app or website. These cards will be pushed to the Google Home app via the PushMessage ClientOp.
         */
        liveCardsSupported?: boolean | null;
        /**
         * Whether the client supports the Lottie animation library for the broadcast feature.
         */
        lottieAnimationSupport?: string | null;
        /**
         * Whether the client supports Assistant dialogs within Maps. This field will be set only when the Maps on the surface supports Assistant dialogs embedded within Maps. go/gsa-gmm.
         */
        mapsDialogsSupported?: boolean | null;
        /**
         * Whether the device supports masquerade mode (go/masquerade).
         */
        masqueradeModeSupported?: boolean | null;
        /**
         * Information about how client handles media controls (play, pause, skip ...)
         */
        mediaControlSupport?: Schema$AssistantApiMediaControlSupport;
        /**
         * The ability of the client to detect media sessions on the device.
         */
        mediaSessionDetection?: string | null;
        /**
         * Whether the client supports joining a Google Meet meeting.
         */
        meetSupported?: boolean | null;
        /**
         * Whether the client can render no input response or just ignore it. No input response is returned when client has a no speech input interaction, eg. user tapped mic but didn't say anything.
         */
        noInputResponseSupported?: boolean | null;
        /**
         * When the entry source is search, whether the client supports rendering a similar response as OPA one does. Entry source is defined at http://cs/symbol:assistant.api.params.DeviceProperties.EntrySource
         */
        opaOnSearchSupported?: boolean | null;
        /**
         * Whether or not the client supports enabling parental controls. When a device to supports parental controls, it has the software necessary to store the relevant information required for parental controls to work. This information includes a boolean "enabled bit" as well as the obfuscated gaia ID of the kid account selected for use with parental controls. Devices supportings kids mode send this information to S3 via S3ClientInfo in every request. See go/aff-kidsproduct for details.
         */
        parentalControlsSupported?: boolean | null;
        /**
         * Whether the client supports persistent display. The new feature allows Assistant devices with screen to display a continuously updating permanent display, such as ambient weather, without the need for a user to ask the Assistant. Design doc: go/assistant-persistent-display.
         */
        persistentDisplaySupported?: boolean | null;
        /**
         * Whether the client supports the privacy-aware lockscreen protocol (go/assistant-lockscreen-spec).
         */
        privacyAwareLockscreenSupported?: boolean | null;
        /**
         * Whether the client supports tts tapering for the read messages flow. If set to true the tapered tts variant would be used during the read messages flow.
         */
        readMessagesTtsTaperingSupported?: boolean | null;
        /**
         * Whether the client supports message summarization.
         */
        readNotificationSummarizationSupported?: boolean | null;
        /**
         * Whether the client has remote casting enabled. For ex: we want to disable this for clients like Auto.
         */
        remoteCloudCastingEnabled?: boolean | null;
        /**
         * Whether the Assistant Server should generate feedback suggestion chips.
         */
        serverGeneratedFeedbackChipsEnabled?: boolean | null;
        /**
         * Whether the client supports SmartHome lock screen logic (i.e. on Tangor).
         */
        shLockScreenSupported?: boolean | null;
        /**
         * Which kind of sign in the client supports.
         */
        signInMethod?: Schema$AssistantApiSignInMethod;
        /**
         * Whether the client can monitor sleep. This allows us to show sleep CUJ related information: go/TwilightDesign Use for development only, see the same field in DeviceCapabilities.SoftwareCapabilities.SelinaCapabilities.
         */
        sleepSensingSupported?: boolean | null;
        /**
         * Whether the client supports smart space cross-device timers. (go/ss-x-device-timer)
         */
        smartspaceCrossDeviceTimerSupported?: boolean | null;
        /**
         * Whether or not the client supports gesture detection via soli chips. The reason to prepend the name with soli is to distinguish it from computer vision based methods, e.g. Newman devices.
         */
        soliGestureDetectionSupported?: boolean | null;
        /**
         * Suggestion chips features, supported by the client.
         */
        suggestionsSupport?: Schema$AssistantApiSuggestionsSupport;
        /**
         * Whether the client supports the sunrise screen brightening feature before the alarm fires. This is used to indicate whether sunrise alarms can be set on the device. http://cs/symbol:assistant.api.core_types.governed.RingtoneTaskMetadata.GentleWakeInfo
         */
        sunriseFeaturesSupport?: Schema$AssistantApiSunriseFeaturesSupport;
        /**
         * Whether the client supports faster optimization for tap_to_read feature.
         */
        tapToReadOptimizationSupported?: boolean | null;
        /**
         * Whether the device supports the 3p GUI framework, which allows third parties to enter the conversation with the user, showing their logo next to their chat bubbles, etc. go/3p-phone
         */
        thirdPartyGuiSupported?: boolean | null;
        /**
         * Transactions features, supported by the client. Transactions feature may includes how Transactions team want to populate additional information from the device to the server.
         */
        transactionFeaturesSupport?: Schema$AssistantApiTransactionFeaturesSupport;
        /**
         * The version of transactions which the client supports.
         */
        transactionsVersion?: string | null;
        /**
         * If set, it indicates that the client can open a separate HTML browser/webviewer (full viewer) to display certain visual results. These visual results usually require more memory to render (e.g. high resolution photos). Compared to the regular viewer that display all other Assistant result, the full viewer does not have memory limit. The field is copied from the device model. See http://google3/assistant/devices_platform/proto/device_model_capabilities.proto?l=225&rcl=312576471 Also see go/webassistant-full-card-viewer.
         */
        usesSeparateFullViewer?: boolean | null;
        /**
         * Whether the client supports viewing of reminder hub page or not. Default is supported. Set to true to disable returning reminder hub page url in reminder responses.
         */
        viewReminderHubPageNotSupported?: boolean | null;
        /**
         * Whether the client supports the programmatic warm welcome tutorial. Design doc: go/opal-pww-design.
         */
        warmWelcomeTutorialSupported?: boolean | null;
        /**
         * Whether the supports opening a URL in a web browser. For example, we want to disable this for clients like Chirp.
         */
        webBrowserSupported?: boolean | null;
        /**
         * Whether or not the client supports WhatsNext in the protocol.
         */
        whatsNextSupported?: boolean | null;
        /**
         * Whether the client supports joining a Zoom meeting.
         */
        zoomSupported?: boolean | null;
    }
    /**
     * Contains versions of protocol buffer messages. This is the equivalence of a proto3 map, keyed by a protocol buffer message’s name, and the value is the version of this message. e.g. {"assistant.api.core_types.Timer": 2, "assistant.api.core_types.Alarm": 1\} See go/assistant-protocol-versioning for more details.
     */
    export interface Schema$AssistantApiSupportedProtocolVersion {
        messageVersion?: Schema$AssistantApiSupportedProtocolVersionMessageVersionPair[];
    }
    export interface Schema$AssistantApiSupportedProtocolVersionMessageVersionPair {
        /**
         * The full path of a message which should start from the package name. e.g. "assistant.api.core_types.Timer".
         */
        messageName?: string | null;
        /**
         * The supported version number.
         */
        version?: number | null;
    }
    /**
     * Types of providers that are supported by the client. For example, ChromeOS support both web app and Android app (for eligible devices).
     */
    export interface Schema$AssistantApiSupportedProviderTypes {
        supportedTypes?: string[] | null;
    }
    /**
     * Properties of the surface that are not hardware related or feature specific.
     */
    export interface Schema$AssistantApiSurfaceProperties {
        executionCapabilities?: Schema$AssistantApiSurfacePropertiesExecutionCapabilities;
        /**
         * Indicates if the surface prefers glanceable UI when rendering Assistant response. (see go/mobile-dr-hbird-glanceable-comms-cuj for more context).
         */
        prefersGlanceableUi?: boolean | null;
        /**
         * If this field is unset, the response format is unknown
         */
        responseDisplayFormat?: string | null;
        /**
         * If true, the client supports receiving multiple responses. See go/multiple-response-in-media-use-cases for more details.
         */
        supportsMultiResponse?: boolean | null;
    }
    /**
     * Describes the capabilities that are related to the execution of client ops on the device.
     */
    export interface Schema$AssistantApiSurfacePropertiesExecutionCapabilities {
        /**
         * Completes the preloading ie., sets up the stage for the execution of client ops on the device while the previous conv delta is being executed. Refer to go/preload-convdelta for more information.
         */
        supportsClientOpPreloading?: boolean | null;
        /**
         * A value of true indicates that the client supports streaming of non-finalized responses by use of ClientExecutionParams.response_stream_id. and ClientExecutionParams.to_be_finalized.
         */
        supportsNonFinalizedResponses?: boolean | null;
        /**
         * If true, the client supports receiving non-materialized interactions (go/as-streaming-protocol-nm).
         */
        supportsNonMaterializedInteractions?: boolean | null;
    }
    /**
     * Restrictions related to system-level notifications.
     */
    export interface Schema$AssistantApiSystemNotificationRestrictions {
        categoryState?: Schema$AssistantApiSystemNotificationRestrictionsNotificationCategoryState[];
        channelState?: Schema$AssistantApiSystemNotificationRestrictionsNotificationChannelState[];
        /**
         * Specifies whether the surface is able to display notifications.
         */
        notificationCapabilities?: string | null;
    }
    /**
     * Notification channels state for the new server driven channels.
     */
    export interface Schema$AssistantApiSystemNotificationRestrictionsNotificationCategoryState {
        /**
         * Notification channel type.
         */
        categoryId?: number | null;
        /**
         * Weather the notifications on this channel are disabled.
         */
        disabled?: boolean | null;
        disabledReason?: string | null;
    }
    /**
     * Notification channels state.
     */
    export interface Schema$AssistantApiSystemNotificationRestrictionsNotificationChannelState {
        /**
         * Notification channel type.
         */
        channelType?: string | null;
        /**
         * Whether the notifications on this channel are enabled.
         */
        enabled?: boolean | null;
    }
    /**
     * 3P Action Metadata. Next ID: 3
     */
    export interface Schema$AssistantApiThirdPartyActionConfig {
        /**
         * DeviceActionCapability from DeviceModelPackage.
         */
        deviceActionCapability?: Schema$AssistantDevicesPlatformProtoDeviceActionCapability;
        /**
         * List of Action project capabilities.
         */
        projectConfigs?: Schema$AssistantApiThirdPartyActionConfigProjectConfig[];
    }
    /**
     * Metadata for ActionPackage. Device Actions are disabled by default unless explicitly enabled for the device here, see go/3p-device-actions-v2-design.
     */
    export interface Schema$AssistantApiThirdPartyActionConfigProjectConfig {
        /**
         * Google cloud project id for which the Action Package or Device Model is registered.
         */
        projectId?: string | null;
    }
    export interface Schema$AssistantApiThirdPartyCapabilities {
        /**
         * Restrictions for the device to share any data with third party apps. See details in go/atv-dsc.
         */
        dataSharingRestrictions?: string | null;
    }
    /**
     * A civil time relative to a timezone.
     */
    export interface Schema$AssistantApiTimeOfDay {
        /**
         * The hour, in 0...23.
         */
        hour?: number | null;
        /**
         * The minute, in 0...59.
         */
        minute?: number | null;
        /**
         * The fraction of seconds in nanoseconds, in 0..999999999.
         */
        nanosecond?: number | null;
        /**
         * The second, in 0...59. Leap seconds are not supported.
         */
        second?: number | null;
    }
    /**
     * An absolute point in time independent of timezone or calendar, based on the proto3 Timestamp (//google/protobuf/timestamp.proto). NOTE: THIS IS NO LONGER RECOMMENDED TO BE USED. It was originally defined separately from google.protobuf.Timestamp due to incompatibility with proto2 syntax. The incompatibility issues have since been resolved and so the Google-wide standard representation of google.protobuf.Timestamp should be preferred. In fact, google.protobuf.* protos in general are now recommended to be used in new APIs.
     */
    export interface Schema$AssistantApiTimestamp {
        /**
         * Non-negative fractions of a second at nanosecond resolution.
         */
        nanos?: number | null;
        /**
         * Seconds of UTC time since the Unix epoch.
         */
        seconds?: string | null;
    }
    /**
     * A time zone. Conceptually, a time zone is a set of rules associated with a location that describes a UTC offset and how it changes over time (e.g. Daylight Saving Time). The offset is used to compute the local date and time.
     */
    export interface Schema$AssistantApiTimeZone {
        /**
         * Time zone in IANA format, e.g. America/Los_Angeles for USA Pacific Time.
         */
        ianaId?: string | null;
    }
    export interface Schema$AssistantApiTransactionFeaturesSupport {
        /**
         * If true, setting this boolean means the device should not support voice PIN. For example, although the phone supports both voice and PIN pad, but we don't want users using voice. https://docs.google.com/document/d/1M8iJQX3GuxGZGeidS8Gl4KJt3LuBWAIlolPlW10DkxU/edit#heading=h.8ovvdd3i2thv
         */
        voicePinSuppressed?: boolean | null;
    }
    export interface Schema$AssistantApiVolumeProperties {
        /**
         * The volume percentages for spelled out values.
         */
        defaultVolumePercentage?: number | null;
        highVolumePercentage?: number | null;
        /**
         * The number of levels to move for a step.
         */
        levelStepSize?: number | null;
        lowVolumePercentage?: number | null;
        /**
         * The max number of volume levels the client supports.
         */
        maximumVolumeLevel?: number | null;
        mediumVolumePercentage?: number | null;
        veryHighVolumePercentage?: number | null;
        veryLowVolumePercentage?: number | null;
    }
    /**
     * LINT.IfChange Identifier for an application provider. NOTE: AppProviderId contains surface-specific info, such as the Android package name of the application. This was necessary for supporting current use cases that rely on surface-specific info in feature code. Eventually we want to deprecate AppProviderId and fetch surface-specific info in some other way (e.g. in a surface-translation layer). But until then, we may continue extending AppProviderId with other surface-specific info.
     */
    export interface Schema$AssistantContextAppProviderId {
        /**
         * The activity class name. E.g. com.google.android.gm.ui.MailActivityGmail
         */
        activityClassName?: string | null;
        /**
         * Unique package name that identifies an Android app of the provider.
         */
        androidPackageName?: string | null;
        /**
         * Unique cast app id that identifies a Cast app of the provider.
         */
        castAppId?: string | null;
        /**
         * Version code of the application.
         */
        versionCode?: number | null;
    }
    /**
     * IMPORTANT: This proto is being migrated to ProviderId. If you are adding new field, please add to ProviderId as well.
     */
    export interface Schema$AssistantContextMediaProviderId {
        /**
         * Unique package name that identifies a Android app of the provider.
         */
        androidPackageName?: string | null;
        /**
         * Unique app id that identifies a Cast app of the provider.
         */
        castAppId?: string | null;
        /**
         * Unique package name that identifies a ChromeOS app of the provider.
         */
        chromeOsPackageName?: string | null;
        /**
         * Unique package name that identifies a Home app of the provider.
         */
        homeAppPackageName?: string | null;
        /**
         * Bundle identifier that identifies an iOS app of the provider.
         */
        iosBundleIdentifier?: string | null;
        /**
         * Unique package name that identifies a KaiOS app of the provider.
         */
        kaiOsPackageName?: string | null;
        /**
         * Each onboarded provider has a unique provider key. KG provider keys are string identifiers used to identify a provider in some Media backends since mids, names, etc can change.
         */
        kgProviderKey?: string | null;
        /**
         * The MID of the provider. A MID is a unique identifier issued by Knowledge Graph for all entities contained in its graph.
         */
        mid?: string | null;
        /**
         * Provider variant corresponding to the current MediaProviderId.
         */
        providerVariant?: Schema$AssistantContextProviderVariant;
        /**
         * Bundle id that identifies an Session Initiation Protocol (SIP) provider.
         */
        sipProviderId?: string | null;
    }
    /**
     * Identifier used to represent a single application (a.k.a. provider). This model represents the surface-agnostic counterpart for assistant.api.core_types.Provider. E.g. it should avoid directly using package names for Android, bundle identifiers for iOS, etc. We require the transformation between assistant.context.ProviderId and assistant.api.core_types.Provider to either be lossless, or "lossy yet retrievable" (e.g. if package name is not available in ProviderId, it can still be retrieved using the ProviderMappingsModule). NOTE: 1. As of May 2021, verticals are highly fragmented in terms of how they represent/identify a provider, and so we may need to accommodate some vertical-specific representations. However, these should be generalized as much as possible so that they can be used by other verticals if needed. 2. If we need to differentiate between whether a provider is a media provider, app actions provider, timer provider, etc. we should capture this information in the context proto that contains a ProviderId field, rather than in the ProviderId message itself. 3. Any common fields across different provider identifier representations (e.g. ecosystem type) should be part of assistant.context.ProviderId directly.
     */
    export interface Schema$AssistantContextProviderId {
        /**
         * TODO(b/241170835) Deprecate this field.
         */
        appProviderId?: Schema$AssistantContextAppProviderId;
        /**
         * Ecosystem type for this provider.
         */
        ecosystemType?: string | null;
        /**
         * DEPRECATED. Fields in MediaProviderId have been pulled out into separate fields in ProviderId and ProviderMetadata. TODO(b/243953766) Deprecate this field.
         */
        mediaProviderId?: Schema$AssistantContextMediaProviderId;
        /**
         * The MID of the provider. A MID is a unique identifier issued by Knowledge Graph for all entities contained in its graph.
         */
        mid?: string | null;
        /**
         * ID issued by the Provider Corpus to uniquely identify a provider entity e.g. an Android app, a Cast app or a Cloud provider. In practice, a single partner can have multiple providers entities. For more detail, see go/se-storage-provider-id. This is the preferred/ standardized ID to use for ProviderId that all use-cases should eventually migrate to.
         */
        providerCorpusId?: string | null;
        /**
         * Provider variant corresponding to the current provider. It's used together with mid to uniquely identify provider.
         */
        providerVariant?: Schema$AssistantContextProviderVariant;
    }
    /**
     * Identifies a business policy used for selecting a given content provider in the form of a name and a resulting scoring action.
     */
    export interface Schema$AssistantContextProviderSelectionPolicy {
        /**
         * Result of applying the policy.
         */
        policyAction?: string | null;
        /**
         * Name of the policy.
         */
        policyName?: string | null;
    }
    /**
     * Message that gets returned from the Provider Selection Library (PSL). It encodes the scores, applied policies, and pruning decisions for a given provider candidate.
     */
    export interface Schema$AssistantContextProviderSelectionResult {
        /**
         * Alternative bucketed score for use by downstream ranking providers. A raw numeric score is subject to semantic-drift, while a bucket is not.
         */
        bucketedFinalScore?: string | null;
        /**
         * Final score in the range [0,1] that can be used for ranking providers. Incorporates both policy rules and quality considerations.
         */
        finalScore?: number | null;
        /**
         * List of business policies applied to the candidate.
         */
        policyApplied?: Schema$AssistantContextProviderSelectionPolicy[];
        /**
         * Indicates whether the candidate should be pruned.
         */
        shouldPrune?: boolean | null;
    }
    /**
     * Note: As of May 2021, multiple providers use the same mids (e.g. YouTube Main, YouTube Go, and YouTube Music all have the same mids). However, quite often we end up using surface specific identifiers (e.g. Android package names, iOS bundle identifiers, etc.) to differentiate amongst them. This field allows us to move away from surface specific identifiers towards a surface-agnostic enum representing the same information.
     */
    export interface Schema$AssistantContextProviderVariant {
        emptyMidVariant?: string | null;
        spotifyVariant?: string | null;
        youtubeVariant?: string | null;
    }
    /**
     * Capability with regard to support of alarms by the client.
     */
    export interface Schema$AssistantDevicesPlatformProtoAlarmCapability {
        /**
         * Maximum number of alarms that can be created on the client. Zero or unset indicates no maximum limit.
         */
        maxSupportedAlarms?: number | null;
        /**
         * Whether the client restricts alarms to ring within the next 24 hours.
         */
        restrictAlarmsToNextDay?: boolean | null;
        /**
         * Whether the client supports mutation of any alarm attribute such as time_pattern, recurrence_pattern, etc through the MUTATE action. If this is false, MUTATE may only be used to disable or dismiss an alarm. This field is true by default for backwards-compatibility; clients which don't support mutation outside of Disable/DismissAlarm should explicitly set this to false.
         */
        supportsGenericMutations?: boolean | null;
        /**
         * Whether the client supports the STOP alarm action. If this is false, stop actions will be represented by the MUTATE action, and the device may need to check alarm state to determine if there's a firing alarm that needs to be dismissed.
         */
        supportsStopAction?: boolean | null;
    }
    export interface Schema$AssistantDevicesPlatformProtoArgSpec {
        intValueSpec?: Schema$AssistantDevicesPlatformProtoIntValueSpec;
        optionValueSpec?: Schema$AssistantDevicesPlatformProtoOptionValueSpec;
        type?: string | null;
    }
    export interface Schema$AssistantDevicesPlatformProtoCallCallCapability {
    }
    export interface Schema$AssistantDevicesPlatformProtoClientReconnectCapability {
    }
    /**
     * States the cloud capabilities of the device, i.e. the endpoint(s) to use for cloud execution of Actions or Registration.
     */
    export interface Schema$AssistantDevicesPlatformProtoCloudCapability {
        /**
         * The list of CloudEndpoints supported by this Device Model. Note that each should have a unique |name|. If any cloud endpoints are provided here, then the first one in the list will be used by default for all Cloud Execution. An Intent may override the default by providing an |execution_config|.
         */
        cloudEndpoints?: Schema$AssistantDevicesPlatformProtoCloudEndpoint[];
    }
    /**
     * A cloud endpoints associates with this device, it can be used for query parsing, or cloud execution.
     */
    export interface Schema$AssistantDevicesPlatformProtoCloudEndpoint {
        /**
         * The name for this cloud endpoint. It's unique per Locale. This is not an API resource name. Ex: sample-nlu-endpoint
         */
        name?: string | null;
        /**
         * The list of scopes to be provided in the OAuth2 token. They must be a subset of the scopes registered in the Account Linking flow, or the request will fail. If the client itself provides the token, then this field is ignored.
         */
        scopes?: string[] | null;
        /**
         * The URL for this endpoint, it must start with https.
         */
        url?: string | null;
    }
    export interface Schema$AssistantDevicesPlatformProtoCoreDismissAssistantCapability {
    }
    /**
     * This capability represents device action needed capability. Next ID: 10
     */
    export interface Schema$AssistantDevicesPlatformProtoDeviceActionCapability {
        /**
         * Integrate your device with Google's Smart Home solution by putting your device into Google's Home Graph, a database that stores and provides contextual data about the home and its devices. For example, Home Graph can store the concept of a living room that contains multiple types of devices, when you say "turn on the light" to a device, if you have light in the living room, that light will be turned on.
         */
        assistantDeviceInRoomOptOut?: boolean | null;
        /**
         * Specifies behavior for built-in device actions for this device model. If not specified, defaults to ENABLE_CONFIGURED_INTENTS_ONLY.
         */
        builtInIntentMode?: string | null;
        /**
         * Specifies which custom device actions should be enabled for this device model. This will only affect the behavior of intents corresponding to those from the Action Package of this project. If not specified, defaults to ENABLE_ALL.
         */
        customIntentMode?: string | null;
        /**
         * Default instructions for routing of any Intent. The data here could be overridden for specific Intents if provided directly in the 'intents' field.
         */
        defaultExecutionConfig?: Schema$AssistantDevicesPlatformProtoExecutionConfig;
        /**
         * Specifies capabilities for device actions that are inlined in the google.assistant.embedded.v1.DeviceAction message.
         */
        inlinedActionCapability?: Schema$AssistantDevicesPlatformProtoInlinedActionCapability;
        /**
         * Intent configurations. Built-in and custom intents may be configured here. Note that built-in intents will always behave with IntentMode of ENABLE_CONFIGURED_INTENTS_ONLY. The IntentMode for custom intents can be changed using the custom_intent_mode. To configure an intent, list it here with its intent name, e.g. "MY_CUSTOM_INTENT", "google.assistant.car.model.capabilities.AC_TEMPERATURE".
         */
        intents?: Schema$AssistantDevicesPlatformProtoIntent[];
        /**
         * Provided data which augments the device action capabilities. Some built-in intents may require additional configuration to be provided. One example could be the list of channels available for the `action.intent.SelectChannel` intent.
         */
        providedData?: Schema$AssistantDevicesPlatformProtoProvidedData[];
        /**
         * List of built-in traits such as "action.devices.traits.OnOff" See java/com/google/home/graph/service/config/protoconf.pi As of Nov. 2017, we also support custom traits for EAP users. We'll eventually disable custom traits once custom actions are in place.
         */
        traits?: string[] | null;
        /**
         * Specifies the format how Google routes queries to 3P cloud. By default, this field is unset, all partners should get shallow NLU. This is needed *ONLY* for specific partners for strong business reasons.
         */
        understandingConfig?: Schema$AssistantDevicesPlatformProtoUnderstandingConfig;
    }
    export interface Schema$AssistantDevicesPlatformProtoDeviceModifySettingCapability {
        clientOpProperty?: Schema$AssistantApiClientOpPropertiesDeviceModifySettingClientOpProperty;
    }
    export interface Schema$AssistantDevicesPlatformProtoDeviceTakePhotoCapability {
    }
    /**
     * Specifies the routing capabilities of the Intent. It will apply only when the Intent is triggered. Next ID: 8
     */
    export interface Schema$AssistantDevicesPlatformProtoExecutionConfig {
        /**
         * Instructions for performing a cloud execution request for the Intent when the execution_type is set to CLOUD. If non-empty, then the device execution would be routed to the CloudEndpoint specified by this name. The Account Linking exchange may be performed to fetch the OAuth access token, and the access token will be included in the HTTP header.
         */
        cloudEndpointName?: string | null;
        /**
         * If this field is set, then the Syndication cloud call will be disabled for this intent. Note this only applies if any Syndication cloud endpoint is associated with the Device Model, otherwise setting this field does nothing. By default, all Intents that are enabled and supported by the Syndication API will be routed through the Syndication cloud endpoint if it's provided.
         */
        cloudIntentTranslationDisabled?: boolean | null;
        /**
         * Specifies the intent command format for this Action. For example, in order to launch an Android intent instead of receiving the device action payload on the client, then this field can be set with "intent:/#Intent;...;my_extra={$.params.channels[0].channelCode\};end" The parameter "{$.params.channels[0].channelCode\}" is in JSON path format, and will be replaced with the content from the original device action payload. Thus, with # JSON "execution": [ { "command": "action.devices.commands.SelectChannel", "params": { "channels": [{ "channelName": "exampleChannel", "channelCode": "1-1" \}] \} \} ] as the original action result, then the final result would look like "intent:/#Intent;...;my_extra=\"1-1\";end"
         */
        intentCommandFormat?: string | null;
        /**
         * If this field is set, then local execution capability is disabled for all matching intents.
         */
        localDisabled?: boolean | null;
        /**
         * Specifies how to execute this Action when it is invoked locally (from the same device.)
         */
        localExecutionType?: string | null;
        /**
         * If this field is set, then remote execution capability is disabled for all matching intents.
         */
        remoteDisabled?: boolean | null;
        /**
         * Specifies how to execute this Action when it is invoked remotely (from a different device.)
         */
        remoteExecutionType?: string | null;
    }
    export interface Schema$AssistantDevicesPlatformProtoExecutionWaitCapability {
    }
    export interface Schema$AssistantDevicesPlatformProtoInlinedActionCapability {
        /**
         * Specifies capabilities for handling on-device alarms. The presence of this field, even if empty, implies that the device supports alarms.
         */
        alarm?: Schema$AssistantDevicesPlatformProtoAlarmCapability;
        /**
         * Specifies the size limits on responses. If message is not defined then no limits exist.
         */
        responseLimits?: Schema$AssistantDevicesPlatformProtoResponseLimits;
        /**
         * Specifies capabilities for handling assistant.embedded.v1.DeviceOp.
         */
        supportedDeviceOps?: Schema$AssistantDevicesPlatformProtoSupportedDeviceOps;
        /**
         * Whether this device model package support sdk.EXECUTE client_op (a.k.a action.devices.EXECUTE intent), which will be filled into google.assistant.embedded.v1.DeviceAction.device_request_json. It is default to true (and not public), since all 3P will depends on the device_request_json. Only internal projects like Edoras will set this to false.
         */
        supportSdkExecute?: boolean | null;
        /**
         * Specifies whether server can send a series of responses for a single query. Example: Routines where multiple actions to be executed one after another.
         */
        supportsMultiResponse?: boolean | null;
        /**
         * Specifies capabilities for handling on-device timers. The presence of this field, even if empty, implies that the device supports timers.
         */
        timer?: Schema$AssistantDevicesPlatformProtoTimerCapability;
        /**
         * Specifies whether client supports receiving `DeviceAction.tts_output`.
         */
        ttsOutput?: Schema$AssistantDevicesPlatformProtoTtsOutputCapability;
    }
    /**
     * An intent configures the behavior of a device action for this device. Next ID: 7
     */
    export interface Schema$AssistantDevicesPlatformProtoIntent {
        /**
         * List of arguments associated this intent. Each of which depends a template for the expected argument.
         */
        argSpecs?: {
            [key: string]: Schema$AssistantDevicesPlatformProtoArgSpec;
        } | null;
        /**
         * Instructions for the routing of this Intent.
         */
        executionConfig?: Schema$AssistantDevicesPlatformProtoExecutionConfig;
        /**
         * The name of the intent.
         */
        name?: string | null;
        /**
         * List of provided data names used by this intent. Note that some built-in intents will not function properly without provided data, such as `action.intent.SwitchChannel` or `action.intent.AppSelector`.
         */
        providedDataNames?: string[] | null;
        /**
         * Security configuration for this Intent.
         */
        securityConfig?: Schema$AssistantDevicesPlatformProtoSecurityConfig;
        /**
         * The conditions which must be met by the device before executing this Intent. More than one can be provided, in which case the conditions operate with the "AND" operator, i.e. the first condition which is failed will be used to restrict the execution of this Intent.
         */
        triggerConditions?: Schema$AssistantDevicesPlatformProtoTriggerCondition[];
    }
    /**
     * Capabilities that may only be set internally. Only internal callers (i.e. Googlers or Google owned projects) will be able to set these, thanks to go/assistant-device-model-package-ownership.
     */
    export interface Schema$AssistantDevicesPlatformProtoInternalCapability {
        /**
         * When using the Assistant SDK (Embedded Assistant API), the project id used to authenticate the gRPC request is checked and must match against the project id of the Device Model. We will additionally allow the project ids listed in the device model here to be let through. See https://docs.google.com/document/d/1InAczpQJs6LCH1l--2yy67JM9hsBJbiL57fusnL3A8A
         */
        allowedAssistantSdkAuthProjectIds?: string[] | null;
        /**
         * Load the assistant.api.AppCapabilities from DEVICE_INSTALLED_APP footprint corpus. See go/edoras-geller.
         */
        appCapabilitiesFromDeviceInstallApps?: boolean | null;
        /**
         * Uses this endpoint for device action fulfillment when there's no endpoint in syndication_metadata. 1p surfaces/devices such as telephone can enable this for its cloud action fulfillment without enabling the whole syndication experience.
         */
        cloudDeviceActionEndpoint?: Schema$AssistantDevicesPlatformProtoCloudEndpoint;
        /**
         * Signals that the model will have updated ranking behavior as described in https://docs.google.com/document/d/1SN_AgadRr_cdIrFe-qgRbIX2J1sOE7lcRXAvM1GUPoU.
         */
        deviceActionsEligibleForHighConfidence?: boolean | null;
        /**
         * Make Google sign-in mandatory for using Google Assistant on the device. (This bit is initially added for Samsung TV.)
         */
        forceSignIn?: boolean | null;
        /**
         * When looking up device (for example for disclosure consent check), then always use the third party device id for lookup instead of any other device id which would normally have higher precedence, such as cast_device_id.
         */
        forceThirdPartyDeviceIdForDeviceLookup?: boolean | null;
        /**
         * Adds "transactions.AUTHENTICATION" for car automation probers. Since the probers run as Assistant SDK requests, voice match always fails for car automation requests, so we add this client op as a hack to allow probers to appear as personal devices and bypass voice match. See b/137221645.
         */
        forceTransactionsAuthentication?: boolean | null;
        /**
         * Signals that this device can "render" raw search results even with no screen (e.g., using a text reader). If this is true, fallback search results can be returned as a custom device action in a SearchResults message. http://google3/assistant/embedded/proto_translation/utils/proto/search_results.proto
         */
        hasCustomSearchResultsRendering?: boolean | null;
        /**
         * When looking up device (for example for disclosure consent check), use this project id as part of the primary key for the device lookup (i.e. instead of the device_config.agent_id.) The precedence is as follows: 1) this field, if set for the device's device model 2) device_config.agent_id 3) device_model.project_id
         */
        overrideProjectIdForDeviceLookup?: string | null;
        stadiaAssistantConfig?: Schema$AssistantDevicesPlatformProtoInternalCapabilityStadiaAssistantConfig;
        /**
         * Telephone server is able to send attribution to user feature phone. See go/telephone-attribution.
         */
        telephoneAttribution?: boolean | null;
    }
    /**
     * The StadiaAssistantConfig. This field should only be set if the device model is a Stadia.
     */
    export interface Schema$AssistantDevicesPlatformProtoInternalCapabilityStadiaAssistantConfig {
        stadiaPlatform?: string | null;
    }
    export interface Schema$AssistantDevicesPlatformProtoIntValueSpec {
        maxValue?: string | null;
        minValue?: string | null;
    }
    export interface Schema$AssistantDevicesPlatformProtoMediaNextCapability {
    }
    export interface Schema$AssistantDevicesPlatformProtoMediaPauseCapability {
    }
    export interface Schema$AssistantDevicesPlatformProtoMediaPlayMediaCapability {
    }
    export interface Schema$AssistantDevicesPlatformProtoMediaPreviousCapability {
    }
    export interface Schema$AssistantDevicesPlatformProtoMediaResumeCapability {
    }
    export interface Schema$AssistantDevicesPlatformProtoMediaShowControlsCapability {
    }
    export interface Schema$AssistantDevicesPlatformProtoMediaStopCapability {
    }
    export interface Schema$AssistantDevicesPlatformProtoOptionValueSpec {
        values?: string[] | null;
    }
    /**
     * Provided data which augments the device action capabilities. Some built-in intents may require additional configuration to be provided. One example could be the list of channels available for the `action.intent.SelectChannel` intent.
     */
    export interface Schema$AssistantDevicesPlatformProtoProvidedData {
        name?: string | null;
    }
    export interface Schema$AssistantDevicesPlatformProtoProviderFulfillCapability {
    }
    export interface Schema$AssistantDevicesPlatformProtoProviderOpenCapability {
        clientOpProperty?: Schema$AssistantApiClientOpPropertiesProviderOpenClientOpProperty;
    }
    /**
     * Specifies the size limits on responses receivable by the client.
     */
    export interface Schema$AssistantDevicesPlatformProtoResponseLimits {
        /**
         * Max size in bytes of the total serialized AssistResponse receivable by the client. If response exceeds this max, response may be modified by the server.
         */
        maxAssistResponseSizeBytes?: number | null;
        /**
         * Maximum size in bytes (not characters) of text the display can handle (which may be different from how much the display can show at a time due to scrolling).
         */
        maxDisplayLinesBytes?: number | null;
        /**
         * Maximum size in bytes (not characters) for each suggestion chip.
         */
        maxSuggestionChipBytes?: number | null;
        /**
         * Maximum number of suggestion chips the device can handle to display.
         */
        maxSuggestionChips?: number | null;
    }
    /**
     * Encapsulates security configuration for a single intent of a device model.
     */
    export interface Schema$AssistantDevicesPlatformProtoSecurityConfig {
        /**
         * Specifies auth mechanism to be used upon remote request for device action.
         */
        authMechanismForRemoteRequests?: string | null;
    }
    export interface Schema$AssistantDevicesPlatformProtoSendChatMessageCapability {
    }
    /**
     * This message will specify supports for fields in |assistant.embedded.v1.DeviceOp|, for a device model package. See go/easi-client-op2 for more info. Next ID: 17
     */
    export interface Schema$AssistantDevicesPlatformProtoSupportedDeviceOps {
        /**
         * |call_call| specifies the support for the call.CALL clientop, and the corresponding call_call field in assistant.embedded.v1.DeviceOp.
         */
        callCall?: Schema$AssistantDevicesPlatformProtoCallCallCapability;
        /**
         * |client_reconnect| indicates support for client.RECONNECT using assistant.embedded.v1.DeviceOp. There is an alternative API/capability for client.RECONNECT specified in RoutineCapability.supports_reconnect. Client should choose between this and RoutineCapability but not both.
         */
        clientReconnect?: Schema$AssistantDevicesPlatformProtoClientReconnectCapability;
        /**
         * [core_dismiss_assistant] specifies the support for core.DISMISS_ASSISTANT client_op and the corresponding core_dismiss_assistant field in assistant.embedded.v1.DeviceOp.
         */
        coreDismissAssistant?: Schema$AssistantDevicesPlatformProtoCoreDismissAssistantCapability;
        /**
         * |device_modify_setting| specifies the support for device.MODIFY_SETTING client_op, and the corresponding device_modify_setting field in assistant.embedded.v1.DeviceOp.
         */
        deviceModifySetting?: Schema$AssistantDevicesPlatformProtoDeviceModifySettingCapability;
        /**
         * [device_take_photo] specifies the support for the device.TAKE_PHOTO clientop, and the corresponding device_take_photo field in assistant.embedded.v1.DeviceOp.
         */
        deviceTakePhoto?: Schema$AssistantDevicesPlatformProtoDeviceTakePhotoCapability;
        /**
         * |execution_wait| specifies the support for execution.WAIT client_op, and the corresponding execution_wait field in assistant.embedded.v1.DeviceOp.
         */
        executionWait?: Schema$AssistantDevicesPlatformProtoExecutionWaitCapability;
        mediaNext?: Schema$AssistantDevicesPlatformProtoMediaNextCapability;
        mediaPause?: Schema$AssistantDevicesPlatformProtoMediaPauseCapability;
        mediaPlayMedia?: Schema$AssistantDevicesPlatformProtoMediaPlayMediaCapability;
        mediaPrevious?: Schema$AssistantDevicesPlatformProtoMediaPreviousCapability;
        mediaResume?: Schema$AssistantDevicesPlatformProtoMediaResumeCapability;
        mediaShowControls?: Schema$AssistantDevicesPlatformProtoMediaShowControlsCapability;
        mediaStop?: Schema$AssistantDevicesPlatformProtoMediaStopCapability;
        /**
         * |provider_fulfill| specifies the support for provider.FULFILL client_op, and the corresponding provider_fulfill field in assistant.embedded.v1.DeviceOp.
         */
        providerFulfill?: Schema$AssistantDevicesPlatformProtoProviderFulfillCapability;
        /**
         * |provider_open| specifies the support for provider.OPEN client_op, and the corresponding provider_open field in assistant.embedded.v1.DeviceOp.
         */
        providerOpen?: Schema$AssistantDevicesPlatformProtoProviderOpenCapability;
        /**
         * |send_chat_message| specifies the support for the chat_message.SEND clientop, and the corresponding send_chat_message field in assistant.embedded.v1.DeviceOp.
         */
        sendChatMessage?: Schema$AssistantDevicesPlatformProtoSendChatMessageCapability;
    }
    /**
     * Capability with regard to support of timers by the client.
     */
    export interface Schema$AssistantDevicesPlatformProtoTimerCapability {
        /**
         * Maximum extended timer duration supported by the client. The extended timer duration is the total start-to-finish duration after an AddTimeToTimer operation. E.g. if a user sets a timer for 30 minutes, and later adds 10 minutes, the extended duration is 40 minutes. Zero or unset indicates no maximum limit.
         */
        maxSupportedExtendedTimerDuration?: Schema$AssistantApiDuration;
        /**
         * Maximum timer duration supported by the client. Zero or unset indicates no maximum limit.
         */
        maxSupportedTimerDuration?: Schema$AssistantApiDuration;
        /**
         * Maximum number of timers that can be created on the client. Zero or unset indicates no maximum limit.
         */
        maxSupportedTimers?: number | null;
        /**
         * Whether the client supports the MUTATE timer action. If this is false, mutate operations may be handled by sending a pair of REMOVE and CREATE timer actions to replace the existing timer instead of mutating it.
         */
        supportsMutateAction?: boolean | null;
    }
    /**
     * A TriggerCondition is described as a set of states which must be met by the device. It also includes instructions to the Assistant on what kind of response to execute when the condition is not met.
     */
    export interface Schema$AssistantDevicesPlatformProtoTriggerCondition {
        /**
         * The map of state keys along with their values which must be returned by the device, for example to start the dishwasher you may require states: {"door": "CLOSED", "detergent_status": "READY"\}.
         */
        requiredStateValues?: {
            [key: string]: Schema$AssistantDevicesPlatformProtoArgSpec;
        } | null;
        /**
         * A simple TTS to play.
         */
        simpleTts?: string | null;
        /**
         * Refers to a defined ConditionalResult keyed by its status. It could be a built-in or custom ConditionalResult for this Intent. Note: the states provided by the device MUST contain all of the states required by the ConditionalResult.
         */
        status?: string | null;
    }
    /**
     * Capabilities with regard to support of outputting TTS.
     */
    export interface Schema$AssistantDevicesPlatformProtoTtsOutputCapability {
        /**
         * Specifies whether client supports out-of-band TTS synthesis. When this is enabled, client could receive TTS request message in `SpeechOutputArgs.structured_tts` which it can then use to make request to S3 for synthesizing TTS audio.
         */
        supportsStructuredTts?: boolean | null;
    }
    /**
     * Specifies the NLU level that Google performs, which determines the request format sent to the 3P cloud.
     */
    export interface Schema$AssistantDevicesPlatformProtoUnderstandingConfig {
        /**
         * Specifies the NLU level for the intent.
         */
        nluLevel?: string | null;
    }
    /**
     * The information associated with an error while selecting the target device. Next ID: 2
     */
    export interface Schema$AssistantDeviceTargetingDeviceTargetingError {
        type?: string | null;
    }
    /**
     * Message containing the processed provider signals. This message is consumed by systems outside of the Provider GP, such as the HGR. For use of provider signals within the Provider GP, please refer to the CTF-governed PackedProviderSignals defined in: cs/google3/assistant/context/proto/packed_provider_signals.proto;rcl=486224300;l=68
     */
    export interface Schema$AssistantGroundingProviderProviderSignalResult {
        /**
         * Whether the provider is the default provider for the BII and entity type. Also known as the 'preferred_provider'.
         */
        isDefaultProvider?: boolean | null;
        /**
         * Whether the provider is currently open in the foreground on the device.
         */
        isForegroundProvider?: boolean | null;
        /**
         * Indicates that fulfillment on this provider will happen within the provider app
         */
        isInAppProvider?: boolean | null;
        /**
         * Whether the provider is installed, or otherwise reachable, from the device.
         */
        isInstalled?: boolean | null;
        /**
         * Whether the provider was the last-used provider for this intent on the device. Also known as the 'sticky_provider'.
         */
        isLastUsedProvider?: boolean | null;
        /**
         * Whether the provider was specified by the query.
         */
        isQueryRestrictedProvider?: boolean | null;
        /**
         * The result of running provider-selection on the provider candidate. This is populated by the Signal Extractor after the PSL has been run.
         */
        providerSelectionResult?: Schema$AssistantContextProviderSelectionResult;
        /**
         * Contains the "fulfillment type" of provider eg whether it's 0p or System API provider.
         */
        providerTypeSignal?: string | null;
    }
    export interface Schema$AssistantGroundingRankerAssistantInteractionFeatures {
        timeDecayed14dHalfLife?: number | null;
        /**
         * Frequency features.
         */
        timeDecayed1dHalfLife?: number | null;
        timeDecayed7dHalfLife?: number | null;
        timeDecayedAccepted14dHalfLife?: number | null;
        timeDecayedAuis14dHalfLife?: number | null;
        timeDecayedCanceled14dHalfLife?: number | null;
        timeDecayedDeclined14dHalfLife?: number | null;
        timeSinceLastButOneCanceledActionSecs?: number | null;
        timeSinceLastButOneCompletedActionSecs?: number | null;
        timeSinceLastButTwoCanceledActionSecs?: number | null;
        timeSinceLastButTwoCompletedActionSecs?: number | null;
        timeSinceLastCanceledActionSecs?: number | null;
        /**
         * Recency features.
         */
        timeSinceLastCompletedActionSecs?: number | null;
    }
    /**
     * Features to be passed from Contact GP to HGR. Next ID: 13
     */
    export interface Schema$AssistantGroundingRankerContactGroundingProviderFeatures {
        /**
         * Concept id for relationships in English, e.g. "Mother" for all non-English locales. It's only populated for source = RELATIONSHIP.
         */
        conceptId?: string | null;
        contactSource?: string | null;
        /**
         * Whether the query is a relationship query based on the annotation source.
         */
        isRelationshipFromAnnotation?: boolean | null;
        /**
         * Whether the contact has relationship in the contact metadata.
         */
        isRelationshipFromSource?: boolean | null;
        /**
         * Whether only populates a single candidate.
         */
        isSingleCandidate?: boolean | null;
        /**
         * Whether the contact is starred contact.
         */
        isStarred?: boolean | null;
        matchedNameType?: string | null;
        /**
         * Number of alternate contact names from fuzzy contact match. (Not suggest using it since it can change due to retrieval iteration)
         */
        numAlternateNameFromFuzzyContactMatch?: number | null;
        /**
         * Number of alternate contact names from S3_HYPOTHESES. (Not suggest using it since it can change due to retrieval iteration)
         */
        numAlternateNamesFromS3?: number | null;
        /**
         * Number of alternate contact names from interpretation. (Not suggest using it since it can change due to retrieval iteration)
         */
        numAlternativeNamesFromInterpretation?: number | null;
        /**
         * Number of contacts populated by the contact Grounding Provider. (Not suggest using it since it can change due to retrieval iteration)
         */
        numCandidates?: number | null;
        recognitionAlternateSource?: string | null;
    }
    /**
     * Device contact affinity from android call logs.
     */
    export interface Schema$AssistantGroundingRankerDeviceContactAffinityFeatures {
        aggregateAffinity?: number | null;
        callAffinity?: number | null;
        messageAffinity?: number | null;
    }
    /**
     * Features to be extracted from Device GP for ranking in HGR. Each candidate from Device GP will be associated with its own DeviceGroundingProviderFeatures. Next ID: 5
     */
    export interface Schema$AssistantGroundingRankerDeviceGroundingProviderFeatures {
        /**
         * ID for the device. This feature is needed specifically for PRR and it contains PII. Note that not every device has a corresponding DeviceId.
         */
        deviceId?: Schema$AssistantApiCoreTypesGovernedDeviceId;
        /**
         * Features generated by Device Targeting library (Lumos).
         */
        deviceTargetingFeatures?: Schema$AssistantGroundingRankerDeviceTargetingFeatures;
        /**
         * Labels tagged by Device Targeting library (Lumos).
         */
        deviceTargetingLabels?: Schema$AssistantGroundingRankerDeviceTargetingLabels;
        /**
         * The set of information that helps identify the surface.
         */
        surfaceIdentity?: Schema$AssistantApiCoreTypesGovernedSurfaceIdentity;
    }
    /**
     * Features generated by Device Targeting library (Lumos). See go/hgr-lumos-integration and go/lumos-feature-extraction for more details. Next ID: 3
     */
    export interface Schema$AssistantGroundingRankerDeviceTargetingFeatures {
        properties?: Schema$AssistantGroundingRankerDeviceTargetingFeaturesProperties;
        states?: Schema$AssistantGroundingRankerDeviceTargetingFeaturesStates;
    }
    /**
     * The properties of the device. They are static and won't change. Next ID: 4
     */
    export interface Schema$AssistantGroundingRankerDeviceTargetingFeaturesProperties {
        /**
         * The model ID of the device. This should be globally unique across manufacturers/OEMs.
         */
        deviceModelId?: string | null;
        /**
         * Indicate whether the device is owned by the user who is speaking.
         */
        isOwnedBySpeaker?: boolean | null;
        /**
         * Assistant surface type (ontology).
         */
        surfaceType?: string | null;
    }
    /**
     * The states of the device. They are dynamic and may change based on the current context. Next ID: 15
     */
    export interface Schema$AssistantGroundingRankerDeviceTargetingFeaturesStates {
        /**
         * The distance of the device relative to others that hear the user's OKG.
         */
        distance?: string | null;
        /**
         * Indicates that the device is running a media session that is currently buffering.
         */
        hasBufferingMediaSession?: boolean | null;
        /**
         * Indicates that the device is running a media session that is currently paused.
         */
        hasPausedMediaSession?: boolean | null;
        /**
         * Indicates that the device is running a media session that is currently playing.
         */
        hasPlayingMediaSession?: boolean | null;
        /**
         * Indicates whether or not the device is in the same room as any hearing devices. Does not consider the device itself or the local device as a hearing device. If no valid hearing devices, this field is not set.
         */
        inSameRoomAsHearingDevice?: boolean | null;
        /**
         * Indicates whether or not the device is in the same room as the local device. If the device is the local device, this field is not set.
         */
        inSameRoomAsLocalDevice?: boolean | null;
        /**
         * Indicates whether or not the device is in the same structure as any hearing devices. Does not consider the device itself or the local device as a hearing device. If no valid hearing devices, this field is not set.
         */
        inSameStructureAsHearingDevice?: boolean | null;
        /**
         * Indicates whether or not the device is in the same structure as the local device. If the device is the local device, this field is not set.
         */
        inSameStructureAsLocalDevice?: boolean | null;
        /**
         * Indicate whether the device is docked on a base.
         */
        isDocked?: boolean | null;
        /**
         * Whether the device is a local device, i.e. the device that heard OKG from a user and is processed by an assistant pipeline. If multiple devices heard OKG (MDA case), each hearing device would be considered a local device in its own assistant pipeline. Example: A user says "OKG, play music on TV" to Google Home, and music is played on the TV. Google home is considered a local device, while TV is considered a remote device. Timestamp of when the device was last used. Should correspond to when the AssistantRequestParams (in ASSISTANT_SNAPSHOT corpus) were last written for this device.
         */
        isLocal?: boolean | null;
        /**
         * Indicate whether the device is locked.
         */
        isLocked?: boolean | null;
        /**
         * Indicate whether the device is tethered to another device.
         */
        isTethered?: boolean | null;
        /**
         * Indicates the state of media focus from a separate non-local hearing device.
         */
        mediaFocusStateFromHearingDevice?: string | null;
        /**
         * Indicates the state of media focus from a separate local device.
         */
        mediaFocusStateFromLocalDevice?: string | null;
    }
    /**
     * Labels tagged by Device Targeting library (Lumos). See go/hgr-lumos-integration and go/lumos-feature-extraction for more details. Next ID: 2
     */
    export interface Schema$AssistantGroundingRankerDeviceTargetingLabels {
        /**
         * Indicate whether the device is selected by Lumos as the target device.
         */
        isSelectedByLumos?: boolean | null;
    }
    /**
     * Features to be extracted from Endpoint GP for ranking in HGR. Next ID: 2
     */
    export interface Schema$AssistantGroundingRankerEndpointGroundingProviderFeatures {
        /**
         * Proxy signal which tells whether the user provided a confirmation to a prompt or not. See http://shortn/_XnZAJBIiwG for more details.
         */
        isUserConfirmed?: boolean | null;
    }
    /**
     * Next ID: 7
     */
    export interface Schema$AssistantGroundingRankerGroundingProviderFeatures {
        contactGroundingProviderFeatures?: Schema$AssistantGroundingRankerContactGroundingProviderFeatures;
        deviceGroundingProviderFeatures?: Schema$AssistantGroundingRankerDeviceGroundingProviderFeatures;
        endpointGroundingProviderFeatures?: Schema$AssistantGroundingRankerEndpointGroundingProviderFeatures;
        mediaGroundingProviderFeatures?: Schema$AssistantGroundingRankerMediaGroundingProviderFeatures;
        podcastGroundingProviderFeatures?: Schema$AssistantGroundingRankerPodcastGroundingProviderFeatures;
        providerGroundingProviderFeatures?: Schema$AssistantGroundingRankerProviderGroundingProviderFeatures;
    }
    export interface Schema$AssistantGroundingRankerLaaFeature {
        name?: string | null;
        value?: number | null;
    }
    export interface Schema$AssistantGroundingRankerLaaFeatures {
        bindingSet?: Schema$AssistantGroundingRankerLaaFeaturesBindingSet;
        communicationEndpoint?: Schema$AssistantGroundingRankerLaaFeaturesCommunicationEndpoint;
        contact?: Schema$AssistantGroundingRankerLaaFeaturesContact;
        features?: Schema$AssistantGroundingRankerLaaFeature[];
        provider?: Schema$AssistantGroundingRankerLaaFeaturesProvider;
    }
    export interface Schema$AssistantGroundingRankerLaaFeaturesBindingSet {
        assistantInteractionFeatures?: Schema$AssistantGroundingRankerAssistantInteractionFeatures;
    }
    export interface Schema$AssistantGroundingRankerLaaFeaturesCommunicationEndpoint {
        assistantInteractionFeatures?: Schema$AssistantGroundingRankerAssistantInteractionFeatures;
    }
    export interface Schema$AssistantGroundingRankerLaaFeaturesContact {
        assistantInteractionFeatures?: Schema$AssistantGroundingRankerAssistantInteractionFeatures;
        deviceContactAffinityFeatures?: Schema$AssistantGroundingRankerDeviceContactAffinityFeatures;
    }
    export interface Schema$AssistantGroundingRankerLaaFeaturesProvider {
        assistantInteractionFeatures?: Schema$AssistantGroundingRankerAssistantInteractionFeatures;
    }
    /**
     * Features to be passed from Media GP to HGR. Next ID: 21
     */
    export interface Schema$AssistantGroundingRankerMediaGroundingProviderFeatures {
        /**
         * Release type for an album container.
         */
        albumReleaseType?: string | null;
        /**
         * Temporary ambiguity classifier signals.
         */
        ambiguityClassifier?: string | null;
        /**
         * Mid of the media item. This is currently only used in manual rules.
         */
        entityMid?: string | null;
        /**
         * True if the candidate has a CAST_VIDEO deeplink regardless of which provider was chosen.
         */
        hasCastVideoDeeplink?: boolean | null;
        /**
         * True if the argument's type was explicitly mentioned in the query.
         */
        hasTypeSemanticEdge?: boolean | null;
        /**
         * Whether the candidate is YouTube CAST_VIDEO candidate. CAST_VIDEO is a deeplink platform. This signal will be used to promote YouTube Music screenful candidates with CAST_VIDEO platform for free users because free users cannot get exact entities in screenless response and can get exact entities with ads in screenful response.
         */
        isCastVideo?: boolean | null;
        /**
         * True if the media item in Binding Set is exclusively available on the provider in Binding set. Example: "Stranger things" is exclusive to "Netflix".
         */
        isExclusiveOriginalProvider?: boolean | null;
        /**
         * True if the media search query is included in the entity name and artists.
         */
        isMediaSearchQuerySubsetOfEntityNameAndArtist?: boolean | null;
        isMostRecentSongAlbumAmbiguous?: boolean | null;
        /**
         * True if the media deeplink has tag SEED_RADIO.
         */
        isSeedRadio?: boolean | null;
        /**
         * True if the user requests seed radio.
         */
        isSeedRadioRequest?: boolean | null;
        /**
         * Provider is a self(user) reported subscripted provider https://g3doc.corp.google.com/knowledge/g3doc/ump/development/GetProviderAffinity.md?cl=head
         */
        isSelfReportedSvodProvider?: boolean | null;
        /**
         * Indicates whether this is youtube content seeking music.
         */
        isYoutubeMusicSeeking?: boolean | null;
        /**
         * Account Type of the user for the provider
         */
        mediaAccountType?: string | null;
        /**
         * MediaAquaAction::media_content_type from interpretation. It can be used for cross-content type ranking, for example, if a candidate's content type does not match this content type from interpretation, this candidate will be slightly demoted. Also, we might avoid fetching some signals when the content type is generic music, since some content types do not need ranking.
         */
        mediaContentType?: string | null;
        /**
         * MSC(Media Short Click) rate. MSC rate = total number of MSC events / total number of MSC candidates The event is considered as MSC candidate if the event is a media seeking query(excluding follow-ons) and the media result is successfully fulfilled. The event is MSC event if any of the following is in the following queries within 30 secs: FOLLOWED_BY_DUPLICATE FOLLOWED_BY_ADD_OR_DELETE_MANUAL_REFINEMENT FOLLOWED_BY_SAME_VERTICAL (MEDIA) FOLLOWED_BY_STOP More details: go/media-ranking, go/billboard-navboost, go/magma-music-actions-efrac
         */
        mscRate?: number | null;
        /**
         * Scubed predicted SAI value (pSAI - SCUBED_MUSIC_ACTIONS) for music populated by a regression model that incorporates a BERT model signal as well as other Scubed signals.
         */
        scubedPSaiMusic?: number | null;
        /**
         * Scubed predicted SAI value (pSAI - SCUBED_TVM_ACTIONS) for music populated by a regression model that incorporates a BERT model signal as well as other Scubed signals.
         */
        scubedPSaiTvm?: number | null;
        /**
         * Type of the media item.
         */
        type?: string | null;
        youtubeConfidenceScore?: number | null;
    }
    /**
     * Features to be extracted from Podcast GP for ranking in HGR. Next ID: 7
     */
    export interface Schema$AssistantGroundingRankerPodcastGroundingProviderFeatures {
        /**
         * Whether the podcast is exclusive to a provider a not.
         */
        isExclusive?: boolean | null;
        /**
         * The count of the unique users that listened to the podcast in the last 28 days.
         */
        podcastListenersCount?: number | null;
        /**
         * Provider popularity score. More details are here go/ps-to-kg.
         */
        popularityScore?: number | null;
        /**
         * The relevance score from Scubed.
         */
        scubedNg3ModelScore?: number | null;
        /**
         * Tstar score is a signal that indicates the quality of the entity.
         */
        scubedTstarScore?: number | null;
        /**
         * This score is in the range [0.0, 1.0] and is used for cross-backend (e.g., YT vs another Music/Podcast service provider) ranking and scoring. 0.0 means no confidence and 1.0 means full confidence.
         */
        youtubeConfidenceScore?: number | null;
    }
    /**
     * Features to be extracted from Provider GP for ranking in HGR. Next ID: 7
     */
    export interface Schema$AssistantGroundingRankerProviderGroundingProviderFeatures {
        /**
         * Cluster IDs for the provider. This field is repeated because some providers can be associated with multiple clusters. PRR specific feature.
         */
        providerClusterIds?: string[] | null;
        /**
         * ProviderId for the provider in the binding set. PRR specific feature.
         */
        providerId?: Schema$AssistantContextProviderId;
        /**
         * Provider signals extracted from Provider GP.
         */
        providerSignalResult?: Schema$AssistantGroundingProviderProviderSignalResult;
        /**
         * Provider quality score in the range [0,1] that can be used for ranking providers. Incorporates both policy rules and quality considerations.
         */
        pslScore?: number | null;
    }
    export interface Schema$AssistantLogsAllMediaStreamLog {
        /**
         * All active media streams while the user issues the query.
         */
        streams?: Schema$AssistantLogsMediaStreamLog[];
        /**
         * The stream selected by stream transfer logic to be transferred to another device. It will be empty for other features. Target_stream is different from target_device since target_stream could have multiple devices.
         */
        targetStream?: Schema$AssistantLogsMediaStreamLog;
    }
    /**
     * This message logs details on ambiguous device targeting logic. 1. It first takes a list of ambiguous devices 2. Then applies two filters: structure filter and playability filter. 3. If more than one device remains, it tiggers DeviceSelectionDialog to let the user pick one device.
     */
    export interface Schema$AssistantLogsAmbiguousTargetDeviceLog {
        /**
         * Device index of the initial ambiguous devices. The device index in this message is consistent with the device index in DeviceInfoLog. It would be used to track more detailed information of a device if needed.
         */
        ambiguousDeviceIndex?: number[] | null;
        /**
         * DeviceInfo for devices after the filters and promoters. - When device targeting is only configured for single target, these are ambiguous devices that would have been the output of Lumos. Downstream may perform extra check before disambiguation dialog. For example, Media Initiation checks playability for devices. The output here is before the check. - When configured for multi-target, these are just the target devices. For privacy consideration, we may only log device id field inside.
         */
        devicesAfterPromoters?: Schema$AssistantLogsDeviceInfoLog[];
        /**
         * the final targeted device selected by playability filter or DeviceSelectionDialog
         */
        finalTargetDevice?: Schema$AssistantLogsDeviceInfoLog;
        /**
         * Device index of the devices after playability filter
         */
        playabilityFilteredDevicesIndex?: number[] | null;
        /**
         * When there is no qualified devices after playability check, it would populate punt_info below. If all devices are filtered out for the same reason, there would only be one item. Otherwise, there will be multiple items.
         */
        puntInfoLog?: Schema$AssistantLogsAmbiguousTargetDeviceLogPuntInfoLog[];
        /**
         * Device index of the devices after structure filter
         */
        structureFilteredDeviceIndex?: number[] | null;
    }
    /**
     * PuntInfoLog is used to log why devices get filtered out during media content playability check. It contains media excuse, provider mid and also index of devices filtered by them.
     */
    export interface Schema$AssistantLogsAmbiguousTargetDeviceLogPuntInfoLog {
        /**
         * Index of devices that have the same punt info during playability check, i.e. same media_excuse and provider_mid.
         */
        deviceIndex?: number[] | null;
        /**
         * Excuse for media action triggering. See: assistant/verticals/media/proto/media_excuse.proto.
         */
        mediaExcuse?: number | null;
        /**
         * Provider id that the excuse belongs to. This is the KG MID of the provider, e.g., "/m/09jcvs" for Youtube.
         */
        providerMid?: string | null;
    }
    /**
     * This is the log version of apps.people.oz.external.mergedpeopleapi.DeviceContactInfo Next ID: 2
     */
    export interface Schema$AssistantLogsCommunicationDeviceContactInfoLog {
        /**
         * This list provides account information from the raw contact which is the source of this field.
         */
        rawContactInfo?: Schema$AssistantLogsCommunicationRawDeviceContactInfoLog[];
    }
    /**
     * This is the log version of fuzzy ngram match results that's used for generating the best fuzzy match. Next ID: 3
     */
    export interface Schema$AssistantLogsCommunicationFuzzyNgramMatchLog {
        relativeCost?: number | null;
        type?: string | null;
    }
    /**
     * From google3/quality/qrewrite/proto/account_provenance.proto;l=14 We need to copy this as the above proto has Enum field which is not compatible between proto2 and proto3. go/proto2-versus-proto3#enums
     */
    export interface Schema$AssistantLogsCommunicationGoogleAccountProvenance {
        email?: string | null;
        gaiaId?: string | null;
        isDasherAccount?: boolean | null;
    }
    /**
     * Contact meta data. Next ID: 30
     */
    export interface Schema$AssistantLogsCommunicationPersonalContactDataLog {
        /**
         * Google AccountProvenance of the contact.
         */
        accountProvenance?: Schema$AssistantLogsCommunicationGoogleAccountProvenance;
        /**
         * Populated if matched_name_type is GIVEN_NAME_ALIAS or FULL_NAME_ALIAS.
         */
        commonNameAliasConfidence?: number | null;
        /**
         * Concept id for relationships in English, e.g. "Mother" for all non-English locales. It's only populated for source = RELATIONSHIP.
         */
        conceptId?: string | null;
        /**
         * Integer value corresponding to DeviceContactExtraMetadata.Attribute enum. http://google3/social/graph/wire/proto/merged_person.proto?l=933&rcl=320308954
         */
        deviceContactAttributes?: number[] | null;
        /**
         * # emails stored for the contact.
         */
        emailIdCount?: number | null;
        /**
         * Populate only if ContactRecognitionAlternate.Source is 'FUZZY_CONTACT_MATCH'.
         */
        fuzzyNgramMatch?: Schema$AssistantLogsCommunicationFuzzyNgramMatchLog[];
        /**
         * Contact owner's gaia id from cs/symbol::symbol:quality_qrewrite.PersonalContactData.shared_contact_owner_gaia_id. Only populated for is_shared = true and non sign-out mode and user is not the owner of the contact(shared contact from other user). This field is not being logged in P2.
         */
        gaiaId?: string | null;
        /**
         * Boolean value indicating whether selected contact is from different account than the logged in account.
         */
        isContactFromSecondaryAccount?: boolean | null;
        /**
         * If this is a shared contact. This is true in 2 cases: - User is calling their own contacts that have been marked as shared. - User is calling shared contacts from some other user's contact list. This field is not being logged in P2.
         */
        isShared?: boolean | null;
        /**
         * Indicate the contact matches the transliterated query.
         */
        isTransliteratedMatch?: boolean | null;
        /**
         * True if the contact is a vanity contact(has email = user's email address).
         */
        isVanityContact?: boolean | null;
        /**
         * If the lookup was done using relationship which is visible to guests. This value will only be set if lookup was done using relationship. E.g. user has a guest relationship (doctor) -\> (John) And user says "call doctor", then this value will be true.
         */
        isVisibleToGuestsRelationship?: boolean | null;
        /**
         * The matched name type of a contact candidate.
         */
        matchedNameType?: string | null;
        /**
         * Alternate recognition term which was used to match this contact.
         */
        matchedRecognitionAlternateName?: string | null;
        /**
         * Ngram matched by starlight lookup for fuzzy matching in fulfillment. We need this to analyze how many contacts are returned by starlight lookup that is not matched by fuzzy matching. For example, "Komal Dear" is matched to "Komal Dr" by fuzzy match. When doing starlight lookup, "Komal" and "Dr" will be looked up separately. So "Dr xxx" will also be returned. We want to see how often this happens.
         */
        matchedStarlightLookupName?: string[] | null;
        /**
         * PersonMetadata of the selected contact.
         */
        metadata?: Schema$AssistantLogsCommunicationPersonMetadataLog;
        /**
         * The indices of the contact in |candidate_contact| whose name matches the |selected_contact_data|. |candidate_contact|: http://google3/logs/proto/assistant/contact.proto?l=111&rcl=306283376 |selected_contact_data|: http://google3/logs/proto/assistant/contact.proto?l=108&rcl=306283376
         */
        nameMatchedContactIndex?: number[] | null;
        /**
         * The original name in the query as transcribed by ASR.
         */
        originalQueryName?: string | null;
        /**
         * Information regarding the phone endpoints of the selected contact. Currently it is only logged for selected candidate.
         */
        phone?: Schema$AssistantLogsCommunicationPhoneLog[];
        /**
         * # phone_numbers stored for the contact.
         */
        phoneNumberCount?: number | null;
        /**
         * Encodes if pkg_person was resolved via a name or relationship reference.
         */
        pkgReferenceType?: string | null;
        /**
         * Populate only if ContactRecognitionAlternate.Source is not NONE.
         */
        recognitionAlternateScore?: number | null;
        /**
         * Recognition alternative source type. If not none, then it indicates the personal contact data is alternative and how the alternative is fulfilled.
         */
        recognitionAlternateSource?: string | null;
        /**
         * The number of resolved relationship names and contact pointers from Assistant Memory.
         */
        relationshipMemoryCount?: number | null;
        /**
         * Information regarding the selected phone endpoint. Currently it is only logged for selected candidate.
         */
        selectedPhone?: Schema$AssistantLogsCommunicationPhoneLog;
        /**
         * Shortcut information of the contact.
         */
        shortcutContactInfo?: Schema$MajelContactInformationShortcutInformation;
        /**
         * The contact source of a contact candidate.
         */
        source?: string | null;
        /**
         * Integer value corresponding to SystemContactGroup enum. http://google3/social/graph/wire/proto/merged_person.proto?l=3151&rcl=320308954
         */
        systemContactGroupId?: number[] | null;
        /**
         * DEPRECATED. Use phone instead. Used before 2020-01-13. Number of phone numbers annotated with Whatsapp.
         */
        whatsappPhoneNumberCount?: number | null;
    }
    /**
     * This is the log version of apps.people.oz.external.mergedpeopleapi.PersonMetadata Next ID: 2
     */
    export interface Schema$AssistantLogsCommunicationPersonMetadataLog {
        deviceContactInfo?: Schema$AssistantLogsCommunicationDeviceContactInfoLog[];
    }
    /**
     * This is the log version of apps.people.oz.external.mergedpeopleapi.Phone proto. Next ID: 3
     */
    export interface Schema$AssistantLogsCommunicationPhoneLog {
        /**
         * This list provides account information from the raw contact which is the source of this field.
         */
        rawDeviceContactInfo?: Schema$AssistantLogsCommunicationRawDeviceContactInfoLog[];
        /**
         * Label for phone number in the Contacts app. It can have standard values provided by the app e.g. MOBILE, HOME, WORK etc, but users are allowed to modify. So essentially it becomes user content.
         */
        type?: string | null;
    }
    /**
     * This is the log version of apps.people.oz.external.mergedpeopleapi.RawDeviceContactInfo proto. Next ID: 3
     */
    export interface Schema$AssistantLogsCommunicationRawDeviceContactInfoLog {
        /**
         * Account type of raw contact, e.g. "com.google" or "com.linkedin.android".
         */
        accountType?: string | null;
    }
    /**
     * Log device info of default speaker and tv
     */
    export interface Schema$AssistantLogsDefaultDeviceLog {
        defaultSpeaker?: Schema$AssistantLogsDeviceInfoLog;
        defaultTv?: Schema$AssistantLogsDeviceInfoLog;
        sourceDeviceId?: string | null;
    }
    export interface Schema$AssistantLogsDefaultDevicesLog {
        localDefaultDevices?: Schema$AssistantLogsDefaultDeviceLog;
        /**
         * Default settings of nearby devices.
         */
        nearbyDefaultDevices?: Schema$AssistantLogsDefaultDeviceLog[];
    }
    /**
     * Device annotation mention from query
     */
    export interface Schema$AssistantLogsDeviceAnnotationLog {
        /**
         * The raw text mentioning a device from the query, such as "any tv".
         */
        rawTextFromQuery?: string | null;
        /**
         * The annotation type mentioned in the query.
         */
        type?: string | null;
        /**
         * The matched device name set by the user, such as "big screen tv".
         */
        userDefinedName?: string | null;
    }
    /**
     * The information related to the device. Next ID: 18
     */
    export interface Schema$AssistantLogsDeviceInfoLog {
        /**
         * Device identifier string for the current device used in the arbitration service.
         */
        arbitrationDeviceId?: string | null;
        connectivity?: string | null;
        /**
         * The identification of the device. DeviceId (go/as-device-id) has multiple fields. To consloidate it to a single to make dremel easier, we use the string obtained by calling go/get-device-id.
         */
        deviceId?: string | null;
        /**
         * The identification of the device. The logging version of the full DeviceId.
         */
        deviceIdLog?: Schema$AssistantLogsSettingsDeviceIdLog;
        /**
         * We index linked devices and log these index to avoid logging device_id. device_index should always be a positive number or -1. -1 means this device is not in homegraph.
         */
        deviceIndex?: number | null;
        /**
         * This is the device_model_id field in device_settings proto. It has the same value for the same type of devices. e.g. Sonos.Sonos One.S13
         */
        deviceModelId?: string | null;
        /**
         * LINT.ThenChange(//depot/google3/assistant/context/proto/device_arbitration.proto:EstimatedRelativeDistance)
         */
        distance?: string | null;
        /**
         * The lumos processor which eliminated this device, if applicable
         */
        eliminatingLumosProcessor?: string | null;
        /**
         * The home structure id of the device.
         */
        homeStructureId?: string | null;
        isRemote?: boolean | null;
        /**
         * This flag indicates this is a non-local device that is tethered to local/originating device. Tethered device is a special case of is_remote and typically used in wearable scenarios. This is always false for local device and when it is true, it implies is_remote is also true.
         */
        isTethered?: boolean | null;
        mediaCapabilities?: Schema$AssistantLogsMediaCapabilities;
        mediaDeviceType?: string | null;
        /**
         * User defined device name
         */
        name?: string | null;
        /**
         * This field should be populated only when there is at least one session on this device.
         */
        sessions?: Schema$AssistantLogsDeviceMediaSessionLog[];
        /**
         * This field should be populated only when the device is an Assistant device.
         */
        surfaceType?: string | null;
    }
    /**
     * Log about the media session on a device.
     */
    export interface Schema$AssistantLogsDeviceMediaSessionLog {
        deviceId?: Schema$AssistantApiCoreTypesDeviceId;
        mediaSessionType?: string | null;
        /**
         * The type of the media session. If provider does not report this field, we ## compute it by mapping provider type to media type. Here is the mapping: |ProviderType |MediaItemMetadata.Type| |-------------------------------------- |MUSIC |TRACK | |VIDEO |VIDEO | |LIVE_TV |TV_CHANNEL | |AUDIOBOOK |AUDIO_BOOK | |PODCAST |PODCAST_EPISODE | ## |LIVE_STREAMING|VIDEO |
         */
        mediaType?: string | null;
        /**
         * The playback states of the session.
         */
        playbackState?: string | null;
        /**
         * The KG mid of the media provider.
         */
        providerMid?: string | null;
        supportedTransportControl?: string[] | null;
    }
    /**
     * Contains information logged in target device selection. See go/improve-device-targeting-logging for details. Next Id: 22
     */
    export interface Schema$AssistantLogsDeviceSelectionLog {
        /**
         * Default settings of all nearby devices Deprecated, use default_devices_log instead.
         */
        allDefaultDevices?: Schema$AssistantLogsDefaultDeviceLog[];
        /**
         * Logs all active media sessions.
         */
        allMediaStreamLog?: Schema$AssistantLogsAllMediaStreamLog;
        /**
         * DeviceSelectionLog for counterfactual logging.
         */
        counterfactualDeviceSelectionLog?: Schema$AssistantLogsDeviceSelectionLog;
        /**
         * Include default tv and default speaker Deprecated, use all_default_devices below.
         */
        defaultDevices?: Schema$AssistantLogsDefaultDeviceLog;
        defaultDevicesLog?: Schema$AssistantLogsDefaultDevicesLog;
        /**
         * Temporaray field for debugging ANDROID_AUTO multi_target_devices punt. This will be removed once we identify the root cause.
         */
        devicesStr?: string[] | null;
        inputErrorLog?: Schema$AssistantLogsInputErrorLog[];
        /**
         * Now we just log the media sessions on local device Deprecated, use NearbyDevicesLog::LocalDevice instead.
         */
        localDevice?: Schema$AssistantLogsDeviceInfoLog;
        /**
         * Indicates which library populated the device_selection_log for this query.
         */
        logDataSource?: string | null;
        /**
         * The Media Focus information. This field should be populated only when there is a Media Focus. Deprecated, use media_focuses below instead.
         */
        mediaFocus?: Schema$AssistantLogsMediaFocusInfoLog;
        /**
         * Media focuses on all devices.
         */
        mediaFocusesLog?: Schema$AssistantLogsMediaFocusesLog;
        /**
         * All nearby devices and local device.
         */
        nearbyDevicesLog?: Schema$AssistantLogsNearbyDevicesLog;
        /**
         * This should log the query annotation features found in the device, such as the device annotation, the room annotation, and the structure annotation from the query.
         */
        queryAnnotation?: Schema$AssistantLogsQueryAnnotationLog;
        /**
         * The result of device selection.
         */
        selectionResult?: Schema$AssistantLogsDeviceSelectionResultLog;
        testCodes?: Schema$AssistantLogsDeviceTargetingTestCode[];
    }
    /**
     * Log the selection result. Next ID: 11
     */
    export interface Schema$AssistantLogsDeviceSelectionResultLog {
        /**
         * Deprecated, please use qualified_devices.
         */
        ambiguousTargetDevices?: Schema$AssistantLogsAmbiguousTargetDeviceLog;
        deviceSelectionDecisionSummary?: Schema$AssistantLogsMediaDeviceSelectionDecisionSummary;
        deviceTargetingErrorType?: string | null;
        /**
         * The class name for the final filter/promoter used by Lumos for device targeting. This filter or promoter runs for all users, and contains no data specific to the individual user.
         */
        finalLumosStage?: string | null;
        /**
         * ////////////////////////////////////////////////////////////////////////// Ambiguous Results: the library failed to select the final target device(s) but it narrows down to a set of devices which are all valid target device candidates. The client needs to do further disambiguation, e.g., giving a dialog or having customized logic. The low confidence target device means the library falied to select the target device but it picked two devices for the client to do disambiguation.
         */
        lowConfidenceTargetDevice?: Schema$AssistantLogsLowConfidenceTargetDeviceLog;
        /**
         * ////////////////////////////////////////////////////////////////////////// This field log the error while selecting target device in media_focus_selector.
         */
        mediaFocusSelectionErrorType?: string | null;
        /**
         * The log for each stage of Lumos, showing the number of eliminated devices from each processor.
         */
        processorInfo?: Schema$AssistantLogsLumosProcessorInfo[];
        /**
         * We will apply several filters and dialogs to select a target device if media_focus_selector fail to select one. This field should log the devices left after each filter or dialog. It also log the detailed info of the final target device.
         */
        qualifiedDevices?: Schema$AssistantLogsAmbiguousTargetDeviceLog;
        /**
         * ////////////////////////////////////////////////////////////////////////// Unambiguous Results: the library successfully selected the final target device(s) and no further disambiguation is needed. Deprecated, please use target_device.
         */
        singleTargetDevice?: Schema$AssistantLogsDeviceInfoLog;
        targetDevice?: Schema$AssistantLogsTargetDeviceLog;
    }
    /**
     * Test code is used to track special events happening in Device Targeting Library. Next Id: 2
     */
    export interface Schema$AssistantLogsDeviceTargetingTestCode {
        type?: string | null;
    }
    export interface Schema$AssistantLogsInputErrorLog {
        errorCode?: number | null;
        errorType?: string | null;
    }
    /**
     * Represents the case where there is a target device with low confidence so that the library didn't directly target it. Instead, the library returns the low confidence target device and the fallback device for the client to decide to either trigger a dialog to disambiguate or select one of them based on extra business logic. Next ID: 3
     */
    export interface Schema$AssistantLogsLowConfidenceTargetDeviceLog {
        /**
         * The fallback device.
         */
        fallbackDeviceLog?: Schema$AssistantLogsDeviceInfoLog;
        /**
         * The selected low confidence focus device.
         */
        lowConfTargetDeviceLog?: Schema$AssistantLogsDeviceInfoLog;
    }
    export interface Schema$AssistantLogsLumosProcessorInfo {
        /**
         * Number of candidate devices after this stage is run.
         */
        devicesAfterRun?: number | null;
        /**
         * Number of candidate devices before this stage is run.
         */
        devicesBeforeRun?: number | null;
        /**
         * Name of the processor for this stage.
         */
        processorName?: string | null;
    }
    export interface Schema$AssistantLogsMediaCapabilities {
        canReceiveRemoteAction?: boolean | null;
        hasScreen?: boolean | null;
    }
    /**
     * A summary of the reasons that we chose a certain target device.
     */
    export interface Schema$AssistantLogsMediaDeviceSelectionDecisionSummary {
        deviceSelectionPreferenceUsed?: string | null;
        deviceSelectionReason?: string | null;
        miscSelectionSignal?: string[] | null;
    }
    /**
     * Following are the MDA compatible loggings for media focus, default settings and nearby devices.
     */
    export interface Schema$AssistantLogsMediaFocusesLog {
        dialogTriggered?: boolean | null;
        localMediaFocus?: Schema$AssistantLogsMediaFocusInfoLog;
        /**
         * Deprecated, use nearby_media_focuses instead.
         */
        mediaFocuses?: Schema$AssistantLogsMediaFocusInfoLog[];
        /**
         * MediaFouces found on nearby devices.
         */
        nearbyMediaFocuses?: Schema$AssistantLogsMediaFocusInfoLog[];
    }
    /**
     * The information related to Media Focus. TODO(b/138952173) Deprecate MediaFocusState in logs/proto/majel_gws/media_action_triggering_info.proto and assistant/verticals/media/proto/target_device_info.proto
     */
    export interface Schema$AssistantLogsMediaFocusInfoLog {
        /**
         * How long the device is in focus so far
         */
        currentFocusDurationSec?: number | null;
        /**
         * TODO(b/134944092) Log MediaFocusDialogTrigger Enum in focus_status.
         */
        dialogTriggered?: boolean | null;
        /**
         * LINT.ThenChange(//depot/google3/logs/proto/majel_gws/media_action_triggering_info.proto) The focus device.
         */
        focusDevice?: Schema$AssistantLogsDeviceInfoLog;
        /**
         * The media focus state at the time of the request.
         */
        mediaFocusState?: string | null;
        /**
         * The source device of media focus.
         */
        sourceDeviceId?: string | null;
    }
    /**
     * Media stream is composed of a media session and one or more devices which are hosting (playing) the session. Usually, a session is only hosted by one devcie. However, with cast group or stream transfer/expansion, a session could be hosted by multiple devices, which are playing the same session simultaneously.
     */
    export interface Schema$AssistantLogsMediaStreamLog {
        /**
         * The device index in this message is consistent with the device index in DeviceInfoLog. This field refers to the devices that hosting the session.
         */
        deviceIndex?: number[] | null;
        session?: Schema$AssistantLogsDeviceMediaSessionLog;
    }
    export interface Schema$AssistantLogsNearbyDevicesLog {
        /**
         * The timestamp that DeviceArbitration is created in milliseconds.
         */
        deviceArbitrationCreationTimestampMs?: string | null;
        /**
         * The timestamp that DeviceTargetingInput is built in milliseconds.
         */
        deviceTargetingInputCreationTimestampMs?: string | null;
        eliminatedByFurtherDistance?: number | null;
        eliminatedByLocalClosest?: number | null;
        eliminatedByUnknownDifferentRoom?: number | null;
        eliminatedByUnregisteredDevice?: number | null;
        localDevice?: Schema$AssistantLogsDeviceInfoLog;
        nearbyDevices?: Schema$AssistantLogsDeviceInfoLog[];
        numClosestDevices?: number | null;
        numEquallyCloseDevices?: number | null;
        numFurtherDevices?: number | null;
        numHearingDevices?: number | null;
        numUnknownDistanceDevices?: number | null;
    }
    /**
     * Provider annotation annotated from the query. These fields contain the detailed information for the provider. (e.g. for Youtube, package_names contains "com.google.android.youtube", localized_names contains "youtube", and lang contains "en" from "en-US" which depends on user's setting.)
     */
    export interface Schema$AssistantLogsProviderAnnotationLog {
        lang?: string | null;
        localizedNames?: string[] | null;
        packageNames?: string[] | null;
    }
    /**
     * Log about the query requirements
     */
    export interface Schema$AssistantLogsQueryAnnotationLog {
        /**
         * Deprecated, please use room_annotations.
         */
        deviceAnnotation?: Schema$AssistantLogsDeviceAnnotationLog;
        /**
         * Log the device annotations mentioned in the query.
         */
        deviceAnnotations?: Schema$AssistantLogsDeviceAnnotationLog[];
        /**
         * Log the provider annotations annotated from the query.
         */
        providerAnnotation?: Schema$AssistantLogsProviderAnnotationLog;
        /**
         * TODO(b/171250187) Deprecates the optional RoomAnnotationLog and DeviceAnnotationLog. Deprecated, please use device_annotations.
         */
        roomAnnotation?: Schema$AssistantLogsRoomAnnotationLog;
        /**
         * Log the room annotations mentioned in the query.
         */
        roomAnnotations?: Schema$AssistantLogsRoomAnnotationLog[];
        /**
         * Log the structure annotations mentioned in the query.
         */
        structureAnnotations?: Schema$AssistantLogsStructureAnnotationLog[];
    }
    /**
     * Annotate a single reminder instance.
     */
    export interface Schema$AssistantLogsReminderLog {
        /**
         * The reminder is created N seconds ago. This helps tracking how the user issues follow-up actions after reminder is created. For example, whether the user likes to issues another [show reminders] query right after reminder is created?
         */
        createdSecondsAgo?: string | null;
        /**
         * If the reminder is retrieved by a ranking class (see go/opa-reminders-ranker), this will be populated with the class info. Refer to assistant.productivity.ReminderRankingClass.RankingType. Since that proto is in proto2 format, we can only wire by int type.
         */
        retrievedRankingClass?: number | null;
    }
    /**
     * Room annotation mentioned in query.
     */
    export interface Schema$AssistantLogsRoomAnnotationLog {
        /**
         * The raw text mentioning a room from the query, such as "my living room".
         */
        rawTextFromQuery?: string | null;
        /**
         * The number of rooms annotated, if there are multiple structures. They are guaranteed to have the same text_from_query and name due to exact matching.
         */
        roomCount?: number | null;
        /**
         * The annotation type mentioned in the query.
         */
        type?: string | null;
        userDefinedName?: string | null;
    }
    /**
     * The logging-version of DeviceId proto, which identifies a device. This mirrors cs/google3/assistant/api/core_types/device_type.proto?q=symbol:DeviceId Next ID: 6
     */
    export interface Schema$AssistantLogsSettingsDeviceIdLog {
        /**
         * The client_instance_id on devices with GSA. See 'client_instance_field' in go/androidids.
         */
        agsaClientInstanceId?: string | null;
        /**
         * A unique device ID for Assistant devices as proposed by go/ocelot-team.
         */
        canonicalDeviceId?: string | null;
        /**
         * If set, indicates that the device is a cast device, and contains the UUID of the cast device. Corresponds to the device_id field of the CastDevice proto.
         */
        castDeviceId?: string | null;
        /**
         * DUSI (go/dusi) is used as the identifier here. This identifier is unique to the user and device. This will help identify which device or application the user's request originated from. This is not to be confused with the client_instance_id that android devices provide. This is currently used by surfaces that use the assistant-legacy-nexus and assistant-legacy-clockwork pipelines. DUSI is created and set in S3. This field is only filled for GAIA requests.
         */
        clientInstanceId?: string | null;
        /**
         * The unique device ID for HomeGraph devices. This is the HomeGraph ID, created when the device is registered into HomeGraph. It is immutable for the same device unless it is completely deleted and recreated. See go/home-graph for details. \}
         */
        homeGraphDeviceId?: string | null;
        /**
         * The unique ID for libassistant based devices.
         */
        libassistantDeviceId?: string | null;
    }
    /**
     * Structure annotation mentioned in query.
     */
    export interface Schema$AssistantLogsStructureAnnotationLog {
        /**
         * The raw text mentioning a structure from the query, such as "my house".
         */
        rawTextFromQuery?: string | null;
        /**
         * The annotation type mentioned in the query.
         */
        type?: string | null;
        userDefinedName?: string | null;
    }
    /**
     * Represents the case where the library successfully selects the target device. It could be one or multiple devices. Next ID: 4
     */
    export interface Schema$AssistantLogsTargetDeviceLog {
        devices?: Schema$AssistantLogsDeviceInfoLog[];
        lowConfidenceReason?: string | null;
        resultConfidenceLevel?: string | null;
    }
    export interface Schema$AssistantPfrDeviceRdMetadata {
        deviceName?: string | null;
        deviceTypes?: string[] | null;
        effectiveArgSpanLength?: number | null;
        /**
         * True if there are more than one possible resolutions to the RD.
         */
        hasAmbiguousResolutions?: boolean | null;
        /**
         * True if there's at least one device id that gets resolved. Note this is different from is_grounded = true: it is possible that is_grounded = false (num_grounded_args =0) but there is resolved device ids. E.g.: "turn on the blue light" Power_on(device_object = [d1, d2]:RD(category=DeviceObject(name='blue light')) where there are "blue light 1" and "blue light 2" hence two resolved device ids. But since the quantifier is single, GB can't resolve the ambiguity and would set num_grounded_args = 0 to indicate such unresolved ambiguity.
         */
        hasResolvedDeviceId?: boolean | null;
        roomName?: string | null;
    }
    /**
     * Used by the Smarthome Business Rules twiddler to determine whether to replace the top-scoring Smarthome intent with another.
     */
    export interface Schema$AssistantPfrSmartHomeIntentMetadata {
        /**
         * Each DeviceRdMetadata represents one device RD (device slot) in the intent. Note that each device RD could have multiple device groundings inside of it.
         */
        deviceRdMetadata?: Schema$AssistantPfrDeviceRdMetadata[];
        intentName?: string | null;
        /**
         * When num_constraints == num_constraints_satisfied, indicating all slot matchings are exact match.
         */
        isExactMatch?: boolean | null;
        /**
         * When num_grounded_args \> 0, indicating there is at least one top-level argument is grounded.
         */
        isGrounded?: boolean | null;
    }
    /**
     * Features used by the PrefulfillmentRanker's scorer exclusively to break ties.
     */
    export interface Schema$AssistantPfrTiebreakingMetadata {
        fingerprint?: string | null;
        sortedNameString?: string | null;
    }
    /**
     * Signals to be used by the Prefulfillment Ranker. Derived from the ParsingSignals and GroundingSignals carried by the FunctionCall. LINT.IfChange Next ID: 69
     */
    export interface Schema$AssistantPrefulfillmentRankerPrefulfillmentSignals {
        /**
         * Assistant User Interaction Score for binding set.
         */
        bindingSetAuis?: number | null;
        /**
         * BindingSet level invalid reason. This is only useful when the bindingset is invalid after running the horizontal check in HGR. More details: go/gb-infeasible.
         */
        bindingSetInvalidReason?: string | null;
        /**
         * Pauis score for the binding set
         */
        bindingSetPauis?: number | null;
        /**
         * BindingSet level validity. When one of the GPs returns invalid resolution, or the combined bindingset is invalid, this enum will indidate the validity. More details: go/gb-infeasible.
         */
        bindingSetValidity?: string | null;
        /**
         * A parsing score that is independently calibrated by each parser/IG.
         */
        calibratedParsingScore?: number | null;
        /**
         * Whether the intent is dominant according to NSP deep-media.
         */
        deepMediaDominant?: boolean | null;
        /**
         * Indicates interpretation dominance predicted by KScorer
         */
        dominant?: boolean | null;
        /**
         * The total effective length of the spans for the arguments used to construct the parse. May include vertical specific adjustments. Eg: For the query [delete my 7 p.m. alarm called chicken] and intent Delete_alarm(alarm_object=RD(category=AlarmObject( label="chicken", trigger_time_datetime=<< 7 PM \>\>))), the effective argument span is "7 p.m." + "chicken" (total length of 13).
         */
        effectiveArgSpanLength?: number | null;
        /**
         * Whether this is a fulfillable, dominant Media intent.
         */
        fulfillableDominantMedia?: boolean | null;
        /**
         * Whether or not the intent was generated by a legacy Aqua domain that PFR should care about.
         */
        generatedByLegacyAquaDomain?: boolean | null;
        /**
         * Grounding Signals. Score indicating how grounded the intent is, populated by the Grounding Box.
         */
        groundabilityScore?: number | null;
        /**
         * Grounding Provider related ranking features, including general Grounding Provider ranking features(shared among multiple GPs) and specific Grounding Provider ranking features(provided by a specific GP).
         */
        groundingProviderFeatures?: Schema$AssistantGroundingRankerGroundingProviderFeatures;
        /**
         * Whether the interpretation has a Search answer group object, signifying it came from Search resolution.
         */
        hasAnswerGroup?: boolean | null;
        /**
         * This is a cross-intent feature which is calculated by iterating all intent candidates. This feature should be populated in post-IG stage (before GB).
         */
        inQueryMaxEffectiveArgSpanLength?: number | null;
        /**
         * intent_name is used by PFR ensemble model. See go/pfr_ha_launch_doc
         */
        intentName?: string | null;
        /**
         * QUS intent-based ranking signals. Assistant User Interaction Score which is aggregated using intent name.
         */
        intentNameAuisScore?: number | null;
        /**
         * Assistant User Interaction Score which is aggregated using intent name from exp laelaps.
         */
        intentNameAuisScoreExp?: number | null;
        /**
         * Intent level Pauis User Interaction Score.
         */
        intentNamePauis?: number | null;
        /**
         * intent_type differentiates between intents that share the top level intent name. For eg: for TV_FALLBACK_SEARCH_INTENT, the top level intent name must be "Find_media" and the media_object argument within it must be of type "Media_unspecified".
         */
        intentType?: string | null;
        isDummyIntent?: boolean | null;
        /**
         * Feasibility of fulfilling the binding set. Eg: For PlayMedia, this is equivalent to playability. More details: go/hgr-feasibility-feature.
         */
        isFeasible?: boolean | null;
        /**
         * Whether the intent is fully grounded.
         */
        isFullyGrounded?: boolean | null;
        /**
         * Used for PFR manual rule to prefer high confidence podcast intent (e.g. topical, genre) over generic podcast intents.
         */
        isHighConfidencePodcastIntent?: boolean | null;
        /**
         * Whether the intent is a media control intent.
         */
        isMediaControlIntent?: boolean | null;
        /**
         * Whether this interpretation was genearted by NSP.
         */
        isNspIntent?: boolean | null;
        /**
         * Whether the intent is a PlayGenericMusic-type intent.
         */
        isPlayGenericMusic?: boolean | null;
        /**
         * Used for PFR manual rule to prefer high confidence podcast intent (e.g. topical, genre) over generic podcast intents.
         */
        isPodcastGenericIntent?: boolean | null;
        /**
         * Whether the intent is a podcast intent.
         */
        isPodcastIntent?: boolean | null;
        /**
         * Whether the intent is an intent marked disabled by the Sage IG.
         */
        isSageDisabledIntent?: boolean | null;
        /**
         * Whether the intent is produced by the Sage IntentGenerator invoked by the NSP intent-generator (thus, Sage-in-NSP-invoking_Sage, or Sage-in-Nage).
         */
        isSageInNageIntent?: boolean | null;
        /**
         * Whether this intent was generated by Sage.
         */
        isSageIntent?: boolean | null;
        /**
         * Whether this intent is a score-based intent, relying on PFR for scoring and pruning to the top intent.
         */
        isScoreBasedIntent?: boolean | null;
        /**
         * Whether the intent is a media object tvm intent.
         */
        isTvmIntent?: boolean | null;
        /**
         * Whether the intent is a Smarthome-domain intent with valid device arguments.
         */
        isValidSmarthomeIntent?: boolean | null;
        /**
         * Whether the intent is a media object video intent.
         */
        isVideoIntent?: boolean | null;
        /**
         * The rank order of the interpretation as determined by kscorer. The kscorer-determined dominant interpretation, if any, gets a rank of 0. The remaining N interpretations get a rank of 1 through N.
         */
        kscorerRank?: number | null;
        /**
         * Learn and adapt(go/laa) related features. Design doc: go/laa-profile-signal-for-grounding.
         */
        laaFeatures?: Schema$AssistantGroundingRankerLaaFeatures;
        /**
         * This feature is always false / no-op in serving time. In training time, this feature may be set true on specific examples for weighted training where when this signal is true, only cross-intent level features are used for training and other candidate level features are masked (set as missing).
         */
        maskCandidateLevelFeatures?: boolean | null;
        /**
         * The maximum score assigned by the Horizontal Grounding Ranker (HGR) across all of the intent's binding sets.
         */
        maxHgrScoreAcrossBindingSets?: number | null;
        /**
         * Rank of the intent as reported by NSP.
         */
        nspRank?: number | null;
        /**
         * Number of alternative hypotheses from speech recognition(S3).
         */
        numAlternativeHypothesis?: number | null;
        /**
         * Sum of the number of constraints used by the Grounding Box to ground each variable.
         */
        numConstraints?: number | null;
        /**
         * Sum of the number of constraints satisfied for each variable. Depending on the match score for a constraint, this number can be fractional and is in the range [0, num_constraints]. Populated by the Grounding Box.
         */
        numConstraintsSatisfied?: number | null;
        /**
         * Number of groundable arguments the intent has, populated by the Grounding Box.
         */
        numGroundableArgs?: number | null;
        /**
         * Number of grounded arguments the intent has, populated by the Grounding Box.
         */
        numGroundedArgs?: number | null;
        /**
         * Signals as proposed in go/improved-grounding-signals. Number of arguments, possibly nested, that the Grounding Box tried to ground.
         */
        numVariables?: number | null;
        /**
         * Number of arguments, possibly nested, that the Grounding Box was able to ground. This includes ambiguously grounded arguments.
         */
        numVariablesGrounded?: number | null;
        /**
         * A ID corresponding to which bucket a given parsing score belongs in.
         */
        parsingScoreMse8BucketId?: number | null;
        /**
         * Query understanding phase the intent was produced in.
         */
        phase?: string | null;
        /**
         * Whether the intent comes from the Sage IntentGenerator's "platinum" source, signifying high-confidence in quality.
         */
        platinumSource?: boolean | null;
        /**
         * Cosine similarity between predicted query-to-term model and assistant intent-type-based salient terms. This is intended to be only used for ACE ranking and only populated for assistant traffic.
         */
        pq2tVsAssistantIbstCosine?: number | null;
        /**
         * Cosine similarity between predicted query-to-term model and intent-type-based salient terms. This is intended to be used as a backoff to pq2t_vs_qibst_cosine if it is missing.
         */
        pq2tVsIbstCosine?: number | null;
        /**
         * Intent confidence predicted by the AssistantVerticalClassifier QRewrite servlet.
         */
        predictedIntentConfidence?: number | null;
        /**
         * Used in HGR to modify the ranker based on input experimental flag and intent name.
         */
        rankerName?: string | null;
        /**
         * The determination made by the SearchDispatchingConfig as to whether and how this interpretation should be dispatched to Search.
         */
        searchDispatch?: string | null;
        /**
         * SmartHome intent metadata used for the SmartHome business-rules twiddler.
         */
        smarthomeIntentMetadata?: Schema$AssistantPfrSmartHomeIntentMetadata;
        subIntentType?: string | null;
        tiebreakingMetadata?: Schema$AssistantPfrTiebreakingMetadata;
        /**
         * Average of per-word confidence for top speech recognition hypothesis. The value is from RecognizerHypothesisLog: http://google3/logs/proto/speech/service/recognizer_log.proto?l=848&rcl=281400256
         */
        topHypothesisConfidence?: number | null;
        /**
         * Whether the interpretation should run through grounding box or not.
         */
        usesGroundingBox?: boolean | null;
        /**
         * Horizontal feature that stores information about confidence scores for each resolution within the binding set.
         */
        verticalConfidenceScore?: number | null;
    }
    /**
     * A message to represent an item in a list. Just a basic string for now, but extensible for the future.
     */
    export interface Schema$AssistantProductivityListItem {
        /**
         * [REQUIRED] The name of the list item.
         */
        name?: string | null;
    }
    /**
     * Proto descrbing an attachment to an Assistant Reminder. If the attachment has different behavior on different surfaces (e.g., deeplinks), there will be multiple attachments attach to the Reminder. Each of them will specify the surface type and the corresponding deeplink.
     */
    export interface Schema$AssistantRemindersAttachment {
        /**
         * REQUIRED. An unique identifier for the attachment. We have a plan to index this field, so it's marked as REQUIRED. Chat with opa-reminders-eng@ if you have a use case without an attachment ID.
         */
        id?: string | null;
        link?: Schema$AssistantRemindersAttachmentLink;
        /**
         * REQUIRED. Surface types this attachment should be shown.
         */
        surfaceType?: string[] | null;
    }
    export interface Schema$AssistantRemindersAttachmentLink {
        /**
         * REQUIRED. The link to surface to frontends (e.g., Hubpage, notifications.) This could also be a surface-specific deeplink (be sure to set `surface_type` accordingly.)
         */
        linkUrl?: string | null;
        /**
         * REQUIRED. The text for the notification link button. Note: We cannot take nlp_generation.TemplateData yet due to cyclic dependency. The plan is to cut dependency from TemplateData to quality.actions.Reminder.
         */
        notificationText?: Schema$AssistantRemindersNlgTemplateKey;
    }
    /**
     * Since this is stored in BE, any update on this proto needs LGTM by ARIS storage owner
     */
    export interface Schema$AssistantRemindersMemoryPayload {
        /**
         * Whether the reminder created has a referenced_entity attached to it or not(go/hub-memory-payload). Since we plan to set this in Assistant reminder creation path flow, in case later the referenced_entity is removed from the reminder, then this bit might still remain true. Also in case referenced_entity is later added to reminder(for example when referenced_entity is attached by Server), then also this bit might remain false. This bit will be used to *guess* if the user has a memory-enabled AGSA, thus we'll surface the "open memory" button on hubpage. This check is not perfect, as the user might have other phones with older AGSA, so this is just a *best guess*. This field won't be stored in Memory backend, and will not be populated back when retrieving reminders.
         */
        hasReferencedEntityAtCreation?: boolean | null;
        /**
         * Id of record that is associated with Reminder. This will be set for all Assistant reminders created after the first launch of the Reminder Memory integration, see go/reminders-memory for more details. Also, this might apply to all other types of reminders.
         */
        recordId?: string | null;
    }
    /**
     * Equivalent to nlp_generation.TemplateKey. We cannot use nlp_generation.TemplateKey message directly becasue that proto is defined in a relatively large proto and has other dependencies, which will increase the size unnecessary and might hit many limitations (e.g., 5MiB limitation for Spanner type environment.).
     */
    export interface Schema$AssistantRemindersNlgTemplateKey {
        /**
         * REQUIRED.
         */
        messageSet?: string | null;
        /**
         * REQUIRED.
         */
        templateName?: string | null;
    }
    export interface Schema$AssistantTeleportTeleportNicknameSignals {
        /**
         * Whether the nickname could also refer to a location. For example, "walmart", "starbucks".
         */
        hasLocationInterpretation?: boolean | null;
        /**
         * Indicates whether the user has the app installed.
         */
        installInfo?: string | null;
        /**
         * True when the name is generic, i.e when it could refer to multiple packages from different developrs. For example, "mail" is considered a generic name (since it can refer to "gmail", "yahoo mail" etc.) but "facebook" although could refer to both "facebook" and "facebook lite" is not considered generic (both packages are from the same third party).
         */
        isGeneric?: boolean | null;
        /**
         * The tier of the nickname.
         */
        nicknameTier?: string | null;
        source?: string | null;
    }
    /**
     * Neural contact match signals.
     */
    export interface Schema$AssistantVerticalsCommonContactMatchSignal {
        /**
         * Neural contact match similarity score.
         */
        matchScore?: number | null;
    }
    /**
     * Metadata for Actions-on-Google configuration.
     */
    export interface Schema$AssistantVerticalsHomeautomationProtoActionProjectConfig {
        /**
         * Actions-on-Google action context ID. See go/sdm-hospitality-design.
         */
        contextId?: string | null;
    }
    /**
     * An agent + device pair that uniquely identifies a device.
     */
    export interface Schema$AssistantVerticalsHomeautomationProtoAgentDeviceId {
        /**
         * The agent's ID. Generally it is the agent's Google pantheon project id.
         */
        agentId?: string | null;
        /**
         * Device ID defined by the agent.
         */
        deviceId?: string | null;
    }
    /**
     * AgentInformation represents the details needed to support both 1P and 3P partnerships for Home Automation. Next ID: 7
     */
    export interface Schema$AssistantVerticalsHomeautomationProtoAgentInformation {
        authType?: string | null;
        deviceSource?: string | null;
        executionPath?: string | null;
        /**
         * Unique Agent ID which maps to a specific Agent. Not using Agent Name here as it may change over time.
         */
        id?: string | null;
        /**
         * Agent's foreign key that uniquely identifies a user's device.
         */
        key?: string | null;
    }
    /**
     * Protos representing device or structure attributes. See go/hgs-attributes-protos. Only protos approved and formalized by assistant/HG team should be added here.
     */
    export interface Schema$AssistantVerticalsHomeautomationProtoAttribute {
        structureBasedRoutine?: Schema$AssistantVerticalsHomeautomationProtoCommonStructureBasedRoutine;
    }
    /**
     * LINT.IfChange(proto_attributes)
     */
    export interface Schema$AssistantVerticalsHomeautomationProtoAttributes {
        attributeProtos?: Schema$AssistantVerticalsHomeautomationProtoAttribute[];
    }
    /**
     * LINT.IfChange(proto_event_trigger) Next id: 5
     */
    export interface Schema$AssistantVerticalsHomeautomationProtoCommonEventTrigger {
        enabled?: boolean | null;
        /**
         * Detailed settings for the event trigger; unset if not applicable.
         */
        eventTriggerPayload?: {
            [key: string]: any;
        } | null;
        /**
         * Different event type may have different settings. For example: * SCHEDULED will have event_trigger_payload of cs/symbol:assistant.verticals.voice_shortcut.proto.Schedule * LOCATION will have event_trigger_payload of cs/symbol:assistant.verticals.voice_shortcut.proto.LocationTriggerEvent
         */
        eventTriggerType?: string | null;
        /**
         * Unique identifier for the EventTrigger, e.g. SCHEDULED_ROUTINES. See the enum values of cs/symbol:WorkflowTriggerInput.TriggerSource
         */
        triggerSource?: number | null;
    }
    /**
     * Routines team stores the core Structure Based Routine data as the payload. We will add specific metadata on a per-need basis. LINT.IfChange(proto_structure_based_routine) Next id: 12 These two forms of payload are equivalent data in different formats and both will be stored in Home Graph. 1. The internal format will fan out to the DynamicEntity Footprints for read in Settings flow and Execution. 2. The UI format will be stripped out upon replication to DynamicEntity Footprints due to its redundancy and the Footprints data size limit, i.e. DE Footprints will only contain the internal format.
     */
    export interface Schema$AssistantVerticalsHomeautomationProtoCommonStructureBasedRoutine {
        /**
         * Whether this Routine is enabled or not. If false, then this Routine can't be triggered by Voice.
         */
        enabled?: boolean | null;
        /**
         * The unique identifier for a class of workflows. For example: * "sbr_001" =\> Away * "sbr_002" =\> Home * "category_template" =\> CUSTOM
         */
        googlePreconfigWorkflowId?: string | null;
        language?: string | null;
        /**
         * Internal format payload primarily for Routines team use.
         */
        payload?: {
            [key: string]: any;
        } | null;
        /**
         * The security level of the Structure Based Routine as determined by the most security-sensitive task.
         */
        securityLevel?: string | null;
        shared?: boolean | null;
        storagePayload?: {
            [key: string]: any;
        } | null;
        structureId?: string | null;
        /**
         * Voice or event triggers.
         */
        triggers?: Schema$AssistantVerticalsHomeautomationProtoCommonStructureBasedRoutineTrigger[];
        type?: string | null;
        /**
         * UI format payload primarily for external team use.
         */
        uiPayload?: {
            [key: string]: any;
        } | null;
    }
    /**
     * Next id: 3
     */
    export interface Schema$AssistantVerticalsHomeautomationProtoCommonStructureBasedRoutineTrigger {
        eventTrigger?: Schema$AssistantVerticalsHomeautomationProtoCommonEventTrigger;
        voiceTrigger?: Schema$AssistantVerticalsHomeautomationProtoCommonVoiceTrigger;
    }
    /**
     * LINT.IfChange(proto_voice_trigger) Next id: 2
     */
    export interface Schema$AssistantVerticalsHomeautomationProtoCommonVoiceTrigger {
        query?: string | null;
    }
    /**
     * The Concierge features a structure is eligible for. See {@link home.graph.common.ConciergeFeatures\}.
     */
    export interface Schema$AssistantVerticalsHomeautomationProtoConciergeFeatures {
        conciergeProductFeatures?: string[] | null;
    }
    /**
     * Next ID: 5
     */
    export interface Schema$AssistantVerticalsHomeautomationProtoDeviceTargetingOutputQueryInfo {
        /**
         * The query span for device mention.
         */
        annotatedSpanDevice?: string | null;
        /**
         * The query span for room mention.
         */
        annotatedSpanRoom?: string | null;
        /**
         * The query span for structure mention.
         */
        annotatedSpanStructure?: string | null;
        /**
         * This field is from query_info.processed_mentioned_span in DTO.
         */
        processedMentionedSpan?: string | null;
    }
    /**
     * Next ID: 9
     */
    export interface Schema$AssistantVerticalsHomeautomationProtoHomeAutomationDevice {
        /**
         * the next 3 fields are for Lumos output (DTO) that needs to be propagated to the Fulfilment through the HomeAutomationDevice proto.
         */
        deviceSelectionLog?: Schema$AssistantLogsDeviceSelectionLog;
        dtoError?: Schema$AssistantDeviceTargetingDeviceTargetingError;
        /**
         * This field is from query_info in DTO.
         */
        dtoQueryInfo?: Schema$AssistantVerticalsHomeautomationProtoDeviceTargetingOutputQueryInfo;
        /**
         * Device meta data.
         */
        homeautomationMetadata?: Schema$AssistantVerticalsHomeautomationProtoHomeAutomation_MetaData;
        /**
         * list of HomeAutomationDeviceItem. After migration completes, we will mark the above 4 field as deprecated and only use this field.
         */
        list?: Schema$AssistantVerticalsHomeautomationProtoHomeAutomationDeviceItem[];
        /**
         * Corresponding to casse matched_item CustomTypeItem key.
         */
        matchedItemKey?: string | null;
        /**
         * Corresponding to casse Argument raw_value.
         */
        matchedItemRawvalue?: string | null;
        /**
         * Corresponding to casse matched_item CustomTypeItem value.
         */
        matchedItemValue?: string[] | null;
    }
    export interface Schema$AssistantVerticalsHomeautomationProtoHomeAutomationDeviceItem {
        /**
         * Device meta data.
         */
        homeautomationMetadata?: Schema$AssistantVerticalsHomeautomationProtoHomeAutomation_MetaData;
        /**
         * Corresponding to casse matched_item CustomTypeItem key.
         */
        matchedItemKey?: string | null;
        /**
         * Corresponding to casse Argument raw_value.
         */
        matchedItemRawvalue?: string | null;
        /**
         * Corresponding to casse matched_item CustomTypeItem value.
         */
        matchedItemValue?: string[] | null;
    }
    /**
     * Next ID: 45
     */
    export interface Schema$AssistantVerticalsHomeautomationProtoHomeAutomation_MetaData {
        /**
         * Custom actions that this item supports.
         */
        actionProjectConfigs?: Schema$AssistantVerticalsHomeautomationProtoActionProjectConfig[];
        /**
         * Agent details.
         */
        agentInformation?: Schema$AssistantVerticalsHomeautomationProtoAgentInformation;
        /**
         * Device ID that matches the ID passed from the device to discourse_context when a user issues a query to an Assistant-enabled device that is registered with Cast (via CCS (see go/castservers)), or some other service.
         */
        assistantDeviceId?: string | null;
        /**
         * Attributes data as provided from SYNC. This gets used in mutation and execution and in some potential cases, in biasing.
         */
        attributes?: {
            [key: string]: any;
        } | null;
        /**
         * See Device.creator_gaia_ids in //home/graph/proto/service/types.proto. If empty, the GAIA ID from the request EUC is assumed to be the creator. We only need at most one creator_gaia_id.
         */
        creatorGaiaId?: string | null;
        /**
         * Any types that are not the given item type, but derived later. For example, if an item has type action.devices.types.OUTLET but is named "floor lamp" we can derive that it also has type action.devices.types.LIGHT. Also considered along with |type| when triggering type-based actions.
         */
        derivedType?: string[] | null;
        /**
         * See note in home_graph.proto; loaded into DE now to avoid having to double-read assistant settings records as per go/smarthome-removing-assistant-settings
         */
        deviceModelId?: string | null;
        /**
         * GCM address for cloud execution across google cloud messaging rather than 3p cloud.
         */
        gcmExecutionAddress?: string | null;
        /**
         * List of parent group IDs, if the device is added to one or multiple device groups (see go/home-groups). Will be consumed by Smart Home APIs and (in the future) Assistant CTF to populate the group member list of device groups.
         */
        groupIds?: string[] | null;
        /**
         * The hash value from go/de-consistency-check
         */
        hashValue?: string | null;
        /**
         * Whether local home platform should discover new devices via LAN for the structure.
         */
        lanscanOptedIn?: boolean | null;
        /**
         * Matter Unique ID. Contains VID/PID information
         */
        matterUniqueId?: Schema$AssistantVerticalsHomeautomationProtoMatterUniqueId;
        /**
         * Model name from HomeGraph, populated from model_manifest.model_name. See b/200087451.
         */
        modelName?: string | null;
        /**
         * Indicates whether notifications have been enabled by a user and will be announced for this device. This is set by the user within the Google app settings, and Google will announce the device notification only if both notification_supported_by_agent and notification_enabled_by_user are true.
         */
        notificationEnabledByUser?: boolean | null;
        /**
         * Indicates whether the device is capable of sending notifications. This field will be set by the agent (partner) on an incoming SYNC. If a device is not capable of generating notifications, the partner should set this flag to false. If a partner is not capable of calling ReportStateAndNotification to send notifications to Google, the partner should set this flag to false. If there is a user setting in the partner app to enable notifications and it is turned off, the partner should set this flag to false.
         */
        notificationSupportedByAgent?: boolean | null;
        /**
         * Store custom data for agent calls here. This will likely be short-lived -- we will replace this with calls to HGS. (Note: This may end up not temporary if we only need it for a couple partners -- more efficient to have it on a few users than require HGS reads for all users.
         */
        opaqueCustomData?: string | null;
        /**
         * Operational CHIP Node ID that combines the fabric ID and node id in format of . (Hex format without 0x prefix, for example, 0F001234FA67AA39.1234ABCD1111DDDD).
         */
        operationalNodeId?: string | null;
        /**
         * Other agent id + foreign id pairs associated with the device. This can be used to represent a group of devices (e.g. Sonos' bonded zone) as a single device, or a device that comes in through different sync flows (e.g. Newman with a Nest camera).
         */
        otherDeviceIds?: Schema$AssistantVerticalsHomeautomationProtoAgentDeviceId[];
        /**
         * Additional device sources. This can be the result of the device being merged with other devices with a different source.
         */
        otherDeviceSources?: string[] | null;
        /**
         * LINT.IfChange(home_graph_single_parent) At the moment, we just have a single string. In future this will expand with additional metadata from client or cloud execution data store. In today's 'tree' HomeGraph each object has a single parent. In the future this may have a mesh for complex cases -- zones, doors, etc -- so we make this a repeated element today. LINT.ThenChange(//depot/google3/assistant/assistant_server/settings/user_defined_actions/footprints/footprint_accessor.cc:home_graph_single_parent)
         */
        parentNode?: string[] | null;
        /**
         * The type of the parent. Currently only set for devices, to distinguish between structure and room parents. Items currently have only one parent, and entries after the first parent_type are ignored.
         */
        parentType?: string[] | null;
        /**
         * User-given nicknames for an entity (e.g. "My house"). These nicknames are unique to the gaia user. Nickname in DeviceInfo is per-entity level nickname, while personalized_nicknames is per-user per-entity.
         */
        personalizedNicknames?: string[] | null;
        /**
         * Stores the location for the STRUCTURE type.
         */
        physicalLocation?: Schema$AssistantVerticalsHomeautomationProtoPhysicalLocation;
        /**
         * We use this to determine if the synonyms matched in the aqua interpretation is plural. Then we will return disambiguate dialog or execute commands with all the targets.
         */
        plural?: string[] | null;
        /**
         * Which of the values was the original, user-provided name -- or our disambiguated, cleaned-up version of it. This is what we use in TTS when we need to identify an object that wasn't just spoken uniquely by the user -- in disambiguation dialogue, or in response to a collective interrogative (e.g. "what lights are on in the kitchen?")
         */
        primaryName?: string | null;
        /**
         * Whether device report state is out of sync with Query response.
         */
        reportStateStatus?: string | null;
        /**
         * User's role information for this device. This will be used in Home Automation server to decide if user has authority to fulfill its request.
         */
        roleInformation?: Schema$AssistantVerticalsHomeautomationProtoRoleInformation;
        /**
         * Only present for a target device. Indicates this target device is reachable by a local (AoGH) path via an AoGH device.
         */
        routableViaGcm?: boolean | null;
        /**
         * SAFT Document with linguistic annotations for the primary device name.
         */
        saftDocument?: Schema$NlpSaftDocument;
        /**
         * Data needed for SDM (fleet management). See go/enterprise-id-in-assistant.
         */
        smartDeviceManagementData?: Schema$AssistantVerticalsHomeautomationProtoSmartDeviceManagementData;
        /**
         * SmartHome feature flags that may be enabled per-item.
         */
        smartHomeFeatures?: Schema$AssistantVerticalsHomeautomationProtoSmartHomeFeatures;
        /**
         * The features that are available for a structure. Will only be populated if the item_type == STRUCTURE.
         */
        supportedStructureFeatures?: Schema$AssistantVerticalsHomeautomationProtoSupportedStructureFeatures;
        /**
         * Map from agent ID to supported traits. Some devices (e.g. Newman) have multiple agents, with each agent being associated with a specific set of traits. This could alternatively have been formatted as map as {trait, agent\} pairs instead of the {agent, list of trait\} pairs, but we retain this format to be consistent with HomeGraph's representation. In practice, a trait should only be paired with a single agent (i.e. we should not have two agents with the same trait in their value list). This field is optional and should only be provided if the item has multiple agents.
         */
        supportedTraitsByAgent?: {
            [key: string]: Schema$AssistantVerticalsHomeautomationProtoHomeAutomation_MetaDataSupportedTraits;
        } | null;
        /**
         * This device supports direct response -- if the device itself is issuing the query (which means it's also an assistant surface) we can return its payload directly rather than via cloud.
         */
        supportsDirectResponse?: boolean | null;
        /**
         * Only present for an AoGH device. HGS Device ID of a target device and the signal strength (RSSI in dB, higher is better) between that target device and the AoGH device. If this map is empty, there are no target devices reachable by this AoGH device.
         */
        targetDeviceSignalStrengths?: {
            [key: string]: string;
        } | null;
        /**
         * The timestamp at which the TDSS map was last updated. This information is used to help determine which hub would be preferred if multiple hubs report the same reach-ability for a device.
         */
        tdssUpdateTimestamp?: string | null;
        /**
         * For SHED devices, some traits can only be executed on 3P cloud, e.g. "action.devices.traits.MediaInitiation", "action.devices.traits.Channel" go/shed-per-trait-routing
         */
        traitRoutingHints?: Schema$HomeGraphCommonTraitRoutingHints[];
        /**
         * Map from traits to routing table. Metadata includes preferred execution path per trait and, when Matter is preferred, which endpoint should be used for the trait.
         */
        traitRoutingTable?: {
            [key: string]: Schema$HomeGraphCommonRoutingTable;
        } | null;
        /**
         * Map of trait to a proto representing the attribute. This is different from the attributes field above which is represented as a struct. The attributes here are represented as protos and will require specific support per trait.
         */
        traitToAttributeProtos?: {
            [key: string]: Schema$AssistantVerticalsHomeautomationProtoAttributes;
        } | null;
        /**
         * The item type, such as "action.devices.types.VACUUM" - to be used in triggering type-based actions, e.g. "start vacuuming": go/smarthome-type-based-actions.
         */
        type?: string | null;
        /**
         * The priority order of speech targeting: 1. user_defined_device_type 2. derived_device_type 3. device_type
         */
        userDefinedDeviceType?: string | null;
        /**
         * Set to which level of voice match is needed. Enum based on string input from the partner in json sync. Values accepted: "none" (but in this case partners won't set it), "owner" [requires matching one of the creator gaia IDs], or "member" [any recognized voice 'enrolled' on the device]. This may expand; only "owner" is in use for first partner, Tile.
         */
        voiceMatchRequired?: string | null;
        /**
         * This device will report state; we can query realtime state from local HGS rather than slow QUERY intent to the 3p cloud.
         */
        willReportState?: boolean | null;
        /**
         * SAFT Document with linguistic annotations for the zone name, if applicable.
         */
        zoneNameSaftDocument?: Schema$NlpSaftDocument;
    }
    export interface Schema$AssistantVerticalsHomeautomationProtoHomeAutomation_MetaDataSupportedTraits {
        traits?: string[] | null;
    }
    /**
     * Matter unique Id. These values are provided by the device.
     */
    export interface Schema$AssistantVerticalsHomeautomationProtoMatterUniqueId {
        productId?: number | null;
        uniqueId?: string | null;
        vendorId?: number | null;
    }
    export interface Schema$AssistantVerticalsHomeautomationProtoPhysicalLocation {
        address?: string | null;
        geoLocation?: Schema$GoogleTypeLatLng;
    }
    /**
     * Represents the user’s role such as assistant only or manager for a device. Design doc: https://docs.google.com/document/d/1c1hnauEbBfDkywO3GZkI8ejHP765l2tLspmPgckEe2Y/
     */
    export interface Schema$AssistantVerticalsHomeautomationProtoRoleInformation {
        /**
         * When true, role_type will be ignored, Nest IAM RPC will called to check authority.
         */
        iamCheckRequired?: boolean | null;
        roleType?: string | null;
    }
    export interface Schema$AssistantVerticalsHomeautomationProtoSmartDeviceManagementData {
        /**
         * The enterprise that owns the structure. E.g. Disney, Dream Hotel, etc. This is used for log/analytics purpose. For privacy reasons, we log at enterprise level instead of structure level.
         */
        enterpriseId?: string | null;
    }
    /**
     * SmartHome feature flags that may be enabled per-item. LINT.IfChange
     */
    export interface Schema$AssistantVerticalsHomeautomationProtoSmartHomeFeatures {
        /**
         * Flag indicating whether the background Circadian Lighting effect is enabled for a particular light (go/circadian-lighting-e2e).
         */
        circadianLightingEnabled?: boolean | null;
        /**
         * Flag indicating whether automatic Energy Savings are enabled for this item.
         */
        energySavingsEnabled?: boolean | null;
        /**
         * Flag indicating whether Gentle Wake Up is enabled for this item (go/sleep-wake-design).
         */
        gentleWakeupEnabled?: boolean | null;
        /**
         * Flag indicating whether the user has enabled / disabled sending Home/Away status updates to the device through the Google custom IntelligenceEvents Matter cluster. (go/google-clusters-design)
         */
        homeAwayOverMatterEnabled?: boolean | null;
    }
    /**
     * The features a structure supports.
     */
    export interface Schema$AssistantVerticalsHomeautomationProtoSupportedStructureFeatures {
        conciergeFeatures?: Schema$AssistantVerticalsHomeautomationProtoConciergeFeatures;
    }
    /**
     * Represents the properties of a mention. Next ID: 13
     */
    export interface Schema$AttentionalEntitiesMentionProperties {
        /**
         * The unique device on which the mention occurred. For example, if the user has two Google Home devices, this indicates which of the two was used.
         */
        deviceId?: Schema$AssistantApiCoreTypesDeviceId;
        /**
         * ID of the event that resulted in this entity mention. For user and system turn AEs, this is taken from the ConversationSnapshotId of the snapshot containing this mention. For client AEs, this is empty. This can be used to join back this particular mention to the specific "turn" in which this mention took place.
         */
        eventId?: Schema$EventIdMessage;
        /**
         * If this mention corresponds to a WebAnswer, then this defines the score associated with that answer.
         */
        factoidScore?: number | null;
        /**
         * If present, this entity was mentioned as part of a larger list.
         */
        listEntryInfo?: Schema$AttentionalEntitiesMentionPropertiesListEntryInfo;
        /**
         * Estimates the recency of the mention. This is internally computed at runtime on a turn-by-turn basis.
         */
        recency?: string | null;
        /**
         * The semantic role that the entity was used in.
         */
        role?: Schema$AttentionalEntitiesSemanticRoleId;
        /**
         * How salient this mention is. This field will only be set if the mention is derived from a SearchAnswerValue. See go/webresultsdata-as-aes for more details.
         */
        salience?: string | null;
        /**
         * Contains metadata about the source of the mention.
         */
        source?: Schema$AttentionalEntitiesMentionPropertiesSource;
        /**
         * If present, properties of visual mentions (e.g., how they are displayed to the user, visibility, etc.).
         */
        spatialProperties?: Schema$AttentionalEntitiesSpatialProperties;
        /**
         * Details about how this mention was presented.
         */
        surfaceForm?: Schema$AttentionalEntitiesSurfaceForm;
        /**
         * Unix timestamp noting (approximately) when this mention occurred. We do not guarantee that the time will correspond precisely to when the user uttered/heard a response. If mentions within a single turn have *different* timestamps, they should accurately reflect the order in which the mentions occurred. If that order is unknown, they should all have the same timestamp.
         */
        timestamp?: string | null;
    }
    /**
     * Contains information about how an entity was presented as part of a list.
     */
    export interface Schema$AttentionalEntitiesMentionPropertiesListEntryInfo {
        /**
         * The index of the entity presented to the user. NOTE: Indexing starts from 0.
         */
        index?: string | null;
        /**
         * A string which uniquely identifies the list item this entity represents in the list. For example, consider the "OrderPizza" intent with the "size" slot: U: I want to order a pizza A: Sure. What size do you want: large, medium, or small? U: Gigantic The lexical_groundings_id can be "large" to identify the large item in the list. This lexical_groundings_id together with the semantic role fields (i.e., role.intent_id & role.role_id) can be used to match the nlp_semantic_parsing::LexicalGroundings::ValueTermType to utilize lexical grounding for i18n of static list selection items. Note that this field only needs to be populated when developers expect to provide lexical groundings for the list item this entity represents. Effectively, this field will be populated when this entity is published by ListPresentationFrame and the ::quality::dialog_manager::IntentStageSignals::FieldCandidate.lexical_groundings_id field is populated. See go/lpf-i18nv2 & go/taskstate-ae-sync for more details.
         */
        lexicalGroundingsId?: string | null;
    }
    /**
     * The agent or system from which the mention was derived. Each mention corresponds to a single source.
     */
    export interface Schema$AttentionalEntitiesMentionPropertiesSource {
        client?: Schema$AttentionalEntitiesMentionPropertiesSourceClient;
        system?: Schema$AttentionalEntitiesMentionPropertiesSourceSystem;
        user?: Schema$AttentionalEntitiesMentionPropertiesSourceUser;
    }
    /**
     * The client provided this entity. Currently, this exclusively corresponds to an entity that was circulated by the client. See go/on-device-aes for more details.
     */
    export interface Schema$AttentionalEntitiesMentionPropertiesSourceClient {
    }
    /**
     * The Assistant mentioned this entity. This corresponds to entities annotated during fulfillment. More specifically, these entities are typically provided by developers either via a Monastery frame or an InteractionBuilder.
     */
    export interface Schema$AttentionalEntitiesMentionPropertiesSourceSystem {
    }
    /**
     * The user mentioned this entity. It was extracted from a previous winning intent (IntentQuery or IntentUpdate). Such entities are computed at runtime from the interpretation history without any developer intervention.
     */
    export interface Schema$AttentionalEntitiesMentionPropertiesSourceUser {
    }
    /**
     * Uniquely identifies a semantic role. When this role corresponds to a slot in a registered user intent (see go/assistant-intent-catalog), then the SemanticRoleId maps precisely onto that slot in the intent catalog. However, not all semantic roles corresponds to such user intent slots.
     */
    export interface Schema$AttentionalEntitiesSemanticRoleId {
        /**
         * Semantic roles will be defined locally, within the context of a single task/feature. The |intent_id| is a unique identifier for such a local cluster. In most cases, this should be exactly the same as the name of the intent used for TaskState (see go/assistant-intent-catalog). In cases where the intent isn't well-defined, this can be an arbitrary, feature-defined identifier.
         */
        intentId?: string | null;
        /**
         * Identifier for a semantic role, unique within the namespace of |intent_id|. When this role corresponds to a slot in the intent, the |role_id| should be equal to the name of that argument. For example, consider an entry in the intent catalog: core_intent { id { id: "BookARide" \} slot { name: "provider" type { string_type { \} \} \} slot { name: "num_riders" type { number_type { \} \} \} \} Then, the |role_id| would be "provider" or "num_riders" when referring to one of these slots. NOTE: when responding to the user, the Assistant may actually make use of other roles such as "ETA" or "driver" that are not part of the intent declaration. These should still be assigned consistent semantic roles. For example, a dialog with the Shopping feature: User: Where can I buy XYZ? Google: [Best Buy in Sunnyvale] has [XYZ] in stock. User: Great! Give me directions. In this case, both "Best Buy" and "XYZ" would be pushed to attentional entities. Best Buy, in this case, may not be an argument in the ShoppingItemStockInquiry intent, but should still have a consistent |role_id| such as "possessing_business".
         */
        roleId?: string | null;
    }
    /**
     * Properties of visual mentions (e.g., how they are displayed to the user, visibility, etc.).
     */
    export interface Schema$AttentionalEntitiesSpatialProperties {
        visibility?: string | null;
    }
    /**
     * How the entity was presented in this mention at a surface level. For example, "President Barack Obama" or "Barack Obama" or "he" might all be reasonable surface forms for the MID /m/02mjmr.
     */
    export interface Schema$AttentionalEntitiesSurfaceForm {
        text?: string | null;
    }
    /**
     * This data is expected to appear in approximately 2 out of every 1,000 documents with an average of 2 fields per document. Rough order of size is in the hundreds of kilobytes per Mustang shard.
     */
    export interface Schema$BiasingPerDocData {
        biasingfield?: Schema$BiasingPerDocDataBiasingField[];
    }
    /**
     * A replacement for BiasingPerDocData that is more efficient wrt size in the index.
     */
    export interface Schema$BiasingPerDocData2 {
        biasingField?: Schema$BiasingPerDocData2BiasingField[];
    }
    export interface Schema$BiasingPerDocData2BiasingField {
        /**
         * A fingerprint of the actual name of the field.
         */
        compressedName?: number | null;
        /**
         * The value, under various representations to get maximum compression. Exactly one of them is guaranteed to be filled. value as a double.
         */
        value?: number | null;
        /**
         * a floating value, represented as an integer by converting using floating_value * 1000. Useable for all floating values that need 3 digits of precision, and are small enough.
         */
        valueFloat?: number | null;
        /**
         * value as an int32. When the value is encode-able as an integer.
         */
        valueInt?: number | null;
    }
    /**
     * Metadata fields on which we can bias (sort) search results independently from the normal ranking using a ScoreAdjuster
     */
    export interface Schema$BiasingPerDocDataBiasingField {
        /**
         * Fingerprint of the attribute name (no need to keep long field names)
         */
        Name?: string | null;
        /**
         * Biasing value translated into a double for uniform comparison
         */
        Value?: number | null;
    }
    /**
     * A BlobRef is used to refer to a blob in BlobStore. Clients may only manipulate blobs through BlobRefs. BlobRefs should not be sent in the clear outside of Google (for example, encoded in URLs, stored in a client cookie, or referred to in Javascript); for efficiency, the IDs expose internal details of the blobstore (such as machine IPs or cluster names). If clients need to store BlobRefs outside of Google, they must encrypt the BlobRef securely or use an alternative insecure identifier with an id-\>BlobRef mapping inside our network.
     */
    export interface Schema$BlobstoreBlobRef {
        BlobID?: string | null;
        Options?: string | null;
        RefID?: string | null;
        ShardBin?: number | null;
        /**
         * Size of the complete blob, in bytes.
         */
        Size?: string | null;
        /**
         * The ID of the V2 blob this blob has
         */
        SourceV2BlobID?: string | null;
        /**
         * Deprecated.
         */
        V2ReadBlobToken?: string | null;
    }
    /**
     * Additional data for Blog/Posts
     */
    export interface Schema$BlogPerDocData {
        /**
         * used for blogurl crowding.
         */
        blogurlFp?: string | null;
        /**
         * This score captures how spammy the client is that the micropost was created with. The higher the score the worse.
         */
        clientSpamminess?: number | null;
        /**
         * For the threaded conversation view. Only populated in docs with provider type SYNTHETIC_CONVERSATION_DOC.
         */
        convTree?: Schema$BlogsearchConversationTree;
        copycatScore?: number | null;
        docQualityScore?: number | null;
        /**
         * A syntactic reshare is a document that is * created from an original and shared with friends and * we detect this resharing property by syntactically parsing the doc. . For example, a retweet is an example of a syntactic_reshare because we can detect that it's a reshare by grepping for "RT @".
         */
        isSyntacticReshare?: boolean | null;
        /**
         * Experimental data for quality experiments. This will NOT be populated in prod, but we will use this for experiments.
         */
        microblogQualityExptData?: Schema$Proto2BridgeMessageSet;
        /**
         * For replies/reshares. num_mentions = number of times the pattern @foo appears in the document.
         */
        numMentions?: number | null;
        outlinks?: Schema$BlogPerDocDataOutlinks[];
        /**
         * The fingerprint for the body text of the microblog post. It is copied from MicroBlogPost.post_content_fingerprint.
         */
        postContentFingerprint?: number | null;
        qualityScore?: number | null;
        /**
         * Blog scoring signals.
         */
        spamScore?: number | null;
        universalWhitelisted?: boolean | null;
        /**
         * User and doc quality scores for updates (aka microposts).
         */
        userQualityScore?: number | null;
    }
    /**
     * Resolved url and site spamscore for outlinks in updates (aka microposts).
     */
    export interface Schema$BlogPerDocDataOutlinks {
        /**
         * Representative id for an equivalence class of URLs. E.g. http://youtube.com/watch?v=12 and http://youtube.com/watch?v=12&feature=related have the same aggregation id since they're effectively the same webpage
         */
        aggregationFp?: string | null;
        resolvedUrl?: string | null;
        siteSpamScore?: number | null;
        title?: string | null;
    }
    export interface Schema$BlogsearchConversationNode {
        /**
         * The username of the author of the microblog post represented by this node.
         */
        authorName?: string | null;
        /**
         * A list of docids of child nodes.
         */
        children?: string[] | null;
        /**
         * The creation date of the doc.
         */
        date?: string | null;
        /**
         * Docid of the microblog post represented by this node.
         */
        docid?: string | null;
        /**
         * The docid of the parent node. The root of the tree will leave this empty.
         */
        parent?: string | null;
    }
    export interface Schema$BlogsearchConversationTree {
        /**
         * The id of this conversation.
         */
        convId?: string | null;
        /**
         * The nodes in this conversation. No particular order is assumed.
         */
        nodes?: Schema$BlogsearchConversationNode[];
    }
    /**
     * Information to indicate BG availability for businesses. This message is filled from Topic Server and stored in the GSR in Superroot.
     */
    export interface Schema$BlueGingerClientVisibleProtoBlueGingerSupportedServices {
        /**
         * List of supported modules for a business.
         */
        modules?: Schema$BlueGingerClientVisibleProtoBlueGingerSupportedServicesBlueGingerModule[];
    }
    export interface Schema$BlueGingerClientVisibleProtoBlueGingerSupportedServicesBlueGingerModule {
        /**
         * Module name, e.g. hairdresser_reservation. from quality/views/extraction/kcube/bg/modules/modules.bzl.
         */
        name?: string | null;
        /**
         * Services of this module that are supported by the business, e.g. haircuts.
         */
        services?: string[] | null;
        useCase?: string | null;
    }
    /**
     * Per-doc data for the web page about the cited book Approximate size is on average ~10bytes
     */
    export interface Schema$BookCitationPerDocData {
        /**
         * the book id for the main citation
         */
        bookId?: string | null;
        /**
         * the discretized citation score for the main book. we map the raw score 1.0-20.0 to 0 - 127
         */
        discretizedCitationScore?: number | null;
        /**
         * Is there a preview or excerpt of the book on this document?
         */
        previewable?: boolean | null;
        /**
         * book id for the second citation if we can't separate the two top citations (they are too close).
         */
        secondBookId?: string | null;
        /**
         * the discretized score for the second citation
         */
        secondDiscretizedCitationScore?: number | null;
    }
    /**
     * We divide up a week into individual open intervals. If any are present then they must be arranged in strictly increasing order, with non-empty spaces between successive intervals, and all times between 0 and 604800, the number of seconds in a week.
     */
    export interface Schema$BusinessHours {
        dayopen?: number | null;
        interval?: Schema$BusinessHoursInterval[];
    }
    export interface Schema$BusinessHoursInterval {
        /**
         * The interval ends at the start of this second
         */
        end?: number | null;
        /**
         * Time in seconds since Midnight-Monday-Morn
         */
        start?: number | null;
    }
    /**
     * Token to be exposed and stored by the bot
     */
    export interface Schema$ChatBotPlatformBotSendToken {
        /**
         * Time since epoch (micros) that this will expire
         */
        expiryTimeMicros?: string | null;
        /**
         * Encrypted InternalSendToken
         */
        sendToken?: string | null;
    }
    export interface Schema$ChatBotPlatformFireballId {
        /**
         * When used as a user ID, it's the phone number of the sender. When used as a session ID: For group conversation, it is the group ID. For 1 to 1, it is the receiver or sender phone number. For 1 to bot, it is the receiver phone number or empty.
         */
        id?: Schema$GoogleInternalCommunicationsInstantmessagingV1Id;
    }
    /**
     * Next ID: 6
     */
    export interface Schema$ClassifierPornClassifierData {
        classification?: Schema$ClassifierPornClassifierDataClassification[];
        /**
         * Records whether the image linker is run already. This is only used for Alexandria but NOT for Segindexer.
         */
        imageBasedDetectionDone?: boolean | null;
        timestamp?: string | null;
    }
    export interface Schema$ClassifierPornClassifierDataClassification {
        label?: string | null;
        score?: number | null;
    }
    /**
     * Next ID: 3
     */
    export interface Schema$ClassifierPornDocumentData {
        classifierdata?: Schema$ClassifierPornClassifierData;
        sitedata?: Schema$ClassifierPornSiteData;
    }
    /**
     * Generic output for one vertical.
     */
    export interface Schema$ClassifierPornQueryClassifierOutput {
        /**
         * This field is only filled for the CSAI vertical.
         */
        csaiClassification?: string | null;
        /**
         * Human-readable debug information about the classification. This field is only set if output_debug is set in the classification input.
         */
        debug?: string | null;
        /**
         * The bit that shows if this classifier outputs positive classification for the input query. Set by thresholding with a recommended threshold.
         */
        isPositive?: boolean | null;
        /**
         * The score that the classifier assigned to the input query. This is filled by all verticals.
         */
        score?: number | null;
    }
    /**
     * Multi-label classification output. It contains the output for each vertical. The output for some verticals can be empty, in case that vertical is not supported by the classifier or if the set of verticals was restricted using MultiLabelClassifierInput.verticals.
     */
    export interface Schema$ClassifierPornQueryMultiLabelClassifierOutput {
        csai?: Schema$ClassifierPornQueryClassifierOutput;
        fringe?: Schema$ClassifierPornQueryClassifierOutput;
        medical?: Schema$ClassifierPornQueryClassifierOutput;
        minor?: Schema$ClassifierPornQueryClassifierOutput;
        offensive?: Schema$ClassifierPornQueryClassifierOutput;
        porn?: Schema$ClassifierPornQueryClassifierOutput;
        spoof?: Schema$ClassifierPornQueryClassifierOutput;
        violence?: Schema$ClassifierPornQueryClassifierOutput;
        vulgar?: Schema$ClassifierPornQueryClassifierOutput;
    }
    /**
     * QuerySats contains the information about the queries that users typed to search for this image.
     */
    export interface Schema$ClassifierPornQueryStats {
        /**
         * A query text porn score for the queries which have clicks to the image: query_text_porn_score := sum(clicks(query) * text_porn_score(query)) / sum(clicks(query))
         */
        queryTextPornScore?: number | null;
        totalClicks?: number | null;
    }
    /**
     * ReferrerCounts stores how many referrers an images has and how many of them were classified as porn and as adult/softporn respectively. Note that a referrer is usually a landing page, but as of March 2011 this also includes referrers which an image can 'inherit' by propagating counts from near duplicate images.
     */
    export interface Schema$ClassifierPornReferrerCounts {
        adult?: number | null;
        /**
         * Number of referrers which are classified as porn and as adult.
         */
        porn?: number | null;
        /**
         * Total number of referrers.
         */
        total?: number | null;
    }
    /**
     * Next ID: 53
     */
    export interface Schema$ClassifierPornSiteData {
        /**
         * The average pedo page score for the site.
         */
        avgPedoPageScore?: number | null;
        finalPedoSiteScore?: number | null;
        /**
         * The number of pages that were used to compute the scores and ratios.
         */
        numberOfPages?: string | null;
        /**
         * The number of pages with pedo restrict.
         */
        numberOfPedoPages?: string | null;
        /**
         * Sitechunk used to compute the signals. The field is present only for data created after December 2022.
         */
        site?: string | null;
        /**
         * The ratio of porn/softporn of the site this page belongs to.
         */
        sitePornRatio?: number | null;
        siteSoftpornRatio?: number | null;
        versionedscore?: Schema$ClassifierPornSiteDataVersionedScore[];
        /**
         * The cubic mean aggregation of violence page scores in the site.
         */
        violenceScore?: number | null;
        violenceStats?: Schema$ClassifierPornSiteViolenceStats;
    }
    /**
     * The site porn score of the site to which the page of interest belongs to. Multiple versions are kept across large changes for some time. The Version-4 score is the average Universal Page Probability of all the site's pages, and will come with populated verticals4_score and site_rule (if any rule fires) fields. When using this score it is recommended to subscribe to the following mailing list: g/safesearch-announce.
     */
    export interface Schema$ClassifierPornSiteDataVersionedScore {
        score?: number | null;
        siteRule?: string[] | null;
        version?: number | null;
        /**
         * Please talk to safesearch@ before relying on any of these internal fields:
         */
        verticals4Score?: number | null;
    }
    /**
     * Next ID: 6
     */
    export interface Schema$ClassifierPornSiteViolenceStats {
        meanFinalViolenceScore?: number | null;
        numberOfImages?: string | null;
        numberOfVideos?: string | null;
        videoViolenceScore?: number | null;
    }
    /**
     * The identity to configure a CloudSQL instance provisioned via SLM Terraform.
     */
    export interface Schema$CloudAiPlatformTenantresourceCloudSqlInstanceConfig {
        /**
         * Output only. The CloudSQL instance connection name.
         */
        cloudSqlInstanceConnectionName?: string | null;
        /**
         * Input/Output [Optional]. The CloudSQL instance name within SLM instance. If not set, a random UUIC will be generated as instance name.
         */
        cloudSqlInstanceName?: string | null;
        /**
         * Input [Optional]. The KMS key name or the KMS grant name used for CMEK encryption. Only set this field when provisioning new CloudSQL instances. For existing CloudSQL instances, this field will be ignored because CMEK re-encryption is not supported.
         */
        kmsKeyReference?: string | null;
        /**
         * Input [Optional]. MDB roles for corp access to CloudSQL instance.
         */
        mdbRolesForCorpAccess?: string[] | null;
        /**
         * Output only. The SLM instance's full resource name.
         */
        slmInstanceName?: string | null;
        /**
         * Input [Required]. The SLM instance template to provision CloudSQL.
         */
        slmInstanceTemplate?: string | null;
        /**
         * Input [Required]. The SLM instance type to provision CloudSQL.
         */
        slmInstanceType?: string | null;
    }
    /**
     * The identity to configure a GCS bucket.
     */
    export interface Schema$CloudAiPlatformTenantresourceGcsBucketConfig {
        admins?: string[] | null;
        /**
         * Input/Output [Optional]. The name of a GCS bucket with max length of 63 chars. If not set, a random UUID will be generated as bucket name.
         */
        bucketName?: string | null;
        /**
         * Input/Output [Optional]. Only needed for per-entity tenant GCP resources. During Deprovision API, the on-demand deletion will only cover the tenant GCP resources with the specified entity name.
         */
        entityName?: string | null;
        /**
         * Input/Output [Optional]. The KMS key name or the KMS grant name used for CMEK encryption. Only set this field when provisioning new GCS bucket. For existing GCS bucket, this field will be ignored because CMEK re-encryption is not supported.
         */
        kmsKeyReference?: string | null;
        /**
         * Input/Output [Optional]. Only needed when the content in bucket need to be garbage collected within some amount of days.
         */
        ttlDays?: number | null;
        /**
         * Input/Output [Required]. IAM roles (viewer/admin) put on the bucket.
         */
        viewers?: string[] | null;
    }
    /**
     * The dynamic IAM bindings to be granted after tenant projects are created.
     */
    export interface Schema$CloudAiPlatformTenantresourceIamPolicyBinding {
        /**
         * Input/Output [Required]. The member service accounts with the roles above. Note: placeholders are same as the resource above.
         */
        members?: string[] | null;
        /**
         * Input/Output [Required]. The resource name that will be accessed by members, which also depends on resource_type. Note: placeholders are supported in resource names. For example, ${tpn\} will be used when the tenant project number is not ready.
         */
        resource?: string | null;
        /**
         * Input/Output [Required]. Specifies the type of resource that will be accessed by members.
         */
        resourceType?: string | null;
        /**
         * Input/Output [Required]. The role for members below.
         */
        role?: string | null;
    }
    /**
     * The configuration for a spanner database provisioning. Next ID: 8
     */
    export interface Schema$CloudAiPlatformTenantresourceInfraSpannerConfig {
        /**
         * Input [Optional]. The options to create a spanner database. Note: give the right options to ensure the right KMS key access audit logging and AxT logging in expected logging category.
         */
        createDatabaseOptions?: Schema$CloudAiPlatformTenantresourceInfraSpannerConfigCreateDatabaseOptions;
        /**
         * Input [Optional]. The KMS key name or the KMS grant name used for CMEK encryption. Only set this field when provisioning new Infra Spanner databases. For existing Infra Spanner databases, this field will be ignored because CMEK re-encryption is not supported. For example, projects//locations//keyRings//cryptoKeys/
         */
        kmsKeyReference?: string | null;
        /**
         * Input [Required]. The file path to the spanner SDL bundle.
         */
        sdlBundlePath?: string | null;
        /**
         * Input [Optional]. The spanner borg service account for delegating the kms key to. For example, spanner-infra-cmek-nonprod@system.gserviceaccount.com, for the nonprod universe.
         */
        spannerBorgServiceAccount?: string | null;
        spannerLocalNamePrefix?: string | null;
        spannerNamespace?: string | null;
        /**
         * Input [Required]. Every database in Spanner can be identified by the following path name: /span//:
         */
        spannerUniverse?: string | null;
    }
    /**
     * The options to create a spanner database. KMS key access audit logging and AxT logging will be associated with the given resource name, resource type and service name. Please ensure to give right options to enable correct audit logging and AxT logging.
     */
    export interface Schema$CloudAiPlatformTenantresourceInfraSpannerConfigCreateDatabaseOptions {
        /**
         * The cloud resource name for the CMEK encryption. For example, projects//locations/
         */
        cmekCloudResourceName?: string | null;
        /**
         * The cloud resource type for the CMEK encryption. For example, contentwarehouse.googleapis.com/Location
         */
        cmekCloudResourceType?: string | null;
        /**
         * The service name for the CMEK encryption. For example, contentwarehouse.googleapis.com
         */
        cmekServiceName?: string | null;
    }
    /**
     * The identity to configure a service account.
     */
    export interface Schema$CloudAiPlatformTenantresourceServiceAccountIdentity {
        /**
         * Output only. The service account email that has been created.
         */
        serviceAccountEmail?: string | null;
        /**
         * Input/Output [Optional]. The tag that configures the service account, as defined in google3/configs/production/cdpush/acl-zanzibar-cloud-prod/activation_grants/activation_grants.gcl. Note: The default P4 service account has the empty tag.
         */
        tag?: string | null;
    }
    /**
     * The identity to configure a tenant project.
     */
    export interface Schema$CloudAiPlatformTenantresourceTenantProjectConfig {
        /**
         * Input/Output [Required]. The billing account properties to create the tenant project.
         */
        billingConfig?: Schema$GoogleApiServiceconsumermanagementV1BillingConfig;
        /**
         * Input/Output [Required]. The folder that holds tenant projects and folder-level permissions will be automatically granted to all tenant projects under the folder. Note: the valid folder format is `folders/{folder_number\}`.
         */
        folder?: string | null;
        /**
         * Input/Output [Required]. The policy bindings that are applied to the tenant project during creation. At least one binding must have the role `roles/owner` with either `user` or `group` type.
         */
        policyBindings?: Schema$GoogleApiServiceconsumermanagementV1PolicyBinding[];
        /**
         * Input/Output [Required]. The API services that are enabled on the tenant project during creation.
         */
        services?: string[] | null;
    }
    /**
     * The tenant project and tenant resources. Next ID: 10
     */
    export interface Schema$CloudAiPlatformTenantresourceTenantProjectResource {
        /**
         * The CloudSQL instances that are provisioned under the tenant project.
         */
        cloudSqlInstances?: Schema$CloudAiPlatformTenantresourceCloudSqlInstanceConfig[];
        /**
         * The GCS buckets that are provisioned under the tenant project.
         */
        gcsBuckets?: Schema$CloudAiPlatformTenantresourceGcsBucketConfig[];
        /**
         * The dynamic IAM bindings that are granted under the tenant project. Note: this should only add new bindings to the project if they don't exist and the existing bindings won't be affected.
         */
        iamPolicyBindings?: Schema$CloudAiPlatformTenantresourceIamPolicyBinding[];
        /**
         * The Infra Spanner databases that are provisioned under the tenant project. Note: this is an experimental feature.
         */
        infraSpannerConfigs?: Schema$CloudAiPlatformTenantresourceInfraSpannerConfig[];
        /**
         * Input/Output [Required]. The tag that uniquely identifies a tenant project within a tenancy unit. Note: for the same tenant project tag, all tenant manager operations should be idempotent.
         */
        tag?: string | null;
        /**
         * The configurations of a tenant project.
         */
        tenantProjectConfig?: Schema$CloudAiPlatformTenantresourceTenantProjectConfig;
        /**
         * Output only. The tenant project ID that has been created.
         */
        tenantProjectId?: string | null;
        /**
         * Output only. The tenant project number that has been created.
         */
        tenantProjectNumber?: string | null;
        /**
         * The service account identities (or enabled API service's P4SA) that are expclicitly created under the tenant project (before JIT provisioning during enabled API services).
         */
        tenantServiceAccounts?: Schema$CloudAiPlatformTenantresourceTenantServiceAccountIdentity[];
    }
    /**
     * A collection of tenant resources.
     */
    export interface Schema$CloudAiPlatformTenantresourceTenantResource {
        /**
         * A list of P4 service accounts (go/p4sa) to provision or deprovision.
         */
        p4ServiceAccounts?: Schema$CloudAiPlatformTenantresourceServiceAccountIdentity[];
        /**
         * A list of tenant projects and tenant resources to provision or deprovision.
         */
        tenantProjectResources?: Schema$CloudAiPlatformTenantresourceTenantProjectResource[];
    }
    /**
     * The identity of service accounts that have been explicitly created under tenant projects.
     */
    export interface Schema$CloudAiPlatformTenantresourceTenantServiceAccountIdentity {
        /**
         * Output only. The email address of the generated service account.
         */
        serviceAccountEmail?: string | null;
        /**
         * Input/Output [Required]. The service that the service account belongs to. (e.g. cloudbuild.googleapis.com for GCB service accounts)
         */
        serviceName?: string | null;
    }
    /**
     * The basic message that contains a single decision output of go/deeptagger.
     */
    export interface Schema$CommerceDatastoreDeepTag {
        /**
         * The confidence of the tag, encoded to 14 bits (range [0, 16383]). Due to modeling details, a large number of tags become trustworthy with confidence greater than 0.001, so two bytes of precision are required.
         */
        confidence?: number | null;
        /**
         * A Deep Tag enum in uint32 form.
         */
        tag?: number | null;
    }
    /**
     * Image-level deep tags: essentially equivalent to the proto above but containing tags that are computed at the image level. These image signals are maintained by the Visual Shopping team (visual-shopping@). *** If you do use the signals, please add an entry in go/ShoppingImageAttributeClients to be notified for model upgrade. *** We recommend our clients against using the raw confidence value directly. Instead, the clients should use the library, cs/ads/shopping/visual/deeptags/public/single_tag.h and cs/ads/shopping/visual/deeptags/public/single_scored_tag.h to specify an operating point in terms of precision or recall. See the following code example: http://google3/shopping/visual/explore_looks/looks_offline_pipeline.cc?l=268&rcl=304165166 *** `model_outputs` is a repeated field. Please check `version` to get the model you desire to use, instead of indexing the model_outputs directly e.g. model_outputs(0). We will remove the old versions in the future and this will lead to incorrect model. *** Models: As of Q2 2020, we have two models running within Shopping: model one only has the overlay tag, which we are deprecating, and model two has the tags specified in go/VisualShoppingImageAttributes.
     */
    export interface Schema$CommerceDatastoreImageDeepTags {
        /**
         * The set of outputs for a series of model versions. The size of this field should not extend beyond 4 at any time: two versions for slow-update track dependencies, and two versions for fast-update track dependencies.
         */
        modelOutputs?: Schema$CommerceDatastoreImageDeepTagsModelOutput[];
    }
    export interface Schema$CommerceDatastoreImageDeepTagsModelOutput {
        backgroundType?: Schema$CommerceDatastoreDeepTag;
        collage?: Schema$CommerceDatastoreDeepTag;
        /**
         * We are looking to deploy a model for the Ads team to identify images with bad cropping. The model will be for Ads only and we will not populate the cropping field in CDS.
         */
        cropping?: Schema$CommerceDatastoreDeepTag;
        modelType?: Schema$CommerceDatastoreDeepTag;
        /**
         * Tag corresponds to the shopping non-family safe (nfs) image signal.
         */
        nfs?: Schema$CommerceDatastoreDeepTag;
        objectCount?: Schema$CommerceDatastoreDeepTag;
        /**
         * Tag corresponding to unwanted text overlay (watermarks, logos, promotional elements, artifacts, etc).
         */
        overlay?: Schema$CommerceDatastoreDeepTag;
        selfie?: Schema$CommerceDatastoreDeepTag;
        /**
         * Tag corresponding to the text overlay classifier (watermarks, logos, promotional elements, artifacts, etc).
         */
        textOverlay?: Schema$CommerceDatastoreDeepTag[];
        version?: number | null;
    }
    /**
     * Protocol record used for collecting together all information about a document. Please consult go/dj-explorer for two basic questions about `CompositeDoc`: - Where should I look up certain information (e.g: pagerank, language)? - What does each field in CompositeDoc mean and who should I contact if I have questions? To add a new field into CompositeDoc, or change existing field's size significantly, please file a ticket at go/dj-new-field, fill in necessary information and get approved by docjoin-access@ team. Next id: 193
     */
    export interface Schema$CompositeDoc {
        /**
         * Contains necessary information to enforce row level Docjoin access control.
         */
        accessRequirements?: Schema$IndexingPrivacyAccessAccessRequirements;
        additionalchecksums?: Schema$CompositeDocAdditionalChecksums;
        alternatename?: Schema$CompositeDocAlternateName[];
        /**
         * Mark as non-personal since no personal fields will be populated in `anchors.link_additional_info` and `anchors.additional_info`. For more details of Search personal data, see go/dma52-search-cdoc-fields.
         */
        anchors?: Schema$Anchors;
        /**
         * Mark as non-personal since it's an aggregation of anchors. For more details of Search personal data, see go/dma52-search-cdoc-fields.
         */
        anchorStats?: Schema$IndexingDocjoinerAnchorStatistics;
        /**
         * This field is present iff the page has a bad SSL certificate itself or in its redirect chain.
         */
        badSslCertificate?: Schema$IndexingBadSSLCertificate;
        /**
         * Visible content checksum as computed by repository::parsehandler::checksum::Checksum96bitsParseHandler. The value is a Fprint96 in "key format" (i.e., by Fprint96::AsKey()).
         */
        ContentChecksum96?: string | null;
        cseId?: Schema$QualityProseCSEUrlInfo[];
        /**
         * URL should only be selected for CSE Index if it's pagerank is higher than cse_pagerank_cutoff.
         */
        csePagerankCutoff?: number | null;
        /**
         * Contains the tracking version of various data fields in CompositeDoc.
         */
        dataVersion?: Schema$IndexingDocjoinerDataVersion;
        doc?: Schema$GDocumentBase;
        /**
         * A generic container to hold document annotations and signals. For a full list of extensions live today, see go/wde.
         */
        docAttachments?: Schema$Proto2BridgeMessageSet;
        /**
         * Info about "selected" images associated with the document for which we (already) have ImageData. For each image URL, some fixed number of documents are selected as web referrers for the image URL, and within those selected documents, we say the image is "selected". Within the remaining documents, we say the image is "rejected". Note that this distinction is slightly different from selected for indexing. Only images within doc_images where is_indexed_by_imagesearch is true will be selected for indexing. You can find the rejected images at composite_doc.doc_attachments().get(). You can find images that are selected, but for which we have no ImageData (yet) at composite_doc.image_indexing_info().selected_not_indexed_image_link()
         */
        docImages?: Schema$ImageData[];
        /**
         * This message set is used for data pushed into the index using the signals framework that is never to be used in Mustang or TG Continuum scoring/snippeting code. Any protocol buffer stored in this message set is automatically returned in a docinfo response - it ends up in the "info" message set in the WWWSnippetResponse, so it can be used in post-doc twiddlers and for display in GWS with no code changes in Mustang or Teragoogle.
         */
        docinfoPassthroughAttachments?: Schema$Proto2BridgeMessageSet;
        /**
         * Info about videos embedded in the document.
         */
        docVideos?: Schema$ImageRepositoryVideoProperties[];
        /**
         * Data produced by the embedded-content system. This is a thin message, containing only embedded_links_info data for the embedder and JavaScript/CSS embedded links (the embedded-content bigtable also contains snapshots, compressed document trees and all embedded link types). Provided using the index signal API.
         */
        embeddedContentInfo?: Schema$IndexingEmbeddedContentEmbeddedContentInfo;
        extradup?: Schema$CompositeDocExtraDup[];
        forwardingdup?: Schema$CompositeDocForwardingDup[];
        includedcontent?: Schema$CompositeDocIncludedContent[];
        indexinginfo?: Schema$CompositeDocIndexingInfo;
        /**
         * Serialized indexing intermediate data.
         */
        indexingIntermediate?: string | null;
        /**
         * This field associates a document to particular labels and assigns confidence values to them.
         */
        labelData?: Schema$QualityLabelsGoogleLabelData;
        liveexperimentinfo?: Schema$CompositeDocLiveExperimentInfo;
        localinfo?: Schema$LocalWWWInfo;
        /**
         * Localized alternate names are similar to alternate names, except that it is associated with a language different from its canonical. This is the subset of webmaster-provided localized alternate names being in the dup cluster of this document. Used during serving for swapping in the URL based on regional and language preferences of the user.
         */
        localizedAlternateName?: Schema$IndexingConverterLocalizedAlternateName[];
        localizedvariations?: Schema$CompositeDocLocalizedVariations;
        /**
         * Only present in partial cdocs.
         */
        partialUpdateInfo?: Schema$CompositeDocPartialUpdateInfo;
        perDocData?: Schema$PerDocData;
        /**
         * Porn related data used for image and web search porn classification as well as for diagnostics purposes.
         */
        porninfo?: Schema$ClassifierPornDocumentData;
        properties?: Schema$DocProperties;
        /**
         * Contains information necessary to perform policy decision on the usage of the data assosiated with this cdoc.
         */
        ptoken?: Schema$PtokenPToken;
        qualitysignals?: Schema$CompositeDocQualitySignals;
        /**
         * Information about the most recent creation and expiration of this domain. It's extracted from domainedge signal.
         */
        registrationinfo?: Schema$RegistrationInfo;
        /**
         * If present, indicates that some content was inserted, deleted, or replaced in the document's content (in CompositeDoc::doc::Content::Representation), and stores information about what was inserted, deleted, or replaced.
         */
        richcontentData?: Schema$IndexingConverterRichContentData;
        /**
         * rich snippet extracted from the content of a document.
         */
        richsnippet?: Schema$RichsnippetsPageMap;
        robotsinfolist?: Schema$CompositeDocRobotsInfoList;
        /**
         * to copy to per-doc
         */
        scaledIndyRank?: number | null;
        /**
         * Sitelinks: a collection of interesting links a user might be interested in, given they are interested in this document. WARNING: this is different from the crawler Sitemaps (see SitemapsSignals in the attachments).
         */
        sitemap?: Schema$Sitemap;
        /**
         * Row timestamp in CDoc storage.
         */
        storageRowTimestampMicros?: string | null;
        subindexid?: string[] | null;
        syntacticDate?: Schema$QualityTimebasedSyntacticDate;
        /**
         * WARNING!!! "url" field in CompositeDoc is optional, and is usually missing: e.g., Docjoin CompositeDoc's don't have CompositeDoc::url. has_url() checking is often useful. So don't rely on CompositeDoc::url unless you're sure otherwise. Usually you want to use CompositeDoc::doc::url instead.
         */
        url?: string | null;
        /**
         * Date in the url extracted by quality/snippets/urldate/date-in-url.cc This is given as midnight GMT on the date in question.
         */
        urldate?: string | null;
    }
    /**
     * Additional checksums of the document.
     */
    export interface Schema$CompositeDocAdditionalChecksums {
        /**
         * Same as ContentChecksum96 but without transient boilerplate.
         */
        NoTransientChecksum96?: string | null;
        /**
         * Deprecated. Use simhash_v2 and simhash_v2_significance instead.
         */
        SimHash?: string | null;
        SimHashIsTrusted?: boolean | null;
        /**
         * Simhash-v2 is generated by SimHashParseHandler, designed as a complete replacement of simhash-v1 (a.k.a. the original simhash above) from ApproxDupsParseHandler. Simhash-v2 uses a revised algorithm so that it is expected to work better in most cases than simhash-v1. They coexist in current transition period, then simhash-v1 will be retired.
         */
        simhashV2?: string | null;
        /**
         * Simhash-v2-significance is used to describe the confidence about the corresponding simhash-v2 value. It is defined as the average absolute difference from zero of all internal state components when finalizing a simhash-v2 value in HashMultiSetDotCauchy. We used to compare the significance against some pre-defined threshold (default: 20) to get a boolean value "trusted_simhash_v2". However, it is possible that this field is missing while "simhash_v2" is present, in such case (1) Use "SimHashIsTrusted" instead if it is present, AND/OR (2) Assume "simhash_v2" is trusted if its value is non-zero.
         */
        simhashV2Significance?: number | null;
    }
    /**
     * Alternate names are some urls that we would like to associate with documents in addition to canonicals. Sometimes we may want to serve these alternatenames instead of canonicals. Alternames in CompositeDoc should come from WebMirror pipeline.
     */
    export interface Schema$CompositeDocAlternateName {
        /**
         * Fp96 of webmirror equivalence class as of last time this was exported.
         */
        ecnFp?: string | null;
        Url?: string | null;
        /**
         * See webutil/urlencoding
         */
        UrlEncoding?: number | null;
    }
    /**
     * The top non-forwarding dups of the canonical url.
     */
    export interface Schema$CompositeDocExtraDup {
        /**
         * Fp96 of webmirror equivalence class as of last time this was exported.
         */
        ecnFp?: string | null;
        /**
         * The url of the non-forwarding dup.
         */
        url?: string | null;
    }
    /**
     * The top forwarding dups of the canonical url. (note: it may actually include some dups that are NOT used for forwarding data but for making "info:" complete)
     */
    export interface Schema$CompositeDocForwardingDup {
        /**
         * The name of the url's webmirror equivalence class.
         */
        ecn?: string | null;
        ecnFp?: string | null;
        /**
         * The purpose(s) of the forwarding dup indicating if it is used for forwarding signal/anchors generally, or only for forwarding some specific signal (e.g. navboost), or for some other purposes (e.g., not for forwarding any data but for making "info:" complete). See indexing/dups/public/dups.h for more details.
         */
        purposes?: number | null;
        /**
         * Raw pagerank of the url.
         */
        rawPagerank?: number | null;
        /**
         * The webmirror repid of the forwarding dup.
         */
        repid?: string | null;
        /**
         * The url of the forwarding dup.
         */
        url?: string | null;
        /**
         * The encoding of the url (see webutil/urlencoding for details).
         */
        urlencoding?: number | null;
    }
    export interface Schema$CompositeDocIncludedContent {
        includedDoc?: Schema$GDocumentBase;
        linkUrl?: string | null;
        perDocData?: Schema$PerDocData;
        properties?: Schema$DocProperties;
        /**
         * Indicate how this content came to be included. Legal values are constructed by bitwise-OR-ing values from the included_content::SourceType enum. Default SourceTypeBitfield = included_content::INCLUDED_FRAME
         */
        SourceTypeBitfield?: string | null;
    }
    /**
     * Contains information *mostly* used within indexing (e.g. not used for building the production serving shards). Most of this data is generated only in Alexandria, however there are exceptions.
     */
    export interface Schema$CompositeDocIndexingInfo {
        /**
         * To hold extra info for building a final cdoc from raw cdoc and goldmine annotations.
         */
        cdocBuildInfo?: Schema$IndexingDocjoinerCDocBuildInfo;
        /**
         * Whether current page is under content protection, i.e. a page has been crawled as an error page, but we preserve its last known good content and keep its crawl_status as converter.CrawlStatus::CONTENT.
         */
        contentProtected?: boolean | null;
        /**
         * If set, indicates that the crawl status was converted to ROBOTED for the reason specified by the enum value in converter.RobotedReasons.ConvertToRobotedReasons. See indexing/converter/proto/converter.proto for details. If unset, then the document was not converted to roboted, and if the document crawl status is ROBOTED, then the document is disallowed (at least to Google) in robots.txt.
         */
        convertToRobotedReason?: number | null;
        /**
         * One of the enum values in converter.CrawlStatus.State (see indexing/converter/proto/converter.proto for details). Default is converter.CrawlStatus::CONTENT. The document is roboted if the value is converter.CrawlStatus::ROBOTED.
         */
        crawlStatus?: number | null;
        demotionTags?: string[] | null;
        /**
         * One of the enum values in converter.ErrorPageType (see indexing/converter/proto/error-page-detector-enum.proto for detail). Default is converter::ERROR_PAGE_NONE.
         */
        errorType?: number | null;
        freshdocsCorpora?: string[] | null;
        /**
         * The host id of the document. Used chiefly to determine whether the document is part of a parked domain.
         */
        hostid?: string | null;
        /**
         * A short descriptive string to help identify the IE application or setup where this CDoc is generated. For example: websearch_m3 This field is for debuggability purposes.
         */
        ieIdentifier?: string | null;
        /**
         * Indexing info about images (i.e. image links missing image data, etc).
         */
        imageIndexingInfo?: Schema$ImageSearchImageIndexingInfo;
        /**
         * The timestamp (the time since the Epoch, in microseconds) when the docjoin is exported from indexing. The main purpose of this field is to identify different versions of the same document.
         */
        indexingTs?: string | null;
        /**
         * If set, the timestamp in microseconds when the URL stopped being canonical. This should never be set for exported canonical documents. This field is used by dups during canonical flip, and by webmain when doc selection switched between desktop and mobile. Union respects this timestamp to prevent old doc being deleted until the new doc is picked up
         */
        noLongerCanonicalTimestamp?: string | null;
        /**
         * This score is calculated by re-mapping the back onto the partition's score distribution, such that the score represents the score of the equivalently ranked organically-selected document.
         */
        normalizedClickScore?: number | null;
        /**
         * Vertical membership of the document. - `primary_vertical` is the vertical that initiated indexing of this document (or empty if the vertical was websearch). - `verticals` is the full list of verticals that contained this document (excluding websearch) at indexing time. `primary_vertical` may or may not be an element of `verticals` because of vertical membership skew between the ingestion time and indexing time. See go/one-indexing-for-web for more background.
         */
        primaryVertical?: string | null;
        /**
         * The raw navboost count for the canonical url without aggregating the navboost from dup urls. This field is used when building forwarding map.
         */
        rawNavboost?: number | null;
        /**
         * The timestamp (the time since the Epoch, in microseconds) to represent doc version, which is used in the downstream processing after Raffia. If it's not set, indexing_ts will be used as row_timestamp. The timestamp is generally set by reprocessing to set slightly newer indexing_ts such that the system can respect the reprocessed version to overwrite old data in storage.
         */
        rowTimestamp?: string | null;
        /**
         * Selection tier rank is a language normalized score ranging from 0-1 over the serving tier (Base, Zeppelins, Landfills) for this document.
         */
        selectionTierRank?: number | null;
        /**
         * The tracing ids is to label the version of url for url status tracking. This repeated field will carry at most 10 tracing id. See more details in go/rich-tracing-design There will be less than 2% base+uz cdocs carrying this field. The major sources of tracing ids include: * Indexing API pushed urls * Index Metrics sampling urls The tracing ids will be written into cdocs by Webmain Ramifier. The consumer of the tracing ids is Union serving notification collector see more at go/serving-notification-from-union
         */
        tracingId?: string[] | null;
        /**
         * Changerate information for this doc (see crawler/changerate/changerate.proto for details).
         */
        urlChangerate?: Schema$CrawlerChangerateUrlChangerate;
        /**
         * Url change history for this doc (see crawler/changerate/changerate.proto for details). Note if a doc has more than 20 changes, we only keep the last 20 changes here to avoid adding to much data in its docjoin.
         */
        urlHistory?: Schema$CrawlerChangerateUrlHistory;
        /**
         * UrlPatternSignals for this doc, used to compute document score in LTG (see indexing/signal_aggregator/proto/signal-aggregator.proto for details).
         */
        urlPatternSignals?: Schema$IndexingSignalAggregatorUrlPatternSignals;
        verticals?: string[] | null;
        /**
         * Indexing info about videos.
         */
        videoIndexingInfo?: Schema$ImageRepositoryVideoIndexingInfo;
    }
    /**
     * Contains information needed for end-to-end live experiments. For a cdoc generated by production pipeline, it includes experiment IDs that have selected current document. For a cdoc generated by experiment pipeline, it includes current experiment ID.
     */
    export interface Schema$CompositeDocLiveExperimentInfo {
        /**
         * List of necessary information for each live experiments.
         */
        perLiveExperimentInfo?: Schema$CompositeDocLiveExperimentInfoPerLiveExperimentInfo[];
    }
    /**
     * Contains information for a live experiment.
     */
    export interface Schema$CompositeDocLiveExperimentInfoPerLiveExperimentInfo {
        /**
         * ID of a live experiment.
         */
        experimentId?: string | null;
        /**
         * Partial CDoc for a live experiment.
         */
        partialCdoc?: Schema$CompositeDoc;
    }
    export interface Schema$CompositeDocLocalizedVariations {
        /**
         * A subset of computed variations, only the members which are dups to the main url. Used during serving for swapping in the URL based on regional and language preferences of the user.
         */
        dupsComputedAlternateNames?: Schema$IndexingDupsComputedLocalizedAlternateNamesLocaleEntry[];
        /**
         * All localized alternate names provided by the webmaster (canonical and dups, indexed and not-indexed). Used on the ranking side for swapping out results based on the webmaster preference.
         */
        webmasterAlternateNames?: Schema$IndexingConverterLocalizedAlternateName[];
    }
    /**
     * Contains information about the partial updates present in a partial CompositeDoc.
     */
    export interface Schema$CompositeDocPartialUpdateInfo {
        /**
         * List of goldmine annotator updates present in the enclosing partial cdoc.
         */
        goldmineAnnotatorNames?: string[] | null;
        /**
         * List of images signal updates present in the enclosing partial cdoc. Images signal name for a images signal is the unique name for the signal according to SignalSpec.
         */
        imagesSignalNames?: string[] | null;
        /**
         * Contains last full indexing information for partial updates.
         */
        lastFullIndexingInfo?: Schema$CompositeDocPartialUpdateInfoLastFullIndexingInfo[];
        /**
         * Which tier we should do cdoc lookup to merge partial cdocs. This uses the integer value of indexing.selection.CorpusId. NOT intended for other usage.
         */
        shouldLookupDocjoinsTier?: number | null;
        /**
         * List of signal updates present in the enclosing partial cdoc. Signal name for a signal is unique name for the signal according to SignalSpec.
         */
        signalNames?: string[] | null;
    }
    /**
     * Last full indexing information for the partial CDoc.
     */
    export interface Schema$CompositeDocPartialUpdateInfoLastFullIndexingInfo {
        /**
         * The corpus of last full updates.
         */
        corpus?: string | null;
        /**
         * Last full update indexing timestamp in microseconds.
         */
        lastFullIndexingTsMicros?: string | null;
    }
    /**
     * Note: This is a misleading name as of 2022/10/14. The field is still set and has meaningful data, but no longer holds quality signals. All the data are freshness-related and they're not particularly sensitive.
     */
    export interface Schema$CompositeDocQualitySignals {
        /**
         * Contains a date used for the "Date Last Modified" toolbelt restrict mode. Note: this date is a combined date and is different from the pure shingle-based signal stored in contentage.last_significant_update field.
         */
        lastSignificantUpdate?: Schema$QualityTimebasedLastSignificantUpdate;
        pagetype?: Schema$QualityTimebasedPageType;
    }
    /**
     * List of robots info parsed for the user-agents other than the default used to crawl this page.
     */
    export interface Schema$CompositeDocRobotsInfoList {
        newsRobotsInfo?: Schema$IndexingConverterRobotsInfo;
    }
    /**
     * A message containing per doc signals that are compressed and included in Mustang and TeraGoogle. For TeraGoogle, this message is included in perdocdata which means it can be used in preliminary scoring. CAREFUL: For TeraGoogle, this data resides in very limited serving memory (Flash storage) for a huge number of documents. Next id: 42
     */
    export interface Schema$CompressedQualitySignals {
        /**
         * anchor_mismatch_demotion: converted from QualityBoost.mismatched.boost.
         */
        anchorMismatchDemotion?: number | null;
        /**
         * authority promotion: converted from QualityBoost.authority.boost
         */
        authorityPromotion?: number | null;
        /**
         * baby_panda_demotion: converted from QualityBoost.rendered.boost.
         */
        babyPandaDemotion?: number | null;
        /**
         * New BabyPanda demotion, applied on top of Panda. This is meant to replace |baby_panda_demotion|.
         */
        babyPandaV2Demotion?: number | null;
        /**
         * Impressions, unsquashed, host level, not to be used with compressed ratios. Not to be used in Pattern Data.
         */
        crapsAbsoluteHostSignals?: number | null;
        crapsNewHostSignals?: string | null;
        crapsNewPatternSignals?: string | null;
        /**
         * For craps_[url|pattern]_signals, please avoid accessing these fields directly, even in minor ways like checking has_craps_*. Instead, please use methods from quality/navboost/craps/craps-lossy-compression.h or talk to dice-team.
         */
        crapsNewUrlSignals?: string | null;
        crapsUnscaledIpPriorBadFraction?: number | null;
        /**
         * Page quality signals converted from fields in proto QualityBoost in quality/q2/proto/quality-boost.proto. To save indexing space, we convert the float values in [0, 1] to integers in range [0, 1023] (use 10 bits). exact_match_domain_demotion: converted from QualityBoost.emd.boost.
         */
        exactMatchDomainDemotion?: number | null;
        /**
         * This field is *not* propagated to shards, but it's populated at serving time by go/web-signal-joins (see b/207344056). See go/0DayLEs for details. This is only meant to be used during LEs, it should *not* be used for launches.
         */
        experimentalNsrTeamData?: Schema$QualityNsrExperimentalNsrTeamData;
        /**
         * This field is *not* propagated to shards, but it's populated at serving time by go/web-signal-joins (see b/207344056). See go/0DayLEs for details. This is only meant to be used during LEs, it should *not* be used for launches.
         */
        experimentalNsrTeamWsjData?: Schema$QualityNsrExperimentalNsrTeamWSJData[];
        /**
         * This field is *not* propagated to shards. It is meant to be populated at serving time using one of the versions present in the `experimental_nsr_team_wsj_data` field above (using the `ExperimentalNsrTeamDataOverridesParams` opti to populate it; see http://source/search?q=ExperimentalNsrTeamDataOverridesParams%20file:ascorer.proto). The purpose of this field is to be read by an experimental Q* component, in order to quickly run LEs with new delta components. See go/0DayLEs for details.
         */
        experimentalQstarDeltaSignal?: number | null;
        /**
         * This field is *not* propagated to shards. It is meant to be populated at serving time using one of the versions present in the `experimental_nsr_team_wsj_data` field above (using the `ExperimentalNsrTeamDataOverridesParams` opti to populate it; see http://source/search?q=ExperimentalNsrTeamDataOverridesParams%20file:ascorer.proto). The purpose of this field is to be read by an experimental Q* component, in order to quickly run LEs with new components. See go/0DayLEs for details.
         */
        experimentalQstarSignal?: number | null;
        /**
         * This field is *not* propagated to shards. It is meant to be populated at serving time using one of the versions present in the `experimental_nsr_team_wsj_data` field above (using the `ExperimentalNsrTeamDataOverridesParams` opti to populate it; see http://source/search?q=ExperimentalNsrTeamDataOverridesParams%20file:ascorer.proto). The purpose of this field is to be read by an experimental Q* component, in order to quickly run LEs with new site components. See go/0DayLEs for details.
         */
        experimentalQstarSiteSignal?: number | null;
        /**
         * S2V low quality score: converted from quality_nsr.NsrData, applied in Qstar. See quality_nsr::util::ConvertNsrDataToLowQuality.
         */
        lowQuality?: number | null;
        /**
         * nav_demotion: converted from QualityBoost.nav_demoted.boost.
         */
        navDemotion?: number | null;
        /**
         * NSR confidence score: converted from quality_nsr.NsrData.
         */
        nsrConfidence?: number | null;
        /**
         * NSR override bid, used in Q* for emergency overrides.
         */
        nsrOverrideBid?: number | null;
        /**
         * Versioned NSR score to be used in continuous evaluation of the upcoming NSR version and assess quality impact on various slices.
         */
        nsrVersionedData?: Schema$NSRVersionedItem[];
        /**
         * PairwiseQ data for QTJ. This field is *not* propagated to shards, but is populated at serving time by go/web-signal-joins. See b/175762140
         */
        pairwiseqScoringData?: Schema$PairwiseQScoringData;
        /**
         * Versioned PairwiseQ score to be used in continuous evaluation of the upcoming PairwiseQ versions and assess quality impact on various slices.
         */
        pairwiseqVersionedData?: Schema$PairwiseQVersionedItem[];
        /**
         * This is the encoding of Panda fields in the proto SiteQualityFeatures in quality/q2/proto/site_quality_features.proto. The encoding/decoding is performed using functions from quality_coati::coati_util.
         */
        pandaDemotion?: number | null;
        /**
         * Encoded page-level PQ signals.
         */
        pqData?: number | null;
        /**
         * Stripped page-level signals, not present in the encoded field 'pq_data'.
         */
        pqDataProto?: Schema$QualityNsrPQData;
        productReviewPDemotePage?: number | null;
        /**
         * Product review demotion/promotion confidences. (Times 1000 and floored)
         */
        productReviewPDemoteSite?: number | null;
        productReviewPPromotePage?: number | null;
        productReviewPPromoteSite?: number | null;
        /**
         * Fields product_review_p_review_page and product_review_p_uhq_page are for promoting/demoting HQ/LQ review pages in NGS. See go/pr-boosts for details. The possibility of a page being a review page.
         */
        productReviewPReviewPage?: number | null;
        /**
         * The possibility of a page being a high quality review page.
         */
        productReviewPUhqPage?: number | null;
        /**
         * Scam model score. Used as one of the web page quality qstar signals. Value range from 0 to 1023.
         */
        scamness?: number | null;
        /**
         * serp demotion: applied in Qstar.
         */
        serpDemotion?: number | null;
        /**
         * site_authority: converted from quality_nsr.SiteAuthority, applied in Qstar.
         */
        siteAuthority?: number | null;
        /**
         * Versioned TopicEmbeddings data to be populated later into superroot / used directly in scorers.
         */
        topicEmbeddingsVersionedData?: Schema$QualityAuthorityTopicEmbeddingsVersionedItem[];
        /**
         * Unauthoritative score. Used as one of the web page quality qstar signals.
         */
        unauthoritativeScore?: number | null;
        /**
         * NSR for low-quality videos, converted from quality_nsr.NsrData.vlq_nsr.
         */
        vlqNsr?: number | null;
    }
    export interface Schema$ConceptsConceptId {
        conceptId?: string | null;
        /**
         * uint64 bring lots of issues, and string a better practice.
         */
        id?: string | null;
    }
    /**
     * The following protobuf is used to store an attribution from one page to (usually) one other page, giving credit for the content. This information is used during ranking to promote the attributed page. This protobuf is copied from a quality_contra::SelectedAttribution. See //quality/contra/authorship/attribution and https://qwiki.corp.google.com/display/Q/ContentTrackingContentAttribution.
     */
    export interface Schema$ContentAttributions {
        /**
         * Selected outgoing attributions extracted on FreshDocs.
         */
        freshdocsOutgoing?: Schema$ContentAttributionsOutgoingAttribution[];
        /**
         * Selected outgoing attributions extracted via offline MR jobs.
         */
        offlineOutgoing?: Schema$ContentAttributionsOutgoingAttribution[];
        /**
         * Selected outgoing attributions extracted online on Alexandria.
         */
        onlineOutgoing?: Schema$ContentAttributionsOutgoingAttribution[];
    }
    /**
     * This is a copy of quality_contra::SelectedAttribution::SelectedInfo. The url is converted to docid and other fields are copied directly.
     */
    export interface Schema$ContentAttributionsOutgoingAttribution {
        bestEvidenceType?: string | null;
        docid?: string | null;
        properties?: number | null;
        usableForClustering?: boolean | null;
    }
    export interface Schema$ContentAwareCropsIndexing {
        /**
         * Compact representation for Mustang storage. See image/search/utils/packed_crops.h for details on the packing format.
         */
        mustangBytes?: string | null;
        mustangBytesVersion?: number | null;
    }
    /**
     * Contains lexical metadata for a given reference. For example, this proto will be used to store locale-specific Lexical mids for contact relationships (e.g. /g/11gv0vypg4 is the mid for mother in english and /g/11gmy_gv87 is for mother in french) as an extension to QRefAnnotation::other_metadata, when available.
     */
    export interface Schema$CopleyLexicalMetadata {
        /**
         * Mid for an entity that has lexical data (a LexiconEntry). See https://g3doc.corp.google.com/nlp/generation/g3doc/lexical_data.md for for more information about lexical data. This is the canonical mid for this entity (eg. it would be for "mother" in EN even if user referred to "mom").
         */
        canonicalLexicalMid?: string | null;
    }
    /**
     * Represents a reference made by a user that refers to some personal entity.
     */
    export interface Schema$CopleyPersonalReference {
        /**
         * The manner in which the entity was referenced (e.g. "my hotel", "the airport").
         */
        personalReferenceType?: string | null;
    }
    /**
     * General message used to store metadata about references to personal entities, even if those entities cannot be resolved.
     */
    export interface Schema$CopleyPersonalReferenceMetadata {
        /**
         * A list of all references made. Empty if no personal references exist. Multiple references can be present when multiple references were made in a single query, or the type of reference was ambiguous.
         */
        references?: Schema$CopleyPersonalReference[];
        /**
         * The strength of the personal reference. For example "my flight" may receive a high reference_score, whereas "the airport" may receive a low score.
         */
        referenceScore?: number | null;
        /**
         * Subreference metadata for all compound references on this span.
         */
        subreferenceMetadata?: Schema$CopleySubreferenceMetadata;
    }
    export interface Schema$CopleySourceTypeList {
        sourceTypeMetadata?: Schema$CopleySourceTypeMetadata[];
    }
    /**
     * Contains the source and type information related to a personal entity, for example if it's an hotel or a restaurant (type) and if it comes from gmail, calendar, etc. (source). Next ID: 13
     */
    export interface Schema$CopleySourceTypeMetadata {
        /**
         * Annotation ID of a contact annotation, e.g. a relationship set via Assistant. This ID is generated by People Write Server. It is used to delete Contact Annotations via People API.
         */
        contactAnnotationId?: string | null;
        displayableName?: string | null;
        /**
         * Only used if personal_data_provenance == PERSONAL_SOURCE_GMAIL. Used to create a link to the source email in the form: mail.google.com/mail/u/0/?extsrc=sync&client=h&plid={email_identifier\}
         */
        emailIdentifier?: string | null;
        /**
         * Populated for some footprints data sources; uniquely identifies the footprint that generated the personal data that this provenance is attached to.
         */
        eventId?: Schema$EventIdMessage;
        localDiscoverySettingsMetadata?: Schema$PersonalizationSettingsApiProtoLocalDiscoveryLocalDiscoverySettingsMetadata;
        personalDataProvenance?: string | null;
        personalDataType?: string | null;
        provenanceCategory?: string[] | null;
        /**
         * Sensitivity applying to this copley annotation.
         */
        sensitivity?: Schema$KnowledgeAnswersSensitivitySensitivity;
    }
    /**
     * Represents the most compound resolved entities and most nested unresolved references for a span. Useful for punting.
     */
    export interface Schema$CopleySubreferenceMetadata {
        /**
         * Resolved entities are sorted from highest resolution score to lowest.
         */
        mostCompoundResolvedEntities?: Schema$CopleySubreferenceResolution[];
        /**
         * This is a merged representation of the compound reference having the most_compound_resolved_entities as an argument.
         */
        mostNestedUnresolvedReference?: Schema$CopleySubreferenceReference;
    }
    /**
     * Represents a reference that may be part of a larger compound reference. For example, "my brother's birthday" will have a subreference that may have references for "my brother".
     */
    export interface Schema$CopleySubreferenceReference {
        /**
         * Type of reference. There may be multiple for a single reference (e.g. relationship and contact).
         */
        personalReferenceTypes?: string[] | null;
        /**
         * Highest reference score for any references merged in this span.
         */
        referenceScore?: number | null;
        /**
         * Only set for unresolved relationship references and can be used to get the canonical word for the relationship (e.g. "mother") in TTS.
         */
        relationshipLexicalInfo?: Schema$CopleyLexicalMetadata;
    }
    /**
     * Represents a resolution that may be part of a larger compound reference. For example, "my brother's birthday" will have a subreference that may have resolutions for "my brother".
     */
    export interface Schema$CopleySubreferenceResolution {
        /**
         * Can be used with PKG Service for looking up metadata about this entity at fulfillment/GenX time.
         */
        mid?: string | null;
        /**
         * Name of the entity represented by this resolution.
         */
        name?: string | null;
        /**
         * A resolution score of 0 indicates that it did not resolve to a real entity.
         */
        resolutionScore?: number | null;
    }
    export interface Schema$CorpusSelectionInfo {
        corpus?: string | null;
        /**
         * Corpus specific score for an image
         */
        corpusScore?: number | null;
        /**
         * Whether an image was selected for indexing.
         */
        isSelectedForIndexing?: boolean | null;
        /**
         * Set of referrers indexed with the image.
         */
        referrerDocid?: string[] | null;
        /**
         * Set of referrer urls indexed with the image.
         */
        referrerUrls?: string[] | null;
    }
    export interface Schema$CountryClickDistribution {
        /**
         * To store confidence in the distribution in cases when total is not set.
         */
        confidence?: number | null;
        item?: Schema$CountryClickDistributionItem[];
        /**
         * To store total clicks on this page/domain.
         */
        total?: number | null;
    }
    export interface Schema$CountryClickDistributionItem {
        doubleValue?: number | null;
        name?: string | null;
        value?: number | null;
    }
    /**
     * If you add new fields to this message, do not use any tag value less than the "Next free tag" below. The lower tag values might be missing in this file, but they were used in past for some field, so cannot be used again. Next free tag: 44
     */
    export interface Schema$CountryCountryAttachment {
        /**
         * Store weighted click distribution for page level country-id classification.
         */
        clickDistribution?: Schema$CountryClickDistribution;
        /**
         * Is true if the country attachment was computed through the UGC pipeline.
         */
        countryidFromUgc?: boolean | null;
        /**
         * A non critical field to store debug info for a country attachment. Used in experiments and for debugging.
         */
        debug?: string | null;
        /**
         * Set to the signal source URLs when merging country signals in Alexandria during sitemoves. Essentially if sites A and B move to C, and we merge A and B's signal to C, in the countryattachment signal C will have URL A and B as source_url. Only used for debugging and it doesn't show up in docjoins.
         */
        debugSourceUrl?: string[] | null;
        /**
         * Specifies the origin of `geo_locations`. Right now, it can either come from deprecated Docloc system or the new Brainloc system when Docloc doesn't have sufficient evidence.
         */
        documentLocationSource?: string | null;
        existNextLevel?: boolean | null;
        /**
         * Booleans to keep track of where the country-id of the page came from. These are used for debugging and/or unittests, and cleared in production.
         */
        fromLanguageFallback?: boolean | null;
        fromRestricts?: boolean | null;
        fromSgDomains?: boolean | null;
        fromTld?: boolean | null;
        fromUgc?: boolean | null;
        fromUrlPattern?: boolean | null;
        fromWmx?: boolean | null;
        /**
         * New MetroID: Now called GeoLocations since the locations could be sublocalities, cities or states. GeoLocations are always more fine grained than country. TODO (jayeshv): Once new MetroID/GeoLocations is launched everywhere, deleted old MetroID related fields.
         */
        geoLocations?: Schema$CountryGeoLocations;
        global?: boolean | null;
        /**
         * Set to true if the local_countries field can be used for country restricts as well.
         */
        isValidForCountryRestrict?: boolean | null;
        /**
         * two-letter(lower-case) countrycode, e.g. us countries that is local to
         */
        localCountries?: string[] | null;
        /**
         * Fields that actually store the country id in docjoins. The format of this data is defined in //i18n/identifiers/stableinternalregionconverter.cc. Converter defined there can be used to convert it to RegionCode format.
         */
        localCountryCodes?: number[] | null;
        /**
         * Metro locations: list of NavBoost feature V2 associated with a doc, along with the enclosing province. Metro locations with new tags.
         */
        metroIdList?: Schema$CountryMetroNBFeature[];
        /**
         * Metro level data. metro_location_id stores geotokens for metro restricts.
         */
        metroLocationId?: string[] | null;
        /**
         * Metro navboost: list of (NavBoost feature V2, navboost float) pairs.
         */
        metroNavboost?: Schema$CountryMetroNBFeature[];
        provinceGeotokenList?: Schema$CountryProvinceGeotoken[];
        /**
         * two-letter(lower-case) countrycode, e.g. us countries that is related to, but not local to
         */
        relatedCountries?: string[] | null;
        relatedCountryCodes?: number[] | null;
        /**
         * List of two-letter(lower-case) countrycodes(e.g. us) valid for restricts. Typically cloned out of local_countries if is_valid_for_country_restrict is set to true.
         */
        restrictCountries?: string[] | null;
        /**
         * [Experimental]: Top salient countries for a doc. If a country can not be found on this field it can be considered that this doc is not relevant to it.
         */
        salientCountries?: Schema$CountrySalientCountry[];
        salientCountrySet?: Schema$QualitySalientCountriesSalientCountrySet;
        /**
         * Domain name of keys in filtering metro reducer class, used only by the intermediate mapreduces to produce filtered data.
         */
        sitename?: string | null;
        /**
         * Super global pages get lesser demotion than global pages. A document can only be either global or super_global but not both.
         */
        superGlobal?: boolean | null;
        urlPatternBasedCountry?: number | null;
        /**
         * Language and country extracted using the URL pattern map.
         */
        urlPatternBasedLanguage?: number | null;
        /**
         * This is used to store the visible country id computed from logs data
         */
        userVisibleCountryFromLogs?: string | null;
        /**
         * This is the country id we show to users on the result page. This is kept different from country demotion country id because we dont want to expose our backoff and url based detection algorithm - also we want to be ultra conservative in showing this.
         */
        userVisibleLocalCountry?: number | null;
        /**
         * If result is global, store weight above ideal, as a confidence signal. Used in query localness, cleared in production CountryAttachment.
         */
        weightAboveIdealForLocalness?: number | null;
        /**
         * Country specified for a web-site through webmaster console.
         */
        wmxCountry?: string | null;
    }
    /**
     * Stores one location and all meta-data associated with that location.
     */
    export interface Schema$CountryGeoLocation {
        /**
         * The radius (in miles) around the assigned location that the document gets 50% of its clicks.
         */
        clickRadius50Percent?: number | null;
        /**
         * Confidence on the location. Ranges in [0.0, 1.0]. Cleared during index creation.
         */
        confidence?: number | null;
        /**
         * Confidence mapped to [0, 100]. Converted to integer for efficient storage. Populated during index creation.
         */
        confidencePercent?: number | null;
        /**
         * Used for compressed docloc data. In compressed data, instead of location_info, only an integer ID for that LocationInfo is stored. A separate lookup table is used to get full LocationInfo from the internal ID.
         */
        internalId?: number | null;
        locationInfo?: Schema$CountryLocationInfo;
        /**
         * True if this location is assigned to one of the subpages, and not to the page itself. If the total number of locations assigned to all the subpages of a page is small (usually up to 5), then that page also gets assigned those locations, and this flag is set for those locations.
         */
        propagatedFromASubpage?: boolean | null;
    }
    /**
     * List of locations assigned to a document.
     */
    export interface Schema$CountryGeoLocations {
        geoLocation?: Schema$CountryGeoLocation[];
        /**
         * This will be set to true for documents which receive several clicks but are not assigned any location because the click distribution is flat. Typical examples are global sites like facebook.com, chains like walmart.com, informational sites like wikipedia.org etc. This flag is not propagated to deeper pages since this signal is meant to indicate that a website or a part of website is conclusively non-local, so propagating this information to deeper pages does not make sense. If this flag is set, then the only possible geo_location will be the ones which are propagated_from_a_subpage.
         */
        isNonLocationSpecific?: boolean | null;
        /**
         * Depth of the URL from it's nearest parent in GeoLocation data. Webpages inherhit locations from their parent pages. For example, if foo.com/a is assigned location L1, and foo.com/a/b is not assigned any location, then http://www.foo.com/a/b inherits location L1 from it's nearest parent foo.com/a in GeoLocation data. This attribute is the distance from the nearest parent which is present in GeoLocation data. In this particular case, it will be 1.
         */
        propagationDepthFromParent?: number | null;
    }
    /**
     * This represents one location.
     */
    export interface Schema$CountryLocationInfo {
        /**
         * The latitude and longitude of the conceptual center of the location. For cities, this would be the center of the downtown, or maybe the location of city hall. For states and countries it might be the capital city. But there are no guarantees and this may be any random point inside the location.
         */
        center?: Schema$GeostorePointProto;
        city?: string | null;
        /**
         * Human readable name hierarchy. Only the relevant fields will be present. For example for city GeoLocations, sub_locality field will not be present. Cleared during index creation.
         */
        country?: string | null;
        county?: string | null;
        /**
         * Oyster feature ID of the enclosing state. Cleared during index creation.
         */
        enclosingStateFeatureId?: Schema$GeostoreFeatureIdProto;
        /**
         * Oyster feature ID of the location. Cleared during index creation.
         */
        featureId?: Schema$GeostoreFeatureIdProto;
        state?: string | null;
        /**
         * 32 bit fingerprint of the feature id of the state of this location. For cities and sub-localities it will be the enclosing state. For state locations, it will be fingerprint of the feture-id of the location itself. Populated during index creation.
         */
        stateIdFprint?: number | null;
        subLocality?: string | null;
        /**
         * Type of the location (sub-locality, city, state etc).
         */
        type?: string | null;
    }
    /**
     * A metro feature, keyed by NavBoost feature id V2. This can be a metro id, a boost, or extended in the future to add probabilities or weights.
     */
    export interface Schema$CountryMetroNBFeature {
        /**
         * The enclosing_province_geotoken is a 32 bit fingerprint of the state encosing the (metro) id. MetroId's can span multiple states. Enclosing geotoken is filled in with the state name for disambiguation. ProvinceGeotoken field is different as it indicates an "interest". Format: 32 bit fingerprint(__state__country).
         */
        enclosingProvinceGeotoken?: number | null;
        /**
         * A 32 bit navboost v2 feature id encoding (country, language, metro). NavBoosterUtils class (google3/quality/navboost/nav_booster_utils.h) provides functions to decode this feature.
         */
        id?: number | null;
        /**
         * This is the multiplier to apply to the result for this locale & query. NOTE: This is for serving purposes only and should not be populated in the index.
         */
        navboost?: number | null;
    }
    /**
     * A 32 bit fingerprint of a state level geotoken. The geotoken is in the following format: __state__country. These indicate a page is of interest to these states/regions of a country. The use of message is to enable easy additions of probabilities or weights per metro id in the future.
     */
    export interface Schema$CountryProvinceGeotoken {
        geotoken?: number | null;
    }
    /**
     * Salient Countries is an estimated probability (salience) of a doc to be relevant to a country. On this message, countries are represented as int32 (the format of this data is defined in i18n/identifiers/stableinternalregionconverter.cc). Salience is a value in range [0.0 - 1.0] in which 1.0 represents a high likelihood to be relevant to the country
     */
    export interface Schema$CountrySalientCountry {
        compressedSalience?: number | null;
        countryCode?: number | null;
        salience?: number | null;
    }
    /**
     * Proto contains parameters for a multiple component distributions, where each component has non-negative weight and the sum of component weights is 1.
     */
    export interface Schema$CrawlerChangerateMultipleComponentDistribution {
        components?: Schema$CrawlerChangerateSingleComponentDistribution[];
    }
    /**
     * Proto contains parameters of a single component distribution.
     */
    export interface Schema$CrawlerChangerateSingleComponentDistribution {
        /**
         * Scaling factor to ensure the approximated posterior to have the same scale as the product of prior and likelihood. This value is used to compute posterior weights. Uses log scale to provide a wider range. This field is for internal use only.
         */
        logScaling?: number | null;
        /**
         * The type indicates the type of the distribution.
         */
        type?: string | null;
        /**
         * The weight is only used in multiple component scenarios.
         */
        weight?: number | null;
    }
    /**
     * NEXT_TAG: 13
     */
    export interface Schema$CrawlerChangerateUrlChange {
        /**
         * Duplicate UrlChanges crawled within a specified time range will be merged together. UrlChanges are considered duplicates if the simhash, simhash_is_trusted, simhash_v2, simhash_v2_is_trusted, and shingle_simhash are the same. additional_changes_merged indiciates the number of duplicate UrlChanges merged into this UrlChange.
         */
        additionalChangesMerged?: number | null;
        /**
         * Deprecated fields. The fraction of tiles (0 to 1) that changed.
         */
        fractionalTileChange?: number | null;
        /**
         * The length in seconds of the change.
         */
        interval?: number | null;
        /**
         * Whether the content of the off-domain links changed.
         */
        offDomainLinksChange?: boolean | null;
        /**
         * The new count of off-domain links, if they changed.
         */
        offDomainLinksCount?: number | null;
        /**
         * The new count of on-domain links, if the count changed.
         */
        onDomainLinksCount?: number | null;
        /**
         * Whether the number of on-domain links changed.
         */
        onDomainLinksCountChange?: boolean | null;
        /**
         * The old simhash value obtained from shingles.
         */
        shingleSimhash?: Schema$IndexingConverterShingleFingerprint;
        /**
         * The simhash-v1 value. Use of simhash-v1 is deprecated, and newer UrlChange should only contain simhash-v2. During this transition period, UrlChange can contain either simhash or simhash_v2. It is possible that previous UrlChange only contain simhash-v1 and the next UrlChange only contain simhash-v2. In this case, we skip that interval in our changerate computation. [go/changerate-simhash-v2-migration]
         */
        simhash?: string | null;
        /**
         * Whether the simhash-v1 should be trusted.
         */
        simhashIsTrusted?: boolean | null;
        /**
         * The simhash-v2 value.
         */
        simhashV2?: string | null;
        /**
         * Whether the simhash-v2 value should be trusted.
         */
        simhashV2IsTrusted?: boolean | null;
    }
    /**
     * The next available field number is 22. To access the best estimate of change period, please use GetChangePeriod in predict-change-rate.h to select between this and other change period estimates below.
     */
    export interface Schema$CrawlerChangerateUrlChangerate {
        /**
         * The approximated posterior distribution.
         */
        approximatedPosterior?: Schema$CrawlerChangerateMultipleComponentDistribution;
        /**
         * The "significance" of the average change we saw of this document (from 0 to 1). Influenced by content changes. This can be used for prioritizing the crawl (higher significance first).
         */
        averageChangeSignificance?: number | null;
        /**
         * //////////////////////////////////////////////////////////////////////////// The classic changerate estimation. //////////////////////////////////////////////////////////////////////////// The classic estimate of change period (in seconds). It is computed by inserted a "fake" change and no-change interval as a prior distribution. This field is generally not used and should NOT be accessed directly. See above for correct method for determining the change period estimate.
         */
        changeperiod?: number | null;
        /**
         * The confidence (between 0 and 1) in the changeperiod guess.
         */
        confidence?: number | null;
        /**
         * //////////////////////////////////////////////////////////////////////////// The changerate estimation based on the global prior. //////////////////////////////////////////////////////////////////////////// The global-based changeperiod. This is our estimate (in seconds) for the average time between changes. It is computed using the new prior method based on global_based_prior_period and the global_based_prior_strength specified below. This is used for computing pattern priors. Use pattern_based_change_period or changeperiod fields for all other purposes.
         */
        globalBasedChangePeriod?: number | null;
        /**
         * The 'confidence' of the global-based changeperiod. This is the n-th root of the posterior evaluated at MAP point, where n is the number of history intervals. For now, it is hard to interpret the meaning of the absolute values of 'average' posterior cross different sets of data.
         */
        globalBasedChangePeriodConfidence?: number | null;
        /**
         * The 2 parameters below specify the prior employed in calculating the global_based_change_period. These values are precomputed through an offline analysis and specified via flags.
         */
        globalBasedPriorPeriod?: number | null;
        globalBasedPriorStrength?: number | null;
        /**
         * The last time (unix timestamp) we saw a changed copy of the document. Provided iff we have seen the page change.
         */
        lastChanged?: number | null;
        /**
         * The "significance" of the last change we saw of this document (from 0 to 1). Influenced by content changes, etc. This can be used for prioritizing the crawl (higher significance first).
         */
        lastChangeSignificance?: number | null;
        /**
         * The last time (unix timestamp) we saw a fetched copy of the document.
         */
        lastFetched?: number | null;
        /**
         * The number of intervals we've seen for this document (where an interval is two different versions).
         */
        numIntervals?: number | null;
        /**
         * //////////////////////////////////////////////////////////////////////////// The changerate estimation based on the pattern prior. //////////////////////////////////////////////////////////////////////////// The pattern-based changeperiod. This is our estimate (in seconds) for the average time between changes. It is calculated based on the pattern_based_prior_period and pattern_based_prior_strength below. This quantity will eventually replace the old changeperiod calculation.
         */
        patternBasedChangePeriod?: number | null;
        /**
         * The same as global_based_change_period_confidence, except it is computed using pattern based priors.
         */
        patternBasedChangePeriodConfidence?: number | null;
        /**
         * The lower edge of a confidence interval for the pattern-based change period.
         */
        patternBasedLowerChangePeriod?: number | null;
        /**
         * The 2 parameters below specify the prior employed in calculating the pattern_based_change_period. These values are calculated in a separate process and looked up based on the URL pattern.
         */
        patternBasedPriorPeriod?: number | null;
        patternBasedPriorStrength?: number | null;
        /**
         * The version number of the algorithm, refer to ChangePeriodVersion for more information.
         */
        patternChangePeriodVersion?: number | null;
        /**
         * //////////////////////////////////////////////////////////////////////////// Basic information of a document. //////////////////////////////////////////////////////////////////////////// The type of the document determined by crawl histories, refer to TYPE for more information.
         */
        type?: number | null;
        /**
         * //////////////////////////////////////////////////////////////////////////// The UGC changerate estimation. //////////////////////////////////////////////////////////////////////////// Information on change period generated from user generated content (UGC) change history.
         */
        ugcChangePeriod?: number | null;
        ugcChangePeriodConfidence?: number | null;
    }
    export interface Schema$CrawlerChangerateUrlHistory {
        /**
         * All the changes we've seen for this URL.
         */
        change?: Schema$CrawlerChangerateUrlChange[];
        /**
         * The latest version we've seen.
         */
        latestVersion?: Schema$CrawlerChangerateUrlVersion;
        /**
         * This field in only set in 'url_history' column of Union repository to avoid having to read CompositeDocs.
         */
        url?: string | null;
    }
    /**
     * NEXT_TAG: 15
     */
    export interface Schema$CrawlerChangerateUrlVersion {
        /**
         * Same as the field in UrlChange. This allows us to merge identical UrlVersions into a single UrlVersion.
         */
        additionalChangesMerged?: number | null;
        /**
         * The content type of the page.
         */
        contentType?: number | null;
        /**
         * Whether this is an IMS response (a 304, not modified).
         */
        isImsNotModified?: boolean | null;
        /**
         * The date from the LastModified header, if present.
         */
        lastModified?: number | null;
        /**
         * The checksum of all the off-domain links on the page.
         */
        offDomainLinksChecksum?: number | null;
        /**
         * The count of all the off-domain links on the page.
         */
        offDomainLinksCount?: number | null;
        /**
         * The count of all the on-domain links on the page. We aren't worried about the contents themselves, since they might often change (e.g., session ids). We assume that a change in the number of links is significant, however.
         */
        onDomainLinksCount?: number | null;
        /**
         * The simhash value obtained from shingles.
         */
        shingleSimhash?: Schema$IndexingConverterShingleFingerprint;
        /**
         * The simhash-v1 value. The simhash-v1 is now deprecated and new UrlVersions should only populate simhash-v2. During migration phase from using simhash-v1 to simhash-v2, it is possible that previous UrlChange only contain simhash-v1 and the next UrlChange / UrlVersion could only contain simhash-v2. In this case, we skip that interval in our changerate computation. [go/changerate-simhash-v2-migration]
         */
        simhash?: string | null;
        /**
         * Whether the simhash-v1 should be trusted.
         */
        simhashIsTrusted?: boolean | null;
        /**
         * The simhash-v2 value.
         */
        simhashV2?: string | null;
        /**
         * Whether the simhash-v2 value should be trusted.
         */
        simhashV2IsTrusted?: boolean | null;
        /**
         * The tiles of the document body. We use int32s instead of int64s (the norm) in order to save space. Since rare inaccuracy doesn't really matter, we've decided this is an okay tradeoff.
         */
        tile?: number[] | null;
        /**
         * The timestamp we crawled the page.
         */
        timestamp?: number | null;
    }
    export interface Schema$CrowdingPerDocData {
        newscluster?: Schema$CrowdingPerDocDataNewsCluster[];
    }
    /**
     * For crowding in news we need to keep data about the last X clustering iterations around.
     */
    export interface Schema$CrowdingPerDocDataNewsCluster {
        /**
         * Fingerprint combination of all urls in a cluster
         */
        ClusterId?: string | null;
        /**
         * This is the X in the "and X related \>\>" link on headlines and search results
         */
        ClusterSize?: number | null;
        /**
         * When was this clustered (needed for keeping last X iterations around and discarding earlier ones)
         */
        ClusterTimeStamp?: number | null;
    }
    export interface Schema$DeepCropIndexing {
        /**
         * Compact representation for indexing, see creatism::CropBitmap for details on the packing format.
         */
        cropBytes?: string | null;
    }
    export interface Schema$DeepCropPixels {
        /**
         * Pixels version of the DeepCropIndexing bytes, this corresponds to the crop box for a given image (based input image size and desired aspect ratio).
         */
        x0?: number | null;
        x1?: number | null;
        y0?: number | null;
        y1?: number | null;
    }
    /**
     * NOTE: In segindexer, the docproperties of a document may be reused from a previous cycle if its content is not changed. If you add a new field to DocProperties, make sure it is taken care (i.e., gets copied from a previous cycle to the current document) in CDocProperties::EndDocument().
     */
    export interface Schema$DocProperties {
        /**
         * The average weighted font size of a term in the doc body
         */
        avgTermWeight?: number | null;
        /**
         * Missing or meaningless title
         */
        badTitle?: boolean | null;
        badtitleinfo?: Schema$DocPropertiesBadTitleInfo[];
        /**
         * A Language enum value. See: go/language-enum
         */
        languages?: number[] | null;
        /**
         * Leading text information generated by google3/quality/snippets/leadingtext/leadingtext-detector.cc
         */
        leadingtext?: Schema$SnippetsLeadingtextLeadingTextInfo;
        numPunctuations?: number | null;
        numTags?: number | null;
        /**
         * The number of tokens, tags and punctuations in the tokenized contents. This is an approximation of the number of tokens, tags and punctuations we end up with in mustang, but is inexact since we drop some tokens in mustang and also truncate docs at a max cap.
         */
        numTokens?: number | null;
        /**
         * The restricts for CSE structured search.
         */
        proseRestrict?: string[] | null;
        restricts?: string[] | null;
        /**
         * The time CDocProperties::StartDocument() is called, encoded as seconds past the epoch (Jan 1, 1970). This value is always refreshed and not reused.
         */
        timestamp?: string | null;
        /**
         * Extracted from the title tag of the content. This is typically extracted by TitleMetaCollector defined at google3/segindexer/title-meta-collector.h. Please see its documentation for the format and other caveats.
         */
        title?: string | null;
    }
    /**
     * Bad title information.
     */
    export interface Schema$DocPropertiesBadTitleInfo {
        score?: number | null;
        type?: string | null;
    }
    /**
     * Protocol buffer for storing compressed feature.
     */
    export interface Schema$DrishtiCompressedFeature {
        featureName?: string | null;
        /**
         * in_range_bitstream is the string produced by range coder, while out_of_range_bitstream corresponds to the overflow stream, which is used whenever a quantized value is out of range. See https://cs.corp.google.com/piper///depot/google3/research/vision/piedpiper/brain/python/layers/entropy_models.py?l=225&cl=234825412
         */
        inRangeBitstream?: string | null;
        outOfRangeBitstream?: string | null;
    }
    export interface Schema$DrishtiDenseFeatureData {
        /**
         * If extra is present it must be of the same length as value.
         */
        extra?: Schema$DrishtiFeatureExtra[];
        generalExtra?: Schema$DrishtiFeatureExtra;
        /**
         * Dense data.
         */
        value?: number[] | null;
    }
    export interface Schema$DrishtiFeatureExtra {
    }
    export interface Schema$DrishtiFeatureSetData {
        /**
         * Extra information for this particular FeatureSetData (example timestamp of this frame in the video). (Almost never used).
         */
        extra?: Schema$DrishtiFeatureExtra[];
        /**
         * The following can have multiple FeatureSetElement(s) Each of these FeatureSetElement correspond to the various feature groups. One concrete example is the way these features are generated - example audio, video or OCR.
         */
        feature?: Schema$DrishtiFeatureSetDataFeatureSetElement[];
        /**
         * Labels for this particular FeatureSetData. (Almost never used). Only interesting when you have (for example) frame level labels.
         */
        label?: Schema$DrishtiLabelSetElement[];
    }
    /**
     * A FeatureSetElement stores the features coming from a single group.
     */
    export interface Schema$DrishtiFeatureSetDataFeatureSetElement {
        compressed?: Schema$DrishtiCompressedFeature;
        dense?: Schema$DrishtiDenseFeatureData;
        indexed?: Schema$DrishtiIndexedFeatureData;
        /**
         * A name for the feature group: example "AUDIO", "VIDEO", "OCR", etc.
         */
        name?: string | null;
        quantized?: Schema$DrishtiQuantizedDenseFeatureData;
        quantizedByteDense?: Schema$DrishtiQuantizedByteDenseFeatureData;
        quantizedByteIndexed?: Schema$DrishtiQuantizedByteIndexedFeatureData;
        sparse?: Schema$DrishtiSparseFeatureData;
    }
    /**
     * This represents a sequence (ordered) of FeatureSetData elements.
     */
    export interface Schema$DrishtiFeatureSetDataSequence {
        /**
         * FeatureSetData contains the features. In most scenarios, you only have one element. However, multiple elements are appropriate in case of videos where each element may correspond to a frame in the video.
         */
        element?: Schema$DrishtiFeatureSetData[];
        /**
         * Some extra information about this FeatureSetDataSequence. (Almost never used).
         */
        extra?: Schema$DrishtiFeatureExtra[];
        /**
         * Global (video-level) labels. In most cases, you only have one LabelSetElement. All the labels will be stored in this single LabelSetElement. Scenarios where you may have multiple LabelSetElement(s) is (for example) when you want to differentiate the labels into various sub-groups - eg, central vs relevant, kg-ids vs queries, etc.
         */
        label?: Schema$DrishtiLabelSetElement[];
        /**
         * If set, must be same length as element. Each entry is the timestamp in microseconds where the FeatureSetData element was extracted.
         */
        timestamp?: string[] | null;
    }
    export interface Schema$DrishtiIndexedFeatureData {
        /**
         * If extra is present it must be of the same length as index and value.
         */
        extra?: Schema$DrishtiFeatureExtra[];
        generalExtra?: Schema$DrishtiFeatureExtra;
        /**
         * Indexed data. index and value must be of the same length.
         */
        index?: string[] | null;
        value?: number[] | null;
    }
    export interface Schema$DrishtiLabelSetData {
        extra?: Schema$DrishtiFeatureExtra[];
        generalExtra?: Schema$DrishtiFeatureExtra;
        targetClass?: string[] | null;
        targetClassName?: string[] | null;
        targetValue?: number[] | null;
        targetWeight?: number[] | null;
        /**
         * Weight assigned to this set of labels.
         */
        weight?: number | null;
    }
    export interface Schema$DrishtiLabelSetElement {
        label?: Schema$DrishtiLabelSetData;
        name?: string | null;
    }
    /**
     * Proto message to store quantized dense feature data.
     */
    export interface Schema$DrishtiQuantizedByteDenseFeatureData {
        /**
         * If extra is present it must be of the same length as value.
         */
        extra?: Schema$DrishtiFeatureExtra[];
        generalExtra?: Schema$DrishtiFeatureExtra;
        /**
         * Quantized values for the feature.
         */
        value?: string | null;
    }
    /**
     * Proto message to store quantized indexed feature data.
     */
    export interface Schema$DrishtiQuantizedByteIndexedFeatureData {
        /**
         * If extra is present it must be of the same length as value.
         */
        extra?: Schema$DrishtiFeatureExtra[];
        generalExtra?: Schema$DrishtiFeatureExtra;
        index?: string[] | null;
        /**
         * Quantized values for the feature.
         */
        value?: string | null;
    }
    export interface Schema$DrishtiQuantizedDenseFeatureData {
        /**
         * If extra is present it must be of the same length as value.
         */
        extra?: Schema$DrishtiFeatureExtra[];
        generalExtra?: Schema$DrishtiFeatureExtra;
        /**
         * Quantized Dense data.
         */
        value?: string[] | null;
    }
    export interface Schema$DrishtiSparseFeatureData {
        /**
         * If extra is present it must be of the same length as label and value.
         */
        extra?: Schema$DrishtiFeatureExtra[];
        generalExtra?: Schema$DrishtiFeatureExtra;
        /**
         * Indexed data. label and value must be of the same length.
         */
        label?: string[] | null;
        value?: number[] | null;
    }
    /**
     * The attributes of encoded thumbnail images. Next id: 10.
     */
    export interface Schema$DrishtiVesperEncodedThumbnail {
        /**
         * Image size in bytes. Meaningful when contents are not stored inline (e.g., via `image_blob_id`).
         */
        byteSize?: string | null;
        /**
         * CRC-32 checksum of the image bytes. Can be used for data integrity check.
         */
        crc32c?: number | null;
        /**
         * JPEG/WEBP quality factor in range [0,100].
         */
        encodingQuality?: number | null;
        /**
         * Image encoding type.
         */
        encodingType?: string | null;
        height?: number | null;
        /**
         * The Blob ID of the thumbnail image in the Blobstore. We recommend absolute IDs with universe prefix if this field is passed across systems. The owner of this blob is also responsible for data Wipeout compliance.
         */
        imageBlobId?: string | null;
        /**
         * Encoded thumbnail bytes. Prefer this over `image_string` as we are not supposed to store image bytes in a proto string field.
         */
        imageBytes?: string | null;
        /**
         * Please migrate to `image_bytes`.
         */
        imageString?: string | null;
        /**
         * Thumbnail resolution.
         */
        width?: number | null;
    }
    /**
     * LINT: LEGACY_NAMES MovingThumbnail is defined as a short video clip that represents the whole video content. Next id: 17.
     */
    export interface Schema$DrishtiVesperMovingThumbnail {
        /**
         * The begin timestamp in milliseconds.
         */
        beginTimestampMs?: number | null;
        /**
         * The duration of the moving thumbnail in milliseconds. Note that the duration may not be the difference between begin_timestamp_ms and end_timestamp_ms, esp when the moving thumbnail covers multiple clips from the video.
         */
        durationMs?: number | null;
        encodedGifAnimation?: string | null;
        /**
         * The encoded video string.
         */
        encodedVideoString?: string | null;
        /**
         * The encoded WebP animation.
         */
        encodedWebpAnimation?: string | null;
        /**
         * The end timestamp in milliseconds.
         */
        endTimestampMs?: number | null;
        /**
         * Pixel height of the moving thumbnail.
         */
        height?: number | null;
        /**
         * MovingThumbnail id (e.g., the video id).
         */
        id?: string | null;
        /**
         * If set, this is the algorithm version used to generate this moving thumbnail.
         */
        movingThumbnailerVersion?: string | null;
        /**
         * MovingThumbnail name.
         */
        name?: string | null;
        /**
         * The score of the moving thumbnail.
         */
        score?: number | null;
        scoreComponents?: Schema$DrishtiVesperMovingThumbnailScoreComponents;
        /**
         * A set of single frame thumbnails in the MovingThumbnail.
         */
        thumbnails?: Schema$DrishtiVesperThumbnail[];
        /**
         * MovingThumbnail type.
         */
        type?: string | null;
        /**
         * The actual quality of the Webp animation. Note this value may not be equal to the quality value requested in the animation creator's options. This is because other requirements, such as the max file size, may force the creator to lower the actual quality value.
         */
        webpQualityLevel?: number | null;
        /**
         * Pixel width of the moving thumbnail.
         */
        width?: number | null;
    }
    /**
     * Sum of individual score components within a moving thumbnail. Used as input for weight fitting.
     */
    export interface Schema$DrishtiVesperMovingThumbnailScoreComponents {
        audienceRewindRatioScore?: number | null;
        iconicFaceScore?: number | null;
        matchingScore?: number | null;
        motionScore?: number | null;
        titleMatchingScore?: number | null;
        videoThumbQualityScore?: number | null;
    }
    /**
     * The attributes of a video thumbnail.
     */
    export interface Schema$DrishtiVesperThumbnail {
        /**
         * Thumbnail dense features
         */
        denseFeatures?: number[] | null;
        /**
         * Thumbnail image as an encoded image. Deprecated, use encoded_thumbnails instead.
         */
        encodedImageString?: string | null;
        /**
         * Thumbnail image as an encoded image with smaller resolution. Deprecated, use encoded_thumbnails instead.
         */
        encodedImageStringSmall?: string | null;
        /**
         * Encoded thumbnail images.
         */
        encodedThumbnails?: Schema$DrishtiVesperEncodedThumbnail[];
        /**
         * Thumbnail id.
         */
        id?: string | null;
        /**
         * Text in video thumbnails that was detected by OCR.
         */
        ocrText?: string | null;
        /**
         * Thumbnail quality scores.
         */
        qualityScores?: Schema$DrishtiVesperThumbnailQualityScore[];
        /**
         * If true, this thumbnail should update default thumbnail.
         */
        shouldUpdateDefaultThumbnail?: boolean | null;
        /**
         * Thumbnailer Version.
         */
        thumbnailerModelVersion?: string | null;
        /**
         * Thumbnail timestamp in milliseconds.
         */
        timestampMs?: number | null;
        /**
         * Thumbnail type.
         */
        type?: string | null;
        userReportedThumbnail?: Schema$DrishtiVesperUserReportUserReportedThumbnail;
        /**
         * All user reported thumbnails of interest.
         */
        userReportedThumbnails?: Schema$DrishtiVesperUserReportUserReportedThumbnail[];
        /**
         * Thumbnail version, i.e., the unix time in seconds when the thumbnail was created.
         */
        version?: number | null;
    }
    export interface Schema$DrishtiVesperThumbnailQualityScore {
        score?: number | null;
        type?: string | null;
    }
    /**
     * Proto holding values for details about human labels.
     */
    export interface Schema$DrishtiVesperUserReportHumanLabel {
        racyLevel?: string | null;
    }
    /**
     * Proto holding values for details about score and the source model.
     */
    export interface Schema$DrishtiVesperUserReportModelScore {
        modelName?: string | null;
        score?: number | null;
    }
    /**
     * Proto holding values for user reported thumbnails. Next id: 12
     */
    export interface Schema$DrishtiVesperUserReportUserReportedThumbnail {
        denseFeatures?: number[] | null;
        /**
         * Number of days in which volume is calculated.
         */
        duration?: number | null;
        humanLabel?: Schema$DrishtiVesperUserReportHumanLabel;
        /**
         * Daily aggregared impressions for the reported video.
         */
        impressions?: number | null;
        /**
         * Whether the thumbnail needs a human label.
         */
        needHumanLabel?: boolean | null;
        rawHumanLabels?: Schema$DrishtiVesperUserReportHumanLabel[];
        reportScore?: Schema$DrishtiVesperUserReportModelScore;
        reportType?: string | null;
        score?: Schema$DrishtiVesperUserReportModelScore;
        useCase?: string | null;
        /**
         * Number of reports.
         */
        volume?: number | null;
    }
    /**
     * Video level container for thumbnail with its attributes, e.g., timestamp, id, quality scores, annotations, or features.
     */
    export interface Schema$DrishtiVesperVideoThumbnail {
        /**
         * Video id.
         */
        id?: string | null;
        movingThumbnails?: Schema$DrishtiVesperMovingThumbnail[];
        thumbnails?: Schema$DrishtiVesperThumbnail[];
    }
    /**
     * Deep-linking data is used to construct a deep-link URI for an activity or frame's embed, such that on click, the user is taken to the right place in a mobile app. If the app is not installed, the user is taken to the app store. If not on mobile, an analogous web uri is used.
     */
    export interface Schema$EmbedsDeepLinkData {
        /**
         * Application ID (or project ID) from Google API Console.
         */
        appId?: string | null;
        /**
         * The data for a Google API Console client is entered by a developer during client registration and is stored in PackagingService.
         */
        client?: Schema$EmbedsPackagingServiceClient[];
        /**
         * The ID for non-URL content. Embeds may either have no analogous web presence or prefer a native mobile experience if supported. In the case of no web presence, instead of setting the "url" field of an embed, such developers will set this field and other content fields, e.g. thumbnail, title, description. If set, this field is used to construct the deep-link URI. Note that the native experience is preferred over the web link and the web link is used as a fallback.
         */
        deepLinkId?: string | null;
        /**
         * Analogous web presence. Used as desktop fallback or when no native link data is present.
         */
        url?: string | null;
    }
    /**
     * Represents an embedded object in an update. This is a wrapper class that can contain a single specific item proto in an extension field. Think of it as a base class like `Message` in Java. Each item proto must declare that it extends this proto: message ExampleObject { option (item_type) = EXAMPLE_OBJECT; extend EmbedClientItem { optional ExampleObject example_object = ; \} \} See go/es-embeds for details.
     */
    export interface Schema$EmbedsEmbedClientItem {
        /**
         * The canonical ID of the embed. If absent, the canonical ID is equal to the ID; if present, then the canonical ID represents an "equivalence class" of embeds which really refer to the same object. (For example, the URLs http://www.foo.com/ and http://foo.com/ refer to the same object) This field may be updated periodically by background processes.
         */
        canonicalId?: string | null;
        /**
         * Deep-linking data to take the user to the right place in a mobile app. This is only used for preview and attribution. Links that are specific to a given embed type should live on that specific embed's proto by using Link. See http://goto.google.com/mariana-design.
         */
        deepLinkData?: Schema$EmbedsDeepLinkData;
        /**
         * The ID of the embed. This corresponds to the schema.org ID, as represented in the ItemScope.id field.
         */
        id?: string | null;
        /**
         * The provenance of the embed, populated when the embed originated from a web fetch. The provenance captures information about the web page the embed had originated, like the URL that was retrieved and the retrieved URL's canonical form. This is useful in the case where the URL shared by the URL redirects (e.g., in the case of a shortened URL).
         */
        provenance?: Schema$EmbedsProvenance;
        /**
         * The ID used to identify the embed during rendering. This field will match ID, if set, otherwise it will be the ID of the parent activity. This field is only populated on the server for client use and is not persisted to storage.
         */
        renderId?: string | null;
        /**
         * Signature of the embed, used for verification.
         */
        signature?: string | null;
        /**
         * Transient generic data that will not be saved on the server.
         */
        transientData?: Schema$EmbedsTransientData;
        /**
         * The first value in `type` determines which extension field will be set. When creating an EmbedClientItem, you only need to set the first (primary) type in this field. When the server receives the item, it will populate the full type list using the parent annotations in the ItemType enum.
         */
        type?: string[] | null;
    }
    /**
     * Developers register a client in Google API Console to get the deep-linking feature on Google+ posts or frames about their apps. The client data is stored in this proto.
     */
    export interface Schema$EmbedsPackagingServiceClient {
        /**
         * Android app's package name to generate the deep-link URI.
         */
        androidPackageName?: string | null;
        /**
         * iOS app's App Store ID to generate the App Store URL when app is not installed on device.
         */
        iosAppStoreId?: string | null;
        /**
         * iOS app's bundle ID to generate the deep-link URI.
         */
        iosBundleId?: string | null;
        /**
         * Type of Google API Console client.
         */
        type?: string | null;
    }
    /**
     * This field records where the ItemScope was retrieved, if it was created via a web fetch.
     */
    export interface Schema$EmbedsProvenance {
        /**
         * Annotation blob from Annotation Service.
         */
        annotationBlob?: string | null;
        /**
         * Canonical url of the retrieved_url, if one was resolved during retrieval, for example, if a rel="canonical" link tag was provided in the retrieved web page.
         */
        canonicalUrl?: string | null;
        /**
         * The url originally passed in the PRS request, which should be used to re-discover the content. Note that this URL may be a forwarding service or link shortener (bit.ly), so it should not be assumed to be canonical, but should be used for navigation back to the original source of the itemscope.
         */
        inputUrl?: string | null;
        /**
         * Contains exact types as parsed, whether or not we recognized that type at parse time. If an itemscope is created by merging SchemaOrg markup and open graph markup then the first itemtype would be schemaorg type, the second would be open graph and so on. example: http://schema.org/VideoObject, og:video.movie Plain text; usually a URL
         */
        itemtype?: string[] | null;
        /**
         * The server retrieved timestamp (in msec).
         */
        retrievedTimestampMsec?: string | null;
        /**
         * The final URL that was the actual source of the itemscope, after any redirects.
         */
        retrievedUrl?: string | null;
    }
    /**
     * Transient generic data that will not be saved on the server.
     */
    export interface Schema$EmbedsTransientData {
    }
    /**
     * An EventId is a 128 bit identifier that uniquely identifies an event, such as a query. The event time recorded to the nearest microsecond, along with information about the process generating the event, ensures that all EventIds are unique. Details of this EventId are described in a design document: http://www/eng/designdocs/sawmill/adlogs.html
     */
    export interface Schema$EventIdMessage {
        /**
         * process_id is an integer that identifies the process on this machine that generated this event. This id is calculated once when the server generates its first event, and may change if the process is migrated to a different host. This field has a very specific format mandated by the logs collection infrastructure, which is subject to change WITHOUT NOTICE. As of 2013-01-09, this format is: uint32 process_id = (time(NULL) << 24) + (getpid() & 0xFFFFFF); If you are generating an extended_pid directly, you MUST use one of the maintained library implementations in order to generate it properly: C++ //borg/borgletlib:extended_pid; call borg::ExtendedPid() Python //borg/borgletlib/python:pyextendedpid; call ExtendedPid() Go //borg/borgletlib/go:extendedpid; call Get() Java //java/com/google/common/logging; call EventId.getPid() If you think that you need to parse the values of this field, please contact logs-collection-dev@ to discuss your requirement.
         */
        processId?: number | null;
        /**
         * server_ip is the IPv4 address or http://go/ghostid of the machine running the server that created this event message. This allows us to distinguish between events that occur at the same time on different servers. Format: 10.1.2.3 is stored as 0x0a010203, and GHostId 1 as 0x00000001.
         */
        serverIp?: number | null;
        /**
         * time_usec is the number of microseconds since the epoch (i.e., since 1970-01-01 00:00:00 UTC) as an int64: 1e6 * (unix time) + microseconds. Applications must ensure that EventIdMessages have increasing times, artificially increasing time_usec to one greater than the previous value if necessary. Alternate implementations were considered: 1. storing unix time and microseconds separately would require a bit more storage, and the convenience of having a single value representing the time seemed more useful than having trivial access to a unix time. 2. storing unix time in the upper 32 bits would allow for more precision - up to 4G events/second, but it wouldn't print nicely as a decimal value and it seems unlikely that any single server would ever sustain more than 1M events/second. 3. Java-compatible time uses millis - this would limit servers to 1000 events per second - too small. Other names for this field were considered, including time, time_stamp, and utime. We felt that including the units in the name would tend to produce more readable code. utime might be interpreted as user time. unix timestamp * 1e6 + microseconds
         */
        timeUsec?: string | null;
    }
    /**
     * the extra info response from ascorer used to build snippets in GWS experiments
     */
    export interface Schema$ExtraSnippetInfoResponse {
        matchinfo?: Schema$ExtraSnippetInfoResponseMatchInfo;
        querysubitem?: Schema$ExtraSnippetInfoResponseQuerySubitem[];
        tidbit?: Schema$ExtraSnippetInfoResponseTidbit[];
    }
    export interface Schema$ExtraSnippetInfoResponseMatchInfo {
        /**
         * bitvector of query items matching the title
         */
        titleMatches?: string | null;
        /**
         * bitvector of query items matching the url
         */
        urlMatches?: string | null;
        /**
         * bitvector of query items considered by chooser
         */
        weightedItems?: string | null;
    }
    /**
     * A query term, phrase, or synonym. An original query term or phrase is called an "item". Each item may have more than one "subitem" if there are synonyms. In rare cases a subitem may correspond to multiple items, such as the subitem "cia" in the query [central intelligence agency].
     */
    export interface Schema$ExtraSnippetInfoResponseQuerySubitem {
        /**
         * Additional information from the SnippetQuery.
         */
        isHighlighted?: boolean | null;
        isOptional?: boolean | null;
        /**
         * true iff this subitem was an original query term or phrase. Can only be false if want_all_query_subitems == true in the request.
         */
        isOriginal?: boolean | null;
        /**
         * a bitvector of the query items corresponding to this subitem. Typically only one bit is set, but see comment above.
         */
        items?: number | null;
        /**
         * text associated with this query item
         */
        text?: string | null;
        /**
         * the weight of this query item, as calculated by SubitemWeight(): https://qwiki.corp.google.com/display/Q/SnippetWeights
         */
        weight?: number | null;
    }
    export interface Schema$ExtraSnippetInfoResponseTidbit {
        anchorinfo?: Schema$ExtraSnippetInfoResponseTidbitAnchorInfo;
        /**
         * For tidbits only: position of tidbit in the document. More specifically, tidbit is found at [begin, end) in the document's tokens.
         */
        begin?: number | null;
        end?: number | null;
        /**
         * a bitvector of each query term within this tidbit
         */
        items?: string | null;
        /**
         * the score for this tidbit if there was one this is returned for Snippets and Tidbits and is only meaningful for comparing between objects of the same type (snippet to snippet, tidbit to tidbit)
         */
        score?: number | null;
        /**
         * the tidbit text, with search terms already highlighted
         */
        text?: string | null;
        type?: string | null;
    }
    /**
     * this information is specific to anchors and is only returned if type == ANCHOR
     */
    export interface Schema$ExtraSnippetInfoResponseTidbitAnchorInfo {
        offdomainCount?: number | null;
        ondomainCount?: number | null;
    }
    export interface Schema$FaceIndexing {
        /**
         * Always use image/search/utils/face_proto_util.h for packing and unpacking these values.
         */
        mustangBytes?: string | null;
        mustangBytesVersion?: number | null;
    }
    export interface Schema$FatcatCompactBinaryClassification {
        /**
         * Either binary_classifier will be set, using the enum above, or binary_classifier_name will be set, if it is not one of the classifiers in the enum - never both.
         */
        binaryClassifier?: string | null;
        binaryClassifierName?: string | null;
        /**
         * A CompactDocClassification will not usually have a weight. For a CompactSiteClassification, this value will be 0...127 corresponding to 0.0...1.0, indicating fraction of the site that this label applies to
         */
        discreteFraction?: number | null;
    }
    /**
     * The result of PetacatAnnotator. Each result contains: 1. RephilClusters; 2. At most 5 verticals from each taxonomy, sorted by the probabilities in descending order. 3. Binary classification results about page types and sensitive content. The types of taxonomies include: verticals4, geo, verticals4_geo, products_services, icm_im_audiences and icm_im_audiences_dev.
     */
    export interface Schema$FatcatCompactDocClassification {
        binary?: Schema$FatcatCompactBinaryClassification[];
        clusters?: Schema$FatcatCompactRephilClusters;
        epoch?: string | null;
        langCode?: string | null;
        /**
         * The id of the Rephil model used to generate the Rephil clusters. If it is absent, Rephil 4 is assumed.
         */
        rephilModelId?: number | null;
        taxonomic?: Schema$FatcatCompactTaxonomicClassification[];
        /**
         * not needed if the url is the sstable / bigtable key used during intermediate processing only
         */
        url?: string | null;
        /**
         * The relative weight of this doc within a site, typically something like pagerank or navboost impressions. May be a large number (like an actual pageviews estimate), not limited to a small range.
         */
        weight?: string | null;
    }
    export interface Schema$FatcatCompactRephilClusters {
        cluster?: Schema$FatcatCompactRephilClustersCluster[];
    }
    export interface Schema$FatcatCompactRephilClustersCluster {
        /**
         * 0...127 corresponds to 0.0 - 1.0
         */
        discreteWeight?: number | null;
        id?: number | null;
    }
    /**
     * A version of this proto for logging is available at cs/symbol:logged_fatcat.LoggedCompactTaxonomicClassification
     */
    export interface Schema$FatcatCompactTaxonomicClassification {
        category?: Schema$FatcatCompactTaxonomicClassificationCategory[];
        classifierVersion?: string | null;
        /**
         * Either taxonomy will be set, using the enum above, or taxonomy_name will be set (if the taxonomy is not one of the ones in the enum) - never both
         */
        taxonomy?: string | null;
        taxonomyName?: string | null;
    }
    /**
     * A taxonomic category. A classification consists of weight (totalling 1.0) distributed among one or more categories.
     */
    export interface Schema$FatcatCompactTaxonomicClassificationCategory {
        /**
         * go/petacat-faq#how-should-i-interpret-classification-weights Discrete to reduce size. Range is [0,127], corresponding to [0.0,1.0].
         */
        discreteWeight?: number | null;
        /**
         * The category's ID, e.g. 20 for /Sports in the go/verticals4 taxonomy.
         */
        id?: number | null;
    }
    /**
     * http://go/contact-detail-hash.
     */
    export interface Schema$FocusBackendContactDetailHash {
        type?: string | null;
        /**
         * The hash here will be a 16-bit weak hash to avoid reverse engineering for decoding the actual contact detail. The hash value is computed by the fingerprint of the raw contact detail mod 2^16.
         */
        value?: number | null;
    }
    /**
     * A contact pointer that represents a contact (http://go/assistant-contact-id).
     */
    export interface Schema$FocusBackendContactPointer {
        /**
         * The annotation ID. Annotations are only allowed to point to annotations that do not themselves have a pointer (avoids any possibilty of loops). Cast this field to string in javascript to make it compile in js.
         */
        annotationId?: string | null;
        /**
         * The raw contact ID from an active mobile device of the user.
         */
        deviceRawContactId?: Schema$FocusBackendDeviceRawContactId;
        /**
         * The contact ID from the Focus backend. Cast this field to string in javascript to make it compile in js.
         */
        focusContactId?: string | null;
        /**
         * Additional contact ids that are not actively used to match contact pointers to contacts.
         */
        otherContactId?: Schema$FocusBackendOtherContactId;
        /**
         * The secondary identifier of contact. It will be used when the primary ID doesn't match any contact.
         */
        secondaryId?: Schema$FocusBackendSecondaryContactId;
    }
    /**
     * //////////////////// DeviceContactId ////////////////////// Used by Device Contacts only. For more details see go/fbs-support-for-device-contacts.
     */
    export interface Schema$FocusBackendDeviceContactId {
        /**
         * DeviceContact Id.
         */
        ContactId?: string | null;
        /**
         * Device Id.
         */
        DeviceId?: Schema$FocusBackendDeviceId;
    }
    /**
     * //////////////////// DeviceId ////////////////////// Used by Device Contacts only. For more details see go/fbs-support-for-device-contacts.
     */
    export interface Schema$FocusBackendDeviceId {
        /**
         * The GServices id on Android. See go/android-id.
         */
        AndroidDeviceId?: string | null;
        /**
         * DeviceId.Hash is a SHA256 of some attribute of the user and device. For Android devices: Hash = SHA256(gaia_account_name + “:” + “1” + “:” + (android id - LSB)); For iOS devices: Hash = TOLOWER(HEX(GMCSComputeUserDeviceToken(userId, iOsDeviceId)) For more details see go/client-instance-id.
         */
        Hash?: string | null;
    }
    /**
     * //////////////////// DeviceRawContactId ////////////////////// Used by Device Contacts Only. The Raw ID as assigned to the original contact on the device. For more details see go/fbs-support-for-device-contacts.
     */
    export interface Schema$FocusBackendDeviceRawContactId {
        DeviceId?: Schema$FocusBackendDeviceId;
        /**
         * Raw ID assigned by the device. Cast this field to string in javascript to make it compile in js.
         */
        RawContactId?: string | null;
    }
    /**
     * Additional contact ids that are not actively used to match contact pointers to contacts. There may be overlap with primary or secondary contact ids.
     */
    export interface Schema$FocusBackendOtherContactId {
        /**
         * Device contact ID, when available: - The annotation points to a device contact, and the device contact id was correctly populated when the annotation was created. Note that the device contact id is populated once per device contact on a device. It is distinct from RawContactId - a single device contact may have multiple raw contact ids. - The annotation points to a Focus contact that was merged with device contact information in Starlight. When the annotation was created, a device contact id was available on the merged person object. - The contact annotation was created from April 2021 onwards. All prior annotations do not populate this field. ContactPointer creation relies on the client caller to correctly populate the device contact id, and does not enforce any assumptions on availability of this field. This field is repeated because in rare cases Starlight may merge device contact information across different devices into a single merged person object. WARNING: Use with extreme caution! This ID is not stable. For more details see go/fbs-support-for-device-contacts.
         */
        deviceContactId?: Schema$FocusBackendDeviceContactId[];
    }
    /**
     * The secondary ID of a contact.
     */
    export interface Schema$FocusBackendSecondaryContactId {
        /**
         * The hashes of the contact details (e.g. phone number and email address).
         */
        contactDetailHash?: Schema$FocusBackendContactDetailHash[];
        /**
         * The contact's full name, not hashed.
         */
        contactName?: string | null;
        /**
         * The hash of contact's full name, generated using Fingerprint2011(). Cast this field to string in javascript to make it compile in js.
         */
        contactNameHash?: string | null;
    }
    /**
     * Citation contains the information needed to correctly attribute the source of data.
     */
    export interface Schema$FreebaseCitation {
        /**
         * Mid of the dataset.
         */
        dataset?: string | null;
        /**
         * If set to true, the citation is required to be displayed when the data is used.
         */
        isAttributionRequired?: boolean | null;
        /**
         * Name of the project of the data's origin.
         */
        project?: string | null;
        /**
         * The name of the provider of this information.
         */
        provider?: string | null;
        /**
         * A human readable statement of attribution.
         */
        statement?: string | null;
        /**
         * Uri link associated with this data.
         */
        uri?: string | null;
    }
    /**
     * An Id contains the identifiers used to reference this topic (entity) in the Knowledge Graph. The Knowledge Graph supports several forms of identifiers: - "mids" (machine ids) that are assigned at creation time, and support a resolution mechanism that tracks topics after they are merged (for more about mids, see go/kg-mid), - "ids" are human-readable ids (HRIDs) that are derived from a namespace hierarchy stored in Knowledge Graph, and a set of rules, - "guids" are low-level ids historically used in Freebase (pre-Knowledge Graph, deprecated). Only the mid and id are supplied here. Note that mids can be converted to guids or uint64s (see //metaweb/util/mid/mid.h).
     */
    export interface Schema$FreebaseId {
        /**
         * "id" may be a human readable ID (HRID) or a MID. Originally it was intended to always be a human readable ID, but that convention was not always followed so clients should be wary. Not every topic has an id.
         */
        id?: string | null;
        /**
         * The "mid" should be used whenever a globally unique, primary key into the Knowledge Graph is needed. These keys are always prefixed with the "/m" and "/g", (and more rarely the "/x" and "/t") namespaces, and are alphanumeric strings consisting of lowercase letters excluding vowels, numbers and the underscore character. (Applications should not assume a constant length for these strings as Livegraph reserves the right to extend the number of characters to accommodate more topics.)
         */
        mid?: string | null;
    }
    /**
     * Represents a geopoint, which is one of the possible Value types.
     */
    export interface Schema$FreebaseLatLong {
        latDeg?: number | null;
        longDeg?: number | null;
    }
    /**
     * Represents a measurements, which is one of the possible Value types. A measurement value like "5.2 meter^2 / second" would be represented as: magnitude: 5.2 unit { unit_mid: "/m/mid_for_meter" power: 2 \} unit { unit_mid: "/m/mid_for_second" power: -1 \}
     */
    export interface Schema$FreebaseMeasurement {
        magnitude?: number | null;
        /**
         * Repeated units are interpreted as a product. i.e. (meter ^ 1) * (second ^ -2)
         */
        unit?: Schema$FreebaseMeasurementUnit[];
    }
    export interface Schema$FreebaseMeasurementUnit {
        power?: number | null;
        unit?: Schema$FreebaseId;
        /**
         * Deprecated fields.
         */
        unitMid?: string | null;
    }
    /**
     * List of { predicate, { object \} \} to be processed as a Nested Struct. Nested Struct can be recursive. NestedStruct.property_value(i).value(j) may have nested_struct field.
     */
    export interface Schema$FreebaseNestedStruct {
        propertyValue?: Schema$FreebasePropertyValue[];
    }
    /**
     * A PropertyValue associates properties with values in the context of a topic.
     */
    export interface Schema$FreebasePropertyValue {
        /**
         * The id of the property.
         */
        property?: Schema$FreebaseId;
        /**
         * Indicates the total values that exist for this property, even if they aren't all present in the value field, due to truncation.
         */
        totalValueCount?: string | null;
        /**
         * The value associated with the property for the containing topic.
         */
        value?: Schema$FreebaseValue[];
        /**
         * If ValueStatus is not set at all, the implication is that there are well-known value(s), specified in the "value" field. (It should be considered malformed data to have value_status set when len(values) \> 0.)
         */
        valueStatus?: string | null;
    }
    /**
     * A Topic represents a Knowledge Graph entity with its associated properties and their values.
     */
    export interface Schema$FreebaseTopic {
        /**
         * The id (mid and human-readable id) of the topic. The id will always be present and will contain a mid value for topics in the topic sstable.
         */
        id?: Schema$FreebaseId;
        /**
         * The property-value bindings associated with the topic. Note that in the case where a property is relevant to a topic based on its type, but no values of that property are present for the topic, the PropertyValue will simply not appear, rather than being present with a null value, or empty repeated value list.
         */
        propertyValue?: Schema$FreebasePropertyValue[];
    }
    /**
     * Values are effectively a union of several possible Knowledge Graph types: simple primitive datatypes such as booleans, integers and floats, references to other Knowledge Graph topics (by id), or "compound values" which are expressed as embedded topics with associated properties and values. Values occur in indexed order (if any).
     */
    export interface Schema$FreebaseValue {
        /**
         * key, uri, or datetime. Present when value is bool.
         */
        boolValue?: boolean | null;
        /**
         * Citation data for this value. See: http://go/kg-clap
         */
        citation?: Schema$FreebaseCitation;
        /**
         * Compound values are those that contain either a number of simple valued facets (such as a latitude/longitude pair), or "mediator" topics representing multi-dimensional relationships between topics. In both cases we represent them here with an embedded topic, although the topic's identity is somewhat secondary to the property/value pairs it contains. (The identity is still made available so that it can be used to perform updates to that mediator on the Knowledge Graph.)
         */
        compoundValue?: Schema$FreebaseTopic;
        /**
         * Deletion provenance for this value.
         */
        deletionProvenance?: Schema$StorageGraphBfgTripleProvenance[];
        /**
         * The lang of the display_value field.
         */
        displayLang?: string | null;
        /**
         * The display value of this value. This is a i18n-aware formatted value if present.
         */
        displayValue?: string | null;
        /**
         * An optional name for a proto field.
         */
        expectedProto?: string | null;
        /**
         * Present when value is float.
         */
        floatValue?: number | null;
        /**
         * Present when value is an id.
         */
        idValue?: Schema$FreebaseId;
        /**
         * Index of the value relative to the containing property (if any). Knowledge Graph supports a loose notion of indexing: some non-unique properties may have indices, while others may not. Furthermore, for a single property, some values may have indices (such as the top 5 actors in a film), while others may not (the film's supporting cast). Un-indexed values will appear at the end of the repeated value list. This field contains the index value only when is present in the Knowledge Graph.
         */
        index?: string | null;
        /**
         * Present when value is int.
         */
        intValue?: string | null;
        /**
         * Whenever the value is text with TYPE_TEXT, the lang field is populated with the III LanguageCode associated with the string_value field.
         */
        lang?: string | null;
        latLongValue?: Schema$FreebaseLatLong;
        measurementValue?: Schema$FreebaseMeasurement;
        /**
         * Populated if this value holds NestedStruct. 'type' field needs to be set to TYPE_NESTED_STRUCT.
         */
        nestedStruct?: Schema$FreebaseNestedStruct;
        /**
         * Provenance for this value.
         */
        provenance?: Schema$StorageGraphBfgTripleProvenance[];
        /**
         * Similar to string_value/etc but contains raw bytes.
         */
        rawValue?: string | null;
        /**
         * Present when value is text, enum,
         */
        stringValue?: string | null;
        subgraphId?: string[] | null;
        /**
         * The ISO-8601 timestamp corresponding to when this value was created (when it was written to the Knowledge Graph). Deprecated in favor of timestamp_usec.
         */
        timestamp?: string | null;
        /**
         * The microsecond timestamp corresponding to when this value was created.
         */
        timestampUsec?: string | null;
        type?: string | null;
    }
    /**
     * Next id: 127
     */
    export interface Schema$GDocumentBase {
        content?: Schema$GDocumentBaseContent;
        /**
         * unix secs from epoch
         */
        ContentExpiryTime?: number | null;
        directory?: Schema$GDocumentBaseDirectory[];
        /**
         * Sometimes the URL displayed in search results should be different from what gets indexed (e.g. in enterprise, content management systems). If this value is not set, we default to the regular URL.
         */
        DisplayUrl?: string | null;
        /**
         * 64-bit docid of the document (usually fingerprint of URL, but not always). WARNING: This does NOT uniquely identify a document ANYMORE. For a unique identifier across all documents in production please refer to the field 'id().key()' listed above.
         */
        DocId?: string | null;
        /**
         * 96-bit fingerprint of the canonical url's webmirror equivalence class name as of when this cdoc was exported.
         */
        ecnFp?: string | null;
        ExternalFeedMetadata?: string | null;
        /**
         * Enterprise-specific external metadata. See http://engdoc/eng/designdocs/enterprise/enterprise_indexing_metadata.html
         */
        ExternalHttpMetadata?: string | null;
        /**
         * Deprecated, do not use, this field is not populated since 2012.
         */
        FilterForSafeSearch?: number | null;
        /**
         * The primary identifier of a production document is the document key given in the ServingDocumentIdentifier, which is the same as the row-key in Alexandria, and represents a URL and its crawling context. In your production code, please always assume that the document key is the only way to uniquely identify a document. ## Recommended way of reading: const string& doc_key = cdoc.doc().id().key(); ## CHECK(!doc_key.empty()); More background information can be found in google3/indexing/crawler_id/servingdocumentidentifier.proto The ServingDocumentIdentifier uniquely identifies a document in serving and also distinguishes between experimental vs. production documents. The SDI is also used as an input for the union/muppet key generation in serving.
         */
        id?: Schema$IndexingCrawlerIdServingDocumentIdentifier;
        /**
         * IP addr in binary (allows for IPv6)
         */
        IPAddr?: string | null;
        /**
         * Localsearch-specific data.
         */
        localsearchDocInfo?: Schema$LocalsearchDocInfo;
        NoArchiveReason?: number | null;
        NoFollowReason?: number | null;
        NoImageframeOverlayReason?: number | null;
        NoImageIndexReason?: number | null;
        /**
         * When these reasons are set to a non zero value, the document should not be indexed, or show a snippet, or show a cache, etc. These reasons are bit maps of indexing.converter.RobotsInfo.RobotedReasons enum values reflecting the places where the restriction was found.
         */
        NoIndexReason?: number | null;
        NoPreviewReason?: number | null;
        NoSnippetReason?: number | null;
        NoTranslateReason?: number | null;
        /**
         * Ocean-specific data.
         */
        oceanDocInfo?: Schema$OceanDocInfo;
        originalcontent?: Schema$GDocumentBaseOriginalContent;
        /**
         * This field is long-deprecated in favour of Pagerank_NS, it is no longer maintained and can break at any moment.
         */
        Pagerank?: number | null;
        /**
         * Pagerank-NearestSeeds is a pagerank score for the doc, calculated using NearestSeeds method. This is the production PageRank value teams should use.
         */
        PagerankNS?: number | null;
        /**
         *  is the webmirror representative id of the canonical url. Urls with the same repid are considered as dups in webmirror. WARNING: use this field with caution! The webmirror duprules change frequently, so this value only reflects the duprules at the time when the canonical's docjoin is built.
         */
        Repid?: string | null;
        /**
         * Citation data for science articles.
         */
        ScienceMetadata?: Schema$ScienceCitation;
        /**
         * WARNING: the URL does NOT uniquely identify a document ANYMORE. For a unique identifier across all documents in production please refer to the field 'id().key()' listed above. Reason: foo.bar:/http and foo.bar:/http:SMARTPHONE share the same URL, but the body of the two documents might differ because of different crawl-context (desktop vs. smartphone in this example).
         */
        URL?: string | null;
        URLAfterRedirects?: string | null;
        /**
         * See webutil/urlencoding
         */
        URLEncoding?: number | null;
        /**
         * The user agent name used to crawl the URL. See //crawler/engine/webmirror_user_agents.h for the list of user-agents (e.g. crawler::WebmirrorUserAgents::kGoogleBot). NOTE: This field is copied from the first WEBMIRROR FetchReplyClientInfo in trawler_fetch_info column. We leave this field unpopulated if no WEBMIRROR FecthReplyClientInfo is found. As the submission of cl/51488336, Alexandria starts to populate this field. However, docjoins from freshdocs (or any other source), won't have this field populated, because we believe no one needs to read this field from freshdocs docjoins.
         */
        userAgentName?: string | null;
    }
    /**
     * Main content section
     */
    export interface Schema$GDocumentBaseContent {
        AuthMethod?: number | null;
        /**
         * The actual length of the content: If Representation is compressed, this equals to Content.UncompressedLength; otherwise it is the length of the representation string.
         */
        ContentLength?: number | null;
        /**
         * See enum ContentType in //depot/google3/webutil/http/content-type.proto.
         */
        ContentType?: number | null;
        /**
         * Crawled file size of the original document.
         */
        crawledFileSize?: number | null;
        /**
         * Seconds since Unix epoch.
         */
        CrawlTime?: string | null;
        /**
         * GeometryAnnotations, encoded with GeometryUtil::DeltaEncode() to reduce disk space usage. Use GeometryUtil::DeltaDecode() to decode this field.
         */
        encodedGeometryAnnotations?: string | null;
        /**
         * See //depot/google3/i18n/encodings/public/encodings.h Encoding of representation
         */
        Encoding?: number | null;
        /**
         * Set to false if Representation does not contain HTTP headers.
         */
        HasHttpHeader?: boolean | null;
        /**
         * A Language enum value. See: go/language-enum Default is english
         */
        Language?: number | null;
        /**
         * If OriginalEncoding is present, the body part of the Representation was converted to UTF-8, Encoding was set to UTF8, and OriginalEncoding was set to the original encoding before conversion. However, the HTTP headers part of the content might not be valid UTF-8. -1=an invalid value
         */
        OriginalEncoding?: number | null;
        /**
         * Possibly compressed for old documents. It is not compressed for docjoins produced by Raffia after ~2012.
         */
        Representation?: string | null;
        /**
         * Historically present if Representation is compressed.
         */
        UncompressedLength?: number | null;
        /**
         * Whether the content was visual right-to-left, and if so, what type of visual document it is. Must be one of the values in enum VisualType from google3/repository/rtl/visualtype.h Default is NOT_VISUAL_DOCUMENT. See http://wiki/Main/RtlLanguages for background.
         */
        VisualType?: number | null;
    }
    /**
     * The Directory proto group holds snippet and title metadata which is made available to the snippet code. The proto group was originally created for metadata coming from the Google Web Directory (gwd) project. It has since come to be used to hold metadata from gwd and other sources.
     */
    export interface Schema$GDocumentBaseDirectory {
        /**
         * encoded in UTF8
         */
        Category?: string | null;
        /**
         * encoded in UTF8
         */
        Description?: string | null;
        DescriptionScore?: number | null;
        /**
         * "gwd", etc.
         */
        Identifier?: string | null;
        /**
         * go/language-enum
         */
        Language?: number | null;
        /**
         * encoded in UTF8
         */
        Title?: string | null;
        /**
         * Deprecated; do not use. There is no code populating these fields as of Oct 2017.
         */
        TitleScore?: number | null;
        URL?: string | null;
    }
    /**
     * The original, unconverted document, typically PDF or Word. Copied from OriginalDoc field of doclogs. Unlike "Content", this does not contain any HTTP headers. The content may be compressed using the same method as "Content". In practice it is only compressed in the Teragoogle index. It is never compressed in docjoins because those are compressed at the sstable level. In doclogs content will only be compressed if the Trawler fetchreply is also compressed--which is currently never and unlikely to change for performance reasons.
     */
    export interface Schema$GDocumentBaseOriginalContent {
        Representation?: string | null;
        /**
         * present iff rep is compressed
         */
        UncompressedLength?: number | null;
    }
    /**
     * The generic version of a snippet response
     */
    export interface Schema$GenericSnippetResponse {
        /**
         * Per-doc debug information.
         */
        debugInfo?: string[] | null;
        /**
         * Servlet-specific response info.
         */
        info?: Schema$Proto2BridgeMessageSet;
        /**
         * Lines of the snippet HTML. Typically gws concatenates these and lets the browser wrap. The values include trailing spaces, so inserting additional spaces is not necessary. However, for very old browsers, gws may insert break tags after each snippet line. This field is confusing and poorly named; "snippet_line" would be better. In particular, note that this does not return multiple snippets for a result. Nor are these fields the individual tidbits of the snippet.
         */
        snippet?: string[] | null;
        /**
         * The title HTML. It may contain tags to denote query term matches. It may be already truncated and "..." is put instead (note that truncation does not always happen at the very end of the title text). However the existence of "..." does not guarantee that the snippet generation algorithm truncated it; e.g. webmasters themselves can write "...".
         */
        title?: string | null;
        /**
         * Snippet-specific members (tag ids 16+, must be optional!) Example: optional NewContentResponse new_response;
         */
        wwwSnippetResponse?: Schema$WWWSnippetResponse;
    }
    /**
     * Actions supported by Madden for a local entity.
     */
    export interface Schema$GeoOndemandAssistantSupportedActions {
        /**
         * Whether this local entity allows guest checkout for reservations.
         */
        allowsGuestCheckout?: boolean | null;
        /**
         * Whether or not this local entity supports asynchronous restaurant reservations, through the above restaurant_reservation_url.
         */
        isAsynchronousRestaurantReservation?: boolean | null;
        /**
         * URL for the Madden restaurant reservation flow, e.g. for display in a WebView. Not populated if restaurant reservations are not supported for the local entity.
         */
        restaurantReservationUrl?: string | null;
    }
    /**
     * This class holds information about a single access point. An access point establishes a relationship between a feature (like a POI or building) and some other feature. For example, consider a TYPE_LOCALITY feature like Seattle. An access point might be the TYPE_AIRPORT feature for Seattle-Tacoma International Airport. The airport feature defines the access point to gain airplane-based access to Seattle. A feature like Seattle will typically have multiple access points. You can get to Seattle using airplanes, various forms of public transit, or by driving a car. Thus Seattle would have multiple access points. You may be able to get to Seattle by flying into SeaTac, or you might be able to fly into Boeing Field, or Paine Field in Everett. You could drive in from the North/South using I-5, or you could drive in from the East using I-90. Many access points are from the road network. Thus the access point for some building at 123 Main Street would likely be a segment that defines the 100-200 block of "Main Street". A feature at the corner of "Hollywood" and "Vine" streets might have access points from both named streets. Access points are an optional field. Data editors may ignore them when creating features or editing other fields. In these cases, other quality teams will synthesize and update them. Several fields are also optional, as they are derivable from other fields. Access points to non-TYPE_SEGMENT features should always have the following fields set: - feature_type - feature_id - point Location and reference fields: BASIC vs DERIVABLE Access points to TYPE_SEGMENT features must have all the following BASIC fields: - feature_type (of the segment, e.g. TYPE_ROAD or TYPE_VIRTUAL_SEGMENT) - point_off_segment (or point; see "fuzzy point" note below) - unsuitable_travel_mode (may be empty) - level (indoor access points only) The following are DERIVABLE fields, which should only be added if the supplier is confident about their accuracy: - feature_id - point_on_segment - segment_position Editing clients are encouraged to set all fields, but they may set only the BASIC fields, in which case quality teams may use the BASIC fields to snap to an appropriate segment and derive the remaining fields. Example: The segment is split, so that the portion that the access point is on has a new feature ID. Quality teams notice that the point_on_segment is no longer on the segment with feature_id, finds the new nearest segment based on feature_type and existing point_on_segment, and re-derives a new feature_id, point_on_segment, and segment_position, keeping other fields consistent. Fuzzy point special case If the editor does not have side-of-road information for access points or is otherwise unsure of the precise placement of the access point, it may supply the point field (and not point_off_segment) as basic data instead, in which case quality teams may generate the point_off_segment. Identity Access points are considered semantically equivalent if they have the same geometry, including derived fields, and the same references to other features (feature_id, level_feature_id). For the exact definition, see cs/symbol:geostore::AreAccessPointsEquivalent. Field definitions
     */
    export interface Schema$GeostoreAccessPointProto {
        /**
         * RESERVED
         */
        canEnter?: boolean | null;
        /**
         * RESERVED
         */
        canExit?: boolean | null;
        /**
         * The ID of the feature that defines the access point. The bounding box of the feature is expanded to include the bounding box of the feature with the access point in accordance with the standard practice for bucketing map/reduce operations. See the wiki page at http://wiki/Main/OysterBucketingMapReduce for more information. For access points to TYPE_SEGMENT features, this may be re-derived if necessary by looking up the nearest segment to existing geometry.
         */
        featureId?: Schema$GeostoreFeatureIdProto;
        /**
         * The type of the feature. Required, to allow handling the access point differently based on feature type. For access points to non-TYPE_SEGMENT features, this cached type also makes things easier for clients that aren't running a bucketing map-reduce. For access points to TYPE_SEGMENT features, this is used to find to find the nearest segment of the given type.
         */
        featureType?: number | null;
        /**
         * For indoor access points, this should be set to the level that the access point is on. The feature_id should point to the indoor segment, but when it is missing or invalid, and we need to derive it from geometry, only segments on this level will be considered. For non-indoor access points, level should remain unset, and when we derive feature_id from geometry, only segments not on any level (non-indoor segments) will be considered. The bounding box of the level feature is expanded to include the bounding box of the feature with the access point in accordance with the standard practice for bucketing map/reduce operations. See the wiki page at http://wiki/Main/OysterBucketingMapReduce for more information. (Though in general the feature should reside on the level already anyway..)
         */
        levelFeatureId?: Schema$GeostoreFeatureIdProto;
        /**
         * Field-level metadata for this access point.
         */
        metadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * For access points to non-TYPE_SEGMENT features, the location of the access point. For access points to TYPE_SEGMENT features, this can be supplied as a fuzzy access point that is not guaranteed to be on the correct side of road. It should not be used by end clients in case of TYPE_SEGMENT access points.
         */
        point?: Schema$GeostorePointProto;
        /**
         * If the access point is defined by a TYPE_SEGMENT feature, this is the location of the access point displaced slightly to the correct side of the segment. This offset is in a direction perpendicular to the direction of travel along the segment. The actual offset distance is unspecified. It would typically be relatively small (approximately 1 meter). You can subtract the "off segment" point from the "on segment" point to get a vector of unknown length pointing from "on segment" point to the "off segment" point. You can then scale that vector to whatever length you want. Note that extending this displacement vector a large distance (10s of meters) may result in a new point that is in the middle of some other feature (park, street, intersection). This is the preferred basic geometry field for incoming data from editing clients and importers, if side-of-road is well-established.
         */
        pointOffSegment?: Schema$GeostorePointProto;
        /**
         * If the access point is defined by a TYPE_SEGMENT feature, this is the point on the centerline of the segment that is closest to the actual access point. May be re-derived if necessary to maintain precise placement on segment.
         */
        pointOnSegment?: Schema$GeostorePointProto;
        /**
         * LINT.ThenChange(//depot/google3/geostore/cleanup/callbacks/\ ID_DUPLICATE_ACCESS_POINT.cc)
         */
        priority?: string | null;
        /**
         * If the access point is defined by a TYPE_SEGMENT feature, this is the location of the access point expressed as a fractional distance along the segment. The value runs from 0 to 1 inclusive. May be re-derived if necessary to maintain precise placement on segment.
         */
        segmentPosition?: number | null;
        /**
         * This list represents the travel modes for which this access-point should be avoided. If this list is empty, the access-point is suitable for any travel mode. If all access points are unsuitable for the current travel mode, client should revert to other heuristics (e.g. feature center). This is only used for access points to TYPE_SEGMENT features; access points to non-TYPE_SEGMENT features, e.g. TYPE_ESTABLISHMENT_POI features with gcid:transit_station GConcepts are just identified by feature_type and feature_id.
         */
        unsuitableTravelMode?: string[] | null;
    }
    /**
     * This class represents a parsed field within an address. NOTE: if you add a field to this proto, please update the AreAddressComponentsEquivalent() function in google3/geostore/base/internal/addresscomponent.cc
     */
    export interface Schema$GeostoreAddressComponentProto {
        /**
         * The id of the corresponding Feature, if such a feature is defined. As discussed above for feature_type, components of TYPE_FEATURE or TYPE_LANDMARK may have a corresponding feature id.
         */
        featureId?: Schema$GeostoreFeatureIdProto;
        /**
         * For components of TYPE_FEATURE or TYPE_LANDMARK, this is the feature type (TYPE_COUNTRY, TYPE_LOCALITY, TYPE_ESTABLISHMENT_POI etc.). Note that some features may not actually exist in the geostore (e.g. a village that we've never heard of), in which case the feature_id will be missing but the feature_type is still specified. Please refer to IsValidAddressComponentFeatureType() in google3/geostore/base/public/addresscomponent.h for the definitive list of feature types allowed for the type (either TYPE_FEATURE or TYPE_LANDMARK) of components.
         */
        featureType?: number | null;
        /**
         * The order of this address component relative to the ones that share the same feature_type in the AddressProto. For now, the primary use of this index field is to handle ordering issue of multiple occurrences of AddressComponentProto with feature_type of TYPE_ROUTE (and subtypes), or TYPE_POLITICAL, where the order of the address components matters as there are dependences. 0 is the smallest valid index value, representing the most specific address component. Index value of 1 represents a relatively less specific address component of the same feature_type on which the 0-indexed address component depends.
         */
        index?: number | null;
        /**
         * The parsed_name field contains one or more names of an address component. Its actual contents depends on where in the Geo/Google stack you are reading a feature: 1. When an address is initially parsed via a feed or other raw input and structured as an AddressProto, parsed_name should contain the set of names that corresponds to the (possibly normalized) raw text from the raw input. 2. In MapFacts, the address component may be linked to an actual feature via feature_id. Any address formatting directly from MapFacts should follow links to retrieve names when possible. The parsed_name contents may be formatted directly if the address component is unlinked following the same rules as selecting and formatting the name of a feature. The cached parsed_name is regularly refreshed from the linked feature with the minimal set of names for address components (usually just a single, preferred name, in the local language, plus a Latin-script name: go/story-of-ac-names). 3. In serving systems, the names of linked features may be denormalized into the parsed_name field to facilitate quicker address formatting or for simple data filtering (e.g. finding all geocodes in California by name). If reading a feature from such a system, the parsed_name field could contain multiple names in multiple languages that reflect a cached copy of the names associated with the linked features. Formatting of such names should follow the same rules as selecting and formatting the name of a feature itself.
         */
        parsedName?: Schema$GeostoreNameProto[];
        /**
         * Any numerical address component may optionally be specified as a range. For example if a component of TYPE_STREET_NUMBER has the optional "range" attribute, then it represents a range of addresses rather than a single address (see AddressRangeProto for details).
         */
        range?: Schema$GeostoreAddressRangeProto;
        /**
         * A place for clients to attach arbitrary data to an address component. Never set in MapFacts.
         */
        temporaryData?: Schema$Proto2BridgeMessageSet;
        /**
         * Additional text to append before and/or after the parsed_name, when the address is formatted. Multiple instance should represent translations. Currently, this is only permitted on TYPE_LANDMARK components, and only one instance is permitted.
         */
        textAffix?: Schema$GeostoreTextAffixProto[];
        /**
         * Every address component has a type. Most address components correspond to one of the feature types defined in FeatureProto, so rather than defining a separate category system here, instead we mark them as TYPE_FEATURE and store the FeatureProto type in the feature_type() field. This is how we handle countries, cities, streets, etc. However, there are a few types of address components that do not have a corresponding feature type (e.g. PO boxes). These components have their type defined here. An address component of TYPE_STREET_NUMBER may correspond to a physical entity that defines a street number, such as a geocoded address or a land parcel. In this case, the address component may have a link to the corresponding feature. A good reference for what types of address components are possible is the xAL standard, which is a published XML schema: http://www.oasis-open.org/committees/ciq/download.shtml. This standard is the basis of the PostalAddress protocol message.
         */
        type?: string | null;
    }
    /**
     * Represents the unparsed portion of an address with an associated language.
     */
    export interface Schema$GeostoreAddressLinesProto {
        /**
         * The external form of a Google International Identifiers Initiative (III) LanguageCode object. See google3/i18n/identifiers/languagecode.h for details. We place extra restrictions on languages in addition to what the III library requires. See http://go/geo-schema-reference/feature-properties/languages.md
         */
        language?: string | null;
        /**
         * These lines are in display order.
         */
        line?: string[] | null;
    }
    /**
     * This class represents an address, partial address, or address range. It is intended to be attached to features to identify their address(es). Some important points about addresses: - The addresses in the Geo Schema do *not* include a component for the name of the feature, i.e. they are not self-referential. For example, the name of a feature might be "Zack's Pizza" and its address would be "123 Main Street". Similarly, streets, cities, and counties do not include themselves as part of their address. The address of "Seattle" is "King County, Washington, USA". If want to construct an address that *does* include the feature name, you can simply prepend it to the other address components. - Lakes, mountains, and other natural features do not normally have addresses. Countries also do not have addresses because they are at the top of the political hierarchy. - Address components in the Geo Schema are listed in a particular order, independent of the conventions used by the country in which they occur. The basic order is "smallest to largest" starting with street numbers and routes, then political features, and ending with postal features. The exact rules are defined by the implementation of the AddressComponentOrdering::IsLessThan() function. - Some types of address components may occur more than once in an address. For example, a UK address with a "dependent thoroughfare" would have two components of TYPE_ROUTE (i.e. street names). These are listed in the order they are normally written.
     */
    export interface Schema$GeostoreAddressProto {
        /**
         * The unparsed portion (lines) of the address. An address can have multiple unparsed portions. Multiple unparsed portions sharing the same language should be modeled as one address_lines instance having multiple lines. Historically, we also supported unparsed portions in different languages, but we no longer do. Consequently, only one value is allowed for this field despite the fact that it is repeated. See go/address-lines-multi-language for information about why we made this change. If any components are filled in, this is supplemental to (i.e. disjoint from) them. Furthermore, this must be the most specific portion of the address (except for the portion, if any, stored in the name field of feature.proto). Unparsed lines are always formatted together in a block. Other address components are never formatted between the address lines. This doesn't imply that the address lines are always either the first or the last part of the formatted output.
         */
        addressLines?: Schema$GeostoreAddressLinesProto[];
        /**
         * A list of parsed address components, e.g. the street, city, etc. An address range is one type of component.
         */
        component?: Schema$GeostoreAddressComponentProto[];
        /**
         * ** DEPRECATED ** This field is now deprecated (see b/33268032). If you want to store cross street information as part of an address, use the address_lines field.
         */
        crossStreet?: Schema$GeostoreAddressComponentProto[];
        /**
         * Field-level metadata for this address.
         */
        metadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * reserved
         */
        partialDenormalization?: Schema$GeostoreAddressProto;
        /**
         * The opaque ID of the address template that contains rules for structuring this address. The id of the address template can be retrieved using google3/geostore/address_templates/public/address_templates.h
         */
        templateId?: string | null;
        /**
         * A place for clients to attach arbitrary data to an address. Never set in MapFacts.
         */
        temporaryData?: Schema$Proto2BridgeMessageSet;
    }
    /**
     * This class represents a range of numbers in an address. It is an optional additional field in the 'AddressComponentProto' message. This structure can be used to model both single addresses and address ranges. There are two primary use-cases for address ranges: definitions and references. Ranges are being defined when they are present on the addresses of segment features. Ranges are being referenced when they are present on non-segment features. NOTE: If you add fields in this proto, consider updating the AreAddressRangesEquivalent() function in google3/geostore/base/internal/addressrange.cc
     */
    export interface Schema$GeostoreAddressRangeProto {
        /**
         * Two or more address numbers. Each number represents an address that was mentioned by the data provider.
         */
        number?: number[] | null;
        /**
         * For address range definitions: Two or more interpolation parameter values. The length of this array must match the length of the number array, and each parameter number specifies the position of the corresponding address number. Each value is an interpolation between 0.0 and 1.0 inclusive. The value is proportional to the distance traveled along the segment's polyline starting at its origin. The parameters must be provided in increasing order and the values in the number array must be in strictly increasing or decreasing order. We make an exception for singleton addresses, which are represented as two copies of a (number, parameter) pair, for backwards compatibility. For address range references: This array must be empty.
         */
        parameter?: number[] | null;
        /**
         * If specified, the prefix or suffix is applied to all numbers in the range. For example, this can be used to indicate that addresses B1 through B99 are on one side of the street, while A1 through A99 are on the other side of the street.
         */
        prefix?: string | null;
        /**
         * If 'same_parity' is true, then all 'number' values must have the same parity (even or odd), and this address range only includes addresses whose parity is the same as the given 'number' values.
         */
        sameParity?: boolean | null;
        suffix?: string | null;
        /**
         * A place for clients to attach arbitrary data to an address range. Never set in MapFacts. Here are some examples: Example #1: Single non-numeric address (e.g., "Twelve") At the moment this can only be represented as a street number (with the value in the parsed_name field of the AddressComponentProto). We have future plans to make other changes so we can handle this case. Example #2: Single semi-numeric address (e.g., "12bis") The number array contains two copies of the single numeric value (12). The prefix is empty and the suffix contains "bis". The parameter array has two identical values specifying the position of the single address. Example #3: Simple address range (e.g., "100 to 198, even numbers only") The number array contains the two values "100" and "198". The prefix and suffix strings are empty in this example. The parameter array has two values, one for each number. The same_parity flag is set in this example.
         */
        temporaryData?: Schema$Proto2BridgeMessageSet;
    }
    /**
     * A feature’s geometry that is populated from the 3D Geometry Store. Please see go/a3d-and-mapfacts for design details.
     */
    export interface Schema$GeostoreAnchoredGeometryProto {
        /**
         * The ID to be used to fetch the feature’s geometry from the 3D Geometry Store.
         */
        geometryId?: string | null;
    }
    /**
     * A container for speed limits that allows tagging with a correctness trust level.
     */
    export interface Schema$GeostoreAppliedSpeedLimitProto {
        /**
         * The actual speed limit value.
         */
        speedLimit?: Schema$GeostoreSpeedLimitProto;
        /**
         * The level of trust we have in this speed limit value.
         */
        trustLevel?: string | null;
    }
    /**
     * An AttachmentProto contains structured data of a client-specified type. An attachment is uniquely identified by the combination of its attachment_id and client_name_space fields.
     */
    export interface Schema$GeostoreAttachmentsAttachmentProto {
        /**
         * attachment_id distinguishes messages of the same type_id associated with the same feature. It can not be set to 0x0.
         */
        attachmentId?: string | null;
        /**
         * This field specifies a namespace identifier that can be used to track the sources of attachments in a human friendly format. Name spaces must be at most 64 characters long and must be composed entirely of alphanumeric characters, hyphens, and underscores. No other characters are allowed.
         */
        clientNameSpace?: string | null;
        /**
         * comment is a human-readable string that is logged whenever this attachment is processed by the framework.
         */
        comment?: string | null;
        /**
         * messages contains the structured data for this attachment. It should contain a single message with a type ID matching the value of the type_id field below.
         */
        messages?: Schema$Proto2BridgeMessageSet;
        /**
         * type_id determines the type of the actual attachment that should be set in the messages MessageSet. It can not be set to 0x0.
         */
        typeId?: string | null;
    }
    /**
     * Used to represent the unique id of an attribute.
     */
    export interface Schema$GeostoreAttributeIdProto {
        /**
         * The id of the attribute. Stored as a stripped format of the gcid (e.g. "foo" instead of "gcid:att_foo").
         */
        id?: string | null;
        /**
         * Set because it's required, but not really meaningful in geostore (always set to "Geo").
         */
        providerId?: string | null;
        type?: string | null;
    }
    /**
     * Protocol buffer for attaching attributes and values to instances. This is for assigning a particular attribute and value to a repository item, not for metadata. For protocol buffers that represents metadata about attributes and values, see CanonicalAttribute in itemclass.proto and ValueSpace in valuespace.proto.
     */
    export interface Schema$GeostoreAttributeProto {
        applicationData?: Schema$Proto2BridgeMessageSet;
        attributeDisplay?: Schema$GeostoreAttributeValueDisplayProto[];
        booleanValue?: boolean | null;
        /**
         * The canonical attribute for this attribute instance.
         */
        canonicalAttributeId?: Schema$GeostoreAttributeIdProto;
        doubleValue?: number | null;
        /**
         * For those attribute ids that expect their values to be taken from an enumeration-style set of values, that value's gcid should be stored here, e.g. "gcid:attval_yes".
         */
        enumIdValue?: string | null;
        floatValue?: number | null;
        int64Value?: string | null;
        integerValue?: number | null;
        itemClassId?: Schema$GeostoreAttributeIdProto;
        /**
         * Field-level metadata for this attribute
         */
        metadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * Fully qualified package name because genprotohdf uses genproto for this proto2 syntax: https://wiki.corp.google.com/twiki/bin/view/Main/Proto2WithGenproto
         */
        protoValue?: Schema$Proto2BridgeMessageSet;
        /**
         * The attribute value falls into one of these fields, based on value_type:
         */
        stringValue?: string | null;
        uint32Value?: number | null;
        /**
         * Used to store language-specific names of this attribute's value (e.g. a translation into another language).
         */
        valueDisplay?: Schema$GeostoreAttributeValueDisplayProto[];
        valueSpaceId?: Schema$GeostoreAttributeIdProto;
        valueType?: string | null;
    }
    /**
     * Used to help display language-specific names of attributes.
     */
    export interface Schema$GeostoreAttributeValueDisplayProto {
        language?: string | null;
        synonym?: string | null;
    }
    export interface Schema$GeostoreBarrierLogicalMaterialProto {
        material?: string[] | null;
    }
    /**
     * A BestLocaleProto holds information about the best-match locale for a feature. Clients may use this information to determine the appropriate local name of a feature.
     */
    export interface Schema$GeostoreBestLocaleProto {
        /**
         * The ID of the best-match TYPE_LOCALE feature for this feature.
         */
        locale?: Schema$GeostoreFeatureIdProto;
        /**
         * The ID of the localization policy to apply when selecting a name for a feature. This field should always be set. If feature_id is also defined, this field should have the same localization policy ID as the referenced locale feature. Localization policy IDs are arbitrary identifiers (up to some number of bytes; see geostore/base/public/constants.h) that uniquely distinguish a set of language-selection rules.
         */
        localizationPolicyId?: string | null;
        /**
         * Field-level metadata for this best locale.
         */
        metadata?: Schema$GeostoreFieldMetadataProto;
    }
    /**
     * The reference to a BizBuilder listing. For details on BizBuilder see http://g3doc/commerce/bizbuilder/backend/g3doc/index.md
     */
    export interface Schema$GeostoreBizBuilderReferenceProto {
        /**
         * Listing id. Used in queries to BizBuilder backend for listing access.
         */
        id?: string | null;
    }
    /**
     * A border represents a line of division between two features of the same type (i.e. United States and Mexico, but not California and Mexico). Borders are only used for features that tile an area. For example, country features have borders with one another because they tile an area of land. Country features do not have borders with province features because those two types of features may intersect with each other. The geometry of a border will often be similar (or derived from) the geometry of the two features that it separates. However, it is useful to have borders represented by stand-alone features for map-styling purposes. Ideally, the geometry in a border feature would be exactly the same as the common edges of the polygonal geometry of the two features. This may not always be true in practice. At some point in the future we would like to build a network of borders for features that are supposed to tile with each other. The network would be composed of different border types meeting at endpoint intersections. In the process of building this network, we would perform small geometry corrections to ensure that the borders align properly at all zoom levels. Border features are intended primarily for map drawing, and they would rarely be useful for geocoding. One exception would be for famous borders like the "Mason Dixon Line" or the "Berlin Wall." The standard feature properties have the following interpretations: name - Borders rarely have names unless they notable in their own right (e.g. "Mason Dixon Line", "Berlin Wall"). point - A border should not have point geometry. polyline - A border should have a single polyline that represents the division between the two features. polygon - A border should not have polygon geometry.
     */
    export interface Schema$GeostoreBorderProto {
        /**
         * The ids of the area features to the left and right of the border, relative to the start and end of this borders' polyline geometry. These features should have the same type as the "type" attribute above. These ids are not required because the corresponding features may be nonexistent or difficult to obtain.
         */
        featureIdLeft?: Schema$GeostoreFeatureIdProto;
        featureIdRight?: Schema$GeostoreFeatureIdProto;
        /**
         * The logical borders which this border is a part of.
         */
        logicalBorder?: Schema$GeostoreFeatureIdProto[];
        /**
         * List of border status overrides. Due to legal reasons, we may be required to display some borders differently on some domains for instance.
         */
        overrideStatus?: Schema$GeostoreOverrideBorderStatusProto[];
        /**
         * The border status identifies the legal status of the border line.
         */
        status?: string | null;
        /**
         * The type of the features this border separates. Should always be a subtype of TYPE_POLITICAL. NOTE: as of December 2019, we currently require this to be equal to TYPE_COUNTRY or TYPE_ADMINISTRATIVE_AREA1. In the future, we may support TYPE_BORDER for lower types of political features.
         */
        type?: number | null;
    }
    /**
     * NOTE: BoundingMarkerProto could be compared against one another by canonicalizing them via GetCanonicalBoundingMarker() in google3/geostore/base/internal/lane.cc. Any fields that don't contribute to the definition of a bounding marker in the real world should be bundled with the annotative fields near the bottom and excluded in GetCanonicalBoundingMarker(). LINT.IfChange
     */
    export interface Schema$GeostoreBoundingMarkerProto {
        /**
         * References to any gcid:physical_lane_marker features that bound this lane or lane connection.
         */
        boundingMarker?: Schema$GeostoreFeatureIdProto;
        /**
         * A token that can be used to identify the version of the data about this bounding marker.
         */
        boundingMarkerToken?: string | null;
        /**
         * Which part of the flowline does this association refer to? These should be between 0 and 1. These are optionally set, but can be approximated geometrically if they aren’t set. NOTE: These refer to the geometry of this feature.
         */
        flowlineAdjacencyBeginFraction?: number | null;
        flowlineAdjacencyEndFraction?: number | null;
        /**
         * Which part of the marker track does this association refer to? These should be between 0 and 1. These are optionally set, but can be approximated geometrically if they aren’t set. NOTE: These refer to the geometry of the marker feature.
         */
        markerAdjacencyBeginFraction?: number | null;
        markerAdjacencyEndFraction?: number | null;
        /**
         * Which side of the flowline does the marker occur on.
         */
        side?: string | null;
    }
    /**
     * This protocol buffer holds the building-specific attributes for features of type TYPE_COMPOUND_BUILDING.
     */
    export interface Schema$GeostoreBuildingProto {
        /**
         * The height of the base of this building, in meters above ground-level, if known.
         */
        baseHeightMetersAgl?: number | null;
        /**
         * The level in this building that should get displayed by default. If present, the default display level must be one of this building's levels that are listed in the level[] field, and if a level is set as a default level of one building, all buildings sharing the level should have that same level as their default level. If not present, clients should not display any level by default for that building.
         */
        defaultDisplayLevel?: Schema$GeostoreFeatureIdProto;
        /**
         * The number of floors above the base of the building, if known. For example a regular 1-story building would set this to "1". Use a value of GeostoreConstants::kDefaultHeightPerFloor when converting "floors" to "height_meters".
         */
        floors?: number | null;
        floorsMetadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * The height of the building above its base, in meters, if known.
         */
        heightMeters?: number | null;
        heightMetersMetadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * The levels in this building, in no particular order. These levels refer back to the building via another strong reference (the LevelProto.building field).
         */
        level?: Schema$GeostoreFeatureIdProto[];
        /**
         * "Structure" denotes a physical architecture of the building that is readily visible. This attribute is useful in that rarer structures can make good landmarks.
         */
        structure?: string | null;
    }
    /**
     * This holds data specific to business chain features.
     */
    export interface Schema$GeostoreBusinessChainProto {
        /**
         * Canonical GConcepts describe the ideal state of the GConcepts of this business chain's members.
         */
        canonicalGconcepts?: Schema$GeostoreCanonicalGConceptProto[];
    }
    /**
     * A BusinessHoursProto stores a weekly schedule of opening hours for a business (represented as a BusinessHours message) together with other closely related information that is Geo-specific.
     */
    export interface Schema$GeostoreBusinessHoursProto {
        /**
         * The actual hours represented by this BusinessHoursProto.
         */
        data?: Schema$BusinessHours;
        /**
         * Field-level metadata for these hours.
         */
        metadata?: Schema$GeostoreFieldMetadataProto;
    }
    /**
     * Message containing calls to action specified by the business owner.
     */
    export interface Schema$GeostoreCallToActionProto {
        /**
         * Required.
         */
        ctaType?: string | null;
        url?: Schema$GeostoreUrlProto;
    }
    /**
     * This proto represents a canonical gconcept of a business chain's members.
     */
    export interface Schema$GeostoreCanonicalGConceptProto {
        gconcept?: Schema$GeostoreGConceptInstanceProto;
        /**
         * Whether the gconcept must be on a member. This must be true for a primary gconcept.
         */
        isRequired?: boolean | null;
    }
    /**
     * This protocol buffer holds S2 cell covering for the feature. See util/geometry/s2cell_union.h for more information on S2 cells. See geostore/base/public/cellcovering.h for utility functions.
     */
    export interface Schema$GeostoreCellCoveringProto {
        /**
         * Array of S2 cell ids that represent the covering. There is no preset limit on how many cells can be used.
         */
        cellId?: string[] | null;
    }
    /**
     * CityJsonProto is a custom proto representation of the portion of the CityJSON spec (https://www.cityjson.org/) relevant to internal projects. See go/cityjsonproto-design for more information about the modeling and design decisions implemented here. LINT.IfChange
     */
    export interface Schema$GeostoreCityJsonProto {
        /**
         * City objects associated with this CityJsonProto.
         */
        cityObjects?: Schema$GeostoreCityJsonProtoCityObject[];
        /**
         * Spec for converting vertices from a local coordinate system in arbitrary units to ECEF coordinates in meters (https://en.wikipedia.org/wiki/Earth-centered,_Earth-fixed_coordinate_system).
         */
        transform?: Schema$GeostoreCityJsonProtoTransform;
        /**
         * Vertices as local coordinates represented as a flattened list: [x1,y1,z1,x2,y2,z2,x3,y3,z3]. Vertices are relative to a local coordinate system and rounded to their nearest integer value. See `transform` for how vertices can be transformed from a local coordinate system into an Earth-centered, Earth-fixed coordinate system. Vertices are flattened for space efficiency, memory locality, and processing performance. To access the x,y,z coordinates of vertex N, read the values at indices 3N, 3N+1, and 3N+2.
         */
        vertexXyz?: number[] | null;
    }
    /**
     * Representation of an object with geometry.
     */
    export interface Schema$GeostoreCityJsonProtoCityObject {
        /**
         * Geometries associated with this object.
         */
        geometries?: Schema$GeostoreCityJsonProtoCityObjectGeometry[];
        /**
         * The ID of this CityObject, which must be unique within this CityJsonProto. The ID does not have a meaning outside this CityJsonProto.
         */
        id?: string | null;
        /**
         * Type of object represented, e.g. building.
         */
        type?: string | null;
    }
    /**
     * Representation of geometry including geometric primitives which are used as building blocks to construct geometries of varying complexity. Geometries vary both in type and in level-of-detail, enabling representation of any shape at any level of granularity. All geometries are ultimately composed of `MultiPoint`s, which reference the actual vertices. Only linear and planar shapes are allowed, no curves or parametric surfaces.
     */
    export interface Schema$GeostoreCityJsonProtoCityObjectGeometry {
        /**
         * Level-of-detail (LoD) indicates how intricate the geometric representation is. May be a single digit per CityGML standards or X.Y per TU Delft (visual depiction at https://3d.bk.tudelft.nl/lod/). `CityObject`s may have multiple geometries with the same LoD.
         */
        lod?: string | null;
        /**
         * For geometries consisting of a single point, line, or loop.
         */
        multipoint?: Schema$GeostoreCityJsonProtoCityObjectGeometryMultiPoint;
        /**
         * For geometries consisting of a collection of surfaces.
         */
        multisurface?: Schema$GeostoreCityJsonProtoCityObjectGeometryMultiSurface;
        /**
         * For geometries consisting of a watertight 3D shape.
         */
        solid?: Schema$GeostoreCityJsonProtoCityObjectGeometrySolid;
    }
    /**
     * A single line, loop, or set of points.
     */
    export interface Schema$GeostoreCityJsonProtoCityObjectGeometryMultiPoint {
        /**
         * A collection of references to vertices in `CityJsonProto.vertex_xyz`. `CityJsonProto.vertex_xyz` is a flattened list of vertex coordinates. A value in `x_indices` should be the index of the x-coordinate of the desired vertex V; the full coordinates of vertex V can then be found at indices [V,V+1,V+2]. For example, an `x_indices` containing 3, 0, and 12 references three vertices, whose complete x,y,z coordinates can respectively be found at `CityJsonProto.vertex_xyz` indices [3,4,5], [0,1,2], and [12,13,14].
         */
        xIndices?: number[] | null;
    }
    /**
     * A collection of arbitrary surfaces that have no prescribed topological relationship.
     */
    export interface Schema$GeostoreCityJsonProtoCityObjectGeometryMultiSurface {
        /**
         * All surfaces are standalone entities with no relationship to each other.
         */
        surfaces?: Schema$GeostoreCityJsonProtoCityObjectGeometrySurface[];
    }
    /**
     * A 3D shape, composed of a watertight exterior shell with optional interior watertight shells.
     */
    export interface Schema$GeostoreCityJsonProtoCityObjectGeometrySolid {
        /**
         * The first shell is exterior; any additional are interior.
         */
        shells?: Schema$GeostoreCityJsonProtoCityObjectGeometryMultiSurface[];
    }
    /**
     * A polygonal surface, composed of a closed exterior loop with optional closed interior loops.
     */
    export interface Schema$GeostoreCityJsonProtoCityObjectGeometrySurface {
        /**
         * The first loop is exterior; any additional are interior.
         */
        loops?: Schema$GeostoreCityJsonProtoCityObjectGeometryMultiPoint[];
    }
    /**
     * Information for transforming a point from an "old" to "new" coordinate frame. Applied as follows: vertex_new = scale * vertex_old + translate
     */
    export interface Schema$GeostoreCityJsonProtoTransform {
        /**
         * Relative scale of the vertices in the new coordinate system relative to the old coordinate system. Applies to all three x,y,z coordinates.
         */
        scale?: number | null;
        /**
         * Offset of each vertex in the new coordinate system relative to the old coordinate system.
         */
        translate?: Schema$GeostoreCityJsonProtoTransformTranslate;
    }
    /**
     * How the object will be moved along the x, y, and z axes, respectively.
     */
    export interface Schema$GeostoreCityJsonProtoTransformTranslate {
        x?: number | null;
        y?: number | null;
        z?: number | null;
    }
    /**
     * Generic item proto. This is intended to have only certain aspects filled (e.g. photo only, name + price). Valid combinations of properties are enforced by linters.
     */
    export interface Schema$GeostoreComposableItemProto {
        /**
         * Call to action for the individual product.
         */
        callToAction?: Schema$GeostoreCallToActionProto;
        jobMetadata?: Schema$GeostoreJobMetadata;
        /**
         * Any photos describing this item.
         */
        media?: Schema$GeostoreMediaItemProto[];
        /**
         * The repeated name_info field is for price list sections listed in multiple languages. At least one name_info containing id must be specified. There should be at most one name_info for any given language. When representing a job item, there should be exactly one name_info specified.
         */
        nameInfo?: Schema$GeostorePriceListNameInfoProto[];
        /**
         * Represents if an item is offered at a business. For TYPE_JOB, this represents if this job is offered by the corresponding business
         */
        offered?: string | null;
        /**
         * Price of the item. There should be at most one price for any given currency.
         */
        price?: Schema$GeostorePriceRangeProto;
        /**
         * Represents which price format is being used by this item, which determines the usage/meaning of the “price” field above. Optional – the default value is legal and safe (represents no price if the “price” field is unset).
         */
        priceFormat?: string | null;
        /**
         * Numerical score which can be provided by data sources to indicate preferred item ordering. This is purely a hint – we are not required to followed it if we have a different order we think is better. Higher scores represent items that should be shown more prominently/earlier. Optional.
         */
        rankingHint?: number | null;
    }
    /**
     * A count value tagged with a comparison operator. This can be used for axle count, trailer count, etc.
     */
    export interface Schema$GeostoreCountComparisonProto {
        comparisonOperator?: string | null;
        count?: number | null;
    }
    /**
     * Possible patterns of a crossing stripe (any element that denotes a point on a segment or lane at which the vehicle must stop or yield). These include crosswalks, stop, and yield lines.
     */
    export interface Schema$GeostoreCrossingStripePatternProto {
        borderLine?: Schema$GeostorePhysicalLineProto;
        borderPattern?: string | null;
        /**
         * Colors found on this crossing.
         */
        color?: Schema$GeostorePaintedElementLogicalColorProto[];
        stripePattern?: string | null;
    }
    export interface Schema$GeostoreCurvatureProto {
        /**
         * Curvature values at points along the flowline. A linear interpolation between two successive points will yield the curvature value at intermediate points.
         */
        pointCurvature?: Schema$GeostorePointCurvatureProto[];
    }
    /**
     * Protocol buffer describing a curve that connects two externally specified endpoints.
     */
    export interface Schema$GeostoreCurveConnectionProto {
        bezierParams?: Schema$GeostoreCurveConnectionProtoBezierParams;
        circleParams?: Schema$GeostoreCurveConnectionProtoCircleParams;
        type?: string | null;
    }
    export interface Schema$GeostoreCurveConnectionProtoBezierParams {
        /**
         * Internal Bezier handles. One can be used for a quadratic curve, two for cubic Beziers.
         */
        controlPoint?: Schema$GeostoreCurveConnectionProtoBezierParamsControlPoint[];
    }
    export interface Schema$GeostoreCurveConnectionProtoBezierParamsControlPoint {
        /**
         * We use this parameterization to make curves change predictable when endpoints move. Each point P is defined in terms of the straight edge [S, E] between the start point of the curve S and its end point E. *P / / / S *------------* E Counter-clockwise angle between vector SE and vector SP.
         */
        angleDegrees?: number | null;
        /**
         * Distance(S, P) in units of Distance(S, E).
         */
        distanceMultiplier?: number | null;
    }
    export interface Schema$GeostoreCurveConnectionProtoCircleParams {
        /**
         * Arc radius. Must be greater than half-distance between two endpoints.
         */
        radius?: number | null;
    }
    /**
     * Every data source used to construct a data repository has an associated feature that provides more information about it. The standard feature properties have the following interpretations: bound - The bounds must includes all features that refer to this data source, so that bucketing MapReduce passes work correctly. name - The provider name associated with this data source. It is expected to remain constant from release to release, and between datasets. address - should be empty. point, polyline, polygon - should be empty. source_info - should not be set. child - should be empty.
     */
    export interface Schema$GeostoreDataSourceProto {
        /**
         * This is the URL of a website representing this DataSource as a whole. If this DataSource feature is specific to a particular dataset or product, the page may contain information relevant to that dataset or product or may be the main page of the organization.
         */
        attributionUrl?: Schema$GeostoreUrlProto[];
        /**
         * A UTF8 string that will be inserted in copyright messages to refer to this copyright owner, e.g. "Tele Atlas".
         */
        copyrightOwner?: string | null;
        /**
         * The copyright year of this data (which may be different than the year of the release date), e.g. 2005.
         */
        copyrightYear?: number | null;
        /**
         * A free-form description of this data source. Ideally the description should include: - Where the data was obtained (URL, company name, individual, etc). - Where to find detailed documentation. - A brief summary of the licensing terms. - As much internal and external contact information as possible (e.g. who to ask about licensing questions, interpreting the data, updating the data, fixing bugs in the importer, etc).
         */
        description?: string | null;
        /**
         * The build information of the importer binary used to generate this data source.
         */
        importerBuildInfo?: string | null;
        /**
         * The build target of the importer binary used to generate this data source.
         */
        importerBuildTarget?: string | null;
        /**
         * The Perforce client information of the importer binary used to generate this data source.
         */
        importerClientInfo?: string | null;
        /**
         * If the importer was built as an MPM, the version number can be stored in this field. As with build_info, this can be useful when tracking down issues that may be due to the use of a particular binary.
         */
        importerMpmVersion?: string | null;
        /**
         * The timestamp of the importer binary used to generate this data source.
         */
        importerTimestamp?: string | null;
        /**
         * The provider type of this data source.
         */
        provider?: string | null;
        /**
         * For every key that is used in raw_data from this source, there must be a corresponding entry in raw_metadata that describes this key.
         */
        rawMetadata?: Schema$GeostoreRawMetadataProto[];
        /**
         * A release string that doesn't have to be a date. This is provided so that we can preserve provider release strings that aren't based on dates. If you don't set it, the release_date will get formatted into this field for debugging purposes.
         */
        release?: string | null;
        /**
         * The release date of this data.
         */
        releaseDate?: Schema$GeostoreDateTimeProto;
        /**
         * A data provider defined string describing the source dataset from which the features of this data source were generated. For example, the MultiNet "fra" dataset produces features for both France and Monaco.
         */
        sourceDataset?: string | null;
    }
    /**
     * WARNING: Outside of FeatureProto, please avoid in favor of a standard civil time type. Direct usage is error-prone due to the conflation of physical time and civil time (go/httat). In a protocol buffer, please use google.type.Date, with an additional google.type.TimeOfDay for precision finer-grained than a day. (For google.type.DateTime, go/prototime#types cites go/httat#zoned_datetime as a caveat). In a programming language, see go/time-devguide/languages. Additionally in C++, google3/geostore/base/public/datetime.h has conversion functions between DateTimeProto and Abseil's civil time types.
     */
    export interface Schema$GeostoreDateTimeProto {
        /**
         * This attribute describes the precision of the date and time. It would be unusual for a data provider to provide a precision along with their date. It is more likely that the precision of a date will be inferred from the date format. For example "19th century" is likely to be correct to the century, while "1800" is probably correct to the year. The precision should be semantically interpreted as a cast, so a DateTimeProto object with a seconds value corresponding to 2018-03-28 18:40:00 UTC and a precision of MONTH should be interpreted as "March 2018". The enums above are only some of the possible precision levels for dates and times. Clients may wish to add more precision enums in the future. However, these enums must be ordered by decreasing duration. Clients should be able to write date formatting code that looks like this: if (datetime.precision() <= DateTimeProto::PRECISION_CENTURY) { date = FormatCenturyDate(proto.seconds()); \} else if (proto.precision() <= case DateTimeProto::PRECISION_DECADE) { date = FormatDecadeDate(proto.seconds()); \} else { ... \} See geostore/base/public/datetime.h for date formatting utility functions.
         */
        precision?: string | null;
        /**
         * Number of seconds since (or before) the UNIX epoch (January 1, 1970). This is also the standard epoch for Java and Python time representations. If it is important for this time be displayed correctly for different time zones, convert the time to Coordinated Universal Time (UTC).
         */
        seconds?: number | null;
    }
    /**
     * A dimension value tagged with a comparison operator. This can be used for height, width, or length.
     */
    export interface Schema$GeostoreDimensionComparisonProto {
        comparisonOperator?: string | null;
        dimensionWithUnit?: Schema$GeostoreDimensionProto;
    }
    /**
     * A dimension with a numerical value and unit. This can be a height, width, or length.
     */
    export interface Schema$GeostoreDimensionProto {
        dimension?: number | null;
        unit?: string | null;
    }
    /**
     * This holds data specific to rendering a POI on a map. It's derived from data already in MapFacts, e.g. containing features and the feature's point field. If empty, this proto should be ignored for rendering. See go/maps-render-alignment for motivation and more details.
     */
    export interface Schema$GeostoreDisplayDataProto {
        /**
         * The location where this feature should be rendered.
         */
        displayLocation?: Schema$GeostorePointProto;
    }
    /**
     * This protocol buffer is used to store information about disputed areas. E.g., the political power that administers a disputed area or the countries that claim it. It should only be used for features of TYPE_DISPUTED_AREA.
     */
    export interface Schema$GeostoreDisputedAreaProto {
        /**
         * If present this feature is administered by the power present in the field. In most cases this will be a two letter ISO-3166 region code, but may be a descriptive string if no region code is available.
         */
        administeredBy?: string | null;
        /**
         * Feature IDs (usually a country feature ID) of all parties who claim this feature. No claimants means the claim by the country that contains it (based on country polygon) is not disputed.
         */
        claimant?: Schema$GeostoreFeatureIdProto[];
    }
    /**
     * This protocol buffer holds the doodle-specific attributes for features of type TYPE_DOODLE.
     */
    export interface Schema$GeostoreDoodleProto {
        /**
         * The type of this feature -- see comments above.
         */
        type?: string | null;
    }
    /**
     * A single cost which will apply based on the duration of utilization. The cost may apply once, or repeatedly on some interval, to account for the total utilization. If the duration expressed by range_start_seconds and range_end_seconds do not cover the entire duration of the utilization (i.e. from 0 to some time greater than the total utilization time), this must be combined with other DurationBasedRateProtos such that the entire duration of the utilization is accounted for. See go/rate-schema for more details.
     */
    export interface Schema$GeostoreDurationBasedRateProto {
        /**
         * If true, represents that the rate is free; i.e. the price is 0 in any currency. If this is true, price must be empty.
         */
        isFree?: boolean | null;
        /**
         * The billable unit of the rate; i.e. after having utilized the service for exactly periodicity_seconds, the total cost should increase by ‘price’. For example, if the rate expresses a price per hour, then periodicity_seconds should be set to 3600. If this is unset, then the rate does not vary based on duration, and price represents a flat cost. May only be set if price is nonempty.
         */
        periodicitySeconds?: number | null;
        /**
         * The total price, in each applicable currency, of utilizing the service for periodicity_seconds, or for the entire duration expressed by range_start_seconds and range_end_seconds if periodicity_seconds is 0. Each entry should have an ID of /measurement_unit/money_value and consist of two properties: one with an ID of /measurement_unit/money_value/amount and a float value with the amount, and another with the ID /measurement_unit/money_value/currency and an ID value with the MID of the proper currency. May only be set if is_free is false.
         */
        price?: Schema$FreebaseTopic[];
        /**
         * Upper bound for durations to match, exclusive. Unset implies indefinite.
         */
        rangeEndSeconds?: number | null;
        /**
         * Lower bound for durations to match, inclusive. Required; a value of 0 expresses that the price applies from the start of the utilization period.
         */
        rangeStartSeconds?: number | null;
    }
    /**
     * Represents raster digital elevation model data.
     */
    export interface Schema$GeostoreElevationModelProto {
        /**
         * Defines the relative order in which terrain data should be rendered. Features with higher blend_order should be blended on top of features with lower blend_order. NOTE: this is backwards from the way BlendRank works in Magrathean.
         */
        blendOrder?: number | null;
        /**
         * The zoom level at which this data is defined. Level 0 is world level data, and each increase in zoom level corresponds to a factor of 2 increase in scale.
         */
        dataLevel?: number | null;
        /**
         * The maximum (finest) level at which this terrain data has sufficient resolution to be displayed.
         */
        dataMaxlevel?: number | null;
        /**
         * A place to store an elevation data protocol buffer. Currently, this must be a keyhole::AssetTileCompressed (see google3/keyhole/common/proto/magrathean.protodevel).
         */
        elevationData?: Schema$Proto2BridgeMessageSet;
        /**
         * If true, all of the data contained in this feature is available at the next highest (more detailed) level. If this is true, partial_child_data_available should also be true.
         */
        fullChildDataAvailable?: boolean | null;
        /**
         * If true, at least part of the data contained in this feature is available at the next highest (more detailed) level.
         */
        partialChildDataAvailable?: boolean | null;
    }
    /**
     * This protocol buffer holds elevation and related data.
     */
    export interface Schema$GeostoreElevationProto {
        /**
         * The average elevation of the feature in meters above the local mean sea level.
         */
        averageElevationMeters?: number | null;
        /**
         * Additional details for TYPE_PEAK and TYPE_VOLCANO features.
         */
        peak?: Schema$GeostorePeakProto;
    }
    /**
     * This protocol buffer holds entrance-specific attributes for features of type TYPE_ENTRANCE.
     */
    export interface Schema$GeostoreEntranceProto {
        allowance?: string | null;
        /**
         * DEPRECATED. Please use enter_or_exit instead.
         */
        canEnter?: boolean | null;
        /**
         * Whether the target can be entered through this entrance. Whether the target can be exited through this entrance.
         */
        canExit?: boolean | null;
    }
    /**
     * Models a relationship between a feature and its entrance or exit.
     */
    export interface Schema$GeostoreEntranceReferenceProto {
        /**
         * Feature ID of the related entrance. References should refer to TYPE_ENTRANCE or TYPE_COMPOUND features that are entrances or exits of the referencing feature.
         */
        featureId?: Schema$GeostoreFeatureIdProto;
    }
    /**
     * This protocol buffer holds establishment-specific attributes for features of type TYPE_ESTABLISHMENT.
     */
    export interface Schema$GeostoreEstablishmentProto {
        /**
         * Reference to BizBuilder data for this establishment. The bizbuilder_reference field indicates that a feature is claimed in CBDB (with the canonical state in MapFacts). The bizbuilder_reference is different from the social_reference's claimed_gaia_id because some BizBuilder clients will not have +Pages. All claimed businesses should have a bizbuilder_reference.
         */
        bizbuilderReference?: Schema$GeostoreBizBuilderReferenceProto;
        /**
         * Regular opening hours for the establishment (weekly schedule).
         */
        hours?: Schema$GeostoreTimeScheduleProto;
        /**
         * Opening hours for this establishment, including regular weekly hours and exceptional hours (e.g. on holidays). NOTE: in practice, only the exceptional hours are filled in this message. A schema migration for regular weekly hours was planned back in 2015 (see b/23105782) but was not completed and is (as of May 2018) not prioritized. Clients should continue getting regular opening hours from the `hours` field above. In openinghours.h there is a utility function `GetOpeningHoursFromFeature` that merges `EstablishmentProto.hours` into this proto.
         */
        openingHours?: Schema$GeostoreOpeningHoursProto;
        /**
         * Pricing for products and services offered. Example: menus for restaurants.
         */
        priceInfo?: Schema$GeostorePriceInfoProto;
        serviceArea?: Schema$GeostoreServiceAreaProto;
        /**
         * Telephone number and related information.
         */
        telephone?: Schema$GeostoreTelephoneProto[];
        /**
         * ** DEPRECATED ** This is deprecated in favor of the top-level (in FeatureProto) set of GConcepts. The type of establishment -- see comments above.
         */
        type?: string | null;
    }
    /**
     * An ExceptionalHoursProto holds information about exceptional (non-regular) hours for a business, such as holiday hours.
     */
    export interface Schema$GeostoreExceptionalHoursProto {
        /**
         * The weekly schedule to be applied for the dates that fall within the range. The schedule may contain hours only for days of the week that occur during the date range specified in the range field.
         */
        hours?: Schema$GeostoreBusinessHoursProto;
        /**
         * Field-level metadata for this exception.
         */
        metadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * The dates for which this exception applies, expressed as a half open interval. For example, an exception that applies for the entire month of December 2015 should have a range December 1, 2015 to January 1, 2016. Any regular hours that start on days in this range are ignored and replaced by the exceptional hours for that day. The TimeIntervalProto for the range must be a fully specified, non-empty, and non-inverted range of dates. Concretely, the requirements are: * the range must be a TYPE_RANGE interval * the interval may not be inverted * the endpoints of the interval must specify a year, month, and day * the day_type of each endpoint must be type DAY_OF_MONTH * the endpoints may not specify hour, minute, second, week, or week_type * the begin endpoint must predate the end endpoint
         */
        range?: Schema$GeostoreTimeIntervalProto;
    }
    export interface Schema$GeostoreExistenceProto {
        /**
         * Indicates whether the place is closed (permanently or temporarily), i.e., not operational in the present, but was at in the past and/or will be in the future. WARNING: New code should use Geo Schema's libraries instead, specifically the OpeningStatus APIs, available in: * C++ (cs/f:google3/geostore/base/public/feature.h%20function:ExistenceState) * Java (cs/f:google3/java/com/google/geostore/base/Existence.java%20function:OpeningStatus) * Python (cs/f:google3/geostore/base/public/python/feature.clif%20existence_state)
         */
        closed?: boolean | null;
        /**
         * Structured reason for the permanent closure (if any).
         */
        closeReason?: string | null;
        /**
         * The earliest known date of this feature's "end" (e.g. an establishment's permanent closure), if the actual date is unknown; i.e. the best known upper bound of the day end_date would represent. end_as_of_date must be in local (civil) time and of PRECISION_DAY. For example, given an establishment: * Without any end_as_of_date, the permanent closure definitely isn't now and isn't known to start at any point in the future. * With an end_as_of_date of 2023-04-05 but without any end_date, the permanent closure definitely starts at latest 2023-04-05 but may start before 2023-04-05. * With an end_as_of_date of 2023-04-05 and an end_date of 2023 (at just PRECISION_YEAR), the permanent closure definitely starts at earliest 2023-01-01 (i.e. the first day of 2023) and at latest 2023-04-05, but may start at any day between 2023-01-01 and 2023-04-05. IMPORTANT: Generally for Geo Schema-internal use only. If you believe you need to use this field directly, please go/contact-geo-schema.
         */
        endAsOfDate?: Schema$GeostoreDateTimeProto;
        endDate?: Schema$GeostoreDateTimeProto;
        /**
         * ** DEPRECATED ** This field is now deprecated (see b/22878252). Please use the Geo Schema GetFeatureBirthTimestamp() API to extract the birth timestamp of a feature. The timestamp in seconds since the UNIX epoch (January 1, 1970) when this feature becomes live in the Geo repository. Different from start_date in that this is the birth date of Google's representation of the place whereas start_date is the birth date of the place in the physical world.
         */
        featureBirthTimestampSeconds?: string | null;
        /**
         * Indicates whether the feature is marked as removed in the Geo repository. Removed features are still present in the Geo repository but are considered to be in an inactive state (not valid for lint purposes, not retrievable except explicitly by feature ID, etc.). NOTE: If you have access to a complete FeatureProto, do NOT read this bit directly to find out whether a feature is removed. Instead, rely on the IsFeatureRemoved() API, available in C++ (geostore/base/public/feature.h) and Java (geostore/base/Feature.java).
         */
        removed?: boolean | null;
        /**
         * Structured reason why the feature is marked as removed. Relevant only when removed == true.
         */
        removedReason?: string | null;
        /**
         * (Initial) opening and (permanent) closing dates of the establishment, such that start_date is the first day open and end_date is the first day closed. The only allowed precisions are PRECISION_DAY, PRECISION_MONTH, PRECISION_YEAR. DateTimeProto.seconds should have the lowest legal value for the desired date/time and precision. E.g. for PRECISION_MONTH, 2019-02-15 21:10:30 is not valid, it should be 2019-02-01 00:00:00 instead. NOTE: The start_date and end_date are stored in UTC but should be interpreted as being in the local timezone. So clients should convert the DateTimeProto to local (civil) time using UTC+0, and then treat the result as local to the feature.
         */
        startDate?: Schema$GeostoreDateTimeProto;
    }
    /**
     * Provenance information for sub-fields of this feature - go/subfield-provenance.
     */
    export interface Schema$GeostoreFeatureFieldMetadataProto {
        fieldProvenance?: Schema$GeostoreFeatureFieldMetadataProtoFieldProvenance[];
    }
    export interface Schema$GeostoreFeatureFieldMetadataProtoFieldProvenance {
        /**
         * Represents all fields for which this SourceInfo is valid. NOTE: Field paths are rooted at FeatureProto level.
         */
        fieldPath?: Schema$GeostoreStableFieldPathProto[];
        provenance?: Schema$GeostoreProvenanceProto;
    }
    /**
     * Metadata related to the history of a given feature in the Geo repository.
     */
    export interface Schema$GeostoreFeatureHistoryMetadataProto {
        /**
         * The timestamp (in microseconds since the UNIX epoch) when this feature first went live in the Geo repository. Note that this has no relation to the birth data of that geographical entity in the real world.
         */
        featureBirthTimestampUs?: string | null;
        /**
         * The timestamp (in microseconds since the UNIX epoch) of the last modification to the feature. Note this includes attachment modifications. The feature's initial creation is also considered as a modification. This is useful for those that consume features via both listening to notifications and reading from repository snapshots. This timestamp can be used to decide whether a feature in the snapshot was already seen in a more recent state through the notifications.
         */
        lastModificationTimestampUs?: string | null;
        /**
         * The timestamp (in microseconds since the UNIX epoch) of the deletion time of the feature. If the feature is currently removed, this field gets populated with the timestamp the feature first became removed after being live (or being removed from beginning). This field won't be set if the feature is live.
         */
        removalTimestampUs?: string | null;
    }
    /**
     * Feature ID forwardings. There are many different types of ID forwardings, some of which are attached to live features, others to removed features. This information is available in multiple forms (with different completeness guarantees): (1) in RPC responses to read requests to the live Geo repository; (2) on disk, as part of the metadata section of features found in the (inactive) features snapshots; (3) on disk, as part of a separate feature_id_forwardings side table.
     */
    export interface Schema$GeostoreFeatureIdForwardingsProto {
        /**
         * If the feature has been marked as a DUPLICATE of another feature, this is the feature ID of that other feature. Note that the other feature may itself be removed. This field is always set.
         */
        duplicateOf?: Schema$GeostoreFeatureIdProto;
        /**
         * The feature ID of the forwarded feature. This field is only set in case (3).
         */
        forwardedId?: Schema$GeostoreFeatureIdProto;
        /**
         * If other features have been marked as DUPLICATE of this feature, this is the set of all such feature IDs. All feature IDs in this set should be for removed (aka inactive) features. Note that in the context of historical read requests against MapFacts (when ReadRequest.version_selection.timestamp is set), this field won't be set.
         */
        inactiveDuplicate?: Schema$GeostoreFeatureIdProto[];
        /**
         * DEPRECATED - Use feature.metadata.feature_replacement_info instead. This field was never populated.
         */
        replacedBy?: Schema$GeostoreFeatureIdListProto;
        /**
         * If the feature has been transitively marked as a DUPLICATE of another feature (via a chain of size \>= 1), this is the feature ID of that other feature which is the end of the chain. The field is always set even if the chain is of size 1. Note that the other feature may itself be removed. This field is only set in case (3).
         */
        transitivelyDuplicateOf?: Schema$GeostoreFeatureIdProto;
    }
    /**
     * A simple list of feature IDs.
     */
    export interface Schema$GeostoreFeatureIdListProto {
        /**
         * The list of feature IDs. While the exact semantics of these IDs are usage-dependent, the list should never be empty or contain duplicates.
         */
        id?: Schema$GeostoreFeatureIdProto[];
    }
    /**
     * A globally unique identifier associated with each feature. We use 128-bit identifiers so that we have lots of bits available to distinguish between features. The feature id currently consists of a 64-bit "cell id" that **sometimes** corresponds to the approximate centroid of the feature, plus a 64-bit fingerprint of other identifying information. See more on each respective field in its comments. Feature ids are first assigned when the data is created in MapFacts. After initial creation of the feature, they are immutable. This means that the only properties that you should rely on are that they are unique, and that cell_ids often - but not always - preserve spatial locality. The degree of locality varies as the feature undergoes geometry changes, and should not in general be considered a firm guarantee of the location of any particular feature. In fact, some locationless features have randomized cell IDs! Consumers of FeatureProtos from Mapfacts are guaranteed that fprints in the id field of features will be globally unique. Using the fprint allows consumers who don't need the spatial benefit of cell ids to uniquely identify features in a 64-bit address space. This property is not guaranteed for other sources of FeatureProtos.
     */
    export interface Schema$GeostoreFeatureIdProto {
        /**
         * The S2CellId corresponding to the approximate location of this feature as of when it was first created. This can be of variable accuracy, ranging from the exact centroid of the feature at creation, a very large S2 Cell, or even being completely randomized for locationless features. Cell ids have the nice property that they follow a space-filling curve over the surface of the earth. (See s2cellid.h for details.) WARNING: Clients should only use cell IDs to perform spatial locality optimizations. There is no strict guarantee that the cell ID of a feature is related to the current geometry of the feature in any way.
         */
        cellId?: string | null;
        /**
         * A 64-bit fingerprint used to identify features. Most clients should rely on MapFacts or OneRing to choose fingerprints. If creating new fprints, the strategy should be chosen so that the chance of collision is remote or non-existent, and the distribution should be reasonably uniform. For example, if the source data assigns unique ids to features, then a fingerprint of the provider name, version, and source id is sufficient.
         */
        fprint?: string | null;
        /**
         * A place for clients to attach arbitrary data to a feature ID. Never set in MapFacts.
         */
        temporaryData?: Schema$Proto2BridgeMessageSet;
    }
    /**
     * General metadata related to a given feature in the Geo repository.
     */
    export interface Schema$GeostoreFeatureMetadataProto {
        /**
         * This field indicates whether the feature is subject to bulk updates. Caution must be exercised while editing such features since the changes made by the edits will be overwritten by the bulk update (if the feature is bulk updated). See go/mapfacts-abu for more information.
         */
        bulkUpdatable?: string | null;
        /**
         * core_version_token is an opaque token representing the version of the core fields of the feature. This field is not updated when attachments are changed.
         */
        coreVersionToken?: string | null;
        /**
         * Metadata for tracking when a feature is derived from or replaced by another feature or set of features.
         */
        featureReplacementInfo?: Schema$GeostoreFeatureReplacementInfoProto;
        /**
         * Metadata about certain repeated fields and their subfields, for which field type is not granular enough.
         */
        fieldMetadata?: Schema$GeostoreFeatureFieldMetadataProto;
        /**
         * Feature ID forwardings, if applicable.
         */
        forwardings?: Schema$GeostoreFeatureIdForwardingsProto;
        /**
         * Metadata related to the history.
         */
        history?: Schema$GeostoreFeatureHistoryMetadataProto;
        /**
         * version_token is an opaque token representing the version of this feature. It can be used as a concurrency token when sending edits.
         */
        versionToken?: string | null;
    }
    /**
     * Message to represent a "feature property" as an abstract construct. Most feature properties are mapped one to one with the EditProto field types. However in some cases the EditProto field type granularity is too coarse to support use-cases that rely on feature properties (such as per-value rights tracking). When that is the case, the feature property is augmented with a secondary field.
     */
    export interface Schema$GeostoreFeaturePropertyIdProto {
        /**
         * Required when field_type == ATTACHMENT.
         */
        attachmentTypeId?: string | null;
        /**
         * Required when field_type == FEATURE_ATTRIBUTE.
         */
        attributeId?: string | null;
        fieldType?: string | null;
        /**
         * Required when field_type == KNOWLEDGE_GRAPH_PROPERTY.
         */
        kgPropertyId?: string | null;
        /**
         * RESERVED
         */
        nameLanguage?: string | null;
    }
    /**
     * Every entry in the GeoStore database is called a "feature". A feature is represented as a discriminated union of all the different feature types, where the actual feature type is specified by the "type" field. There are also various fields that are meaningful for most or all feature types, such as bounding regions and names. Every feature has a globally unique id that can be used to refer to it from other features.
     */
    export interface Schema$GeostoreFeatureProto {
        /**
         * Optional access point information. Access points hold detailed information about routing endpoints. For example, the main Google office is at "1600 Amphitheatre Parkway". The feature representing that office has a polygon, a center, and an address with components for the street number, route, locality, etc. The access point information, on the other hand, identifies the specific segment, the latitude/longitude of the driveway, and so forth.
         */
        accessPoint?: Schema$GeostoreAccessPointProto[];
        /**
         * Address for this feature. A Geo Schema address is designed to model a mailing address, so only features that have mailing addresses in the real world may have addresses. Each feature should have only one address. If you want to describe the geographic location of a feature which does not have a mailing address with respect to other well-known features, some other schema constructs should be used. Note that the field is defined as repeated though features that use this field with its intended semantics are constrained to have a single address even if they may have multiple mailing addresses in the real world. The “single address” rule is enforced by lint. Current exceptions to the single address rule and mailing address rule are described in the g3doc. Bear note that the schema team is actively working on eliminating these exceptions. http://go/geo-addresses Note the following conventions: - Addresses follow the postal hierarchy, not the political hierarchy. Addresses may have components that refer to political entities when those entities also appear in the postal hierarchy. - As stated previously, but it bears repeating, addresses on features are mailing addresses. In many cases the physical address and the mailing address are the same but the address stored on a feature represents the mailing address of the feature. An example of a non-physical mailing address would be a PO Box. - These addresses are commonly defined and verifiable by a governmental authority (e.g. the United States Postal Service in the United States, Royal Mail in the United Kingdom, Correios in Brazil, etc.) and should follow conventions and rules defined by those authorities.
         */
        address?: Schema$GeostoreAddressProto[];
        /**
         * Represents information about the feature’s anchored geometry.
         */
        anchoredGeometry?: Schema$GeostoreAnchoredGeometryProto;
        associatedEvChargingStation?: Schema$GeostoreFeatureIdProto[];
        /**
         * The collection of attachments for this feature. Documentation: http://go/geo-attachments
         */
        attachment?: Schema$GeostoreAttachmentsAttachmentProto[];
        /**
         * ** DEPRECATED ** A list of attributes that describe defined aspects of this feature. An attribute must be a concrete, high quality, and editable piece of information about a feature, and must be used on some general consumer facing Google property. The data types used for attributes must be primitive types or reusable in a generic manner.
         */
        attribute?: Schema$GeostoreAttributeProto[];
        /**
         * Describes the best-match locale for this feature.
         */
        bestLocale?: Schema$GeostoreBestLocaleProto;
        border?: Schema$GeostoreBorderProto;
        /**
         * A latitude-longitude rectangle used by bucketing MapReduces. See the documentation on bucketing MapReduce for details. This field can be a source of confusion. Because it is called "bound", it is often assumed that it is a tight bound on the geometry but it can be (and often is) much larger. If a tight bound is needed then use the standard GetFeatureGeometryBound() function instead. To be more explicit, if you are using this field for *anything* else than a bucketing MapReduce, you are doing the wrong thing. Not all features are required to have bounding boxes. See geostore::IsBoundRequiredForFeatureType() for the list of feature types required to have a bounding box. This bound field will be updated when a feature changes in MapFacts to include its geometry. Also, a GeoSchema pipeline, go/geo-schema-pipelines-docs#expand-bounds runs periodically to update the field for strong references from other features. Therefore, most editors don't need to edit this field explicitly. See go/geo-changes:no-edit-for-feature-bound for the details.
         */
        bound?: Schema$GeostoreRectProto;
        building?: Schema$GeostoreBuildingProto;
        /**
         * Data specific to business chain features, e.g., Canonical GConcepts.
         */
        businessChain?: Schema$GeostoreBusinessChainProto;
        /**
         * The conceptual center of the feature, used for routing. For cities, this would be the center of the downtown, or maybe the location of city hall. For states and countries it might be the capital city. Most feature types will not have a conceptual center - by default, routing will use the centroid of the feature's geometry. If you need a feature center point consider using GetFeatureGeometryCenter() function from geostore/base/public/feature.h rather than reading from this field directly.
         */
        center?: Schema$GeostorePointProto;
        /**
         * Features can define themselves as a collection of other features. For example, a route is a collection of road segments, and a feature for the "Great Lakes" could be defined as lakes Superior, Michigan, Huron, Erie, and Ontario. It is not recommended to design a multi level tree using the child field to build up a feature because it requires fetching many features to see the details of the feature. In practice this is used to model archipelago, route, transit (agencies, lines, trips, departures), and river features. The geometry of a feature is implicitly defined by its children, so if a feature has children then it should not have any points, polylines, or polygons. In general, this field should not be used to represent political or postal hierarchies. For example, a county would not list its cities as children, because the county is not defined in terms of its cities (it also contains unincorporated areas, etc.).
         */
        child?: Schema$GeostoreFeatureIdProto[];
        /**
         * S2 cell coverings for this feature. See util/geometry/s2cell_union.h for more information about S2 cells. Coverings are useful for quick containment or intersection tests. S2 covering that consists of cells that intersect with the feature.
         */
        covering?: Schema$GeostoreCellCoveringProto;
        dataSource?: Schema$GeostoreDataSourceProto;
        /**
         * Data used to render this feature on a map.
         */
        displayData?: Schema$GeostoreDisplayDataProto;
        /**
         * Represents information about disputed areas. Only TYPE_DISPUTED_AREA features should have the field set.
         */
        disputedArea?: Schema$GeostoreDisputedAreaProto;
        /**
         * ** DEPRECATED **
         */
        doodle?: Schema$GeostoreDoodleProto;
        elevation?: Schema$GeostoreElevationProto;
        /**
         * Captures elevation data used on TYPE_DIGITAL_ELEVATION_MODEL features.
         */
        elevationModel?: Schema$GeostoreElevationModelProto;
        entrance?: Schema$GeostoreEntranceProto;
        /**
         * Also allowed on TYPE_BUSINESS_CHAIN and TYPE_TRANSIT_AGENCY features, to model the feature's phone number(s). Other fields within EstablishmentProto are not permitted on non-TYPE_ESTABLISHMENT features.
         */
        establishment?: Schema$GeostoreEstablishmentProto;
        /**
         * A list of feature ids of polygon based restrictions that do not apply to this feature. This may only include features of TYPE_REGULATED_AREA that also have a feature.regulated_area.restriction field defined. Setting this field opts the feature out of all restrictions set on that regulated area.
         */
        exemptRegulatedArea?: Schema$GeostoreFeatureIdProto[];
        /**
         * Specifies the TYPE_FUTURE_GEOMETRY whose geometry will replace this feature's geometry. If this field is populated, the referenced future geometry must have a future_geometry_for referencing this feature.
         */
        futureGeometry?: Schema$GeostoreFeatureIdProto;
        /**
         * Specifies the feature that this feature's geometry will replace. If this field is populated, the referenced feature must have a future_geometry reference back to this feature. This field is only allowed (and required) for TYPE_FUTURE_GEOMETRY features.
         */
        futureGeometryFor?: Schema$GeostoreFeatureIdProto;
        /**
         * Geometry Store ID and materialized geometry representing the feature's physical shape in the world.
         */
        geometry3d?: Schema$GeostoreGeometryStoreReferenceProto;
        /**
         * If set, the feature's actual location can be assumed to be somewhere within a circle of this radius, centered on the feature's location. More information on this field at go/gpm-definition-update. NOTE: Only applicable to features with 'point' geometry. Please contact geo-schema-team@ if you have non-point use cases for which this field would be useful.
         */
        geometryPrecisionMeters?: number | null;
        geopolitical?: Schema$GeostoreGeopoliticalProto;
        /**
         * Geopolitical (unsimplified) polygons for a feature for different geopolitical use cases.
         */
        geopoliticalGeometry?: Schema$GeostoreGeopoliticalGeometryProto;
        /**
         * ** DEPRECATED ** Features can have zero or more HTML texts associated with them. These might be HTML balloons used by Google Earth, for example.
         */
        htmlText?: Schema$GeostoreHtmlTextProto[];
        /**
         * The globally unique id for this feature.
         */
        id?: Schema$GeostoreFeatureIdProto;
        inferredGeometry?: Schema$GeostoreInferredGeometryProto;
        /**
         * S2 interior covering that consists of cells completely enclosed within the feature's geometry (for features with polygonal geometry).
         */
        interiorCovering?: Schema$GeostoreCellCoveringProto;
        /**
         * Additional internal feature-level attributes that may be set by data providers to be used inside the Geo Data infrastructure. This field should never be present in the output of the Geo Data infrastructure that read-only clients consume.
         */
        internal?: Schema$GeostoreInternalFeatureProto;
        intersection?: Schema$GeostoreIntersectionProto;
        intersectionGroup?: Schema$GeostoreIntersectionGroupProto;
        /**
         * Properties that apply to this feature whose schema is defined in the Knowledge Graph schema (see https://hume.google.com/graph/schema). Not all properties that exist in the KG schema can be asserted via this mechanism. The set of properties that are allowed to be set on a feature depends on the feature's GConcepts (and feature type). For instance, only gcid:country features may have the /geo/type/country/president property (made up example, since that property doesn't actually exist in the KG schema). GConcept hierarchy is taken into account for deciding the set of allowed properties. Additionally, the specific properties allowed are further constrained by the list specified at go/kg-property-allowlist. NOTE: not all types of properties are allowed to appear in the Geo Schema. For now, we limit ourselves to properties whose value type is TYPE_BOOL, TYPE_COMPOUND, TYPE_DATETIME, TYPE_FLOAT, TYPE_ID, TYPE_INT, TYPE_NESTED_STRUCT, TYPE_TEXT, or TYPE_URI. NOTE(b/35039936): We are in the process of changing how a KG property with multiple values is stored in this field. Currently, such a KG property is stored in a single instance of the kg_property field. However, we will be changing this so that each value will be stored in its own instance of kg_property. Any client that wants to read from this field should be prepared to read data represented in either format. See b/35039936 or the announcement at http://g/geo-schema-announce/7IXR3Fex8to/7yFyT5UoAwAJ for an example and more details. The mechanism to assert that a KG property has no value is via the property_value_status field below. freebase.PropertyValue.value_status is not allowed be set here for consistency reason.
         */
        kgProperty?: Schema$FreebasePropertyValue[];
        /**
         * RESERVED
         */
        knowledgeGraphReference?: Schema$GeostoreKnowledgeGraphReferenceProto;
        laneMarker?: Schema$GeostoreLaneMarkerProto;
        /**
         * Represents information about TYPE_LEVEL features.
         */
        level?: Schema$GeostoreLevelProto;
        locale?: Schema$GeostoreLocaleProto;
        logicalBorder?: Schema$GeostoreLogicalBorderProto;
        /**
         * Metadata about this particular feature. Metadata is managed internally by the Geo Data Infrastructure and in general should not be set by clients. Features that don't ultimately come from the Geo repository (MapFacts) won't have any metadata set.
         */
        metadata?: Schema$GeostoreFeatureMetadataProto;
        /**
         * The name(s) of this feature. A feature may have different names in different languages, colloquial or "vanity" names, etc.
         */
        name?: Schema$GeostoreNameProto[];
        /**
         * Information about this feature's operations, e.g. when this feature is temporarily closed. NOTE: for legacy reasons, some closure-specifc information (e.g. permanent closure reason) lives in ExistenceProto instead. In the future, such information should move here in OperationsProto.
         */
        operations?: Schema$GeostoreOperationsProto;
        /**
         * This field is used internally by the pipeline for id stability. It should not be set by individual importers, nor should it be read by consumer clients. In particular, this field will not be present in features read or snapshotted from the Mapfacts Repository.
         */
        originalId?: Schema$GeostoreFeatureIdProto;
        parent?: Schema$GeostoreFeatureIdProto[];
        /**
         * Describes parking details for the feature.
         */
        parking?: Schema$GeostoreParkingProto;
        /**
         * Defines the geometry of the feature. The geometry may be specified as an arbitrary union of points, poses, polylines, tracks, and polygons. Points, poses, polylines, and tracks are assumed to represent regions of unspecified size or width rather than regions of zero area. Most features should have some sort of geometry. Geometry may be synthesized if none is available (e.g., polygons for postal codes). The synthetic_geometry flag should be set in that case. Point is currently enforced as a non-repeating field for all feature types, though it is defined as repeating in case future modeling requires multiple points. The number of allowed polylines, tracks, or polygons vary based on feature type. A feature can have at most one pose (it is an optional field).
         */
        point?: Schema$GeostorePointProto[];
        political?: Schema$GeostorePoliticalProto;
        polygon?: Schema$GeostorePolygonProto[];
        /**
         * Provide version of the geometry suitable for display. This has been subject to water removal and (possibly) moderate simplification.
         */
        polygonForDisplay?: Schema$GeostorePolygonProto;
        polyline?: Schema$GeostorePolyLineProto[];
        /**
         * Defines the geometry of a feature as a 6D pose, including lat, lng, altitude, roll, pitch, and yaw along the WGS-84 ellipsoid. Only the lat and lng are strictly required.
         */
        pose?: Schema$GeostorePoseProto;
        /**
         * The preferred viewport for this feature. If present, this latitude-longitude rectangle holds the preferred viewport for the feature. For example, it might hold the bounds of the "central" portion of a large city. There are no aspect ratio requirements. This is an optional field: if no viewport is supplied, interested clients can use heuristics to determine a viewport. Calling the standard GetFeatureGeometryBound() function would be a good way to start but note that it can return an empty bounding box (e.g., if the feature has no geometry). The preferred viewport is not necessarily fully contained by the above bounding box.
         */
        preferredViewport?: Schema$GeostoreRectProto;
        /**
         * The value status of properties on this feature. For example, this specifies whether the feature is known to have no name (this is the value status of the 'FEATURE_NAME' property). Only property IDs which have no specific value are allowed to have a value status. Note: not all field types will be supported, please contact geo schema team if you want to enable this field for a field type that is not currently supported.
         */
        propertyValueStatus?: Schema$GeostorePropertyValueStatusProto[];
        /**
         * WARNING: Please do NOT introduce new uses of this field; treat it as if it were deprecated. For appropriate ranking contacts, see g3doc/company/teams/gdeng/geo-schema-reference/home/feature-properties/rank.md. A floating-point number between 0.0 and 1.0 indicating how "important" we think this feature is. This can be used to decide which features to render on maps, and how to rank results when the user does a search. The rank can depend on any number of factors such as the number of references to this feature in web pages, geographic size, population, number of referring geographic entities, "priority" information encoded in the source data, etc.
         */
        rank?: number | null;
        /**
         * The rank field is computed as a weighted sum of several signals. This field contains a protocol buffer whose fields give those signals and their weights. Clients should try very hard not to depend on these individual signals and use the single rank field instead. At some point in the future, this field will not be exposed anymore.
         */
        rankDetails?: Schema$GeostoreRankDetailsProto;
        /**
         * Geo Ontology GConcept Instances - Design doc linked off http://go/geo-ontology - In order to shield clients from changes in GConcept representation we provide an accessor library: geostore/base/public/gconcept_instance.h
         */
        rawGconceptInstanceContainer?: Schema$GeostoreOntologyRawGConceptInstanceContainerProto;
        regulatedArea?: Schema$GeostoreRegulatedAreaProto;
        /**
         * For TYPE_COUNTRY or TYPE_ADMINISTRATIVE_AREA1 features, this field defines the associated TYPE_BORDERs which reference this feature. The linked TYPE_BORDERs must have the feature.border set, pointing to this feature. TYPE_COUNTRY or TYPE_ADMINISTRATIVE_AREA1 features must have this field set for each TYPE_BORDER referencing them.
         */
        relatedBorder?: Schema$GeostoreFeatureIdProto[];
        /**
         * Logical relationship to other features that are entrances or exits to this feature.
         */
        relatedEntrance?: Schema$GeostoreEntranceReferenceProto[];
        /**
         * Geographic or logical relationships to other features. Importers don't need to fill a geographic relationship in - it is handled by related feature processing by a standalone pipeline. Adding "contained by" country relations is however encouraged (and required for TYPE_ROUTE features). WARNING: Updates to this field handled by standalone pipelines are NOT atomic with regard to updates to the features being referenced; we do not guarantee that a given MapFacts snapshot will be consistent between this field and the related features.
         */
        relatedFeature?: Schema$GeostoreRelationProto[];
        /**
         * Terminal points associated with this feature. For instance, an airport terminal may have specifically designated pickup and drop-off points.
         */
        relatedTerminalPoint?: Schema$GeostoreFeatureIdProto[];
        /**
         * Contains time zones known to be associated with a feature. Most features are associated with the single time zone that contains them. However, some larger features (countries, continents, etc.) are associated with all of the time zones they contain. Most features can have any number of related time zones, but TYPE_SEGMENT and TYPE_ESTABLISHMENT_POI features can have at most 1.
         */
        relatedTimezone?: Schema$GeostoreTimezoneProto[];
        restrictionGroup?: Schema$GeostoreRestrictionGroupProto;
        roadMonitor?: Schema$GeostoreRoadMonitorProto;
        /**
         * Additional details on the feature types below can be found in the individual protocol buffer definitions. These extensions capture data that is specific to a set of feature types and which makes no sense for other feature types.
         */
        route?: Schema$GeostoreRouteProto;
        schoolDistrict?: Schema$GeostoreSchoolDistrictProto;
        segment?: Schema$GeostoreSegmentProto;
        segmentPath?: Schema$GeostoreSegmentPathProto;
        sign?: Schema$GeostoreRoadSignProto;
        skiBoundary?: Schema$GeostoreSkiBoundaryProto;
        skiLift?: Schema$GeostoreSkiLiftProto;
        skiTrail?: Schema$GeostoreSkiTrailProto;
        /**
         * All establishments must have a social reference. WARNING: Aside from creating new establishments, please do NOT introduce new uses; treat social references as if they were deprecated. For alternatives and more, see g3doc/company/teams/gdeng/geo-schema-reference/home/feature-types/establishments/social-reference.md.
         */
        socialReference?: Schema$GeostoreSocialReferenceProto;
        /**
         * A list of the data sources that were used to construct this feature, together with optional "raw data" in the provider's format. Raw data should not be used by production clients but may be useful for exploring data that is not currently converted to a canonical form.
         */
        sourceInfo?: Schema$GeostoreSourceInfoProto[];
        /**
         * All features can have "existence" information associated with them.
         */
        status?: Schema$GeostoreExistenceProto;
        /**
         * Represents information about the store front geometry. Only TYPE_ESTABLISHMENT_POI should have this field set.
         */
        storefrontGeometry?: Schema$GeostoreAnchoredGeometryProto[];
        /**
         * Geometry Store ID and materialized geometry for a POI feature's storefront(s).
         */
        storefrontGeometryModel?: Schema$GeostoreGeometryStoreReferenceProto;
        /**
         * We prefer features that have geometry over those that do not. In some cases we synthesize geometry (e.g., polygons for postal codes). This flag is set to indicate features that have such synthetic geometry.
         */
        syntheticGeometry?: boolean | null;
        /**
         * A place for clients to attach arbitrary data to a feature. Never set in MapFacts.
         */
        temporaryData?: Schema$Proto2BridgeMessageSet;
        /**
         * Captures full model representing the feature's 3D geometry. Should only be found on TYPE_COMPOUND_BUILDING features for now, but not part of the BuildingProto extension for possible future extensions.
         */
        threeDimModel?: Schema$GeostoreThreeDimensionalModelProto;
        /**
         * Represents information about TYPE_TOLL_CLUSTER features.
         */
        tollCluster?: Schema$GeostoreTollClusterProto;
        /**
         * Defines the geometry of a feature as a sequence of 6D poses, including lat, lng, altitude, roll, pitch, and yaw. Only lat and lng are typically required. Each track has an index so that they can be viewed in a stable order.
         */
        track?: Schema$GeostoreTrackProto[];
        transitLine?: Schema$GeostoreTransitLineProto;
        /**
         * RESERVED
         */
        transitLineVariant?: Schema$GeostoreTransitLineVariantProto;
        transitStation?: Schema$GeostoreTransitStationProto;
        /**
         * The type of this feature -- see comments above.
         */
        type?: string | null;
        /**
         * Represents vertical ordering for this feature relative to other geometrically-overlaping features. See go/aboutgrades for more information about distinction among different levels.
         */
        verticalOrdering?: Schema$GeostoreVerticalOrderingProto;
        /**
         * Geometry Store ID and materialized geometry representing a tight bounding box of the feature's geometry (or the building/grounds a POI occupies), e.g. for generating flyover experiences.
         */
        visualizationArea?: Schema$GeostoreGeometryStoreReferenceProto;
        /**
         * A version of the geometry which has water removed but is not simplified (thus having equal or more vertices than polygon_for_display).
         */
        waterRemovedPolygon?: Schema$GeostorePolygonProto;
        /**
         * The official website of this feature. Stored as a repeated field to allow for multilingual official websites (see comments in url.proto).
         */
        website?: Schema$GeostoreUrlProto[];
    }
    /**
     * Metadata to track feature derivations and replacements. This is used to track feature provenance (particularly for road segments).
     */
    export interface Schema$GeostoreFeatureReplacementInfoProto {
        /**
         * This feature was created to replace other features that are referenced by this field.
         */
        derivedFrom?: Schema$GeostoreFeatureIdProto[];
        /**
         * This feature was replaced by other features that are referenced by this this field.
         */
        replacedBy?: Schema$GeostoreFeatureIdProto[];
    }
    /**
     * Internal field metadata. This part is not exposed to downstream consumers of the repository (read-only clients) but is available to upstream providers to the repository (read-write clients).
     */
    export interface Schema$GeostoreFieldMetadataProto {
        internal?: Schema$GeostoreInternalFieldMetadataProto;
    }
    /**
     * Proto used to represent rights for a feature property id. See go/geo-rights for more details. NOTE: Use google3/geostore/provenance/public/rights.h or google3/java/com/google/geostore/provenance/rights/Rights.java instead of accessing this proto directly.
     */
    export interface Schema$GeostoreFieldWithRightsProto {
        /**
         * **DEPRECATED** Never set.
         */
        attributeId?: string | null;
        /**
         * The feature property id for which this entry tracks rights.
         */
        featurePropertyId?: Schema$GeostoreFeaturePropertyIdProto;
        /**
         * **DEPRECATED** The field type for which this entry tracks rights. There may be multiple entries for the same field type - prefer feature_property_id to uniquely identify a particular entry.
         */
        fieldType?: number | null;
        /**
         * The minimum rights level among all current values for this feature property id.
         */
        minRightsLevel?: string | null;
    }
    /**
     * Wrapper to hold data related to a lane’s track, extendable for future data.
     */
    export interface Schema$GeostoreFlowLineProto {
        /**
         * RESERVED
         */
        curvature?: Schema$GeostoreCurvatureProto;
        track?: Schema$GeostoreTrackProto;
    }
    /**
     * Example: the choice of chicken, beef, or tofu for the Thai Basil dish. Each option would have its own name, price, allergen info, etc. Note: This proto stores both food and service items despite the name.
     */
    export interface Schema$GeostoreFoodMenuItemOptionProto {
        allergenAbsent?: string[] | null;
        allergenPresent?: string[] | null;
        calories?: number | null;
        /**
         * Ingredients of the food dish option.
         */
        ingredients?: Schema$GeostoreFoodMenuItemOptionProtoIngredient[];
        /**
         * Photos of the food dish option.
         */
        media?: Schema$GeostoreMediaItemProto[];
        /**
         * The repeated name_info field here is for item options with names or descriptions listed in multiple languages. When an item option has no names or descriptions, the size of the repeated field name_info may be 0. For example, when a food menu item does not have multiple options, the item option proto is used only to specify price and nutritional information, so it will not have a name_info field. There should be at most one name_info for any given language.
         */
        nameInfo?: Schema$GeostorePriceListNameInfoProto[];
        /**
         * Nutrition facts of the food dish option. Note that it also includes calories information with a finer defined unit information.
         */
        nutritionFacts?: Schema$GeostorePriceInfoFoodNutritionFacts;
        /**
         * Size of the order, represented in units of items. (e.g. 4 "skewers”, 6 "pieces”)
         */
        portionSize?: Schema$GeostoreFoodMenuItemOptionProtoPortionSize;
        /**
         * Methods on how the food dish option is prepared.
         */
        preparationMethods?: string[] | null;
        /**
         * We use PriceRangeProto here but we expect the lower_price and upper_price to be both set to equal numbers because an option should have a single price. This field is not required because food item prices may be variable depending on season.
         */
        price?: Schema$GeostorePriceRangeProto;
        restriction?: string[] | null;
        /**
         * Number of people can be served by this food dish option.
         */
        servesNumPeople?: number | null;
        spiciness?: string | null;
    }
    /**
     * This message denotes an ingredient information of a food dish.
     */
    export interface Schema$GeostoreFoodMenuItemOptionProtoIngredient {
        /**
         * The repeated name_info field is for the ingredient in multiple languages.
         */
        nameInfo?: Schema$GeostorePriceListNameInfoProto[];
    }
    /**
     * This message denotes the serving portion size of a food dish.
     */
    export interface Schema$GeostoreFoodMenuItemOptionProtoPortionSize {
        /**
         * Required.
         */
        quantity?: number | null;
        /**
         * Required. The repeated name_info field is for the unit in multiple languages.
         */
        unit?: Schema$GeostorePriceListNameInfoProto[];
    }
    /**
     * A food menu item must have a name although it can have multiple names in different languages. Example: Thai Basil. Price for this item is specified in the item_option field. Since the price of an item may be unknown, e.g. seasonal price, there is nothing that requires an item_option to be present in the FoodMenuItemProto.
     */
    export interface Schema$GeostoreFoodMenuItemProto {
        itemOption?: Schema$GeostoreFoodMenuItemOptionProto[];
        /**
         * The repeated name_info field is for items listed in multiple languages.
         */
        nameInfo?: Schema$GeostorePriceListNameInfoProto[];
    }
    /**
     * A GConceptInstanceProto contains a GConceptID (which is the unique identifier of a GConcept, a category in the Geo Ontology).
     */
    export interface Schema$GeostoreGConceptInstanceProto {
        /**
         * The unique identifier of a GConcept (e.g. "gcid:railway").
         */
        gconceptId?: string | null;
        /**
         * Field-level metadata for this GConcept.
         */
        metadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * The relative prominence of this category to this feature according to the data provider, as one of the values from the enum above. Prominence is a measure of how well the given GConcept describes the feature. An example is a gas station with convenience store and ATM. All three GConcepts are very relevant, but the gas_station GConcept is the most prominent. If the prominence of this GConcept is unknown, this field should not be set.
         */
        prominence?: string | null;
    }
    /**
     * Encapsulates all the features which, together, define the geometry of a feature. This happens by: 1. taking the union of all polygons of features referenced in includes_geometry_of 2. subtracting the polygons of all the features referenced in excludes_geometry_of
     */
    export interface Schema$GeostoreGeometryComposition {
        /**
         * Features whose geometry to exclude while composing the geometry of this feature.
         */
        excludesGeometryOf?: Schema$GeostoreFeatureIdProto[];
        /**
         * Features whose geometry to include while composing the geometry of this feature.
         */
        includesGeometryOf?: Schema$GeostoreFeatureIdProto[];
    }
    /**
     * A Geometry Store ID and, in some contexts, geometry materialized from the record associated with that ID.
     */
    export interface Schema$GeostoreGeometryStoreReferenceProto {
        /**
         * Geometry (in STGeography format) materialized from the footprint field of the Geometry Store record associated with the geometry_id referenced above.
         */
        footprint?: string | null;
        /**
         * Geometry materialized from the full_fidelity_proto field of the Geometry Store record associated with the geometry_id referenced above.
         */
        geometry?: Schema$GeostoreCityJsonProto;
        /**
         * The ID of a record in the Geometry Store.
         */
        geometryId?: string | null;
    }
    /**
     * Geopolitical (unsimplified) polygons for a feature for different geopolitical use cases. See go/unsimplified-poly.
     */
    export interface Schema$GeostoreGeopoliticalGeometryProto {
        /**
         * The unsimplified, water-subtracted polygon representing the feature's geometry as viewed by the rest of the world, which may differ from its default polygon, for example by excluding certain regions.
         */
        restOfWorldPolygon?: Schema$GeostorePolygonProto;
        /**
         * The unsimplified, water-subtracted polygon representing the feature's geometry as viewed by the country that administers it, which may differ from its default polygon, for example by including disputed areas.
         */
        selfPolygon?: Schema$GeostorePolygonProto;
    }
    export interface Schema$GeostoreGeopoliticalProto {
        /**
         * If present, some aspect of this feature (usually name or geometry) can signify ownership of the area by the region specified. The string, if present, will be a region code. E.g., suppose a TYPE_POSTAL_CODE feature has a Russian format in Crimea (which is disputed by Ukraine), then this field would be set to "RU".
         */
        conveysAttributionTo?: string | null;
        /**
         * Any specific handling of this feature's name from different regions' POVs.
         */
        regionSpecificName?: Schema$GeostoreRegionSpecificNameProto[];
    }
    /**
     * The grade level of a segment represents the relative altitude of the segment at a particular point along the segment. This level is in relation to other segments at the same point. For example, you might have a freeway at level = 0 and an overpass at level = 2. Vertical segments are represented by a polyline containing only 1 vertex and exactly two grade_level in segment.proto whose indices are 0. grade_level(0) represents the relative height at the start point of the segments, and grade_level(1) represents the one at the end point.
     */
    export interface Schema$GeostoreGradeLevelProto {
        /**
         * The index of the point along the segment, where 0 is the starting point. This means that the index of a point along a segment and its sibling will be different.
         */
        index?: number | null;
        /**
         * The grade level of the indexed point. The grade level can be thought of as a relative vertical ordering with respect to other segments at the same point, where larger/more positive numbers are "higher". Negative grade level values are allowed and are typically used for points below grade level (0 is a common choice to represent the level of points at the ground level). For vertical segments, the height, i.e. the vertical length, is represented by difference of levels in millimeters. For example, feature.segment().grade_level(0).level() == 0 and feature.segment().grade_level(1).level() == 5000, then the length of the vertical segment feature is 5000 millimeters (5 meters).
         */
        level?: number | null;
    }
    /**
     * Represents HTML text associated with a feature.
     */
    export interface Schema$GeostoreHtmlTextProto {
        /**
         * Zero or more texts of the specified type, in various languages. If this is a HTML_DESCRIPTION blob then these texts would hold the description in English, German, and so forth. The text is an HTML fragment, not a full page. The fragment should be suitable for including in a DIV. It must have balanced HTML tags. It may use HTML's "class" attributes to assign classes to HTML elements. This allows the HTML to be formatted by an (external) style sheet. The HTML should not have embedded style sheet definitions, nor should it have embedded JavaScript.
         */
        text?: Schema$GeostoreLanguageTaggedTextProto[];
        type?: string | null;
    }
    /**
     * Inferred geometry defines the geometry of a feature as the union or exclusion of the geometry of other features. For instance, the geometry of a timezone can be specified as the union of all the countries it applies to. In this scenario, the timezone will can be considered a "composite feature", while the countries are its "composing features". A composite feature must have a bidirectional reference between itself and all its composing features. A composite feature refers to its composing features via `geometry_composition`, while the composing features must refer back to the composing feature via `defines_geometry_for`. See: go/inferred-geometry and go/geo-schema:composite-geometry-editor for more details.
     */
    export interface Schema$GeostoreInferredGeometryProto {
        /**
         * Features whose geometry depends on this feature's geometry.
         */
        definesGeometryFor?: Schema$GeostoreFeatureIdProto[];
        /**
         * Features whose geometry defines the geometry of this feature (i.e. "composing features").
         */
        geometryComposition?: Schema$GeostoreGeometryComposition;
    }
    /**
     * Main proto for all internal fields to be stored at the feature level.
     */
    export interface Schema$GeostoreInternalFeatureProto {
        /**
         * A unique identifier for this feature's polygon data which is being held externally in Shapestore (see go/shapestore).
         */
        polygonShapeId?: string | null;
        /**
         * A unique identifier for this feature's rest-of-world view polygon data which is being held externally in Shapestore (see go/shapestore). This is part of the feature's geopolitical geometry.
         */
        restOfWorldPolygonShapeId?: string | null;
        /**
         * Per-field rights for this feature. See http://g3doc/geostore/g3doc/developers-guide/inputs/rights-tracking for more information.
         */
        rightsStatus?: Schema$GeostoreRightsStatusProto;
        /**
         * A unique identifier for this feature's self view polygon data which is being held externally in Shapestore (see go/shapestore). This is part of the feature's geopolitical geometry.
         */
        selfPolygonShapeId?: string | null;
        /**
         * Trust signals/annotations for the feature. In an input feature, these signals are computed at the beginning of the pipeline and are immutable during the processing. In output features, this proto may define the rules/criteria that a newer edit should meet, in order to be applied.
         */
        trust?: Schema$GeostoreTrustSignalsProto;
        /**
         * A unique identifier for this feature's water-removed polygon data which is being held externally in Shapestore (see go/shapestore).
         */
        waterRemovedPolygonShapeId?: string | null;
    }
    export interface Schema$GeostoreInternalFieldMetadataProto {
        /**
         * Whether or not the piece of data has been generated automatically (i.e., by a bot/automated process based on heuristics/algorithms rather than coming as a fact set by some human user or data provider based on their knowledge). Note that this does NOT imply that the value was set as a result of a bot operation on the repository, since it is conceivable to use a bot/automated process simply as a way of convenience to ingest large amount of canonical/ground truth data.
         */
        isAuto?: boolean | null;
        /**
         * Information about the source providing the piece of data this metadata is attached to.
         */
        sourceSummary?: Schema$GeostoreInternalSourceSummaryProto;
    }
    /**
     * Internal-only proto used to express additional information about segments. This is intended for communicating extra information between editing clients and the repository, and should not be used by or visible to clients. WARNING - if you add new fields to InternalSegmentProto, make sure that geostore/tools/internal/mr-mergesegments_test.cc is aware of them.
     */
    export interface Schema$GeostoreInternalSegmentProto {
        /**
         * A list of lane connections that are explicitly not allowed to be added. NOTE: This should never reference existing lane connections on this segment.
         */
        disallowedConnections?: Schema$GeostoreInternalSegmentProtoLaneConnectionReference[];
        /**
         * A list of lane connections which cannot have the primary_connection bit set.
         */
        disallowedPrimaryConnection?: Schema$GeostoreInternalSegmentProtoLaneConnectionReference[];
        /**
         * The set of restrictions that apply to this segment; these are actually *POSITIVE* restrictions, i.e. they are known to be allowed.
         */
        travelAllowance?: Schema$GeostoreRestrictionProto[];
    }
    /**
     * Specifies a single outgoing lane connection.
     */
    export interface Schema$GeostoreInternalSegmentProtoLaneConnectionReference {
        /**
         * The lane number on this segment.
         */
        fromLaneNumber?: number | null;
        /**
         * This reference to the other segment is weak, since strong would blow up bounds of all segments.
         */
        segment?: Schema$GeostoreFeatureIdProto;
        /**
         * This is the lane number on the target segment.
         */
        toLaneNumber?: number | null;
    }
    export interface Schema$GeostoreInternalSourceSummaryProto {
        /**
         * Within the above provider, the dataset from which this piece of data was generated. For fields that are auto-generated the "dataset" is likely to be some algorithm's or program's name. Similar to SourceInfoProto.dataset but with the difference that it is required to always be set. Providers that don't have a concept of dataset may use "default".
         */
        dataset?: string | null;
        /**
         * The data provider from which this piece of data was generated. Equivalent to SourceInfoProto.provider in the public schema.
         */
        provider?: string | null;
    }
    /**
     * Our TYPE_INTERSECTION features model the point where one or more segments terminate. This is topological definition: it may not match what a typical user would think of as an "intersection". Consider the intersections where Hayes, Market, Larkin, and 9th Street meet near (37.77765, -122.41638) in San Francisco. Most people would probably consider this a single feature, even though we model it as four separate TYPE_INTERSECTION features. The TYPE_INTERSECTION_GROUP is used to model the user's concept of a real-world intersection, which also includes turn lanes or a whole roundabout (a logical intersection). For the purposes of modeling turn restrictions and lane connections, a smaller grouping is needed to model the "core" part of the intersection where there are no lane markings. This is called a core or artifact group. An intersection group must contain at least two intersections or add some information (e.g. a name or a polygon) compared to the intersection itself, or else must not exist. The standard feature properties are interpreted as follows: name - Can be used to specify any "special" names associated with this intersection (e.g. Reads Corner intersection, PEI, Canada). Intersections that are named according to their cross streets do not need to specify this field, since this can be determined by looking at the routes associated with each segment. address - This should always be empty. point - Specifies the center of the intersection. This is basically the point where the intersection name should be rendered. Can be omitted in favor of a polygon. polyline - This should always be empty. polygon - Specifies the two-dimensional extent of the intersection. This may substitute to the point field, though having a center set is desirable in this case. child - This should always be empty.
     */
    export interface Schema$GeostoreIntersectionGroupProto {
        /**
         * All artifact intersection groups that are in this logical group.
         */
        childGroup?: Schema$GeostoreFeatureIdProto[];
        groupType?: string | null;
        /**
         * The list of TYPE_INTERSECTION features that form this intersection group, but are NOT in any of this group's child groups. This could be an empty list, though that is sub-optimal. Even an empty list would allow the paint team to draw a label for a named intersection, but a non-empty list would, for example, enable PathFinder to generate better directions. Each of the TYPE_INTERSECTION feature referred here must refer back to this feature in its IntersectionProto.
         */
        intersection?: Schema$GeostoreFeatureIdProto[];
        /**
         * Parent logical intersection group. An artifact group that does not have an associated parent logical group is assumed to be both an artifact and logical group.
         */
        parentGroup?: Schema$GeostoreFeatureIdProto;
    }
    /**
     * A TYPE_INTERSECTION feature represents a common endpoint of one or more segments in a transportation network at which the segments are connected. An intersection in the real world may be more complicated than that (e.g., comprise multiple segment endpoints or have extra attributes), which can be modeled with an additional TYPE_INTERSECTION_GROUP feature, if needed (see intersectiongroup.proto). The standard feature properties are interpreted as follows: name - This should always be empty. Intersections that have a "special" name (e.g. Reads Corner intersection, PEI, Canada) should point to a separate TYPE_INTERSECTION_GROUP feature that captures it. Intersections which are named according to their cross streets do not need this requirement, since their name can be determined by looking at the routes associated with each segment. address - This should always be empty. point - Specifies the center of the intersection. This should be the last vertex of all the segments which terminate at this intersection. polyline - This should always be empty. polygon - This should always be empty. child - This should always be empty.
     */
    export interface Schema$GeostoreIntersectionProto {
        /**
         * The artifact or logical intersection group to which this intersection belongs. If present, the intersection group must also refer back to the intersection. If an intersection is within both the artifact and logical group, then this reference should be to the artifact group.
         */
        intersectionGroup?: Schema$GeostoreFeatureIdProto;
        /**
         * RESERVED
         */
        outSegment?: Schema$GeostoreFeatureIdProto[];
        /**
         * The list of segments that terminate at this intersection, in any order. Note that all segments are directed towards the intersection, i.e. their endpoints indicate what sort of intersection this is. This should not be empty because an intersection with no associated segment is meaningless.
         */
        segment?: Schema$GeostoreFeatureIdProto[];
        /**
         * The toll cluster to which this intersection belongs. If present, the toll cluster must also refer back to the intersection.
         */
        tollClusterId?: Schema$GeostoreFeatureIdProto;
    }
    export interface Schema$GeostoreJobMetadata {
        /**
         * Describes how much time the service is going to take, e.g. how long it takes to do a haircut. Value of seconds must be from +60 (1 min) to +31,536,000 (365 days) inclusive. Value of nanos must be zero.
         */
        duration?: string | null;
        /**
         * Represents the name of a potential grouping of items. For TYPE_JOB, this is the category names of the categories that a user picked this job type from at the time of input.
         */
        jobRelatedCategories?: Schema$GeostoreJobRelatedCategory[];
        /**
         * Unique identifier for a job. This is required for standard jobs and blank for free-form jobs. Job type ids are prefixed with "job_type_id:". Notice this is a unique string representation of a job across languages. E.g., “job_type_id:air_duct_repair”. The existence of a job_type_id means the job type is a standard one, and has a corresponding entry in the Standard Jobs Taxonomy.
         */
        jobTypeId?: string | null;
        /**
         * Represents the MID corresponding to the job_category entity in the Knowledge Graph. For example, job_type_id="job_type_id:install_faucet", job_type_mid="/g/11hzzxjv3f".
         */
        jobTypeMid?: string | null;
    }
    /**
     * This is the category that a user picked this job type from at the time of input. The field serves two purposes: 1) The name is used in consumer surface similar to the heading name today (i.e., grouping jobs under the category. 2) The gcid is needed mainly for free-formed entries, for which GMB needs to map them to corresponding categories in the frontend, if applicable. Notice that the name and the id are both not expected to be in sync with gcid deprecation or location category change per product decision. In other words, they are not guaranteed to stay in sync, only guaranteed true at time of creation.
     */
    export interface Schema$GeostoreJobRelatedCategory {
        gcid?: string | null;
        language?: string | null;
        /**
         * Category name in the primary language of the feature. Generally intended to be used as a fallback when we are unable to fetch the name in the user's language.
         */
        name?: string | null;
    }
    /**
     * The reference to an entity in the KnowledgeGraph. For details on the KnowledgeGraph see http://goto/kg.
     */
    export interface Schema$GeostoreKnowledgeGraphReferenceProto {
        /**
         * KG Identifier (MID). For details, see http://go/ke-bg-knowledge-graph#mids.
         */
        id?: string | null;
    }
    /**
     * This protocol buffer represents the association between a segment and a landmark feature. Notes: - References to TYPE_SEGMENT features should always point to the even sibling. - Self-references are allowed but the referencing segment's sibling is required to have a self-reference as well (the above requirement to always reference the even sibling still applies).
     */
    export interface Schema$GeostoreLandmarkReferenceProto {
        /**
         * The type of the landmark feature. Allowed types: - TYPE_CARTOGRAPHIC e.g. a putting green or water hazard - TYPE_COMPOUND e.g. - the Empire state building (TYPE_COMPOUND_BUILDING) - a park (TYPE_COMPOUND_GROUNDS) - a section of a retail store (TYPE_COMPOUND_SECTION) - TYPE_ESTABLISHMENT e.g. - the Eiffel Tower (TYPE_ESTABLISHMENT_BUILDING) - a sports field (TYPE_ESTABLISHMENT_GROUNDS) - Starbucks (TYPE_ESTABLISHMENT_POI) - TYPE_INTERSECTION_GROUP e.g. a major intersection - TYPE_NATURAL_FEATURE e.g. a river - TYPE_SEGMENT e.g. a bike trail or train tracks
         */
        featureType?: number | null;
        /**
         * The feature ID of the landmark feature.
         */
        landmark?: Schema$GeostoreFeatureIdProto;
        /**
         * The mode(s) of travel for which this landmark is useful.
         */
        travelMode?: string[] | null;
    }
    /**
     * This proto contains attributes relevant to physical lane markers.
     */
    export interface Schema$GeostoreLaneMarkerProto {
        /**
         * If this is a physical barrier marker, represent materials found on the marker.
         */
        barrierMaterials?: Schema$GeostoreBarrierLogicalMaterialProto;
        /**
         * Pattern border and color for crossing markers. These include crosswalks, stop, and yield lines.
         */
        crossingPattern?: Schema$GeostoreCrossingStripePatternProto;
        /**
         * Stripe pattern, spacing, and color for longitudinal markers.
         */
        linearPattern?: Schema$GeostoreLinearStripePatternProto;
    }
    /**
     * Describes an individual road lane. Not only driving lanes, but also parking and biking lanes are covered by this. Note that we may eventually add curbs and walking to this schema. MOTIVATION/DESIGN DISCUSSION The intent of this schema is to model a schematic representation of the road for a bunch of use cases within GMM, navigation, map tiles. For rendering, we do not want to represent the geometry of each lane exactly, but do want to model types/width/gaps/lane markings so that a schematic rendering can be made. For navigation, we model lane connectivity and restrictions per lane, so that Pathfinder can potentially pick routes based on lanes, and definitely use the lanes to better describe the path to the driver. This schema is driven by the GT team, which is likely to be the only provider of this data. It is based on compromises that we are working out with other teams, based on what our operators can reasonably collect and what is useful. See docs here: https://docs.google.com/a/google.com/document/d/11XJ1WvqS5Sm7MxWXzzc3tnsk49VhrR3BYFjiRMAzYm0/edit?hl=en_US https://docs.google.com/a/google.com/document/d/1nzdupynTUKE8xY8JcfvQbU-KWtCJ6IwHiTaCxuq40EM/edit?hl=en_US Note: Some lane information (width, surface type, etc) may duplicate or contradict information stored at the segment level.
     */
    export interface Schema$GeostoreLaneProto {
        /**
         * References to any gcid:physical_lane_marker features that bound this lane.
         */
        boundingMarker?: Schema$GeostoreBoundingMarkerProto[];
        /**
         * If the current lane is part of a merge/split area, indicates the type (split or merge) and whether the current lane is on the left or right or in the middle of the merge/split area, as seen in the direction of traffic. See go/lane-split-merge-schema
         */
        conjoinedCategory?: string | null;
        /**
         * Gap between this lane and the next in meters. This is relevant when the divider is physical, or a wide painted area. For regular painted single or double lines, there is no gap. This distance is duplicated between the innermost lanes for each side. Note that this is not used to describe smallish islands - this is only for long-running gaps. In particular, this models the median width, the gap between HOV lanes/regular lanes on freeways, and the road verge between a curb and sidewalk. Note on split roads: We can model any split road with a median as a single sibling pair with this distance set to the width of the median, or as two one-way sibling pairs.
         */
        distanceToNextLane?: number | null;
        /**
         * The most logical path for the center of an object to travel along within the lane. Typically, this is the lane's center line, but doesn't have to be.
         */
        flow?: Schema$GeostoreFlowLineProto;
        /**
         * Connections to lanes of other segments at the end of this segment. These connections model the connectivity where you don't have to do a lane change maneuver. If any lane connection is present, assume that all others are forbidden. Also note that segment level restrictions do apply if present, and can disallow some turn even if the lanes are connected. For instance, this can happen with timed or vehicle type based restrictions on the segment. If lane connectivity implies a segment-level restriction (can't transition to some target segment), that restriction will also exist as a segment level restriction. In effect - PathFinder does not have to look at lane connectivity to figure out segment connectivity. Example: Typically, lanes are just connected to one other lane. Example: A splitting lane is connected to the two resulting lanes. Example: At an intersection, a lane is connected to crossing lanes according to how lanes are painted across the intersection. In the common case, the target segment will be connected to the same intersection as this segment. That will however NOT be true for complex intersections where there is an intersection group. The connections will be across the whole group, connecting to one of the outgoing segments from the group. This is analogous to how we do turn restrictions around intersection groups.
         */
        laneConnection?: Schema$GeostoreLaneProtoLaneConnection[];
        /**
         * clang-format on Whether the divider to the inside of this lane can be crossed. Note that we assume this is symmetric, and that this also describes whether someone in the next inside lane can cross to this one. The "inside" lane is the one with a lower lane_number. Note on lane markers: We do not model the painting, but only the resulting legality. There are many painted marker styles and colors that lead to the same legality. We expect Paint or Driveabout to render lanes stylized, with solid meaning "can't cross", and dashed meaning "can cross". Note on varying legality along segment: ALLOWED takes precedence - even if some small portion has a restriction (such as right before an intersection) , the lane change will be ALLOWED.
         */
        laneDividerCrossing?: string | null;
        /**
         * These indicate for what portion of the segment the lane's flowline exactly follows the segment, and the lane is of constant width. This will be set to not include the whole segment where there is a split/turn/merge at either end of the lane. The painting of the lane should completely synthesize the lane geometry outside of this portion, connecting it to neighboring lanes to make graphical nice.
         */
        laneFollowsSegmentBeginFraction?: number | null;
        laneFollowsSegmentEndFraction?: number | null;
        /**
         * Lanes are numbered from inside of the road outward, i.e. the lane next to the center line is lane 0. The lanes then stack outwards, towards the side that one drives on this segment (right or left). NOTE: do NOT use the lane_number as index for lookup. Lane_number is not guaranteed to match the segment.lane repeated field index.
         */
        laneNumber?: number | null;
        /**
         * A token that can be used to identify the version of the data about this lane.
         */
        laneToken?: string | null;
        /**
         * Field-level metadata for this lane.
         */
        metadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * Restrictions that apply to this lane only. Examples include HOV lanes. If a lane restriction implies a segment-level restriction (can't route on the segment at all), that restriction will also exist as a segment level restriction. In effect - PathFinder does not have to look at lane restrictions to figure out segment restrictions.
         */
        restriction?: Schema$GeostoreRestrictionProto[];
        /**
         * True if this lane is usable in both directions (left-turn lane, reversing lane, one-lane road, etc). To get the total number of lanes for a road, add up the lanes in each direction counting 0.5 for each shared lane.
         */
        shared?: boolean | null;
        /**
         * References to any gcid:physical_lane_marker features that intersect this lane, with the implication that a moving vehicle should stop there.
         */
        stopLine?: Schema$GeostoreFeatureIdProto[];
        /**
         * clang-format on LINT.ThenChange(//depot/google3/geostore/base/proto/segment.proto) Unlike the surface in SegmentProto, this field does not have a default value. This is because the lane-level surface overrides the segment-level surface. The lane's surface should be unset unless explicitly overriding the segment's surface.
         */
        surface?: string | null;
        /**
         * clang-format on
         */
        type?: string | null;
        /**
         * Width of this lane in meters. In many cases, we will collect this data by dividing the total road width by the number of lanes. On accuracy: This is a rough average width along this segment. If and when we wanted to be more accurate, we'd extend this schema to have full polygons for segments/lanes rather than just this average width.
         */
        width?: number | null;
    }
    export interface Schema$GeostoreLaneProtoLaneConnection {
        /**
         * References to any gcid:physical_lane_marker features that bound this lane connection.
         */
        boundingMarker?: Schema$GeostoreBoundingMarkerProto[];
        /**
         * A token that can be used to identify the version of the data about this lane connection.
         */
        connectionToken?: string | null;
        /**
         * Specifies how the flowline should be synthesized in this connection region. If unspecified, heuristics may be used to pick a sweep shape based on retraction values or neighboring curves.
         */
        curve?: Schema$GeostoreCurveConnectionProto;
        /**
         * The most logical path for the center of an object to travel along within the lane connection. Typically, this is the lane connection's center line, but doesn't have to be.
         */
        flow?: Schema$GeostoreFlowLineProto;
        /**
         * This is the lane number on the target segment. This field is not set if the target segment doesn't have lanes, or we don't know the exact connectivity.
         */
        laneNumber?: number | null;
        /**
         * True if this connects to the unique, natural continuation of the current lane. At most one LaneConnection per lane can have this field set true. This attribute is of interest to ADAS providers as a hint to which lane a vehicle is likely to follow, in the absence of other information about the vehicle's planned path.
         */
        primaryConnection?: boolean | null;
        /**
         * This reference to the other segment is weak, since strong would blow up bounds of all segments.
         */
        segment?: Schema$GeostoreFeatureIdProto;
        /**
         * The inverse of the primary connection bit that provides a hint that this connection is part of a merge and a vehicle following this connection should yield to vehicles following other incoming connections.
         */
        yieldToOtherConnections?: boolean | null;
    }
    /**
     * Represents a piece of text with an associated language.
     */
    export interface Schema$GeostoreLanguageTaggedTextProto {
        /**
         * The external form of a Google International Identifiers Initiative (III) LanguageCode object. See google3/i18n/identifiers/languagecode.h for details. We place extra restrictions on languages in addition to what the III library requires. See http://go/geo-schema-reference/feature-properties/languages.md
         */
        language?: string | null;
        /**
         * The text (UTF-8 encoding).
         */
        text?: string | null;
    }
    /**
     * A feature used to represent a logical level, e.g. floor. A feature belonging to a given level should point to the level feature using relation RELATION_ON_LEVEL. The standard feature properties are interpreted as follows: name - Levels should have names according to the following: * Short, elevator-style names, such as "L" for "Lobby" and "2" for "Second floor", must be included and must be tagged with FLAG_ABBREVIATED. There must be an unambiguous "best" abbreviated name. * Longer names such as "Ticketing" or "Upper Level" may be present when the level has a specific name. * Non-abbreviated names should only be added if they are known to meaningfully expand upon the abbreviated name. For example, the long name "Observation Deck 2" for the abbreviated name "OD2" is a good additional name. In contrast, the name "Level 2" for the abbreviated name "2" is not desired. address - This should always be empty. point, polyline, polygon, center - These should never be set (since we are representing a logical entity). preferred_viewport - This should be the approximate extent of the level. child - This should always be empty.
     */
    export interface Schema$GeostoreLevelProto {
        /**
         * The building(s) to which this level belongs. A level will typically belong to a single building, but it is valid for a single level to be shared by multiple buildings (for example, a large underground parking lot). These buildings refer back to the level via another strong reference (the BuildingProto.level field).
         */
        building?: Schema$GeostoreFeatureIdProto[];
        /**
         * The elevation of this level relative to the ground level, in levels. 0 = ground floor (even in locales that call the ground floor "1st floor"); 0.5 = between ground and first floor, eg mezzanine; 1 = first floor (one level above ground floor); -3 = three levels below ground floor.
         */
        number?: number | null;
    }
    export interface Schema$GeostoreLinearStripePatternProto {
        /**
         * A linear marker may consist of one or more parallel physical lines. These are ordered left to right along the direction of the marker core polyline.
         */
        line?: Schema$GeostorePhysicalLineProto[];
    }
    /**
     * This message describes the details of a single language within a locale.
     */
    export interface Schema$GeostoreLocaleLanguageProto {
        /**
         * The language associated with this preference. The external form of a Google International Identifiers Initiative (III) LanguageCode object. See google3/i18n/identifiers/languagecode.h for details. We place extra restrictions on languages in addition to what the III library requires. See http://go/geo-schema-reference/feature-properties/languages.md
         */
        language?: string | null;
        /**
         * Flag to indicate if the associated language is "official" within a locale.
         */
        official?: boolean | null;
        /**
         * This value represents the preference of the associated language within a locale. It must be between 0.0 and 1.0.
         */
        preference?: number | null;
        /**
         * Percentage of population that can speak the associated language within a locale. It must be between 0 and 100.
         */
        speakingPercent?: number | null;
        /**
         * Percentage of population that can write the associated language within a locale. It must be between 0 and 100.
         */
        writingPercent?: number | null;
    }
    /**
     * A locale is a meta-feature that describes the geographic extent of localization preferences such as the local language, and formatting conventions for numbers, dates and monetary values. Multilingual areas may be contained by multiple locales. We try to model locales fine-grained enough for deciding which languages are typically used within a city. For example, while French is an official language for all of Switzerland, we would prefer to have Zurich contained by a separate (more fine-grained) Swiss-German locale indicating that German, not French, is the predominantly spoken language in this city. Note that language borders are frequently considered a political question and often don't have clearly defined extents. For example, California has a significant Spanish-speaking population, but Spanish is not an official language of California.
     */
    export interface Schema$GeostoreLocaleProto {
        /**
         * This holds the list of languages spoken within a locale.
         */
        language?: Schema$GeostoreLocaleLanguageProto[];
        /**
         * The ID of the localization policy (from googledata/geostore/localization/localization_policies.textpb) to apply to features that have this locale as their best match locale. Localization policy IDs are arbitrary identifiers that uniquely distinguish a set of language-selection rules.
         */
        localizationPolicyId?: string | null;
    }
    /**
     * A logical border is a grouping of border features, which together model a divide between two regions. The borders within this grouping share common attributes, such as the regions they divide, and may represent a conceptual group of borders, of which may be wholly disputed, wholly undisputed, or a mixture of disputed and undisputed. Note that any borders within this group may be part of multiple logical borders. A logical border is required to have a name describing what the grouping represents (e.g. "US - Mexico Border", "Kosovo - Serbia Border (Disputed)").
     */
    export interface Schema$GeostoreLogicalBorderProto {
        /**
         * All the border segments which make up this logical border. Border segments must be TYPE_BORDER features which have the same left/right features. This is a many-to-many bidirectional relationship, so any border segment within this list might be part of another logical border.
         */
        borderSegment?: Schema$GeostoreFeatureIdProto[];
        /**
         * The logical border status identifies its legal status. This is similar to the BorderStatus present within border segments, but applies to the group as a whole.
         */
        status?: string | null;
    }
    /**
     * Media item attached to an element of price list.
     */
    export interface Schema$GeostoreMediaItemProto {
        /**
         * The FIFE url associated with the media. NOTE: This FIFE URL must be PII-free, see go/product-catalogue-photo-storage
         */
        googleUrl?: string | null;
        mediaFormat?: string | null;
        /**
         * The mediaKey associated with the media. NOTE: This media key must be PII-free, see go/product-catalogue-photo-storage
         */
        mediaKey?: string | null;
        mediaSize?: Schema$GeostoreMediaItemProtoMediaSize;
    }
    /**
     * Width and height of the original photo in pixels.
     */
    export interface Schema$GeostoreMediaItemProtoMediaSize {
        originalHeightPx?: number | null;
        originalWidthPx?: number | null;
    }
    /**
     * A name for a Feature (street name, point of interest, city, building, etc). We currently use NameProto for two essentially disjoint purposes: 1. Common names, which can be language-specific, or have other kinds of variations. 2. Opaque IDs, such as postal codes, which only have the `text` field set, and potentially some flags. This includes internal-only features like template ids. Each NameProto representing a common name corresponds to an assertion that a fluent speaker or writer of a language would recognize NameProto.text to name the given feature in that language. As such, NameProtos are stored in a repeated field, often having: 1. multiple names with the same text and varying languages, and 2. multiple names with the same language and varying texts.
     */
    export interface Schema$GeostoreNameProto {
        /**
         * clang-format on The set of flags that apply to this name.
         */
        flag?: string[] | null;
        /**
         * The external form of a Google International Identifiers Initiative (III) LanguageCode object. See google3/i18n/identifiers/languagecode.h for details. These strings should be treated as opaque blobs. You can use LanguageCodeConverter::FromOther to convert the string to a LanguageCode reference. You can then call methods on the LanguageCode class to extract language/script/region subtags (if any). See also http://g3doc/i18n/identifiers/g3doc/using-iii. We place extra restrictions on languages in addition to what the III library requires. See go/geo-schema-reference/feature-properties/languages. This field may be missing if the name does not have a concept of language but should be set if the language is unknown.
         */
        language?: string | null;
        /**
         * Field-level metadata for this name. NOTE: there are multiple NameProto fields in the Geo Schema. Metadata here is only expected to be present on FeatureProto.name[].
         */
        metadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * ** DEPRECATED ** The name text provided in the original source data (UTF-8 encoding). This is the text provided in the source data unmodified with the exception of being converted to UTF-8 and stripping extra leading, trailing and duplicate whitespaces (if necessary).
         */
        rawText?: string | null;
        /**
         * The short name text (UTF-8 encoding). Acronyms/abbreviations should be consistently used, for example "NE 57th St" rather than "Northeast 57th Street", "N.E 57th St." or some other variant. This field should be populated with the chosen canonical version of the shortened name, based on per-term transformations. For feature specific abbreviations (such as 'CA' for 'California'), one should define a separate name with FLAG_ABBREVIATED set. For other variants of the shortened name that are not the canonical one, devise client based logic (ex: query rewriting rules).
         */
        shortText?: string | null;
        /**
         * A place for clients to attach arbitrary data to a name. Never set in MapFacts.
         */
        temporaryData?: Schema$Proto2BridgeMessageSet;
        /**
         * The name text (UTF-8 encoding). Acronyms/abbreviations should be fully expanded, for example "Northeast 57th Street" rather than "NE 57th St". They can be shortened at display or geocode time. This decision prevents ambiguity over such issues as whether "St" represents "Street" or "Saint". However, it pushes language-specific knowledge into code. We will have libraries and data files to contract acronyms/abbreviations at run-time.
         */
        text?: string | null;
    }
    /**
     * The container for all GConceptInstances associated with a feature.
     */
    export interface Schema$GeostoreOntologyRawGConceptInstanceContainerProto {
        instance?: Schema$GeostoreOntologyRawGConceptInstanceProto[];
    }
    /**
     * A RawGConceptInstanceProto contains all data required by both internal and external clients. We store the 'public' data in a GConceptInstanceProto and the 'private' data inside of RawGConceptInstanceProto. NOTE: this doesn't really match the design we want anymore. Please talk to the Geo Schema team if you are planning to make use of the "private" fields below.
     */
    export interface Schema$GeostoreOntologyRawGConceptInstanceProto {
        /**
         * This is the 'public' section of the GConceptInstance.
         */
        instance?: Schema$GeostoreGConceptInstanceProto;
        /**
         * ** DEPRECATED ** Was this GConcept explicitly added by an edit? Examples of gconcepts not added by edits include those inferred through geo ontology and those mapped from legacy category forms by the feature updater. Note that it is possible for both is_added_by_edit and is_inferred to be true - it means this gconcept is added by an edit and there is also another more fine-grained gconcept added by an edit.
         */
        isAddedByEdit?: boolean | null;
        /**
         * RESERVED
         */
        isInferred?: boolean | null;
        /**
         * ** DEPRECATED ** These two fields combined describe the source of a GConceptInstance. They are based on geostore/base/proto/datasourceprovider.proto. Their use has been deprecated. Use the FieldMetadataProto inside instance instead.
         */
        provider?: string | null;
        sourceDataset?: string | null;
    }
    /**
     * Message to represent opening hours including regular weekly hours and a set of exceptions.
     */
    export interface Schema$GeostoreOpeningHoursProto {
        /**
         * Date delimited exceptions to the typical recurring opening hours. May only be present if regular weekly hours are also specified.
         */
        exception?: Schema$GeostoreExceptionalHoursProto[];
        /**
         * Typical recurring opening hours, expressed as a weekly schedule. NOTE: this field was introduced to have a more client-friendly format for representing weekly hours but, as of November 2018, it's not used for the main opening hours of TYPE_ESTABLISHMENT features (instead, the data is stored in the `EstablishmentProto.hours` field, see b/23105782 tracking the possible schema migration). It is however used in other contexts where `OpeningHoursProto` appears in the Geo Schema. In openinghours.h there is a utility function `GetOpeningHoursFromFeature` that merges `EstablishmentProto.hours` into this proto.
         */
        regularHours?: Schema$GeostoreBusinessHoursProto;
    }
    /**
     * Information about a feature's operations, e.g. when the feature is temporarily closed.
     */
    export interface Schema$GeostoreOperationsProto {
        /**
         * Records temporary status change of the feature, such as remodel, vacation, etc.: the feature is temporarily (but not permanently) unavailable. This prevents users from going to the feature. Supports an arbitrary number of past, present, and future temporary closures, with the feature's data owner choosing which range of past and future closures to permit or guarantee to keep. All start and end dates must be unique from each other. If two consecutive dates are a start and an end of a TemporaryClosureProto, then the two dates must be from the same TemporaryClosureProto. Otherwise, exact dates may be missing so long as there exist a possible sequence of temporary closures with both exact start_date and end_date that keeps any known exact start_date and end_date. The earliest temporary closure must begin after whenever initial operations begin. Likewise, the latest temporary closure must end before whenever the permanent closure begins. NOTE: does *not* guarantee chronological order.
         */
        temporaryClosure?: Schema$GeostoreTemporaryClosureProto[];
    }
    /**
     * This message captures a border status override. For instance, if the TYPE_BORDER feature between China and Hong Kong must be hidden on ditu.google.cn (the Chinese domain for Google Maps) but may be displayed on other domains, we will have a country override border status for "CN" set to STATUS_NEVER_DISPLAY. At least one override restriction must be defined. Currently the only supported restriction is by country code.
     */
    export interface Schema$GeostoreOverrideBorderStatusProto {
        /**
         * The two-letter ISO 3166-1 country code corresponding to the domain this status override applies to, when rendering the border polyline.
         */
        countryCode?: string | null;
        /**
         * The override status, from the BorderStatus enumeration. The value here must be different from the main status (otherwise there's no point in providing the override).
         */
        status?: string | null;
    }
    /**
     * Painted element logical color. Most legal definitions only specify a color category (like "yellow") and don't specify an exact hue, rather stating that the colors must be distinguishable from each other. We refer to this as the "logical" color.
     */
    export interface Schema$GeostorePaintedElementLogicalColorProto {
        color?: string | null;
    }
    /**
     * Describes the parking allowances for a feature, or the situations and requirements under which one may be permitted to park, such as certain vehicle types, valet parking, and permit parking. Also describes the cost of parking, which may vary based on the time and duration parked. Includes vehicle type, any other conditions for eligibility, and the cost of parking, which may vary based on the time and duration parked. If is_discount is set to true on a given allowance, that allowance represents a discount that can be applied to lower the cost of non-discount allowances specified on feature via parking_provider_feature. In this way, allowances can be 'layered,' i.e. appended, onto each other when denormalizing references via parking_provider_feature.
     */
    export interface Schema$GeostoreParkingAllowanceProto {
        /**
         * The type of parking for this allowance. Allowance details only apply to the type of parking specified.
         */
        allowanceType?: string | null;
        /**
         * If true, this allowance represents a discount rather than an individual rate; any rate values specified in this allowance describe a discount to be applied to the non-discount allowances in the ParkingProto.
         */
        isDiscount?: boolean | null;
        /**
         * If this rate requires validation, this expresses the minimum purchase required for validation in each applicable currency. Should have an ID of /measurement_unit/money_value and consist of two properties: one with an ID of /measurement_unit/money_value/amount and a float value with the amount, and another with the ID /measurement_unit/money_value/currency and an ID value with the MID of the proper currency (from the /finance/currency type). A value of 0 suggests that no purchase is required. If empty, this suggests that no validation is required for this rate.
         */
        minPurchaseForValidation?: Schema$FreebaseTopic[];
        /**
         * Any additional details about the permit type; e.g. “Zone A”. In any local languages. Should only be set if allowance_type is PERMIT.
         */
        permitType?: Schema$GeostoreLanguageTaggedTextProto[];
        /**
         * The types of services that this parking allowance applies to. For instance, some cities have streets that only allow traditional taxis to pick up passengers.
         */
        serviceType?: string[] | null;
        /**
         * Describes the rate structures. Each TimeBasedRateProto defines a rate which may apply based on a particular arrival, departure or utilization time; for example, one rate might apply if arriving before 9am, and another might apply regardless of arrival or departure time.
         */
        timeBasedRate?: Schema$GeostoreTimeBasedRateProto[];
        /**
         * Restrictions on which vehicle type(s) the allowance applies to. By default, the allowance applies to any vehicle types.
         */
        vehicleType?: string | null;
    }
    /**
     * Used to describe the parking facilities provided by or available to a feature. Features of TYPE_ROAD or TYPE_COMPOUND can have a ParkingProto (with parking_provider_feature unset) that describes the parking facilities provided by that feature. Features of TYPE_COMPOUND or TYPE_ESTABLISHMENT_POI can have a ParkingProto (with parking_provider_feature set) to indicate that the feature has dedicated parking and provide details about it, and defer some details of the parking facilities to the referent feature(s). ParkingProto is maintained by the Harbor Pilot team (go/harbor-pilot). Detailed modeling information is described at go/parking-schema.
     */
    export interface Schema$GeostoreParkingProto {
        /**
         * Describes the parking allowances for the feature, which are the situations and requirements under which one is permitted to park at the feature’s parking facilities, or discounts that a user may be eligible for.
         */
        allowance?: Schema$GeostoreParkingAllowanceProto[];
        /**
         * Hours in which the parking facility is open; that is, permits both arrivals and departures of the facility. Should only be set on compounds (i.e. parking lots or garages); roads are considered to always be “open,” though parking at certain times may be prohibited via restrictions. If unset on a compound, this suggests we don’t know the opening hours, or they are the same as the hours of the entity for which this feature offers parking facilities.
         */
        openingHours?: Schema$GeostoreOpeningHoursProto;
        /**
         * Indicates whether long-term parking is available at the feature; if true, long-term parking is available at the feature and parking allowances may be present on this feature, or parking_provider_feature may indicate deferred parking feature(s). If false, this is an explicit statement that there is no long-term parking associated with this feature. If unset, we don't know whether there is long-term parking associated with this feature. If false or unset, only additional restrictions or short-term allowances will be populated.
         */
        parkingAvailable?: boolean | null;
        /**
         * If empty, indicates that the feature containing this ParkingProto provides parking facilities, which are described by this proto. If nonempty, indicates that the feature with this ParkingProto does not contain parking facilities itself, but visitors of this feature may use the parking available to the referent feature(s). The referent feature(s) may themselves contain parking facilities or defer to other features. A ParkingProto may defer parking details to another feature, but still include its own data. This suggests that a visitor of the referrer feature is eligible for different rates or discounts. The data in these fields applies transitively, and any fields in a referrer may be applied to the referent (for a visitor of the referrer).
         */
        parkingProviderFeature?: Schema$GeostoreFeatureIdProto[];
        /**
         * Describes any parking restrictions that apply to this feature. Should only be set on road segments for which parking is explicitly prohibited for some or all times; for roads which do not prohibit parking and for all other facilities, the ability to park should be expressed using allowances. In the instance that both a restriction and an allowance applies at a given time, restrictions always have precedence over the same parking allowances. However, explicit short-term allowances (PICKUP_GOODS, PICKUP_PASSENGERS) take precedence over general NO_PARKING, NO_STANDING, or NO_STOPPING restrictions.
         */
        restriction?: Schema$GeostoreParkingRestrictionProto[];
    }
    /**
     * Expresses a parking restriction on a road; i.e. times at which parking on the road is prohibited.
     */
    export interface Schema$GeostoreParkingRestrictionProto {
        /**
         * Times at which parking is prohibited.
         */
        restrictedHours?: Schema$GeostoreTimeScheduleProto;
        /**
         * clang-format on The type of restriction that applies at this time.
         */
        restrictionType?: string | null;
        /**
         * The types of services that this parking restriction applies to. We expect most parking restrictions to apply to all services, but some airports have specific rideshare parking or taxi parking zones.
         */
        serviceType?: string[] | null;
        /**
         * The types of vehicles that this parking restriction applies to. For instance, some streets may allow motorcycles to park but not automobiles or trucks.
         */
        vehicleType?: string[] | null;
    }
    /**
     * This protocol buffer holds related data for features of type TYPE_PEAK and TYPE_VOLCANO.
     */
    export interface Schema$GeostorePeakProto {
        /**
         * Topographic prominence in meters: the height of the peak’s summit above the lowest contour line encircling it and no higher summit.
         */
        prominenceMeters?: number | null;
    }
    /**
     * A crossing describes a path from the end point of a segment to the start point of its sibling. Each individual crossing should uniquely represent a physically distinct crossing in the real world. Pedestrian crossings are bidirectional. This proto represents "simple" crossings. More complicated crossings (such as the diagonal crosswalk at Shibuya Station in Tokyo) will be represented using a separate pedestrian network. Example 1: Standard four way crossing. Assume each road (A/B/C) has a crosswalk (denoted by a '-') right before intersection X. Assume crossing at D is prohibited (denoted by a '%'). Assume "prime" roads (A',B',...) are OUT segments relative to X. A\\A' B//B' \\ // \\ // - - X - % // \\ // \\ C'//C D'\\D * A CROSSABLE PedestrianCrossing should be added to A, B and C. * An UNCROSSABLE PedestrianCrossing should be added to D. Example 2: Simple intersection with one crossing. Assume intersection X was added to accommodate the crosswalk (through X, denoted by '-'). Assume "prime" roads (A',B',...) are OUT segments relative to X. A\\A' \\ \\ -X- \\ \\ B'\\B * A CROSSABLE PedestrianCrossing must be added to either A or B, but not both because each real-world crossing should be represented exactly once. Duplicative crossings may be arbitrarily removed.
     */
    export interface Schema$GeostorePedestrianCrossingProto {
        /**
         * This value specifies the angle of the crosswalk. Zero degrees represents a crosswalk perpendicular to the direction of travel, towards the right side of the segment. The crosswalk angle, winds clockwise. Range [-90, 90]. The following crosswalk would have a 15 degree angle: / / <--/-------------------------------- / /
         */
        angleDegrees?: number | null;
        /**
         * This value enables crossing anywhere (not just at the segment’s endpoint), typically used on long, low-traffic residential streets. This attribute is only respected for trivial segment -\> sibling routes. All other routes can cross at a MapFacts intersection.
         */
        crossAnywhere?: boolean | null;
        /**
         * Crossing type is used as a restriction and can also be used for rendering.
         */
        crossingType?: string | null;
        /**
         * The crossing offset defines a fraction between the distance from the segment endpoint to the centerline of the crosswalk and the length of the segment. For example, the segment length is 20 meters and the distance from segment end to center of crosswalk is 2 meters, the value of offset will be 0.1.
         */
        offset?: number | null;
        /**
         * Restrictions for this crossing (such as constructions on the crosswalk). They must not have subpath or travel_mode.
         */
        restriction?: Schema$GeostoreRestrictionProto[];
        /**
         * This value defines the full width of the crossing in the direction perpendicular to the direction which pedestrians walk on the crossing (in meters). The crossing is allowed to "spill" into the next segment (0.5 * width can be greater than the offset). Cannot be a negative value.
         */
        width?: number | null;
    }
    /**
     * Describes a single physical marker line. NOTE: PhysicalLineProto could be compared against one another by canonicalizing them via GetCanonicalPhysicalLine() in google3/geostore/base/internal/lane_marker.cc. Any fields that don't contribute to the definition of a physical line in the real world should be bundled with the annotative fields near the bottom and excluded in GetCanonicalPhysicalLine(). LINT.IfChange
     */
    export interface Schema$GeostorePhysicalLineProto {
        /**
         * Applicable for DASHED and DOTTED_DASHED lines.
         */
        dashLengthMeters?: number | null;
        /**
         * This should be rarely needed, but can represent patterns of alternating colors.
         */
        gapColor?: Schema$GeostorePaintedElementLogicalColorProto;
        /**
         * Applicable for DASHED, DOTTED, and DOTTED_DASHED lines.
         */
        gapLengthMeters?: number | null;
        material?: string[] | null;
        /**
         * Color for the painted elements. Applicable to all types.
         */
        paintColor?: Schema$GeostorePaintedElementLogicalColorProto;
        pattern?: string | null;
        /**
         * A token that can be used to identify the version of the data about this marker line.
         */
        physicalLineToken?: string | null;
    }
    export interface Schema$GeostorePointCurvatureProto {
        curvatureStatus?: string | null;
        /**
         * Curvature in radians per meter. Negative is a curve to the left and positive is a curve to the right.
         */
        radiansPerMeter?: number | null;
        /**
         * How far along the line this curvature value starts to apply, in the format of decimal between 0 and 1.
         */
        startPointFraction?: number | null;
    }
    export interface Schema$GeostorePointProto {
        latE7?: number | null;
        lngE7?: number | null;
        /**
         * NOTE: If removing metadata, remove 'option objc_class_prefix = "GS";' together. See cl/189921100. Field-level metadata for this point. NOTE: there are multiple PointProto fields in the Geo Schema. Metadata here is only expected to be present on FeatureProto.point[] and FeatureProto.center.
         */
        metadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * A place for clients to attach arbitrary data to a point. Never set in MapFacts.
         */
        temporaryData?: Schema$Proto2BridgeMessageSet;
    }
    /**
     * PointWithHeightProto encodes lat/lng through PointProto and contains altitude information.
     */
    export interface Schema$GeostorePointWithHeightProto {
        /**
         * Altitude of this point is assumed to be relative to the ground level.
         */
        altitudeMeters?: number | null;
        point?: Schema$GeostorePointProto;
    }
    /**
     * This protocol buffer is included from feature.proto as an optional message. Political features represent the different ways that people are divided into geographical regions.
     */
    export interface Schema$GeostorePoliticalProto {
        /**
         * Many political regions have a conceptual center (capitals of a country or a top-level division are examples). If set, the target feature must be a TYPE_LOCALITY feature.
         */
        capital?: Schema$GeostoreFeatureIdProto;
        /**
         * Feature IDs of the features claimed by this feature's government that are not necessarily included in the feature's geometry.
         */
        claim?: Schema$GeostoreFeatureIdProto[];
        /**
         * The Gross Domestic Product of the political region measured in millions of current United States dollars. It must not be negative.
         */
        grossDomesticProductUsdMillions?: number | null;
        /**
         * Percentage of population that are literate within a political region. It must be between 0 and 100.
         */
        literacyPercent?: number | null;
        /**
         * The number of people in this political region. This field is intended to store accurate population, not an estimation such as representative value for population range. It must not be negative.
         */
        population?: string | null;
    }
    /**
     * A general non-self-intersecting spherical polygon, consisting of one or more loops defining multiple disconnected regions possibly with holes. All loops should be oriented CCW around the region they define. This applies to the exterior loop(s) as well as any holes. Within MapFacts (and underlying infrastructure) the data fields may be replaced by a single shape_id stored in internal_feature. Any such PolygonProtos shouldn't be expected to work with public functions in //geostore/base/public/polygon.h.
     */
    export interface Schema$GeostorePolygonProto {
        /**
         * The polygon loops above are basically flat: each point has a latitude and a longitude but no altitude. We don't want to build real 3D models here, but we do want to be able to generate 2.5D models. A 2.5D model is built by translating the flat polygon upward some distance (base) then extruding it upward some additional distance (height). The elevation of the bottom of the extruded polygon (above ground level).
         */
        baseMeters?: number | null;
        /**
         * ** DEPRECATED ** This is part of a splitting strategy for large polygons, which was never fully launched and we decided not to pursue. For features with very complex polygonal geometry, we break up the polygon into pieces that align with S2 cells at various levels. We do this for performance reasons as some geometry operations have quadratic complexity with regards to the total number of vertices. In these cases, we store the S2 cell ID corresponding to the piece of the overall polygon that is described by this specific PolygonProto message. Each polygon piece is expected to be fully contained by the S2 cell corresponding to this cell ID. However, note that the S2 cell ID is not required to correspond to the smallest S2 cell that fully contains the polygon (and often won't be). In addition, polygon pieces are required to not have any overlap (which translates to having entirely disjoint S2 cell IDs, i.e. one can not be parent (or grand parent, etc.) of another).
         */
        cellId?: string | null;
        /**
         * Encoding of the polygon using S2Polygon::Encode()'s compressed representation.
         */
        encoded?: string | null;
        /**
         * The distance from the bottom of the extruded polygon to the top.
         */
        heightMeters?: number | null;
        /**
         * ** DEPRECATED ** We have switched to using exclusively the encoded form in the wire format to and from MapFacts, so this field should never be populated there. See go/encoded-polygons for more info. "Classic" polygon representation, defined by one or more loops. The last vertex of each polyline is implicitly connected to the first vertex. All loops should be specified in CCW order.
         */
        loop?: Schema$GeostorePolyLineProto[];
        /**
         * Field-level metadata for this polygon.
         */
        metadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * A place for clients to attach arbitrary data to a polygon. Never set in MapFacts.
         */
        temporaryData?: Schema$Proto2BridgeMessageSet;
        /**
         * Some polygons are known to be rough proxies for a feature's "real" polygonal representation. Such polygons are generally unsuitable for display. Rendering clients should not show these in most cases. Polygons unsuitable for display do have other uses, such as user location or containment analysis, or as an input to learning algorithms. This is an orthogonal concept to FeatureProto.synthetic_geometry, which only pertains to the method by which a polygon was created, rather than its fidelity to ground truth. For features that have multiple polygons, this bit should be consistently set to the same value on all polygons.
         */
        unsuitableForDisplay?: boolean | null;
    }
    export interface Schema$GeostorePolyLineProto {
        /**
         * Field-level metadata for this polyline. NOTE: there are multiple PolyLineProto fields in the Geo Schema. Metadata here is only expected to be present on FeatureProto.polyline[].
         */
        metadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * A place for clients to attach arbitrary data to a polyline. Never set in MapFacts.
         */
        temporaryData?: Schema$Proto2BridgeMessageSet;
        /**
         * A sequence of vertices connected by geodesics (the equivalent of straight lines on the sphere). Adjacent vertices are connected by the shorter of the two geodesics that connect them, i.e. all edges are 180 degrees or less. Note that the edge definition becomes numerically unstable as the arc length approaches 180 degrees. Polylines are generally expected to be non-self-intersecting, but any such restriction is imposed by the user of the polyline rather than the polyline itself.
         */
        vertex?: Schema$GeostorePointProto[];
    }
    /**
     * A pose is an object's position in space, as well as its orientation. All fields except lat and lng are optional. All fields are in the WGS-84 ellipsoid, and rotations are right-hand rule (i.e. if the right hand thumb points along a vector, curled fingers indicate positive rotation direction). An un-rotated pose would be pointing due North, along the surface of the ellipsoid. Rotations are applied in the order: yaw, pitch, roll. Note that the rotation axes are rotated along with the model for each rotation step. WARNING: This proto is not meant to be used directly. Please use the provided libraries: //geostore/base/public/pose.h //java/com/google/geostore/base/Pose.java
     */
    export interface Schema$GeostorePoseProto {
        /**
         * The height of the pose. A positive height is above the WGS-84 ellipsoid in meters; negative is below.
         */
        altitude?: number | null;
        /**
         * The index of the PoseProto in a list of PoseProtos.
         */
        index?: number | null;
        /**
         * The latitude of the pose in degrees [-90, 90].
         */
        lat?: number | null;
        /**
         * The longitude of the pose in degrees (-180,180].
         */
        lng?: number | null;
        /**
         * The rotation around the longitude line East tangent in degrees [-90, 90].
         */
        pitch?: number | null;
        /**
         * The rotation around the latitude line North tangent in degrees (-180, 180].
         */
        roll?: number | null;
        /**
         * The rotation around the Up vector, from North, in degrees (-180, 180].
         */
        yaw?: number | null;
    }
    /**
     * This message represents nutrition facts for a food dish.
     */
    export interface Schema$GeostorePriceInfoFoodNutritionFacts {
        calories?: Schema$GeostorePriceInfoFoodNutritionFactsCaloriesFact;
        /**
         * Cholesterol information for a given food dish.
         */
        cholesterol?: Schema$GeostorePriceInfoFoodNutritionFactsNutritionFact;
        /**
         * Protein information for a given food dish.
         */
        protein?: Schema$GeostorePriceInfoFoodNutritionFactsNutritionFact;
        /**
         * Sodium information for a given food dish.
         */
        sodium?: Schema$GeostorePriceInfoFoodNutritionFactsNutritionFact;
        /**
         * Carbohydrate information for a given food dish.
         */
        totalCarbohydrate?: Schema$GeostorePriceInfoFoodNutritionFactsNutritionFact;
        /**
         * Fat information for a given food dish.
         */
        totalFat?: Schema$GeostorePriceInfoFoodNutritionFactsNutritionFact;
    }
    /**
     * This message denotes calories information with an upper bound and lower bound range.
     */
    export interface Schema$GeostorePriceInfoFoodNutritionFactsCaloriesFact {
        lowerAmount?: number | null;
        /**
         * Unit of the given calories information.
         */
        unit?: string | null;
        upperAmount?: number | null;
    }
    /**
     * This message denotes nutrition information with an upper bound and lower bound range and can be represented by mass unit.
     */
    export interface Schema$GeostorePriceInfoFoodNutritionFactsNutritionFact {
        lowerAmount?: number | null;
        /**
         * Unit of the given nutrition information.
         */
        unit?: string | null;
        upperAmount?: number | null;
    }
    export interface Schema$GeostorePriceInfoProto {
        /**
         * The actual food menus. This is a repeated field because a restaurant may offer multiple menus, e.g. for different language or for different available time, such as holidays vs non-holidays.
         */
        priceList?: Schema$GeostorePriceListProto[];
        /**
         * All URLs that give price list information for this establishment. For food menus, this would represent menu_urls. Note that this field is a repeated list of UrlListProtos. Each UrlListProto instance in the list is intended to hold lists of URLs that are translations of the same URL.
         */
        priceListUrl?: Schema$GeostoreUrlListProto[];
        /**
         * Message containing metadata about the verified status of the PriceInfo. Only verified listings should be displayed.
         */
        status?: Schema$GeostorePriceInfoStatus;
    }
    /**
     * Providers of PriceInfo (e.g. SinglePlatform, YEXT) send verified and unverified listings. PriceInfoStatus is used to encapsulate this information.
     */
    export interface Schema$GeostorePriceInfoStatus {
        isVerified?: boolean | null;
    }
    /**
     * A PriceListNameInfoProto is used by PriceListProto and fields and messages contained in it for storing names, descriptions, languages, and IDs. The name field and the description field must be in the same language, as specified by the language field. None of the fields in this proto is required, although it is not expected to have the language field set unless there is a name or description. When the language field is not set, it is understood to be the preferred language of the locale where the establishment is located. An empty string for any of the fields is not allowed (as enforced by lints).
     */
    export interface Schema$GeostorePriceListNameInfoProto {
        description?: string | null;
        /**
         * IDs are intended to be unique identifiers of PriceInfoLists, Sections, and Menu items. This is enforced by the ID_DUPLICATE_PRICE_LIST_ID lint.
         */
        id?: string | null;
        /**
         * The external form of a Google International Identifiers Initiative (III) LanguageCode object. See google3/i18n/identifiers/languagecode.h for details. We place extra restrictions on languages in addition to what the III library requires. See go/geo-schema-reference/feature-properties/languages.
         */
        language?: string | null;
        name?: string | null;
    }
    /**
     * A PriceListProto can be used to represent any type of price lists, one of which is a menu of food and drinks. It contains names and descriptions, together with its source URL list if it is extracted or attributed to that URL. The names and descriptions are represented using repeated PriceListNameInfo fields to allow versions in different languages. A PriceListProto may contain multiple sections; in the context of a food menu, this would be multiple menu sections, e.g. for breakfast, lunch, dinner, prix fixe, or dinner for two, etc. At least one menu section must be present. Each section contains a number of items; for food menus, it may be FoodMenuItems defined below. At least one item must be present in each section.
     */
    export interface Schema$GeostorePriceListProto {
        /**
         * For third party lists, represents the ID of the aggregator which provided this data. Optional.
         */
        aggregatorId?: string | null;
        /**
         * The time period when this price list is available. Establishments are not required to give available_time for any given price list, however, when this field is not set, the price list is understood as available any time the establishment is open.
         */
        availableTime?: Schema$GeostoreTimeScheduleProto;
        /**
         * Cuisine information if the location the price lists attached to is an eligible feature for a food menu price list. Cuisine information should also only show up in a food price list.
         */
        cuisines?: string[] | null;
        /**
         * The repeated name_info field is for price lists listed in multiple languages. When a price list has no names or descriptions, the size of the repeated field name_info may be 0. There should be at most one name_info for any given language.
         */
        nameInfo?: Schema$GeostorePriceListNameInfoProto[];
        /**
         * Each price list may have multiple sections. Note that these sections within the same price list should most times contain only the same type of items for sale, e.g. all sections should usually contain only food items if the enclosing price list is representing food menu. However, sometimes such a requirement may be wrong, for example, McDonald's may sell burgers as well as toys, and the toys may be in its own section. Thus we don't enforce any requirement that all sections contain only the same type of items.
         */
        section?: Schema$GeostorePriceListSectionProto[];
        /**
         * Where this price list comes from. If set, this must also be a member of the price_list_url field, and represents translations of a single URL.
         */
        sourceUrl?: Schema$GeostoreUrlListProto;
    }
    /**
     * A PriceListSectionProto is used to store a section of a PriceListProto. For example, for a PriceListProto representing a food menu, a PriceListSectionProto represents a menu section. Each PriceListSectionProto contains a repeated list of items for sale; these items can be products or services. Right now every section should contain items of one type.
     */
    export interface Schema$GeostorePriceListSectionProto {
        /**
         * Call to action for the section.
         */
        callToAction?: Schema$GeostoreCallToActionProto;
        /**
         * To store food and drink items when the containing PriceListSectionProto is a food menu section.
         */
        foodItem?: Schema$GeostoreFoodMenuItemProto[];
        /**
         * To store any items when the containing PriceListSectionProto is not food / legacy services.
         */
        item?: Schema$GeostoreComposableItemProto[];
        /**
         * This has to have at most one value.
         */
        itemType?: string[] | null;
        /**
         * The external form of a Google International Identifiers Initiative (III) LanguageCode object. See google3/i18n/identifiers/languagecode.h for details. We place extra restrictions on languages in addition to what the III library requires. See go/geo-schema-reference/feature-properties/languages. When set, represents the language of the section and its items. Any section and item level name infos must match this language. Optional.
         */
        language?: string | null;
        /**
         * One or more media items (photos, videos, etc.) describing this section / category.
         */
        media?: Schema$GeostoreMediaItemProto[];
        /**
         * The repeated name_info field is for price list sections listed in multiple languages. When a price list section has no names or descriptions, the size of the repeated field name_info may be 0. There should be at most one name_info for any given language.
         */
        nameInfo?: Schema$GeostorePriceListNameInfoProto[];
    }
    /**
     * This message represents a price range of an attribute. The meaning of the price bounds is domain specific. But mainly they are soft bounds for a normal usage. E.g. "restaurant prices" are subject to an higher level of "soft" bounds than "museum admission price"
     */
    export interface Schema$GeostorePriceRangeProto {
        /**
         * Currency code for the price range: a valid currency code from i18n/identifiers/currencycode.h. Lower and upper price are both assumed to use the same currency.
         */
        currency?: string | null;
        /**
         * This message allows unbounded price ranges. e.g. Lower_price is undefined. At least one of the two prices must be set for the price range to be meaningful.
         */
        lowerPrice?: number | null;
        /**
         * clang-format on
         */
        units?: string | null;
        upperPrice?: number | null;
    }
    /**
     * PropertyValueStatusProto specifies what we know about a field corresponding to FeaturePropertyId's value in the absence of any specific value. For now, it just indicates when we know that there is no value. Eventually it might also indicate that we know it has value, just not what it is, etc.
     */
    export interface Schema$GeostorePropertyValueStatusProto {
        /**
         * The property ID whose value status is defined by this proto.
         */
        propertyId?: Schema$GeostoreFeaturePropertyIdProto;
        /**
         * `value_status` specifies whether the feature has a value for the property. This should always be set to something other than the default value (`PROPERTY_VALUE_STATUS_UNSPECIFIED`).
         */
        valueStatus?: string | null;
    }
    /**
     * This is a minimal version of SourceInfoProto.
     */
    export interface Schema$GeostoreProvenanceProto {
        /**
         * The dataset from which this the referenced data was created. The content of this string will be determined by the data provider, and may encode extra information, such as data confidence.
         */
        dataset?: string | null;
        /**
         * The data provider from which the referenced data was generated.
         */
        provider?: string | null;
    }
    /**
     * This message is embedded within a FeatureProto. It has rank calculation details such as available rank signals and rank signal mixer used to compute final rank. For more details, see the Oyster Rank wiki page: http://wiki.corp.google.com/twiki/bin/view/Main/OysterRank
     */
    export interface Schema$GeostoreRankDetailsProto {
        /**
         * A list of signals. Each one is extracted separately by a SignalExtractor.
         */
        signal?: Schema$GeostoreRankSignalProto[];
        /**
         * The signal mixer that was used to calculate the rank.
         */
        signalMixerType?: string | null;
    }
    /**
     * This message is embedded in the RankDetailsProto (below). It represents one rank signal, which is a floating point value estimating the Oyster Rank of the feature.
     */
    export interface Schema$GeostoreRankSignalProto {
        /**
         * Field-level metadata for this signal.
         */
        metadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * A value in the range [0, 1] estimating Oyster Rank according to this signal. Non-provider specific signals (e.g. SIGNAL_POPULATION) are interpreted by some common code in the ranking pipeline. Because of that, data providers should leave this field empty when setting such signals (so that the rank assignment can be uniform across all features regardless of contributing data providers). On the other hand, provider-specific signals (e.g. SIGNAL_ZENRIN_CITY_CATEGORY) are required to specify the rank field (it is not optional for them). That is because no code other than that of the provider itself will be able to fill in a meaningful value later on. We don't want clients to be reading from the raw_scalar / raw_string fields to interpret the data.
         */
        rank?: number | null;
        /**
         * The raw scalar value that was used to compute 'rank' above. The meaning of this attribute changes depending on the signal type.
         */
        rawScalar?: number | null;
        /**
         * The raw string value that was used to compute 'rank' above. The meaning of this attribute changes depending on the signal type.
         */
        rawString?: string | null;
        type?: string | null;
    }
    /**
     * A RawDataProto is a key-value pair that represents arbitrary source data from a particular provider. Raw data can be attached to features using their source_info field.
     */
    export interface Schema$GeostoreRawDataProto {
        /**
         * The key associated with this data item. For source data in shape file format, this will typically be a column name. Keys need to be unique with respect to a particular data source (see DataSourceProto), but they do not need to be globally unique. You can look up the documentation for a key (e.g. a longer label and description) by following the source_id link of the parent SourceInfoProto, which takes you to a TYPE_DATA_SOURCE feature, and then looking up the corresponding RawMetadataProto object for this key in that feature's optional data_source field.
         */
        key?: string | null;
        /**
         * All data items are represented as strings, the logic being that it is easy to convert other data types to strings, and there is no need to access this data efficiently.
         */
        valueString?: string | null;
    }
    export interface Schema$GeostoreRawMetadataProto {
        /**
         * Method to use when conflating together RawDataProto values at the same key NB: If you add a new ConflationMethod, then you must add the corresponding logic to MergeRawData to conflate the RawDataProto values using this method.
         */
        conflationMethod?: string | null;
        /**
         * Self-contained documentation about what this field represents and how its values are encoded.
         */
        description?: string | null;
        /**
         * The key being described.
         */
        key?: string | null;
        /**
         * A longer, human-readable name associated with this key. The label might be used in a data explorer tool, for example.
         */
        label?: string | null;
    }
    /**
     * A latitude-longitude rectangle, represented as two diagonally opposite points "lo" and "hi". The rectangle is considered to be a closed region, i.e. it includes its boundary. The latitude bounds must be in the range -90 to 90 degrees inclusive, and the longitude bounds must be in the range -180 to 180 degrees inclusive. Various cases include: - If lo == hi, the rectangle consists of a single point. - If lo.longitude \> hi.longitude, the longitude range is "inverted" (the rectangle crosses the 180 degree longitude line). - If lo.longitude == -180 degrees and hi.longitude = 180 degrees, the rectangle includes all longitudes. - If lo.longitude = 180 degrees and hi.longitude = -180 degrees, the longitude range is empty. - If lo.latitude \> hi.latitude, the latitude range is empty.
     */
    export interface Schema$GeostoreRectProto {
        hi?: Schema$GeostorePointProto;
        lo?: Schema$GeostorePointProto;
    }
    /**
     * This protocol buffer supports a name per region per language, allowing it to represent the name of a given feature in different regions and languages. For example, the Persian Gulf has different English names in UAE versus Lebanon.
     */
    export interface Schema$GeostoreRegionSpecificNameProto {
        /**
         * If true, this region specific name should be appended, in parentheses, to the appropriate name from FeatureProto.name, for the default rest of world behavior.
         */
        displayableAsAlternativeName?: boolean | null;
        /**
         * Name to be used for this feature in a specific region and language.
         */
        name?: Schema$GeostoreNameProto;
        /**
         * Region code (or other identifier) for the region.
         */
        regionCode?: string | null;
    }
    /**
     * A collection of information that applies to a polygonal area.
     */
    export interface Schema$GeostoreRegulatedAreaProto {
        /**
         * The set of restrictions that apply to a zone. These restrictions may limit the routability of every segment contained within the defined feature.polygon. Repeated restrictions are treated collectively as an OR meaning that segments in the zone are only routable if none of the restrictions apply. If any segments within the defined polygon should not have these restrictions applied, they must list this regulated area's feature id in their feature.exempt_regulated_area field.
         */
        restriction?: Schema$GeostoreRestrictionProto[];
    }
    /**
     * This message is embedded within a FeatureProto, and represents a geographic or logical relationship of that feature to some other feature. Note that some relation types are there purely for the purpose of grouping together other relation types. They are noted as ABSTRACT in comments. Other relation types are no longer supported / in use. They are noted as DEPRECATED in comments (and marked with the standard deprecated option, too). Other relation types are reserved for future use or just not intended for use at all, for various internal reasons. They are noted as RESERVED in comments. WARNING: Updates to this proto within a FeatureProto's related_feature field handled by standalone pipelines and are NOT atomic with regard to updates to the features being referenced; we do not guarantee that a given MapFacts snapshot will be consistent between this field and the related features.
     */
    export interface Schema$GeostoreRelationProto {
        /**
         * Field-level metadata for this relation.
         */
        metadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * If and only if the other feature is of TYPE_COUNTRY, the 2-letter country code. This is the FLAG_COUNTRY_CODE_2 name of the country component.
         */
        otherFeatureCountryCode?: string | null;
        /**
         * The feature ID of the feature to which we're relating. WARNING: the related feature does not necessarily have a bound that encloses this feature, so in a bucketing MapReduce, you may not be able to follow all relationships. Relations that use strong references are annotated above but you can also refer to IsRelationStrong() in geostore/base/public/relation.h.
         */
        otherFeatureId?: Schema$GeostoreFeatureIdProto;
        /**
         * RESERVED
         */
        otherFeatureName?: Schema$GeostoreNameProto[];
        /**
         * If and only if the other feature is of TYPE_DISPUTED_AREA, the territorial administrator found in its GeopoliticalAttachmentProto.administered_by field, if any. Since this string is copied exactly, it may be a 2-letter country code or another type of descriptive string.
         */
        otherFeatureTerritorialAdministrator?: string | null;
        /**
         * The type of the feature to which we're relating.
         */
        otherFeatureType?: number | null;
        /**
         * ** DEPRECATED ** If relation is exactly RELATION_OVERLAPS but not any of its subcategories, overlap_fraction contains an estimate of the fraction of the geometry of this feature that intersects with the other feature, ranging from 0.0 to 1.0. Note that this is a rough estimate based on cell coverings, and may not be very accurate. In particular, values of 0.0 and 1.0 are possible, even though in principle they should not be.
         */
        overlapFraction?: number | null;
        /**
         * The relationship of the feature that contains this RelationProto to the feature other_feature_id. Note the relation_is_reversed field below. Some relations imply weak references, other strong ones. Strong references are annotated above but you can also refer to IsRelationStrong() in geostore/base/public/relation.h.
         */
        relation?: string | null;
        /**
         * RESERVED
         */
        relationIsReversed?: boolean | null;
        /**
         * A place for clients to attach arbitrary data to a relation. Never set in MapFacts.
         */
        temporaryData?: Schema$Proto2BridgeMessageSet;
    }
    /**
     * A restriction group represents common properties of a set of restrictions on segments that are associated with the same underlying cause across a geographic region. Every segment referenced by this restriction group should have at least one restriction that refers backs to this restriction group. The standard feature properties have the following interpretations: name - A name that represents the name for this restriction group. kg_property - A reference back to a KG event in case this restriction group belongs to an event in KG. /geo/type/restriction_group/associated_event contains a mid to the associated event.
     */
    export interface Schema$GeostoreRestrictionGroupProto {
        /**
         * Field-level metadata for this restriction group.
         */
        metadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * FeatureId of all segments that have a RestrictionProto referring back to this RestrictionGroup.
         */
        segment?: Schema$GeostoreFeatureIdProto[];
    }
    /**
     * A restriction is an expression that limits when an action can be taken. Each restriction has a set of conditions. If all of the conditions are true, then the restriction applies and the action cannot be taken. For example, the restriction "no turns 3-5pm except buses" would have two conditions: "time is 3-5pm" and "vehicle is not a bus". If both of these conditions apply, the restriction is true, and the turn is prohibited. Multiple restrictions may apply to the same action. Clients handle this by always declaring RestrictionProto as a "repeated" element. The semantics of having multiple restrictions are that if any restriction applies, then the action cannot be taken. In other words, restrictions are OR-ed together. Putting all of this together, a set of RestrictionProtos can be interpreted as an bool expression in disjunctive normal form: (A and B) or (D and E and F) or (G and H) The action is prohibited if this expression is true. Note that a restriction with no conditions is always true, i.e. its action is always prohibited. NOTE: RestrictionProtos are often compared against one another (e.g. to check for duplicate/redundant restrictions) by canonicalizing them via GetCanonicalRestriction() in google3/geostore/base/internal/restriction.cc. Any fields that don't contribute to the definition of a restriction in the real world should be bundled with the annotative fields near the bottom and excluded in GetCanonicalRestriction(). LINT.IfChange
     */
    export interface Schema$GeostoreRestrictionProto {
        /**
         * The restriction only applies in these specific autonomous driving product scenarios. NOTE: This should only be set on restrictions with TRAVEL_AUTONOMOUS_VEHICLE travel mode.
         */
        autonomousDrivingProducts?: string[] | null;
        /**
         * Actually *required* if style=STYLE_IN_OUT, otherwise forbidden. Typically the intersection group type is artifact, but either artifact or logical groups can be used for STYLE_IN_OUT restrictions.
         */
        intersectionGroup?: Schema$GeostoreFeatureIdProto;
        /**
         * Field-level metadata for this restriction.
         */
        metadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * Restriction group this restriction belongs to.
         */
        restrictionGroup?: Schema$GeostoreFeatureIdProto;
        /**
         * A token that can be used to identify the version of the data about this restriction.
         */
        restrictionToken?: string | null;
        /**
         * When specified, restriction applies only at particular times (operating hours or times of the year: reversing lanes, seasonal roads, no left turns from 3-5pm Mon-Fri except holidays). Otherwise, restriction is in effect at all times.
         */
        schedule?: Schema$GeostoreTimeScheduleProto;
        /**
         * The scope that the restriction applies to. - SCOPE_DIRECTION means the segment/sibling pair is restricted in the direction of the segment that contains this RestrictionProto. For segment/sibling pairs with pedestrian facilities (and thus side-of-road routing) the RestrictionProto restricts both facilities in the direction of the segment (assuming that the restriction applies to travel mode TRAVEL_PEDESTRIAN). - SCOPE_SIDE means the RestrictionProto applies only to the side of road that the containing segment represents. That sibling's pedestrian facility is restricted in both directions. Schema constraints: - SCOPE_SIDE must be set if and only if travel_mode == [TRAVEL_PEDESTRIAN] and the segment containing the restriction has the pedestrian_facility field set and is not set to PEDESTRIAN_FACILITY_UNKNOWN. Such restrictions must have no subpath. - All other restrictions must have this field set to SCOPE_DIRECTION (whether explicitly or implicitly). This distinction is necessary for cases such as pedestrian facility on one-way segment/sibling roads.
         */
        scope?: string | null;
        /**
         * Restriction Style defines the semantics of the subpath field, as defined above in the documentation of subpath.
         */
        style?: string | null;
        /**
         * "subpath" specifies the GeoStore segments that this restriction applies to, according to the restriction_style field below. Segments that are referenced by this subpath field also refer to this feature back via the same subpath field. For all styles of restriction, all segments in the subpath must have identical copies of the restriction. In other words, restrictions are duplicated along every segment in the subpath. Note that subpaths of length 1 do not have any purpose and are disallowed. Note that it is possible to represent restrictions either using STYLE_CONTIGUOUS, or depending on the length of the subpath, one of the more specific STYLE_SINGLE, STYLE_TURN, or STYLE_IN_OUT. New code should use the more specific alternatives if possible, as they support instant updates. For restriction_style == STYLE_CONTIGUOUS (the default): "subpath" can either be empty, for a single-segment restriction, or it specifies exactly the sequence of segments which this restriction applies to. The subpath may be used to specify a turn restriction (a subpath of length 2) or to prohibit more complex maneuvers. For example, when merging onto a road from the right-hand side it may not be possible to make an immediate left turn due to insufficient time to cross the intervening lanes or the presence of a physical barrier. This would be indicated by a subpath restriction of length 3 or more. For restriction_style == STYLE_SINGLE: The subpath field of the Restriction must be empty. The restriction applies only to the segment it is attached to. There must not be an intersection group specified. For restriction_style == STYLE_TURN: The subpath field of the Restriction must contain exactly two segments. The first is called the "in_segment", the second is the "out_segment". They must be contiguous, i.e. the end intersection of the in_segment is the start intersection of the out_segment. The restriction applies only to a direct maneuver from the in_segment to the out_segment. Other paths from the in_segment to the out_segment are not restricted. There must not be an intersection group specified. For restriction_style == STYLE_IN_OUT: The subpath field of the Restriction must contain exactly two segments. The first is called the "in_segment", the second is the "out_segment". Note that the two segments define paths, but may not actually be one. The end intersection of the in_segment must be in an intersection group which also contains the start intersection of the out_segment. The in- and out-segments are not required to be adjacent, but may be. Either way, the restriction applies to any path from the in_segment to the out_segment through the intersection group, not just direct turns. The intersection_group must be specified. Note that clients which read restrictions and need to know which paths are restricted by a given IN_OUT restriction must expand the IN_OUT restriction by finding all paths through the intersection group from the in_segment to the out_segment.
         */
        subpath?: Schema$GeostoreFeatureIdProto[];
        /**
         * A place for clients to attach arbitrary data to a restriction. Never set in MapFacts.
         */
        temporaryData?: Schema$Proto2BridgeMessageSet;
        /**
         * Restriction applies only to the given travel modes. This field should always be set, but may be missing in old data. WARNING: Restrictions with no travel modes are DEPRECATED. Historically, no travel modes has meant "all travel modes", except they didn't really even mean that, because Pathfinder would use a complex set of heuristics to interpret the "correct" travel modes. Pathfinder currently (last updated August 2013) has heuristics to cope with incomplete data that reduce or extend application of the specified restrictions to pedestrians or bicycles. We are actively working to remove these heuristics and replace them with explicit, correct travel modes in the data. See b/8746491.
         */
        travelMode?: string[] | null;
        /**
         * LINT.ThenChange(//depot/google3/google/geo/entities/v1/fields/segment.proto) clang-format on The type of restriction. This is not a condition, but rather tells you what kind of restriction it is. This field should always be set.
         */
        type?: string | null;
        /**
         * The restriction only applies to vehicles that meet all of the attributes defined here. If this is empty, it does not affect the scope of the restriction.
         */
        vehicleAttributeFilter?: Schema$GeostoreVehicleAttributeFilterProto;
    }
    /**
     * Proto used to represent rights for FeatureProto. See go/geo-rights for more details. NOTE: Use google3/geostore/provenance/public/rights.h or google3/java/com/google/geostore/provenance/rights/Rights.java instead of accessing this proto directly.
     */
    export interface Schema$GeostoreRightsStatusProto {
        fieldWithRights?: Schema$GeostoreFieldWithRightsProto[];
    }
    /**
     * A RoadConditionalProto defines conditions that affect when the road traversal information is applicable.
     */
    export interface Schema$GeostoreRoadConditionalProto {
        /**
         * Specifies what times the information is applicable. This can be specific times (3-5 PM) or days of the week (Mon - Fri), as well as more general times like school hours, dusk to dawn, etc. If no value is set, the restriction is applicable at all times.
         */
        timeSchedule?: Schema$GeostoreTimeScheduleProto;
        /**
         * Additional attributes that apply to the applied vehicle types.
         */
        vehicleAttribute?: Schema$GeostoreVehicleAttributeFilterProto;
        /**
         * Restrictions applying to specific types of vehicles.
         */
        vehicleType?: string[] | null;
    }
    /**
     * A road monitor is a device that observes traffic for road violations like speeding or running a red light. These are modeled within MapFacts so that navigation services can warn users when they drive along road segments that are monitored.
     */
    export interface Schema$GeostoreRoadMonitorProto {
        /**
         * The TYPE_ROAD segment features that this road monitor may observe.
         */
        monitoredRoad?: Schema$GeostoreFeatureIdProto[];
    }
    /**
     * Below is some horrible ASCII art and a description of the components of a road sign. +-------------------+ | A11 E50 Paris | | Chartres | +-------------------+ This sign would be composed of four components (all of them text components, the only option we support for now). The three in the first row would all have a "major_position" of zero. Their "minor_position" values would be zero for "A11", one for "E50", and two for "Paris". The component in the second row would have "major_position" value of one. This message provides the details of a single component of a road sign. A component defines its position within a sign, its type, and its content.
     */
    export interface Schema$GeostoreRoadSignComponentProto {
        /**
         * The id of the feature referred to by this component, typically the route or locality feature this sign points towards. In the ASCII art example above, this field would contain the id for the routes A11 and E50 and the localities Chartres and Paris in the corresponding component.
         */
        featureId?: Schema$GeostoreFeatureIdProto;
        /**
         * The type of the feature referred to by this component. If feature_id is specified type of that feature should be the same as this field.
         */
        featureType?: number | null;
        /**
         * This is the "major" position of this component within the set of components that make up a sign. This number can be thought of as the "row" of the sign on which the component appears, but no guarantees are made that there is a one-to-one mapping between "major_position" and the rows of information on the actual sign being modeled. A "major_position" value of zero would indicate that the component is near the top of the sign.
         */
        majorPosition?: number | null;
        /**
         * This is the position of a component within the components of a sign that share a common "major_position". It can be though of as the "column" of the component, but like "major_position", no guarantees are made regarding its mapping to reality. For data sources that don't provide enough information to determine a component's major and minor positions, major position should be populated and minor position should not be present. A "minor_position" value of zero would indicate that the component is near the "beginning" of the sign. In countries where signs are read from left to right, "minor_position" zero would be near the left side of the sign.
         */
        minorPosition?: number | null;
        /**
         * The direction of traffic for the referenced TYPE_ROUTE feature.
         */
        routeDirection?: string | null;
        /**
         * The semantic type of sign.
         */
        semanticType?: string | null;
        /**
         * If this sign component is of type "TYPE_TEXT", this field contains the text of the component. A NameProto is used to allow language and flags to be associated with the text.
         */
        text?: Schema$GeostoreNameProto;
        /**
         * This type of content represented by this sign component.
         */
        type?: string | null;
    }
    /**
     * A RoadSignProto holds the details of a road sign. Currently this is simply a list of the items that appear on the sign and their relative position.
     */
    export interface Schema$GeostoreRoadSignProto {
        /**
         * The list of components for a single road sign. A sign may be composed of multiple components, each with its own position and content.
         */
        component?: Schema$GeostoreRoadSignComponentProto[];
    }
    /**
     * This protocol buffer holds metadata about the association between a segment and a route.
     */
    export interface Schema$GeostoreRouteAssociationProto {
        /**
         * clang-format on
         */
        displayPreference?: string | null;
        /**
         * Field-level metadata for the route association.
         */
        metadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * Identifies the route feature to which this metadata applies. This is one of the routes the segment refers to via the SegmentProto.route field.
         */
        route?: Schema$GeostoreFeatureIdProto;
        /**
         * The direction of the TYPE_ROUTE feature in this route association. A small number of countries (mostly just the United States, Mexico, and Canada) use directional routes. For example, in the United States highway US-1 is referred to as US-1 North or US-1 South on the sides where flow of traffic moves in those directions.
         */
        routeDirection?: string | null;
    }
    /**
     * A route is a collection of segments that forms a logical group - usually a named road or highway. Segments can belong to more than one route, and the segments of one route may be a subset of the segments of another route (e.g. I-5 N is a subset of I-5). Segments in the collection that define the route do not need to constitute a single uninterrupted line, there can be disconnects. The standard feature properties are interpreted as follows: name - Routes should have one or more names. (While unnamed roads certainly exist in the real world, we choose not to create route features for such roads. Instead, the unnamed segments are merely not part of any route.) address - This should always be empty. type - Specifies a particular route subtype, see feature.proto. point - This should always be empty. polyline - This should always be empty. polygon - This should always be empty. child - The pairs of segments that belong to this route (a given route should always reference segments in both travel directions).
     */
    export interface Schema$GeostoreRouteProto {
        /**
         * The feature type of the route children. Should be set if and only if all children are of the same feature type.
         */
        childType?: number | null;
    }
    /**
     * This protocol buffer holds school district specific attributes for features of TYPE_SCHOOL_DISTRICT.
     */
    export interface Schema$GeostoreSchoolDistrictProto {
        type?: string | null;
    }
    /**
     * A segment path describes a path through a short set of segments. The segment path can be used for any purpose. At the moment, only TYPE_ROAD_SIGN features can have associated segment paths: The segment path lists the segments that refer to the sign. These are the segments for which the sign is applicable. The sign's physical location is independent of the segments in the path.
     */
    export interface Schema$GeostoreSegmentPathProto {
        /**
         * Specifies a sequence of feature ids of GeoStore segments. The feature ids are ordered. The path "AB" is not the same as the path "BA". The segments along the path are assumed to be connected via the appropriate intersections. The segment features that are referenced by this subpath refer to this feature back via the road_sign field in segment proto extension.
         */
        subpath?: Schema$GeostoreFeatureIdProto[];
    }
    /**
     * --------------------------------------------------------------------------- WARNING - if you add new fields to SegmentProto (or to other protos used by SegmentProto), you need to: - ensure that the ShortSegmentsMerger class (in geostore/tools/internal/mr-mergesegments.cc) is aware of them, otherwise the new fields will be discarded randomly. - consider whether they should be cleared in the ClearFeature() function (in maps/render/process-high-priority-roads.cc) if they are irrelevant for rendering high priority roads at far-out zoom levels. - update the test cases that ensure these two packages know all the SegmentProto fields in both mr-mergesegments_test.cc and maps/render/process-high-priority-roads_test.cc or you will break the VersaTile build. ---------------------------------------------------------------------------
     */
    export interface Schema$GeostoreSegmentProto {
        advisoryMaximumSpeed?: Schema$GeostoreAppliedSpeedLimitProto[];
        /**
         * RESERVED
         */
        altitude?: number[] | null;
        /**
         * The average speed that should be expected along this route under normal conditions, in kilometers per hour. (Hopefully we'll replace this with something a lot more sophisticated.)
         */
        avgSpeedKph?: number | null;
        /**
         * Field-level metadata for the average speed.
         */
        avgSpeedKphMetadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * clang-format on
         */
        barrier?: string | null;
        /**
         * Field-level metadata for the barrier.
         */
        barrierMetadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * clang-format on
         */
        bicycleFacility?: string | null;
        bicycleSafety?: string | null;
        condition?: string | null;
        /**
         * Field-level metadata for the condition.
         */
        conditionMetadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * If known, the date that construction is scheduled to begin.
         */
        constructionBeginDate?: Schema$GeostoreDateTimeProto;
        /**
         * If known, the date that construction is scheduled to end.
         */
        constructionEndDate?: Schema$GeostoreDateTimeProto;
        constructionStatus?: string | null;
        /**
         * Field-level metadata for the construction status.
         */
        constructionStatusMetadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * Whether the segment is covered by a roof etc. If this field is missing, the status is unknown.
         */
        covered?: boolean | null;
        /**
         * Average distance between the segment's polyline and edge of the road on this side in meters. It need not be equal to the sum of width of all lanes in this direction. This width includes on-street bicycle lanes but excludes off-street lanes such as sidewalks. The edge of the road is the rightmost edge for segments in right side driving countries and leftmost edge for left side driving countries. Width of the road is sum of this and sibling's distance_to_edge.
         */
        distanceToEdge?: number | null;
        /**
         * Field-level metadata for distance_to_edge.
         */
        distanceToEdgeMetadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * These indicate for what portion of the segment does the outer curb of the segment follow the segment polyline - i.e., where do the sweep curves connect along the outer curb. If unspecified, may be assumed to be equal to lane retraction, preferring outermost lane.
         */
        edgeFollowsSegmentBeginFraction?: number | null;
        edgeFollowsSegmentEndFraction?: number | null;
        /**
         * clang-format on
         */
        elevation?: string | null;
        /**
         * Field-level metadata for the elevation.
         */
        elevationMetadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * clang-format on
         */
        endpoint?: string | null;
        /**
         * Field-level metadata for the endpoint.
         */
        endpointMetadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * Detailed information about grade levels along the segment. If a GradeLevelProto is not present for any point (index) along the segment, the default grade level is zero. In between two points (indexes), the grade level of the segment is taken to be the max of the grade levels on either side of it. See gradelevel.proto for semantics of repeated indexes.
         */
        gradeLevel?: Schema$GeostoreGradeLevelProto[];
        /**
         * Internal-only data.
         */
        internal?: Schema$GeostoreInternalSegmentProto;
        /**
         * If specified, the perpendicular offset in meters from a road segment to an interpolated address along that road segment. See go/synthetic-address-positions.
         */
        interpolationOffsetMeters?: number | null;
        /**
         * The intersection feature corresponding to the destination of this segment. Intersections are used to represent the connectivity between segments. Each intersection stores the segment ids of all the incoming and outgoing segments that meet at that intersection. Turns can be made from this segment to any of the outgoing segments of its intersection, unless there is a restriction that explicitly disallows the turn (see below). Every segment has an intersection object, even if there are no other segments to connect to (i.e., a cul-de-sac or dead end).
         */
        intersection?: Schema$GeostoreFeatureIdProto;
        /**
         * Specifies whether the max_permitted_speed_kph was derived from a heuristic as opposed to coming from an authoritative source.
         */
        isMaxPermittedSpeedDerived?: boolean | null;
        /**
         * Detailed information about each lane in this direction, if available. Lanes are numbered from inside of the road outward, i.e. the lane next to the center line has lane_number 0. Note that lanes that are valid for travel in both directions appear in both segments of a segment pair (left turn lanes, one-lane roads, some passing lanes, reversing lanes). Some lanes may not be usable by cars, such as bike lanes. Also, some lanes may not exist along the entire segment, e.g. left- or right-turn lanes that appear just before the intersection.
         */
        lane?: Schema$GeostoreLaneProto[];
        /**
         * The legal maximum, legal minimum, and advisory (recommended but non-legally binding) maximum speed limits that are permitted on this segment. These should be the segment's legal limits; however, note that it may contain estimated values based on country-wide defaults and other heuristics (see 'AppliedSpeedLimitProto.trust_level'). Before exposing these fields to users as the legal speed limit please consult with Google lawyers.
         */
        legalMaximumSpeed?: Schema$GeostoreAppliedSpeedLimitProto[];
        legalMinimumSpeed?: Schema$GeostoreAppliedSpeedLimitProto[];
        /**
         * The maximum speed that is permitted on this segment, in kilometers per hour. This should be the segment's legal speed limit; however, note that it may contain estimated values based on country-wide defaults and other heuristics (see 'is_max_permitted_speed_derived' below). Before exposing this field to users as the legal speed limit please consult with Google lawyers.
         */
        maxPermittedSpeedKph?: number | null;
        /**
         * Field-level metadata for the maximum permitted speed.
         */
        maxPermittedSpeedKphMetadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * Specifies whether this segment carries right-hand traffic (cars keep to the right side of the road) instead of left-hand traffic (cars keep to the left side). This is true for US roads and false for UK roads, for example. See go/wikip/Left-_and_right-hand_traffic.
         */
        onRight?: boolean | null;
        /**
         * Defines the pedestrian crossing(s) between the end point of this segment and the start point of this segment's sibling.
         */
        pedestrianCrossing?: Schema$GeostorePedestrianCrossingProto;
        /**
         * clang-format on
         */
        pedestrianFacility?: string | null;
        pedestrianGrade?: string | null;
        /**
         * LINT.ThenChange(//depot/google3/maps/pathfinder/pgraph/pgraph-segment-categories.cc)
         */
        priority?: string | null;
        /**
         * Field-level metadata for the priority.
         */
        priorityMetadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * RESERVED
         */
        ramp?: Schema$GeostoreSegmentProtoRampProto;
        /**
         * The set of restrictions that apply to this segment. Restrictions may make a single segment, turn, or more complex maneuver along a set of segments unroutable for the specified travel modes, or may only add penalties or warnings, depending on the restriction type. Turn restrictions are one example of a restriction. By default, turns are allowed onto all outgoing segments from this segment's intersection (including the sibling of this segment, i.e. U-turns are allowed by default). If any of these turns are disallowed they will be listed as "subpath restrictions". A subpath restriction disallows travel on given sequence of segments. In the case of a disallowed turn, the subpath simply consists of the source and destination feature ids. There may also be restrictions that apply to all travel on this segment (e.g. chains required, or closed in winter), or restrictions that just apply to certain lanes (e.g. high occupancy vehicle lanes).
         */
        restriction?: Schema$GeostoreRestrictionProto[];
        /**
         * The road monitors that monitor this segment for traffic violations.
         */
        roadMonitor?: Schema$GeostoreFeatureIdProto[];
        /**
         * The road sign(s) which this segment refers to. These are features of TYPE_ROAD_SIGN that are applicable to this segment. For example, a sign that says "TO KIRKLAND" might apply to several segments on a freeway off-ramp (until the end of the ramp). Note that this field makes it easy to find the signs for a given road segment. The feature for the sign lists the segments that refer to it.
         */
        roadSign?: Schema$GeostoreFeatureIdProto[];
        /**
         * The route(s) to which this segment belongs.
         */
        route?: Schema$GeostoreFeatureIdProto[];
        /**
         * Holds metadata about the associations between this segment and the route features listed in the route field. This metadata need not be present; the only consistency requirement is that every feature ID that appears inside 'route_association' must also appear in the repeated 'route' field. If a route does not appear in route_association, consumers should assume that it has a default initialized RouteAssociationProto.
         */
        routeAssociation?: Schema$GeostoreRouteAssociationProto[];
        /**
         * Indicates whether the segment's opposing lanes of traffic are separated from this segment, and hence have been represented in a separate feature. This means that there are two pairs of siblings instead of one.
         */
        separatedRoadways?: boolean | null;
        /**
         * The other segment of this segment pair (see above). The segment that is referenced by the sibling field refers to this feature back via the same sibling field. Both segment and sibling should have the same properties such as geometry, country code, elevation, level relation, priority etc. Since routes are required to have segment and sibling at the same time, the set of routes on a segment is same to that of the sibling.
         */
        sibling?: Schema$GeostoreFeatureIdProto;
        /**
         * Each slope instance is tied to a point along the segment polyline (unrelated to the vertices in the segment's polyline) and represents the slope of the segment between that point and the point tied to the next slope istance, or the end of the segment if it's the last slope instance. A segment should have at least one slope.
         */
        slope?: Schema$GeostoreSlopeProto[];
        /**
         * clang-format on LINT.ThenChange(//depot/google3/geostore/base/proto/lane.proto) Specific lanes may override this segment-level surface type.
         */
        surface?: string | null;
        /**
         * Field-level metadata for the surface.
         */
        surfaceMetadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * The geometric sweeps between this segment and nearby segments, used for real road width rendering. A sweep describes the surface that connects to segments.
         */
        sweep?: Schema$GeostoreSweepProto[];
        /**
         * If this segment is part of a toll road. It would be nice to have data about the toll cost, locations of toll booths, and so forth. Sadly, we don't have this data at this time.
         */
        tollRoad?: boolean | null;
        /**
         * clang-format on LINT.ThenChange(//depot/google3/maps/pathfinder/pgraph/pgraph-segment-categories.cc)
         */
        usage?: string | null;
        /**
         * A collection of landmarks that are visible when traveling along this segment and useful for wayfinding to users following routes using this segment. The landmark need not be on the segment. Each segment in a pair of siblings specifies its landmarks independently. A landmark applicable to both appears in both.
         */
        visibleLandmark?: Schema$GeostoreLandmarkReferenceProto[];
    }
    /**
     * Encapsulates ramp-specific properties.
     */
    export interface Schema$GeostoreSegmentProtoRampProto {
        /**
         * The highest priority of any TYPE_ROAD endpoint segment which is transitively connected to this ramp via other ramp segments. For instance, if we have two roads connected through a series of ramps (omitting intersections): Road(P=96)-\> Ramp 1 -\> Ramp 2 -\> Ramp 3 -\> Road(P=122) -\> Road(P=144) The `max_connected_priority` of all three intermediary ramps is 122. It's not 144, since Road(P=144) is connected through another road, not a ramp. This differs from the usual `SegmentProto.priority` field, which contains the lowest priority across any connected road segment.
         */
        maxConnectedPriority?: string | null;
    }
    /**
     * This proto represents the geographic area served by an establishment. WARNING: This proto is not meant to be used directly. Please use the provided libraries. http://google3/geostore/base/public/service_area.h http://google3/java/com/google/geostore/base/ServiceArea.java
     */
    export interface Schema$GeostoreServiceAreaProto {
        /**
         * The features that make up the service area for this establishment. These features are subject to the following constraints applied by editing middleware (notably, not strictly enforced by lints in storage): 1. The following feature types (and their subtypes) may be used: + TYPE_ISLAND + TYPE_POLITICAL, except the following prohibited subtypes: - TYPE_CONSTITUENCY - TYPE_LAND_PARCEL + TYPE_POSTAL 2. There is a maximum limit (currently 20) to the number of areas which may be provided. This is due to serving efficiency limitations. 3. There are no additional geometry requirements for these features beyond the requirements based on the feature types above. In practice this means that these features will either have polygonal or point-based geometries. 4. These referenced features are generally required to have names, though this is not strictly enforced.
         */
        servedFeature?: Schema$GeostoreFeatureIdProto[];
    }
    /**
     * Defines an ordered reference to a line variant’s stop.
     */
    export interface Schema$GeostoreServicedStopProto {
        /**
         * Reference to a Transit POI feature (gcid:transit_station) or platform compound section (gcid:railway_platform) serviced by the line variant.
         */
        id?: Schema$GeostoreFeatureIdProto;
        /**
         * An index representing the order in which the above station is serviced by the line variant.
         */
        index?: number | null;
    }
    /**
     * This protocol buffer holds attributes for features of TYPE_SKI_BOUNDARY.
     */
    export interface Schema$GeostoreSkiBoundaryProto {
        type?: string | null;
    }
    /**
     * This protocol buffer holds attributes for features of TYPE_SKI_LIFT.
     */
    export interface Schema$GeostoreSkiLiftProto {
        /**
         * clang-format on
         */
        type?: string | null;
    }
    /**
     * This protocol buffer holds attributes for features of TYPE_SKI_TRAIL.
     */
    export interface Schema$GeostoreSkiTrailProto {
        difficulty?: string | null;
        type?: string | null;
    }
    export interface Schema$GeostoreSlopeProto {
        /**
         * Slope value as elevation change divided by horizontal distance, in the format of decimal, e.g., ‘0.1234’ means a 12.34% slope. If a slope_value is unset, it indicates we don’t have enough information to compute slope at this location.
         */
        slopeValue?: number | null;
        /**
         * Indicates how far along the segment this slope value starts to apply, in the format of decimal between 0 and 1.
         */
        startPointFraction?: number | null;
    }
    /**
     * MapFacts GAIA ID assigned to this feature. These values are virtual GAIA IDs from MapFacts, and as such are not stored in Focus.
     */
    export interface Schema$GeostoreSocialReferenceProto {
        /**
         * WARNING: Please do NOT introduce new uses; treat this field as if it were deprecated.
         */
        baseGaiaId?: string | null;
        /**
         * GAIA ID used when a business has been claimed. This value is a robot GAIA ID. Robots are a special type of GAIA account used to denote identity for a user or a group of users, but are not logged-in directly by a user.
         */
        claimedGaiaId?: string | null;
        /**
         * WARNING: Please do NOT introduce new uses; treat this field as if it were deprecated.
         */
        gaiaIdForDisplay?: string | null;
    }
    /**
     * Source infos are the canonical way to establish data provenance. They can currently be set on features, edits, and issues. Every feature has a repeated list of SourceInfoProto messages to describe the source data that was used in building this feature. The data includes a feature id that points to additional data about the data source (version, copyright notice, etc), and optional "raw data" that is taken directly from the provider's format and has not been converted to a canonical form.
     */
    export interface Schema$GeostoreSourceInfoProto {
        /**
         * This is the URL of a page representing all the data from this source in this feature. It may have be the ultimate source of the data (in case of scraping) or merely the same data styled according the provider's taste. There is a similar field in DataSourceProto which is NOT cached in this field, since it has a different meaning.
         */
        attributionUrl?: Schema$GeostoreUrlProto[];
        /**
         * The time that this particular piece of data was collected. If different attributes were collected on different dates, this is the date of the most recent edit.
         */
        collectionDate?: Schema$GeostoreDateTimeProto;
        /**
         * A source info may have a magic cookie whose content and semantics are defined by the specific import process or third-party feed. For feeds that are processed by Distillery, the cookie, when set, should contain the unique identifier for the feature as provided by the feed.
         */
        cookie?: string | null;
        /**
         * The dataset from which this SourceInfoProto was created. The content of this string will be determined by the data provider (e.g. for MultiNet data, "fra" would indicate the dataset for France). This field is unnecessary for providers that deliver a single dataset per release (e.g. Basarsoft).
         */
        dataset?: string | null;
        /**
         * The Gaia ID of the user who provided us with this data. This field should never be set on source infos present on features, but may be set on source infos present on edits. DEPRECATED: Most clients should use the "user" field instead where Gaia IDs are encrypted.
         */
        gaiaId?: string | null;
        /**
         * Information about an internal user or system that is operating on behalf of `user` by way of impersonation.
         */
        impersonationUser?: Schema$GeostoreUserProto;
        /**
         * The name of the layer from which this SourceInfoProto was created.
         */
        layer?: string | null;
        /**
         * The OGR feature identifier from which this SourceInfoProto was created. This is an internal OGR record identifier and has nothing to do with any of the feature's fields or the FeatureIdProto for the FeatureProto containing this SourceInfoProto. This field is present only for debugging purposes and possible use in the match pattern of a FeatureChangeProto designed to fix bad source data very early in the importing process.
         */
        ogrFid?: string | null;
        /**
         * The data provider from which this source info was generated. The value must be equal to the one on the TYPE_DATA_SOURCE feature referenced by this source info via the source_id reference (see above).
         */
        provider?: number | null;
        /**
         * A source info may optionally have a set of key-value pairs that provide "raw data" specific to that source. The types of raw data available will vary from one provider to another and should not be used in production code. Instead, new fields and/or protocol buffers should be defined to represent this information in a canonical form, and the relevant importers should be modified to populate these new fields.
         */
        rawData?: Schema$GeostoreRawDataProto[];
        /**
         * The data release from which this SourceInfoProto was created. The format for this string is provider-dependent (e.g. a MultiNet release would look like "2008.01").
         */
        release?: string | null;
        /**
         * A source info may have a corresponding TYPE_DATA_SOURCE feature that describes it (provider, copyright information, date of release, etc). In the context of edits and issues, this field should not be set.
         */
        sourceId?: Schema$GeostoreFeatureIdProto;
        /**
         * A place for clients to attach arbitrary data to a source info. Never set in MapFacts.
         */
        temporaryData?: Schema$Proto2BridgeMessageSet;
        /**
         * RESERVED
         */
        user?: Schema$GeostoreUserProto;
    }
    /**
     * Trust related information about the input source (feed or user) to help feature summarization. Typically, the values in this proto are either based on source's previous observations (e.g., a blocked LBC user or a trusted feed) or their status (Google hired operator or admin user). The proto can later contain a more granular trust score or correctness probabilities. A higher enum value indicates a more trusted source. Leaving room in the value space for adding more granular enums, if they become necessary later.
     */
    export interface Schema$GeostoreSourceTrustProto {
        /**
         * The level of trust for the source of the observation.
         */
        level?: string | null;
    }
    /**
     * A speed limit, containing both the limit and the conditions in which it applies.
     */
    export interface Schema$GeostoreSpeedLimitProto {
        /**
         * The type of speed limit.
         */
        category?: string | null;
        /**
         * The conditions under which this speed limit is applicable. If multiple conditions are set, at least one of them must be true.
         */
        condition?: Schema$GeostoreRoadConditionalProto[];
        /**
         * The source of the speed limit.
         */
        sourceType?: string | null;
        /**
         * A constant speed limit.
         */
        speedWithUnit?: Schema$GeostoreSpeedProto;
        /**
         * A speed limit with no limit value. When there is no speed limit in place.
         */
        unlimitedSpeed?: Schema$GeostoreUnlimitedSpeedProto;
        /**
         * A dynamic speed limit that can vary within a range of values based on road conditions.
         */
        variableSpeed?: Schema$GeostoreVariableSpeedProto;
    }
    /**
     * A speed value and unit.
     */
    export interface Schema$GeostoreSpeedProto {
        /**
         * All speed values are stored in kilometers per hour.
         */
        speed?: number | null;
        /**
         * Mapfacts only allows unit to be KILOMETERS_PER_HOUR.
         */
        unit?: string | null;
    }
    /**
     * Represents a way to traverse nested fields by referencing their token fields. Everything starts relative to a known root message, specified externally. E.g., suppose we have a feature proto that has a lane with token 0x123 which in turn has a lane connection with token 0x456 for which we want to assert something about flowline altitudes. The field path in that case will look like: field_path: { field_num: 31 # segment \} field_path: { field_num: 6 # lane version_token: "0x123" \} field_path: { field_num: 8 # lane_connection version_token: "0x456" \} field_path: { field_num: 3 # flow \} field_path: { field_num: 1 # track \} field_path: { # Note: pose is repeated. By not specifying a token we refer to all poses # in a track. field_num: 2 # pose \} field_path: { field_num: 4 # altitude \} This path could also be represented succinctly in a more human-friendly form as something like: segment.lane[@0x123].lane_connection[@0x456].flow.track.pose[*].altitude
     */
    export interface Schema$GeostoreStableFieldPathProto {
        /**
         * A sequence of field selectors to be traversed starting from the root message.
         */
        fieldPath?: Schema$GeostoreStableFieldPathProtoStableFieldSelector[];
    }
    export interface Schema$GeostoreStableFieldPathProtoStableFieldSelector {
        /**
         * Field number to select.
         */
        fieldNum?: number | null;
        /**
         * Select repeated field entry by its version token. If this is used, then the message referenced by field_num must have a token field annotated with the (version_token) field option. Must be omitted for leaf non-repeated fields. If unset for a repeated field, we consider this selector to apply equally to all descendants.
         */
        versionToken?: string | null;
    }
    /**
     * This protocol buffer represents the 2D polygon connecting two segments at an intersection. Collectively, sweep polygons represent intersections for real road width rendering. Notes: - Sweeps represent geometry between the *end* of one segment and the *end* of the other segment (modulo retraction values). - Sweeps are strongly referenced, meaning geometry is stored on both segments involved in the sweep. For example, in the diagram below, the sweep between A and B would be stored on both segment A and segment B. | B | v --A--\> - Sweeps are not strictly stored on adjacent segments. Disconnected segments (e.g., segments separated by an intersection group) may also contain sweeps.
     */
    export interface Schema$GeostoreSweepProto {
        /**
         * The segment feature connected to this segment via the sweep geometry.
         */
        otherSegmentFeatureId?: Schema$GeostoreFeatureIdProto;
        /**
         * Polygonal geometry representing the area between this segment and the other segment.
         */
        polygon?: Schema$GeostorePolygonProto;
        /**
         * Describes parameters for generating the edge of this sweep that starts at edge_follows_segment_end_fraction. The other side of the sweep should be described on the sweep present on the sibling pair.
         */
        sweepCurve?: Schema$GeostoreCurveConnectionProto;
        /**
         * A token that can be used to identify the version of the data about this sweep.
         */
        sweepToken?: string | null;
    }
    /**
     * This protocol buffer is used to represent telephone numbers and related information.
     */
    export interface Schema$GeostoreTelephoneProto {
        /**
         * RESERVED
         */
        callRate?: Schema$GeostorePriceRangeProto[];
        /**
         * Disambiguates between the types of information or service a caller might seek when contacting this phone number.
         */
        contactCategory?: string | null;
        flag?: string[] | null;
        /**
         * True if this phone number is not unique to this establishment and might be shared with other features. In case an establishment shares a phone number with a business chain of which it is a member, and the number canonically belongs to that chain, it should be marked as shared for the establishment but not shared for the chain.
         */
        isSharedNumber?: boolean | null;
        /**
         * RESERVED
         */
        label?: Schema$GeostoreNameProto[];
        /**
         * RESERVED
         */
        language?: string[] | null;
        /**
         * Field-level metadata for this telephone number.
         */
        metadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * ** DEPRECATED ** This is deprecated in favor of phone_number below. An internationalized representation of a phone number. See //location/country/telephonenumber.proto
         */
        number?: Schema$TelephoneNumber;
        /**
         * An internationalized representation of a phone number. See //java/com/google/i18n/phonenumbers/phonenumber.proto
         */
        phoneNumber?: Schema$I18nPhonenumbersPhoneNumber;
        /**
         * The features from which this phone number can be called from. For instance, if a phone number can only be called from Europe, this field will contain a reference to the TYPE_CONTINENT feature of Europe. This field is analogous to http://kg/schema/common/phone_number/service_location. The only valid destination feature types are TYPE_CONTINENT and TYPE_POLITICAL. If empty, this phone number can be called from anywhere in Earth (this is the case for the majority of phones).
         */
        serviceLocationFeature?: Schema$GeostoreFeatureIdProto[];
        type?: string | null;
    }
    /**
     * This protocol buffer stores information related to temporary closure of a feature. The only allowed precisions for a date is PRECISION_DAY. DateTimeProto.seconds should have the lowest legal value for the desired date/time and precision. E.g. for PRECISION_MONTH, 2019-02-15 21:10:30 is not valid, it should be 2019-02-01 00:00:00 instead. NOTE: Each date is stored in UTC but should be interpreted as being in the local timezone. So clients should convert the DateTimeProto to local (civil) time using UTC+0, and then treat the result as local to the feature.
     */
    export interface Schema$GeostoreTemporaryClosureProto {
        /**
         * The latest when this closure may end, if the exact date is unknown. If set, the feature is operational again no later than this date.
         */
        endAsOfDate?: Schema$GeostoreDateTimeProto;
        /**
         * RESERVED
         */
        endDate?: Schema$GeostoreDateTimeProto;
        /**
         * The latest when this closure may start, if the exact date is unknown. If set, the feature is temporarily closed starting no later than this date.
         */
        startAsOfDate?: Schema$GeostoreDateTimeProto;
        /**
         * RESERVED
         */
        startDate?: Schema$GeostoreDateTimeProto;
    }
    /**
     * Represents text (with an associated language) that is affixed to the beginning and/or end of a primary text.
     */
    export interface Schema$GeostoreTextAffixProto {
        /**
         * The external form of a Google International Identifiers Initiative (III) LanguageCode object. See google3/i18n/identifiers/languagecode.h for details. These strings should be treated as opaque blobs. You can use LanguageCodeConverter::FromOther to convert the string to a LanguageCode reference. You can then call methods on the LanguageCode class to extract language/script/region subtags (if any). See also http://g3doc/i18n/identifiers/g3doc/using-iii. We place extra restrictions on languages in addition to what the III library requires. See http://go/geo-schema-reference/feature-properties/languages.md
         */
        language?: string | null;
        /**
         * Text to prepend to the primary text, including any necessary trailing whitespace. At least one of prefix or suffix is required.
         */
        prefix?: string | null;
        /**
         * Text to append to the end of the primary text, including any necessary leading whitespace. At least one of prefix or suffix is required.
         */
        suffix?: string | null;
    }
    export interface Schema$GeostoreThreeDimensionalModelProto {
        /**
         * Triangle vertex indices, each triple defines a triangle.
         */
        pointIndices?: number[] | null;
        /**
         * We store a triangular mesh in indexed format. Points array.
         */
        points?: Schema$GeostorePointWithHeightProto[];
    }
    /**
     * A rate which applies based on the precise times of utilization. Defines a rate, as well as restrictions on the start and end times which must be satisfied in order to be eligible for the rate. See go/rate-schema for more details.
     */
    export interface Schema$GeostoreTimeBasedRateProto {
        /**
         * The rates for this rule. Each duration_based_rate defines the costs associated with a particular duration of a stay. There must be at least one rate with range_start_seconds set to 0 and there cannot be gaps between durations (i.e. there should be no interval uncovered between 0 and the largest range_end_seconds of any duration-based rate).
         */
        durationBasedRate?: Schema$GeostoreDurationBasedRateProto[];
        /**
         * If true, tax is included in the prices in this rate. If false, additional taxes may apply.
         */
        taxIncluded?: boolean | null;
        validEndWithin?: Schema$GeostoreTimeScheduleProto;
        /**
         * Time period during which utilization of this rate must start in order to be eligible for the rate. If not set, there is no restriction on the time when the utilization starts.
         */
        validStartWithin?: Schema$GeostoreTimeScheduleProto;
    }
    export interface Schema$GeostoreTimeComponentProto {
        componentType?: string | null;
        /**
         * The time component is the intersection of these intervals
         */
        interval?: Schema$GeostoreTimeIntervalProto[];
    }
    /**
     * Not all combinations of optional fields in TimeEndpointProto are allowed. The granularity of time is a path along the directed graph with these edges: second -\> minute minute -\> hour hour -\> day of week hour -\> day of month hour -\> day of year day of week -\> week of month day of week -\> week of year day of month -\> month day of year -\> year week of month -\> month week of year -\> year month -\> year A TimeEndpointProto may not specify two fields that are unordered with respect to each other ("day of year" and "day of week", for instance). The absence of fields larger than any specified field indicates repetition (e.g. no year indicates that the interval occurs every year). The absence of units that are "smaller" than the largest specified unit indicates a default lowest value (no hour means midnight (0)). When intersecting time intervals, "smaller" units repeat within the "larger" unit as many times as necessary. For example, the intersection of the interval from hour 0 to hour 24 with the interval from second 0 to second 1 is equivalent to the union of the set of intervals which represents the first second of every minute of every hour of every day. ----------------------------------------------------------------------------- WARNING - if you add new fields to TimeEndpointProto you need to: - ensure AreTimeEndpointsEquivalent considers the new fields (and update the corresponding tests) -----------------------------------------------------------------------------
     */
    export interface Schema$GeostoreTimeEndpointProto {
        /**
         * Valid ranges are 0-7, 1-31, and 1-366 (see day_type below)
         */
        day?: number | null;
        dayType?: string | null;
        /**
         * Valid range is 0-24. Because it could be unclear what wrapping hours mean in relation to days, 24 is used to denote midnight at the end of a day.
         */
        hour?: number | null;
        /**
         * Valid range is 0-59, except when a repetitive minute interval ends at the end of an hour, in which case 60 is a legal end value.
         */
        minute?: number | null;
        month?: string | null;
        /**
         * Valid range is 0-59, except when a repetitive second interval ends at the end of a minute, in which case 60 is a legal end value.
         */
        second?: number | null;
        /**
         * Valid ranges are 0-5 and 1-53 (depending on the value of week_type, see below).
         */
        week?: number | null;
        weekType?: string | null;
        year?: number | null;
    }
    export interface Schema$GeostoreTimeIntervalProto {
        /**
         * Begin and end are used to specify a range of times: [begin, end). If one is present, the other must be present as well. Additionally, both must have matching time granularities - all fields specified in the begin TimeEndpointProto must be present in the end TimeEndpointProto and vice-versa. Hours are not allowed to wrap (begin.hour() <= end.hour()).
         */
        begin?: Schema$GeostoreTimeEndpointProto;
        end?: Schema$GeostoreTimeEndpointProto;
        /**
         * If true, then this interval actually encodes the complement of the specified occasion or range. For example, the following TimeIntervalProto encodes all times other than the month of May. TimeIntervalProto[ type = TYPE_RANGE inverted = true begin = TimeEndpointProto[ month = MAY ] end = TimeEndpointProto[ month = JUNE ] ]
         */
        inverted?: boolean | null;
        /**
         * clang-format on
         */
        occasion?: string | null;
        type?: string | null;
    }
    export interface Schema$GeostoreTimeScheduleProto {
        /**
         * The schedule is the union of these components.
         */
        component?: Schema$GeostoreTimeComponentProto[];
    }
    /**
     * A TimezoneProto holds information about a feature's related time zone.
     */
    export interface Schema$GeostoreTimezoneProto {
        /**
         * i18n recognized time zone identifier. For the full list of identifiers, see google3/i18n/identifiers/data/timezones.txt.
         */
        id?: string | null;
        /**
         * Field-level metadata for this relation.
         */
        metadata?: Schema$GeostoreFieldMetadataProto;
    }
    /**
     * A collection of information that applies to a toll cluster.
     */
    export interface Schema$GeostoreTollClusterProto {
        /**
         * The list of TYPE_INTERSECTION features that are toll points and form this toll cluster. A toll cluster can consist of either a single or a group of intersection points called toll points at the end of various road segments in MapFacts that represent one or more lanes passing through a toll fixture that all go to the same routing destination. This relationship is reciprocal, as a toll point intersection also stores a reference to the toll cluster it belongs to. A toll cluster must have reference to one or more toll points i.e. toll_cluster.intersection should always be populated.
         */
        intersection?: Schema$GeostoreFeatureIdProto[];
    }
    export interface Schema$GeostoreTrackProto {
        /**
         * The index of this TrackProto in a list of TrackProtos.
         */
        index?: number | null;
        /**
         * The instantaneous pose of points along this track. The fields set inside each pose must be set consistently along the track.
         */
        pose?: Schema$GeostorePoseProto[];
    }
    /**
     * A transit line is a named set of transit trips that are advertised to passengers under a common name, and a number of attributes that are true for all those trips. There is no requirement for each trip to travel through the same list of stops or use the same legs, so a line can contain trips in opposite directions or with variations in the sequence of stops. See go/oysterpedia for an overview of the transit feature types. The standard feature properties are interpreted as follows: name - The names of this line, including both long and short names, if available. Short names like "10" or "Blue" should carry the FLAG_ABBREVIATED, long names like "Dublin/Pleasanton line" should not. The preferred name (one per language) for displaying the line on its own (e.g., as a search result for the line) should carry the FLAG_PREFERRED. website - The official web page describing this line. Repeated if multilingual. Line features have no geometry (neither points nor polylines nor polygons). Within Transit Oyster, geometry can be found in legs. Additional data only in Transit Oyster: child - The legs of this line, in no particular order. source_info - Specifies the GTFS routes that match this feature. Each is given as a PROVIDER_GOOGLE_TRANSIT source_info where dataset is the feed name and cookie is the route_id.
     */
    export interface Schema$GeostoreTransitLineProto {
        /**
         * The transit agencies responsible for operating this line. All lines should have at least one agency, and most will have exactly one. The following cases are reasons for multiple agencies: - Code share: Two or more agencies share trips - Alternations: Each trip is run by one of multiple agencies - Additional: All trips run by one agency, but a second one sells tickets In all cases the order has no meaning. Clarification comes from the trips.
         */
        agency?: Schema$GeostoreFeatureIdProto[];
        /**
         * The background color of labels for that transit line. The encoding is like in HTML or CSS, eg. 0x11ff00 means a bit of red, full green, no blue, in sRGB color space. The most significant byte must be zero, i.e. no transparency.
         */
        labelBackgroundColor?: number | null;
        /**
         * The text color of labels for that transit line. Encoding like label_background_color.
         */
        labelTextColor?: number | null;
        /**
         * The transit stations (establishment POIs with gcid:transit_station) which this transit line can go through, in no particular order. Usage note: The source of truth are the transit leg features in Transit Oyster. In MapFacts, that information is cached in two locations: in this field, and in transit station attachments on POIs. Do not assume these locations are always up to date and/or synchronized with each other.
         */
        stations?: Schema$GeostoreFeatureIdProto[];
        /**
         * The type of vehicle that applies to all trips that use this line.
         */
        vehicleType?: string | null;
    }
    /**
     * A line variant is a specific instantiation of a line concept, denoted by the ordered set of stops and collection of segments that it traverses. Line variants are modeled as TYPE_ROUTE features with gcid:transit_line_variant. This proto stores line-variant-specific information that is not generally applicable to all routes. Schema Design Doc: go/transit-line-concepts-and-variants
     */
    export interface Schema$GeostoreTransitLineVariantProto {
        /**
         * Reference to the line variant’s line concept.
         */
        lineConcept?: Schema$GeostoreFeatureIdProto;
        /**
         * Ordered list of stations or platforms serviced by this line variant. The order is captured by the ServicedStopProto.index field.
         */
        stops?: Schema$GeostoreServicedStopProto[];
    }
    /**
     * Encapsulates information related to an individual transit station.
     */
    export interface Schema$GeostoreTransitStationProto {
        /**
         * All the transit agencies which service this station. A station can be serviced by multiple stations. There may only be one agency association per transit agency. See go/transit-agency-relation-migration for more details.
         */
        agencyAssociations?: Schema$GeostoreTransitStationProtoTransitAgencyAssociationProto[];
    }
    /**
     * The association between this station and the agency which services this station.
     */
    export interface Schema$GeostoreTransitStationProtoTransitAgencyAssociationProto {
        /**
         * The transit agency which services this station.
         */
        agency?: Schema$GeostoreFeatureIdProto;
        /**
         * A station code uniquely identifies a transit station within the transit agency's network.
         */
        stationCode?: string | null;
    }
    export interface Schema$GeostoreTrustSignalsProto {
        /**
         * Trust signals for the source of a given observation, typically based on historical evidences or status (like internal Google operator).
         */
        sourceTrust?: Schema$GeostoreSourceTrustProto;
    }
    /**
     * A speed limit without a limit value. Used to indicate the absence of a speed limit.
     */
    export interface Schema$GeostoreUnlimitedSpeedProto {
    }
    /**
     * Hold a list of URLs, usually to contain translations of a single URL.
     */
    export interface Schema$GeostoreUrlListProto {
        url?: Schema$GeostoreUrlProto[];
    }
    /**
     * A web location for a Feature. URLs should always be stored in repeated fields because some objects (eg. transit schedules in Brussels) have different URLs for different languages.
     */
    export interface Schema$GeostoreUrlProto {
        /**
         * The external form of a Google International Identifiers Initiative (III) LanguageCode object. See google3/i18n/identifiers/languagecode.h for details. We place extra restrictions on languages in addition to what the III library requires. See http://go/geo-schema-reference/feature-properties/languages.md This field represents the language of the content of the web site. It may be missing if the web site is language-independent or if the language is unknown.
         */
        language?: string | null;
        /**
         * Field-level metadata for this URL. NOTE: there are multiple UrlProto fields in the Geo Schema. Metadata here is only expected to be present on FeatureProto.website[].
         */
        metadata?: Schema$GeostoreFieldMetadataProto;
        /**
         * ** DEPRECATED ** The pagerank of this URL. Valid values [0, 65535] See http://wiki/Main/NearestSeeds for more information.
         */
        pagerank?: number | null;
        /**
         * The URL.
         */
        url?: string | null;
    }
    /**
     * UserProto identifies a (human) user of Geo Data. Its primary use is in describing the source of pieces of data (e.g. edits). It could be a simple identifier, but isn't so that we can store it in the clear while still preventing correlation between a user's contribution.
     */
    export interface Schema$GeostoreUserProto {
        /**
         * The user Gaia ID in encrypted form. Wipeout ids take value of "" in bytes.
         */
        encryptedGaiaId?: string | null;
        /**
         * Required. The name of the key used to encrypt the Gaia ID.
         */
        encryptionKeyName?: string | null;
        /**
         * Required (valid default provided). The config ID of the owner of the above encryption_key_name. This field must be set if the encryption key name is *not* "mapfacts_gaia_id_encryption_key".
         */
        keystoreConfigId?: number | null;
        /**
         * If possible, writers should set this to a full user email, including the domain. Readers should not assume that this is a well-formed email address. This field may only be set by Atlas, Pushpin and OneRing because they are internal tools which have a PWG exception to store textual usernames in the clear.
         */
        username?: string | null;
    }
    /**
     * A speed limit whose value can change based on road, traffic, and weather conditions.
     */
    export interface Schema$GeostoreVariableSpeedProto {
    }
    /**
     * A set of vehicle attribute conditionals (ex: weight \>= 20T && num_trailers = 2) used to define a slice of all possible vehicles. This can be useful for filtering one or more vehicles by a predicate.
     */
    export interface Schema$GeostoreVehicleAttributeFilterProto {
        /**
         * A repeated value here is treated as an AND operation. This allows for ranges to be represented by two values (ex: "count < 4" AND "count \>= 2" means "2 <= count < 4").
         */
        axleCount?: Schema$GeostoreCountComparisonProto[];
        /**
         * Whether the applied vehicle types have a trailer attached to them.
         */
        hasTrailer?: boolean | null;
        /**
         * List of prohibited hazardous goods for a vehicle to carry. A repeated value here is treated as an OR operation, meaning that they may not carry ANY of the goods listed.
         */
        hazardousGoods?: string[] | null;
        /**
         * A repeated value here is treated as an AND operation. This allows for ranges to be represented by two values (ex: "count <= 4" AND "count \> 2" means "2 < count <= 4").
         */
        numTrailers?: Schema$GeostoreCountComparisonProto[];
        /**
         * A repeated value here is treated as an AND operation. This allows for ranges to be represented by two values (ex: "length <= 53ft" AND "length \> 48ft" means "48ft < length <= 53ft").
         */
        trailerLength?: Schema$GeostoreDimensionComparisonProto[];
        /**
         * A repeated value here is treated as an AND operation. This allows for ranges to be represented by two values (ex: "height \> 3m" AND "height <= 5m" means "3m < height <= 5m").
         */
        vehicleHeight?: Schema$GeostoreDimensionComparisonProto[];
        /**
         * A repeated value here is treated as an AND operation. This allows for ranges to be represented by two values (ex: "length <= 40m" AND "length \> 35m" means "35m < length <= 40m").
         */
        vehicleLength?: Schema$GeostoreDimensionComparisonProto[];
        /**
         * A repeated value here is treated as an AND operation. This allows for ranges to be represented by two values (ex: "weight < 8T" AND "weight \>= 3T" means "3T <= weight < 8T").
         */
        vehicleWeight?: Schema$GeostoreWeightComparisonProto[];
        /**
         * A repeated value here is treated as an AND operation. This allows for ranges to be represented by two values (ex: "width < 4m" AND "width \>= 2m" means "2m <= width < 4m").
         */
        vehicleWidth?: Schema$GeostoreDimensionComparisonProto[];
    }
    /**
     * A proto representing a vertical ordering of a feature. NOTE: This shouldn’t be used if a more specific field can be used instead. E.g., for TYPE_SEGMENT features grade_level field should be preferred. For indoor features RELATION_ON_LEVEL should be preferred. See go/aboutgrades for comparison of various types of levels available.
     */
    export interface Schema$GeostoreVerticalOrderingProto {
        /**
         * The level represents the relative vertical ordering of a feature among all overlapping features. For example, we may have features along freeway surface have level = 0, and features on an overpass have level = 1. NOTE: It’s assumed that all features have level 0 by default, so that it’s not necessary for all overlapping features to have this set.
         */
        level?: number | null;
    }
    /**
     * A weight value tagged with a comparison operator.
     */
    export interface Schema$GeostoreWeightComparisonProto {
        comparison?: string | null;
        comparisonOperator?: string | null;
        weightWithUnit?: Schema$GeostoreWeightProto;
    }
    /**
     * A weight with a numerical value and unit.
     */
    export interface Schema$GeostoreWeightProto {
        unit?: string | null;
        weight?: number | null;
    }
    /**
     * An anchor label can be attached to any element to give it a reference address. LogicalEntity links (see goodoc-semantics.proto) may use anchor labels to point to goodoc elements (they may also use indices to locate the element, but the indices could become invalid if the goodocs are allowed to mutate). Multiple elements may have the same anchor.
     */
    export interface Schema$GoodocAnchorLabel {
        /**
         * There is a generic method for composing such strings. Please take a look at GoodocUtils::GenerateUniqueAnchorName(...) in ocr/goodoc/goodoc-utils.h.
         */
        Anchor?: string | null;
        anchorScope?: number | null;
    }
    /**
     * Bounding box for page structural elements: pictures, paragraphs, characters, etc.
     */
    export interface Schema$GoodocBoundingBox {
        Height?: number | null;
        /**
         * Optional magic label, so objects can be sorted on bounding box dimensions easily
         */
        Label?: number | null;
        /**
         * BoundingBox coordinates and sizes are expressed in pixels
         */
        Left?: number | null;
        Top?: number | null;
        Width?: number | null;
    }
    /**
     * A way to specify a simple partitioning of a BoundingBox into a sequence of sub-boxes. +----------------------------------------------------+ | | | | | | | span(0) | (1) | (2) | (3) | (4) | | | | | | | +----------------------------------------------------+ This representation can, for example, be used to store coarse Symbol boundaries within a Word (see Word.CompactSymbolBoxes below) instead of per-Symbol BoundingBoxes, for saving space.
     */
    export interface Schema$GoodocBoxPartitions {
        direction?: number | null;
        /**
         * "span" is width or height, determined by "direction". If there are k partitions, then there are k - 1 "span" values, one for each except the last symbol (which is redundant).
         */
        span?: number[] | null;
    }
    /**
     * Break label
     */
    export interface Schema$GoodocBreakLabel {
        BreakLabelType?: number | null;
        /**
         * True if break prepends the element
         */
        isPrefix?: boolean | null;
    }
    /**
     * Font label
     */
    export interface Schema$GoodocCharLabel {
        /**
         * The shift of a character from the base line of the string in pixels
         */
        BaseLine?: number | null;
        /**
         * Height of small characters in pixels on the source image
         */
        CharacterHeight?: number | null;
        /**
         * The foreground color of the symbol; the default color is 0 (black)
         */
        Color?: number | null;
        /**
         * Symbol recognition confidence from OCR. Range depends upon OCR Engine.
         */
        Confidence?: number | null;
        /**
         * The font ID refers to the fonts table in the document header
         */
        FontId?: number | null;
        /**
         * Size in points (JFYI: point is 1/72"). This is rounded to the nearest whole number.
         */
        FontSize?: number | null;
        /**
         * Size in points represented as float.
         */
        FontSizeFloat?: number | null;
        FontType?: number | null;
        /**
         * If CharacterHeight is defined uncertainly
         */
        HasUncertainHeight?: boolean | null;
        /**
         * The horizontal scaling for a character, in percents. The default value for this property is 100, which corresponds to no scaling.
         */
        HorizontalScale?: number | null;
        IsBold?: boolean | null;
        IsItalic?: boolean | null;
        IsSmallCaps?: boolean | null;
        IsStrikeout?: boolean | null;
        IsSubscript?: boolean | null;
        IsSuperscript?: boolean | null;
        /**
         * If OCR Engine marked the character as "suspicious" (this character is likely to be recognized incorrectly).
         */
        IsSuspicious?: boolean | null;
        IsUnderlined?: boolean | null;
        /**
         * True if a QA operator has marked this as not OCRable. This is used for complex equations, scripts that the operator can't type, or handwriting.
         */
        NotOcrablePerQA?: boolean | null;
        /**
         * Symbol-level penalty from the garbage text detector. Lower is better; range = [0,100].
         */
        Penalty?: number | null;
        /**
         * The probability that a character is written with a Serif font
         */
        SerifProbability?: number | null;
    }
    /**
     * Top-level representation of OCRed document
     */
    export interface Schema$GoodocDocument {
        /**
         * Debug info, recording the history of any editing done through the interface in goodoc-editing.h. The strings look like "MoveParagraph(page_index = 0, source_block_index = 3, ...);
         */
        EditingHistory?: string[] | null;
        header?: Schema$GoodocDocumentHeader;
        /**
         * Logical entities are stored as blobs. Depending on the kind of thing this is a goodoc of, a separate .proto file is expected to define the logical entity structure. Hence we can still parse this as a goodoc for people who dont care about this, and people who care about this can parse it specifically. ocr/goodoc/logical-entity-utils.h has methods to read and write these. See Goodoc++ doc
         */
        LogicalEntity?: string[] | null;
        /**
         * The names of the proto messages serialized in LogicalEntity, one for each LogicalEntity. The repetitions should number 0 to leave this unspecified, or they should equal the number of LogicalEntity strings.
         */
        LogicalEntityMessageName?: string[] | null;
        page?: Schema$GoodocDocumentPage[];
        /**
         * For multi-goodoc documents
         */
        SubDocuments?: Schema$GoodocDocument[];
    }
    export interface Schema$GoodocDocumentHeader {
        font?: Schema$GoodocDocumentHeaderFont[];
        OcrEngineId?: string | null;
        OcrEngineVersion?: string | null;
    }
    export interface Schema$GoodocDocumentHeaderFont {
        FontId?: number | null;
        FontName?: string | null;
    }
    export interface Schema$GoodocDocumentPage {
        block?: Schema$GoodocDocumentPageBlock[];
        /**
         * If the garbage text detector was run, the changelist that the binary was sync'ed to (or -1 if unknown), and whether the settings had their production values (or false if unknown).
         */
        GarbageDetectorChangeList?: number | null;
        GarbageDetectorWasProduction?: boolean | null;
        /**
         * Height in pixels
         */
        Height?: number | null;
        /**
         * Horizontal resolution in DPI.
         */
        HorizontalDpi?: number | null;
        Label?: Schema$GoodocLabel;
        mergedpageinfo?: Schema$GoodocDocumentPageMergedPageInfo[];
        /**
         * Score of porn classifier from analyzing images on page. Note: This should be named porn_score, but we use PornScore as the name in order to be consistent with the rest of this proto.
         */
        PornScore?: number | null;
        /**
         * Whether page-level text confidences and other summary data were computed by PostOcrUtils instead of the now-obsolete GarbageTextDetector
         */
        postOcrConfidence?: boolean | null;
        /**
         * Page level stats (font size, line spacing, etc.)
         */
        stats?: Schema$GoodocSummaryStats;
        /**
         * Page text recognition confidence. Range depends on the algorithm but should be consistent in a given volume. 0 is bad, 100 is good.
         */
        TextConfidence?: number | null;
        /**
         * Vertical resolution in DPI.
         */
        VerticalDpi?: number | null;
        /**
         * Width in pixels
         */
        Width?: number | null;
    }
    export interface Schema$GoodocDocumentPageBlock {
        BlockType?: number | null;
        Box?: Schema$GoodocBoundingBox;
        Label?: Schema$GoodocLabel;
        /**
         * Which way is upright for this block, and what is the reading order (applicable if there is text here).
         */
        OrientationLabel?: Schema$GoodocOrientationLabel;
        Paragraph?: Schema$GoodocParagraph[];
        /**
         * If RotatedBox is set, Box must be set as well. See RotatedBoundingBox.
         */
        RotatedBox?: Schema$GoodocRotatedBoundingBox;
        /**
         * Block text recognition confidence. Range depends on the algorithm but should be consistent in a given volume. 0 is bad, 100 is good.
         */
        TextConfidence?: number | null;
    }
    /**
     * If we have merged text from another goodoc into this one (for example, from a PDF text layer goodoc into an OCR'd goodoc), we record some source goodoc info here.
     */
    export interface Schema$GoodocDocumentPageMergedPageInfo {
        OcrEngineId?: string | null;
        OcrEngineVersion?: string | null;
    }
    /**
     * Statistics about a particular font size (from CharLabel.FontSize) aggregated over a range of symbols
     */
    export interface Schema$GoodocFontSizeStats {
        /**
         * CharLabel.FontId and FontSize
         */
        fontId?: number | null;
        fontSize?: number | null;
        /**
         * The measurements are in pixels
         */
        medianHeight?: number | null;
        /**
         * top to bottom
         */
        medianLineHeight?: number | null;
        /**
         * bottom to next top in para
         */
        medianLineSpace?: number | null;
        /**
         * top to next top in para
         */
        medianLineSpan?: number | null;
        medianWidth?: number | null;
        /**
         * Line stats for this font. "top" corresponds to the highest ascender and "bottom" to the lowest descender. num_lines = # lines with \> 50% symbols having this font
         */
        numLines?: number | null;
        /**
         * Lines (out of num_lines) that have a successor line within their para
         */
        numLineSpaces?: number | null;
        numSymbols?: number | null;
    }
    /**
     * Label aggregates all kinds of optional characteristics of page elements.
     */
    export interface Schema$GoodocLabel {
        /**
         * AnchorLabel identifies a link target.
         */
        AnchorLabel?: Schema$GoodocAnchorLabel[];
        BreakLabel?: Schema$GoodocBreakLabel;
        /**
         * CharLabel is specifically intended for symbols
         */
        CharLabel?: Schema$GoodocCharLabel;
        /**
         * Languages used in the element (page, block, paragraph or word). Ordered by dominant-language first. Note: content scanjobs processed by the garbage_text_detector before CL 9223538 (Dec. 2008) have LanguageLabels in arbitrary order (within Page and Block elements) -- the confidence value should be inspected to find the dominant language guess for these, rather than just taking the first.
         */
        LanguageLabel?: Schema$GoodocLanguageLabel[];
        /**
         * SemanticLabel is defined in goodoc-semantics.proto, it allows rich annotation of content, identifying the nature of page elements.
         */
        SemanticLabel?: Schema$GoodocSemanticLabel;
    }
    /**
     * Weighted language
     */
    export interface Schema$GoodocLanguageCombinationLanguage {
        /**
         * Bcp47 language code. Note, this is not the same as OceanCode used by goodoc::Document.
         */
        bcp47Tag?: string | null;
        /**
         * Weight of language. This specifies how likely it is to see the language in the input text. The values don't have to add up to 1.
         */
        weight?: number | null;
    }
    /**
     * Language label
     */
    export interface Schema$GoodocLanguageLabel {
        /**
         * Closest id from i18n/languages/proto/languages.proto; caveat: may not accurately capture the language. GoodocLanguageCodeToLanguage() declared in ocr/goodoc/goodoc-utils.h may be used to convert a Language enum (i18n/languages/proto/languages.proto) to a string suitable for this field.
         */
        ClosestLanguageId?: number | null;
        /**
         * Confidence level on that language, between 0 and 100
         */
        Confidence?: number | null;
        /**
         * Old (Ocean) Language Code Usage: The language code is inferred during the running of the Garbage Text Detector and gets set at the paragraph, block and page level. Language code is a string of 3 or more characters. The first 3 letters specify the language, according to ISO 639. Optionally, the 3-letter code can be extended with an underscore and a language variant specifier. Specifiers exist for regional variants or for different forms of language spelling. The regional variants are specified as 2-letter country code, according to ISO 3166. Some examples: Standard "por" - Portuguese, standard "rus" - Russian, standard Regional variants: "por_br" - Portuguese, Brazilian "eng_us" - English, United States Variants of spelling: "rus_old" - Russian, old spelling "chi_tra" - Chinese, traditional "ger_new" - German, new spelling LanguageToGoodocLanguageCode() declared in ocr/goodoc/goodoc-utils.h may be used to convert a Language enum (i18n/languages/proto/languages.proto) to a string suitable for this field. New Language Code Usage: Most of the usages described above were standardized in BCP 47, and these codes are the new stanadard to be used in this field. To load either new or old language codes to form LanguageCode objects, use the function FromOceanCode() in ocr/quality/lang_util.h Note that the function ocr::FromOceanCode is capable of transforming either version of the LanguageCode to a C++ i18n_identifiers::LanguageCode.
         */
        LanguageCode?: string | null;
    }
    /**
     * A logical entity in the abstract is just a group of links to the goodoc. Depending on the kind of item, a separate proto file should extend this to define the logical structure for that kind. For example. newspapers.proto defines the logical entity for newspapers. LogicalEntity is also used within some SemanticLabels, for example, for a table-of-contents link.
     */
    export interface Schema$GoodocLogicalEntity {
        link?: Schema$GoodocLogicalEntityLink[];
        Metadata?: string | null;
    }
    /**
     * NOTE(gponcin) 2008/11 This is repeated for articles where we may have multiple links in one entity. From Vivek (Atlantis): "The block segmenter outputs a list of headlines on a page as a single logical entity that we attach to the logicalentity(1) for the goodoc."
     */
    export interface Schema$GoodocLogicalEntityLink {
        /**
         * The preferred way to link to an element is to create an AnchorLabel in the target element and name it here. Multiple elements may contain the same Anchor string.
         */
        Anchor?: string | null;
        BlockId?: number | null;
        /**
         * Links may also specifically locate the target element with the following indices. Note that during the course of layout analysis, goodoc elements may move around, so such hard links should be created only very late (or not at all -- Anchors would be more reliable target addresses).
         */
        DocId?: number | null;
        PageId?: number | null;
        ParagraphId?: number | null;
        RouteId?: number | null;
        SymbolId?: number | null;
        /**
         * If not defined, link points to the current doc
         */
        Url?: string | null;
        WordId?: number | null;
    }
    /**
     * An Ordinal message represents a single ordinal component of a page number. It encodes the printed or inferred numbering style (Roman, ASCII, etc.) and the ordinal value of the component. An optional set of variable is defined in order to express a sectioned ordinal. A sectioned ordinal may appear in certain page numbering styles, for example "12-1" where "12" identifies a chapter and "1" identifies the page within it. This case will be encoded with value 1 and section_value 12 both of type ASCII.
     */
    export interface Schema$GoodocOrdinal {
        implicit?: string | null;
        sectionStringValue?: string | null;
        sectionValue?: number | null;
        /**
         * The following vars describe the section component of an ordinal (if exists). They are used to express situation where a page number has a section component, usually denoating the chapter number. For example pages 5-14, 5-15 will both have the common section 5. (If exists). The semantcis of the section variables correspond to that of the primary part of the ordinal. (Described above).
         */
        sectionValueType?: string | null;
        /**
         * The string page value.
         */
        stringValue?: string | null;
        /**
         * The numeric page value.
         */
        value?: number | null;
        /**
         * The delta in which the value increases between pages.
         */
        valueDelta?: string | null;
        /**
         * A value type from the Type enum above.
         */
        valueType?: string | null;
    }
    /**
     * OrientationLabel groups the details about orientation and reading order.
     */
    export interface Schema$GoodocOrientationLabel {
        /**
         * After rotating so that the text orientation is upright, how many radians does one have to rotate the block anti-clockwise for it to be level? We guarantee: -Pi/4 <= deskew_angle <= Pi/4
         */
        deskewAngle?: number | null;
        /**
         * Whether a text line is mirrored (e.g. reflected in a shiny surface or seen through the opposite side of a storefront window). The intent is that this is a quality of the text line image. It needs to be reflected according to a vertical axis along the direction of upright characters to make it readable. This does not affect the shape of the bounding box. A mirrored line with top to bottom writing remains top to bottom. A mirrored horizontal line will flip left to right. However any child entities (symbols) will remain in the same order, and the writing direction imposed by the language (ltr or rtl) will remain the same.
         */
        mirrored?: boolean | null;
        orientation?: string | null;
        textlineOrder?: string | null;
        writingDirection?: string | null;
    }
    /**
     * This message specifies structure "overrides" to apply: it can be used to force certain kinds of GoodocToHTML renderings of elements.
     */
    export interface Schema$GoodocOverrides {
        /**
         * For text blocks only: do not allow this block to be turned into an image when rendering, even if your algorithms want to do so:
         */
        blockImagination?: string | null;
        /**
         * For graphic blocks, we often expand the block a bit for rendering, to compensate for bad image segmentation. do_not_expand_graphic_box forces this behavior to be turned off.
         */
        doNotExpandGraphicBox?: boolean | null;
        /**
         * For Pages only: explicitly specify whether or not this page should be rendered fully as an image
         */
        fullPageAsImage?: string | null;
        /**
         * For Pages only: explicitly specify whether or not all text on this page should be treated as "LINEATED"
         */
        fullPageLineated?: string | null;
        /**
         * For Pages only: explicitly specify whether or not this page should be skipped.
         */
        fullPageSkipped?: string | null;
        /**
         * This GRAPHIC block's image can be shown even when GoodocToHTMLOptions.suppress_photos_with_this is specified.
         */
        needNotSuppressPhoto?: boolean | null;
        /**
         * For blocks: explicitly specify whether or not this block should get a page-break before it.
         */
        pageBreakBefore?: string | null;
        style?: Schema$GoodocOverridesStyle[];
        /**
         * For Words only: replace the rendered HTML by this:
         */
        wordHtml?: string | null;
    }
    /**
     * Extra css styles to apply
     */
    export interface Schema$GoodocOverridesStyle {
        /**
         * css attribute name: "margin-left", for eg.
         */
        name?: string | null;
        /**
         * css attribute vale: "1em", for eg.
         */
        value?: string | null;
    }
    /**
     * Represents a paragraph of text in OCRed content.
     */
    export interface Schema$GoodocParagraph {
        alignment?: number | null;
        Box?: Schema$GoodocBoundingBox;
        droppedcap?: Schema$GoodocParagraphDroppedCap;
        FirstLineIndent?: number | null;
        Label?: Schema$GoodocLabel;
        LeftIndent?: number | null;
        LineSpacing?: number | null;
        /**
         * Which way is upright for this paragraph and what is the dominant reading order?
         */
        OrientationLabel?: Schema$GoodocOrientationLabel;
        RightIndent?: number | null;
        /**
         * If RotatedBox is set, Box must be set as well. See RotatedBoundingBox.
         */
        RotatedBox?: Schema$GoodocRotatedBoundingBox;
        route?: Schema$GoodocParagraphRoute[];
        SpaceAfter?: number | null;
        SpaceBefore?: number | null;
        /**
         * If we merge any paragraphs into this one (through the MergeParagraphWithNext() interface in goodoc-editing.h), then we append the properties of the merged paragraph here, for debugging and to avoid losing any info. Note that the SubsumedParagraphProperties Paragraphs do not contain Routes.
         */
        SubsumedParagraphProperties?: Schema$GoodocParagraph[];
        /**
         * Paragraph text recognition confidence. Range depends on the algorithm but should be consistent in a given volume. 0 is bad, 100 is good.
         */
        TextConfidence?: number | null;
        Width?: number | null;
    }
    /**
     * Information about the paragraph's dropped capital letter
     */
    export interface Schema$GoodocParagraphDroppedCap {
        Box?: Schema$GoodocBoundingBox;
        LettersCount?: number | null;
    }
    export interface Schema$GoodocParagraphRoute {
        /**
         * Route end point
         */
        EndPoint?: Schema$GoodocRoutePoint;
        /**
         * Route start point
         */
        StartPoint?: Schema$GoodocRoutePoint;
        /**
         * Route weight, i.e. route
         */
        Weight?: number | null;
        /**
         * The array of words on this route
         */
        Word?: Schema$GoodocWord[];
    }
    /**
     * Similar to goodoc.BoundingBox, but containing an angle of rotation, thus able to represent non-axis-aligned boxes. RotatedBoundingBox can be used in combination with BoundingBox to better represent non-axis-aligned page structural elements. In such case, two bounding boxes can be used per element. A RotatedBoundingBox that is rotated to tightly encompass the element; embedded (as tightly as possible) inside an axis-aligned BoundingBox. Note that there is some amount of ambiguity regarding what angle and vertex to use. Consider a square with axis-aligned diagonals: B / \ A C \ / D This can either be represented as a -45 degree rotation around A, a 45 degree rotation around B, a 135 degree rotation around C, or a -135 degree rotation around D. Which one you use depends on your use case, but one recommendation is to use the vertex that would be top left if the reader was reading it in the 'natural' orientation.
     */
    export interface Schema$GoodocRotatedBoundingBox {
        /**
         * Angle of rotation of the original non-rotated box around the top left corner of the original non-rotated box, in clockwise degrees from the horizontal.
         */
        Angle?: number | null;
        Height?: number | null;
        /**
         * Coordinates and sizes are expressed in pixels, where the top-left pixel is (0, 0). The coordinates refer to the corner of the top-left vertex of the unrotated version of the box.
         */
        Left?: number | null;
        Top?: number | null;
        Width?: number | null;
    }
    export interface Schema$GoodocRoutePoint {
        /**
         * The sequential route number, starts at 0
         */
        RouteIndex?: number | null;
        /**
         * The sequential word number, starts at 0
         */
        WordIndex?: number | null;
    }
    /**
     * Label identifying a logical part of the page content. This applies mostly at Block level or Paragraph level (but can apply to Words or to arbitrary spans if needed).
     */
    export interface Schema$GoodocSemanticLabel {
        /**
         * Alternate text for a sequence of the Goodoc, just for the element containing this label, or for a sequence starting from this element to the EndOfSpanningLabel. Typically this is inserted by automatic or manual OCR correction. We use text instead of editing the Goodoc directly since we dont usually have accurate symbol level bboxes for the alternate text. Also the original values from OCR are preserved. It is upto the application to do anything more intelligent like mapping words and finding potential symbol/word bboxes.
         */
        AlternateText?: string | null;
        appearance?: number | null;
        /**
         * Page elements can be given Attributes refining meaning/role. We keep this flexible by using strings instead of pre-determined enum values. But it is useful to list all such Attributes in use in ocr/goodoc/goodoc-semantics-attributes.h
         */
        Attribute?: string[] | null;
        /**
         * Blocks that are at the beginning of chapters have this set:
         */
        ChapterStart?: boolean | null;
        CleanupAnnotation?: number[] | null;
        columndetails?: Schema$GoodocSemanticLabelColumnDetails;
        contentlink?: Schema$GoodocSemanticLabelContentLink;
        ContinuesFromPreviousPage?: boolean | null;
        /**
         * When ContinuesFromPreviousPage=true, this bit can be set to note that the word fragment on the previous page ends in a hyphen.
         */
        ContinuesFromPreviousPageHyphenated?: boolean | null;
        /**
         * Paragraphs that span across pages can be identified with the following flags. Note that flows just connect Blocks across pages. These continuation flags imply something more specific -- the case of a single logical paragraph split over pages. Only the last Paragraph in the last Block within a given FlowThread() on a page can have ContinuesOnNextPage set. Similarly, only the first Paragraph in the first Block with a given FlowThread() on a page may have ContinuesFromPreviousPage set.
         */
        ContinuesOnNextPage?: boolean | null;
        editcorrectioncandidate?: Schema$GoodocSemanticLabelEditCorrectionCandidate[];
        /**
         * Normally, a SemanticLabel applies exactly to the goodoc element that it is contained in (usually Block or Paragraph, sometimes Word). Occasionally, we need a SemanticLabel to span across the boundary or end before the boundary. For example, a URL may just be a few words within a Paragraph. In such cases, the SemanticLabel is added to the first element of the span and contains this LogicalEntity pointing to the last element of the span:
         */
        EndOfSpanningLabel?: Schema$GoodocLogicalEntity;
        /**
         * Message set for experimental algorithm data. Use case: We keep a set of features that was computed for the unsupervised caption extraction and store it here. Agora question producer will consume this message set to be embedded in a question. The experimental feature set can then be used later to pair up with ground truth labels for designing a supervised algorithm. Currently holding: o ocean/analysis/content/caption_data.proto's TextualElement
         */
        ExperimentalData?: Schema$Proto2BridgeMessageSet;
        /**
         * Flow identifies a single sequential unit of text (or other content). It is only set on Blocks -- a flow identifies a sequence of Blocks. The default, main flow is just the empty string. The "FlowThread" of a block is the flow (if non-empty), suffixed with the block appearance. This is computed by GoodocUtils::FlowThread(). Paragraphs may be split over blocks in the same FlowThread, across pages. The following table shows how FlowThread gets computed: ## Flow Appearance FlowThread (empty) UNSPECIFIED "UNSPECIFIED" foo BODY "foo:BODY" Please use lower-case strings for flows (such as article-33-box). One useful way to think of flows is this: A logical unit of interest in a a Document (for example, an article) would be identified by a starting block, an ending block, and a list of flows of interest within the [start, end) span. message Article { (page#, block#): article_start; (page#, block#): article_end; repeated string flows; \} The reading order of blocks, paragraphs/etc within this article would be the same order as present in the goodoc itself. Some applications (such as rendering) may want to process the article by running over all the flows together, others (such as indexing) may want to deal with the FlowThreads one after the other.
         */
        Flow?: string | null;
        /**
         * This field can be used to record the steps by which AlternateText for a sequence of the Goodoc is generated.
         */
        ModificationRecord?: string | null;
        /**
         * Structure overrides: typically manual corrections to goodoc renderings.
         */
        overrides?: Schema$GoodocOverrides;
        /**
         * If Appearence is PAGE_NUMBER:
         */
        PageNumberOrdinal?: Schema$GoodocOrdinal;
        snippetfilter?: Schema$GoodocSemanticLabelSnippetFilter[];
        tablecelldetails?: Schema$GoodocSemanticLabelTableCellDetails;
        tabledetails?: Schema$GoodocSemanticLabelTableDetails;
    }
    /**
     * If Appearance is COLUMN:
     */
    export interface Schema$GoodocSemanticLabelColumnDetails {
        Column?: number | null;
        Columns?: number | null;
    }
    /**
     * If the label is for something that links to another piece of content (in this volume, outside, a url, a citation, etc.).
     */
    export interface Schema$GoodocSemanticLabelContentLink {
        citationtarget?: Schema$GoodocSemanticLabelContentLinkCitationTarget;
        involumetarget?: Schema$GoodocSemanticLabelContentLinkInVolumeTarget;
        /**
         * For URL labels, we note the url here directly (it's also available by grabbing all text symbols within the labeled span). SCHOLARLY_CITATION labels or even CAPTION labels may occasionally contain URLs.
         */
        UrlTarget?: string | null;
    }
    /**
     * For SCHOLARLY_CITATION labels:
     */
    export interface Schema$GoodocSemanticLabelContentLinkCitationTarget {
        /**
         * separated by semicolons
         */
        Authors?: string | null;
        BibKey?: string | null;
        Confidence?: number | null;
        Title?: string | null;
        Year?: number | null;
    }
    /**
     * For CAPTION or FOOTNOTE_POINTER or TOC_ENTRY or INDEX_ENTRY or CONTINUATION labels:
     */
    export interface Schema$GoodocSemanticLabelContentLinkInVolumeTarget {
        Confidence?: number | null;
        /**
         * The CAPTION label typically targets the previous or the next Block. The FOOTNOTE_POINTER label typically targets a paragraph in a FOOTNOTE Block. TOC_ENTRY and INDEX_ENTRY labels are links that point to a different page within the volume. CONTINUATION labels also are links that point to a different page within the volume, or maybe even a particular block or paragraph.
         */
        LogicalEntity?: Schema$GoodocLogicalEntity;
    }
    /**
     * If there is more than one edit correction candidate, store all the candidates here. This helps a manual correction utility fire the right kind of question with the relevant options.
     */
    export interface Schema$GoodocSemanticLabelEditCorrectionCandidate {
        EditedWord?: string | null;
        Probability?: number | null;
    }
    /**
     * Recording the output of the snippet filter. We run through a series of snippet filters and store all the conditions that this article passed. A condition is denoted by the "badword_fraction_allowed" in a running window of size - "window_size". If ARTICLE_SNIPPET_NOT_CLEAN annotation is set, this group has 0 items. It can be a part of article logicalentity, but keeping it here for consistency and coherence as SemanticLabel holds all other article metadata.
     */
    export interface Schema$GoodocSemanticLabelSnippetFilter {
        badwordFraction?: number | null;
        windowSize?: number | null;
    }
    /**
     * If Appearance is TABLE_CELL:
     */
    export interface Schema$GoodocSemanticLabelTableCellDetails {
        Column?: number | null;
        ColumnSpan?: number | null;
        /**
         * Row and Column are 0-based
         */
        Row?: number | null;
        RowSpan?: number | null;
    }
    /**
     * If Appearance is TABLE:
     */
    export interface Schema$GoodocSemanticLabelTableDetails {
        Columns?: number | null;
        Rows?: number | null;
    }
    /**
     * Goodoc stats for a range of elements, such as one page or a whole book. These stats can be computed using the SummaryStatsCollector class. Some range stats are pre-computed and stored in goodocs/volumes (eg., Page.stats below, and Ocean's CA_VolumeResult.goodoc_stats).
     */
    export interface Schema$GoodocSummaryStats {
        /**
         * This flag is set if the histogram above has been derived by estimating font sizes from CharLabel.CharacterHeight; that happens if the FontSize field is constant, as has happened with Abbyy 9.
         */
        estimatedFontSizes?: boolean | null;
        /**
         * Symbol counts (and other attributes) for each distinct CharLabel.FontId and FontSize; histogram is in decreasing order of symbol count
         */
        fontSizeHistogram?: Schema$GoodocFontSizeStats[];
        meanSymbolsPerBlock?: number | null;
        meanSymbolsPerLine?: number | null;
        meanSymbolsPerParagraph?: number | null;
        meanSymbolsPerWord?: number | null;
        meanWordsPerBlock?: number | null;
        meanWordsPerLine?: number | null;
        meanWordsPerParagraph?: number | null;
        /**
         * bottom to next top in flow on page
         */
        medianBlockSpace?: number | null;
        /**
         * 0,2,4..
         */
        medianEvenPrintedBox?: Schema$GoodocBoundingBox;
        medianFullEvenPrintedBox?: Schema$GoodocBoundingBox;
        medianFullOddPrintedBox?: Schema$GoodocBoundingBox;
        /**
         * Each median_full*_printed_box includes page header/footer but still excludes all graphic blocks
         */
        medianFullPrintedBox?: Schema$GoodocBoundingBox;
        medianHeight?: number | null;
        medianHorizontalDpi?: number | null;
        /**
         * top to bottom
         */
        medianLineHeight?: number | null;
        /**
         * bottom to next top in para
         */
        medianLineSpace?: number | null;
        /**
         * top to next top in para
         */
        medianLineSpan?: number | null;
        /**
         * 1,3,5..
         */
        medianOddPrintedBox?: Schema$GoodocBoundingBox;
        /**
         * leading space on first line
         */
        medianParagraphIndent?: number | null;
        /**
         * bottom to next top in block
         */
        medianParagraphSpace?: number | null;
        /**
         * Each median*_printed_box excludes page header/footer and all graphic blocks
         */
        medianPrintedBox?: Schema$GoodocBoundingBox;
        medianSymbolsPerBlock?: number | null;
        medianSymbolsPerLine?: number | null;
        medianSymbolsPerParagraph?: number | null;
        medianSymbolsPerWord?: number | null;
        medianVerticalDpi?: number | null;
        medianWidth?: number | null;
        medianWordsPerBlock?: number | null;
        medianWordsPerLine?: number | null;
        medianWordsPerParagraph?: number | null;
        /**
         * ------ Block stats Median symbols and words omit junk, header and footer blocks; they are intended to be a measure of the typical "content" block. There can still be substantial differences between means and medians; however, block values will generally exceed paragraph values (not the case when headers and footers are included).
         */
        numBlocks?: number | null;
        /**
         * blocks that have a successor block within their flow on their page
         */
        numBlockSpaces?: number | null;
        /**
         * ------ Line stats "top" corresponds to the highest ascender and "bottom" to the lowest descender.
         */
        numLines?: number | null;
        /**
         * Lines (out of num_lines) that have a successor line within their para
         */
        numLineSpaces?: number | null;
        numNonGraphicBlocks?: number | null;
        /**
         * ------ Page stats.
         */
        numPages?: number | null;
        /**
         * ------ Paragraph stats Median symbols and words omit junk, header and footer blocks; they are intended to be a measure of the typical "content" paragraph. There can still be substantial differences between means and medians, particularly if a table is present (every cell is a paragraph).
         */
        numParagraphs?: number | null;
        /**
         * paras that have a successor para within their block
         */
        numParagraphSpaces?: number | null;
        /**
         * ------ Symbol stats
         */
        numSymbols?: number | null;
        /**
         * ------ Word stats
         */
        numWords?: number | null;
    }
    /**
     * A single symbol representation
     */
    export interface Schema$GoodocSymbol {
        Box?: Schema$GoodocBoundingBox;
        /**
         * The unicode character code in UTF-32
         */
        Code?: number | null;
        Label?: Schema$GoodocLabel;
        /**
         * If RotatedBox is set, Box must be set as well. See RotatedBoundingBox.
         */
        RotatedBox?: Schema$GoodocRotatedBoundingBox;
        symbolvariant?: Schema$GoodocSymbolSymbolVariant[];
    }
    export interface Schema$GoodocSymbolSymbolVariant {
        Code?: number | null;
        Confidence?: number | null;
    }
    /**
     * A word representation
     */
    export interface Schema$GoodocWord {
        alternates?: Schema$GoodocWordAlternates;
        /**
         * The baseline's y-axis offset from the bottom of the word's bounding box, given in pixels. (A value of 2, for instance, indicates the baseline is 2px above the bottom of the box.)
         */
        Baseline?: number | null;
        Box?: Schema$GoodocBoundingBox;
        /**
         * The capline is the y-axis offset from the top of the word bounding box. A positive value n indicates that capline is n-pixels above the top of this word.
         */
        Capline?: number | null;
        /**
         * For space efficiency, we sometimes skip the detailed per-symbol bounding boxes in Symbol.Box, and use this coarser representation instead, where we just store Symbol boundaries within the Word box. Most client code should not have to worry directly about this, it should be handled in the deepest layers of writing/reading goodocs (for example, see Compress() and Uncompress() in ocean/goodoc/goovols-bigtable-volume.h). Note(viresh): I experimented with this compression, and here are some numbers for reference. If the zlib-compressed page goodoc string size was 100 to start with, then this compaction makes it 65. As a possible future relaxation to consider: if we add in, for each symbol, a "top" and "bottom" box offset then the size would be 75 (that's with "repeated int32 top/bottom_offset" fields inside BoxPartitions, instead of inside each symbol).
         */
        CompactSymbolBoxes?: Schema$GoodocBoxPartitions;
        /**
         * Word recognition confidence. Range depends upon OCR Engine.
         */
        Confidence?: number | null;
        /**
         * word. The meaning and range depends on the OCR engine or subsequent processing. Specifies whether the word was found
         */
        IsFromDictionary?: boolean | null;
        /**
         * a number True if word represents
         */
        IsIdentifier?: boolean | null;
        /**
         * True if the word is the last word in any sub-paragraph unit that functions at the same level of granularity as a sentence. Examples: "She hit the ball." (regular sentence) "Dewey defeats Truman" (heading) "The more, the merrier." (no verb) Note: not currently used. Code to set this was introduced in CL 7038338 and removed in OCL=10678722.
         */
        IsLastInSentence?: boolean | null;
        /**
         * in the dictionary True if the word represents
         */
        IsNumeric?: boolean | null;
        Label?: Schema$GoodocLabel;
        /**
         * Penalty for discordance of characters in a
         */
        Penalty?: number | null;
        /**
         * If RotatedBox is set, Box must be set as well. See RotatedBoundingBox.
         */
        RotatedBox?: Schema$GoodocRotatedBoundingBox;
        /**
         * Word characters, the text may
         */
        Symbol?: Schema$GoodocSymbol[];
        /**
         * As a shortcut, the content API provides the text of words instead of individual symbols (NOTE: this is experimental). This is UTF8. And the main font for the word is stored in Label.CharLabel.
         */
        text?: string | null;
        /**
         * Writing direction for this word.
         */
        writingDirection?: string | null;
    }
    /**
     * Alternate OCR words for Ptolemy OCR Correction. This is the output of the Ptolemy error estimator. See http://go/Ptolemy.
     */
    export interface Schema$GoodocWordAlternates {
        alternate?: Schema$GoodocWordAlternatesAlternate[];
        /**
         * The probability that the main OCR engine (Abbyy) string is incorrect; range is 0 (definitely correct) to 100 (definitely incorrect).
         */
        ErrorProbability?: number | null;
    }
    /**
     * An alternate word provided by another OCR engine, used for OCR Correction. This iteration only supports simple substitution errors (exhanging one word for another), but with minor modifications (e.g. adding a word count for each alternate), it could support repairing word segmentation and text detection errors.
     */
    export interface Schema$GoodocWordAlternatesAlternate {
        /**
         * See Document.Header
         */
        OcrEngineId?: string | null;
        /**
         * See Document.Header
         */
        OcrEngineVersion?: string | null;
        /**
         * In order to compile, this recursive message needs to be optional, even though it's within an optional group.
         */
        Word?: Schema$GoodocWord;
    }
    /**
     * Describes the billing configuration for a new tenant project.
     */
    export interface Schema$GoogleApiServiceconsumermanagementV1BillingConfig {
        /**
         * Name of the billing account. For example `billingAccounts/012345-567890-ABCDEF`.
         */
        billingAccount?: string | null;
    }
    /**
     * Translates to IAM Policy bindings (without auditing at this level)
     */
    export interface Schema$GoogleApiServiceconsumermanagementV1PolicyBinding {
        /**
         * Uses the same format as in IAM policy. `member` must include both a prefix and ID. For example, `user:{emailId\}`, `serviceAccount:{emailId\}`, `group:{emailId\}`.
         */
        members?: string[] | null;
        /**
         * Role. (https://cloud.google.com/iam/docs/understanding-roles) For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
         */
        role?: string | null;
    }
    /**
     * Specifies the desired format for the server to use when it returns `audio_out` messages.
     */
    export interface Schema$GoogleAssistantAccessoryV1AudioOutConfig {
        /**
         * Current audio mode on the device while issuing the query.
         */
        audioMode?: string | null;
        /**
         * Current audio routing on the device while issuing the query.
         */
        audioRoutingMode?: string | null;
        /**
         * *Required* The encoding of audio data to be returned in all `audio_out` messages.
         */
        encoding?: string | null;
        /**
         * *Optional* Specifies preferred encoding bitrate (bits-per-second). Currently this is only implemented for OGG_OPUS for bitrates of 12000, 16000, 24000, 32000. If not specified, OGG_OPUS defaults to 32000.
         */
        preferredBitrateBps?: number | null;
    }
    /**
     * *Required* Fields that identify the device to the Assistant. See also: * [Register a Device - REST API](https: //developers.google.com/assistant/sdk/re // ference/device-registration/register-device-manual) * [Device Model and Instance Schemas](https: //developers.google.com/assistant/sdk/re // ference/device-registration/model-and-instance-schemas) * [Device Proto](https: //developers.google.com/assistant/sdk/re // ference/rpc/google.assistant.devices.v1#device)
     */
    export interface Schema$GoogleAssistantAccessoryV1DeviceConfig {
        /**
         * Device model capabilities from client to override capabilities in the primary device model.
         */
        deviceModelCapabilitiesOverride?: Schema$GoogleAssistantEmbeddedV1DeviceModelCapabilitiesOverride;
        /**
         * *Optional* An encrypted heterodyne_experiment_token containing the list of experiment_ids (go/ph-server-tokens).
         */
        heterodyneToken?: string | null;
        /**
         * *Required* Identifier for the device which sent the request.
         */
        surfaceIdentity?: Schema$GoogleAssistantEmbeddedV1SurfaceIdentity;
    }
    /**
     * Information about the state of the device. This contains any state that Assistant may need to know about in order to fulfill requests, for example which timers and alarms are set. Next ID: 13
     */
    export interface Schema$GoogleAssistantAccessoryV1DeviceState {
        /**
         * *Optional* Information about on-device alarms. For devices that support alarms, all on-device alarms must be sent up with the DeviceState in order for Assistant Server to be able to perform operations on them.
         */
        alarmState?: Schema$GoogleAssistantEmbeddedV1Alarms;
        /**
         * Other context params to be sent to Assistant. This is a assistant.embedded.v1.ContextParams message in serialized binary proto format.
         */
        contextParams?: string | null;
        /**
         * A timestamp of the current device time when the request was made. This field is required if your device supports alarms or timers. This ensures that requests are fulfilled relative to the current device time and regardless of any clock skew between the client and the server.
         */
        deviceTime?: string | null;
        /**
         * The time zone where the device is currently located. This helps the Assistant answer time-related queries relative to the device's time zone. Generally speaking, mobile devices that support alarms or timers should supply device_time_zone. This field is required if your device supports alarms or timers and the device's location cannot reliably be determined. (See the comment above google.assistant.embedded.v1.DeviceLocation for a description of how the device's location is determined.) If the time zone cannot be determined, some queries for creating or modifying timers or alarms may fail with a generic error such as, "Sorry, I don't know how to help with that."
         */
        deviceTimeZone?: Schema$GoogleTypeTimeZone;
        /**
         * Indicate whether do not disturb mode is turned on.
         */
        doNotDisturb?: boolean | null;
        /**
         * Information about on-device fitness activities. For devices that support fitness activities, all on-device fitness activities must be sent up with the DeviceState in order for Assistant Server to be able to perform operations on them.
         */
        fitnessActivitiesState?: Schema$GoogleAssistantEmbeddedV1FitnessActivities;
        /**
         * Information about apps currently installed on device.
         */
        installedApps?: Schema$GoogleAssistantAccessoryV1DeviceStateInstalledAppsState;
        /**
         * This contains a zlib-compressed binary-encoded `InstalledAppsState` proto message.
         */
        installedAppsZlib?: string | null;
        /**
         * *Optional* Information about on-device timers. For devices that support timers, all on-device timers must be sent up with the DeviceState in order for Assistant Server to be able to perform operations on them.
         */
        timerState?: Schema$GoogleAssistantEmbeddedV1Timers;
        /**
         * This indicates which specific settings are currently unavailable for modification, despite being listed as a supported setting. Assistant can use this field to trigger unavailability messages, rather than claiming that a setting is entirely unsupported on device.
         */
        unavailableSettings?: string[] | null;
    }
    /**
     * State of the apps currently installed on the device.
     */
    export interface Schema$GoogleAssistantAccessoryV1DeviceStateInstalledAppsState {
        /**
         * List of apps currently installed on the device.
         */
        apps?: Schema$AssistantApiCoreTypesProvider[];
    }
    /**
     * Configuration for the response. Next Id: 11
     */
    export interface Schema$GoogleAssistantAccessoryV1ResponseConfig {
        /**
         * Specifies the current audio mode on the device.
         */
        audioOutConfig?: Schema$GoogleAssistantAccessoryV1AudioOutConfig;
        /**
         * Configuration related to a specific device.
         */
        deviceConfig?: Schema$GoogleAssistantAccessoryV1DeviceConfig;
        /**
         * The client interaction to be sent to Assistant. This is a assistant.embedded.v1.DeviceInteraction message in serialized binary proto format.
         */
        deviceInteraction?: string | null;
        /**
         * Device state to pass to the Assistant server to use in calculating the response.
         */
        deviceState?: Schema$GoogleAssistantAccessoryV1DeviceState;
        /**
         * Specifies the initial bytes of TTS audio to send.
         */
        initialAudioBytes?: number | null;
        /**
         * If true, the server will treat the request as a new conversation and not use state from the prior request. Set this field to true when the conversation should be restarted, such as after a device reboot, or after a significant lapse of time since the prior query.
         */
        isNewConversation?: boolean | null;
        /**
         * Specifies the desired audio sample rate of the output TTS stream in Hz.
         */
        outputSampleRateHz?: number | null;
        /**
         * Specifies the requested response type.
         */
        responseType?: string | null;
        /**
         * Specifies the desired format to use when server returns a visual screen re